/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.formplugin;

import java.util.EventObject;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.disf.constants.IDataCommonConstant;
import kd.data.fsa.model.rpt.config.FSABaseStdRptIndicator;
import kd.data.fsa.utils.FSAJSONUtils;

public class FSARptIndicatorsFormPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"calcformular_btn"});
    }

    public void afterBindData(EventObject e) {
        String rptItemSrcType;
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String number = (String)model.getValue("number");
        if (StringUtils.isNotEmpty((String)number)) {
            view.setEnable(Boolean.FALSE, new String[]{"number"});
        }
        if ("0".equals(rptItemSrcType = (String)model.getValue("rptitemsrctype"))) {
            view.setEnable(Boolean.FALSE, new String[]{"number", "name", "rpttype", "calcformular_btn", "bar_save"});
        }
    }

    public void click(EventObject evt) {
        String actionKey;
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        switch (actionKey = ctlSource.getKey()) {
            case "calcformular_btn": {
                this.showCalculateForm();
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("rpttype".equalsIgnoreCase(e.getProperty().getName())) {
            IDataModel model = this.getModel();
            String displayFormular = (String)model.getValue("displayformular");
            String calculateFormular = (String)model.getValue("calcformular");
            if (StringUtils.isNotEmpty((String)displayFormular) && StringUtils.isNotEmpty((String)calculateFormular)) {
                String userEditFlag = this.getPageCache().get("userEdit");
                if (!"1".equals(userEditFlag)) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u62a5\u8868\u7c7b\u578b\uff0c\u6307\u6807\u516c\u5f0f\u5b9a\u4e49\u5c06\u88ab\u6e05\u9664\uff0c\u662f\u5426\u786e\u8ba4\u64cd\u4f5c\uff1f", (String)"FSARptIndicatorsFormPlugin_6", (String)"data-fsa-formplugin", (Object[])new Object[0]), null, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("callbackRemove", (IFormPlugin)this), null, (String)e.getChangeSet()[0].getOldValue());
                }
                this.getPageCache().remove("userEdit");
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if ("callbackRemove".equalsIgnoreCase(messageBoxClosedEvent.getCallBackId())) {
            IDataModel model = this.getModel();
            if (MessageBoxResult.Yes == messageBoxClosedEvent.getResult()) {
                model.setValue("displayformular", (Object)"");
                model.setValue("calcformular", (Object)"");
                model.setValue("description", (Object)"");
            } else {
                this.getPageCache().put("userEdit", "1");
                String oldRptType = messageBoxClosedEvent.getCustomVaule();
                model.setValue("rpttype", (Object)oldRptType);
            }
        }
    }

    private void showCalculateForm() {
        IDataModel model = this.getModel();
        String checkedTypes = (String)model.getValue("rpttype");
        if (StringUtils.isEmpty((String)checkedTypes)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u62a5\u8868\u7c7b\u578b", (String)"FSARptIndicatorsFormPlugin_0", (String)"data-fsa-formplugin", (Object[])new Object[0]));
            return;
        }
        FSABaseStdRptIndicator rptIndicator = new FSABaseStdRptIndicator();
        rptIndicator.setDescription((String)model.getValue("description"));
        rptIndicator.setCalcFormular((String)model.getValue("calcformular"));
        rptIndicator.setDisplayFormular((String)model.getValue("displayformular"));
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("fsa_rptformula_edit");
        showParameter.getCustomParams().put("formula_json", FSAJSONUtils.toJsonString((Object)rptIndicator));
        showParameter.getCustomParams().put("rpttype", model.getValue("rpttype"));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "close_fsa_rptformula_edit"));
        TreeNode root = new TreeNode("", "root", ResManager.loadKDString((String)"\u8d22\u52a1\u6307\u6807", (String)"FSARptIndicatorsFormPlugin_1", (String)"data-fsa-formplugin", (Object[])new Object[0]), true);
        root.setIsOpened(true);
        if (checkedTypes.indexOf(44) > -1) {
            String[] typeArray;
            String typesStr = checkedTypes.substring(1, checkedTypes.lastIndexOf(44));
            for (String type : typeArray = typesStr.split(",")) {
                TreeNode typeNode = null;
                switch (type) {
                    case "0": {
                        typeNode = new TreeNode("root", type, ResManager.loadKDString((String)"\u8d44\u4ea7\u8d1f\u503a\u8868", (String)"FSARptIndicatorsFormPlugin_2", (String)"data-fsa-formplugin", (Object[])new Object[0]), true);
                        break;
                    }
                    case "1": {
                        typeNode = new TreeNode("root", type, ResManager.loadKDString((String)"\u5229\u6da6\u8868", (String)"FSARptIndicatorsFormPlugin_3", (String)"data-fsa-formplugin", (Object[])new Object[0]), true);
                        break;
                    }
                    case "2": {
                        typeNode = new TreeNode("root", type, ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u91cf\u8868", (String)"FSARptIndicatorsFormPlugin_4", (String)"data-fsa-formplugin", (Object[])new Object[0]), true);
                        break;
                    }
                }
                if (typeNode == null) continue;
                this.initChildTreeNode(type, typeNode);
                root.addChild(typeNode);
            }
        }
        String fldNodes = FSAJSONUtils.toJsonString((Object)root);
        showParameter.getCustomParams().put("treenodes", fldNodes);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        switch (closedCallBackEvent.getActionId()) {
            case "close_fsa_rptformula_edit": {
                FSABaseStdRptIndicator rptIndicator = (FSABaseStdRptIndicator)FSAJSONUtils.cast((String)((String)closedCallBackEvent.getReturnData()), FSABaseStdRptIndicator.class);
                if (rptIndicator == null) break;
                IDataModel model = this.getModel();
                model.setValue("displayformular", (Object)rptIndicator.getDisplayFormular());
                model.setValue("calcformular", (Object)rptIndicator.getCalcFormular());
                model.setValue("description", (Object)rptIndicator.getDescription());
                this.createRptEnt(rptIndicator.getCalcFormular());
                break;
            }
        }
    }

    private void createRptEnt(String calculate) {
        if (StringUtils.isNotEmpty((String)calculate)) {
            String pattern = "\\[[^\\]]+\\]";
            Pattern r = Pattern.compile(pattern);
            Matcher m = r.matcher(calculate);
            HashSet<String> numberList = new HashSet<String>(1);
            while (m.find()) {
                String number = m.group().replaceAll("\\[", "").replaceAll("\\]", "");
                numberList.add(number);
            }
            if (!numberList.isEmpty()) {
                TableValueSetter tvs = new TableValueSetter(new String[0]);
                tvs.addField("srcstdrpt", new Object[0]);
                QFilter numberFilter = new QFilter("fnumber", "in", numberList);
                StringBuilder querySql = new StringBuilder("select FID,FRPTTYPE FROM T_FSA_RPTITEMS where ").append(numberFilter);
                HashSet<Long> idList = new HashSet<Long>(numberList.size());
                HashSet<String> typeSet = new HashSet<String>(numberList.size());
                try (DataSet ds = DB.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".createRptEnt"), (DBRoute)IDataCommonConstant.DBRoute_BDAI, (String)querySql.toString());){
                    if (ds != null) {
                        while (ds.hasNext()) {
                            Row currentRow = ds.next();
                            idList.add(currentRow.getLong(0));
                            typeSet.add(currentRow.getString(1));
                        }
                    }
                }
                if (!idList.isEmpty()) {
                    for (Long id : idList) {
                        tvs.addRow(new Object[]{id});
                    }
                }
                IDataModel model = this.getModel();
                model.setValue("refrptcnt", (Object)typeSet.size());
                model.deleteEntryData("rptidxrptent");
                AbstractFormDataModel abstractModel = (AbstractFormDataModel)model;
                abstractModel.beginInit();
                abstractModel.batchCreateNewEntryRow("rptidxrptent", tvs);
                abstractModel.endInit();
                this.getView().updateView("rptidxrptent");
            }
        }
    }

    private TreeNode initChildTreeNode(String typeId, TreeNode parentNode) {
        QFilter typeFilter = new QFilter("rpttype", "=", (Object)typeId);
        QFilter itemTypeFilter = new QFilter("itemtype", "=", (Object)"1");
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"fsa_rptitems", (String)"number,name", (QFilter[])new QFilter[]{typeFilter, itemTypeFilter});
        if (doc != null && !doc.isEmpty()) {
            for (int i = 0; i < doc.size(); ++i) {
                String number = (String)((DynamicObject)doc.get(i)).get(0);
                String name = (String)((DynamicObject)doc.get(i)).get(1);
                TreeNode childNode = new TreeNode(typeId, number, name, false);
                parentNode.addChild(childNode);
            }
        }
        return parentNode;
    }
}

