/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class FSAScheduleNotifyFormPlugin
extends AbstractFormPlugin {
    private static final String TEMPLATECALLBACK = "templateCallBack";
    private static final Set<String> enableTypes = new HashSet<String>(5);

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setMsgChannelItem();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        String notifyType = (String)model.getValue("snotifytype");
        if (StringUtils.isNotEmpty((String)notifyType)) {
            String[] types = notifyType.split(",");
            ArrayList<String> effectTypes = new ArrayList<String>(types.length);
            for (String type : types) {
                if (!enableTypes.contains(type) || !StringUtils.isNotEmpty((String)type)) continue;
                effectTypes.add(type);
            }
            model.setValue("snotifytype", (Object)String.join((CharSequence)",", effectTypes));
            model.setDataChanged(false);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.setMsgChannelItem();
        HashMap<String, String> msgTemplateMap = new HashMap<String, String>(16);
        QFilter filter = new QFilter("msgentity", "=", (Object)"sch_schedule");
        DynamicObjectCollection templateCol = QueryServiceHelper.query((String)"msg_template", (String)"msgtype,msgchannel,msgtemplate", (QFilter[])filter.toArray(), (String)"createdate asc");
        if (templateCol != null && !templateCol.isEmpty()) {
            HashSet<String> notifyTypeSets = new HashSet<String>(10);
            for (DynamicObject dynamicObject : templateCol) {
                String msgChannel = dynamicObject.getString("msgchannel");
                String msgTemplate = dynamicObject.getLocaleString("msgtemplate").getLocaleValue();
                notifyTypeSets.add(msgChannel);
                msgTemplateMap.put("smsgcontent", msgTemplate);
            }
            msgTemplateMap.put("snotifytype", String.join((CharSequence)",", notifyTypeSets));
        }
        IDataModel model = this.getModel();
        String msgContent = (String)msgTemplateMap.get("smsgcontent");
        model.setValue("snotifytype", msgTemplateMap.get("snotifytype"));
        model.setValue("smsgcontent", (Object)(msgContent == null ? "" : msgContent));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"smsgcontent"});
    }

    public void click(EventObject evt) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String key = ((Control)evt.getSource()).getKey().toLowerCase();
        if ("smsgcontent".equals(key)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            String msgContent = (String)model.getValue("smsgcontent");
            parameter.setFormId("sch_msg_content");
            parameter.setCaption(ResManager.loadKDString((String)"\u6d88\u606f\u5185\u5bb9\u7f16\u8f91", (String)"FSAScheduleNotifyFormPlugin_0", (String)"data-fsa-formplugin", (Object[])new Object[0]));
            parameter.setCustomParam("entityNumber", (Object)"sch_schedule");
            parameter.setCustomParam("FROM", (Object)"task");
            parameter.setCustomParam("value", (Object)msgContent);
            parameter.setCustomParam("isInclude", (Object)"true");
            parameter.setCustomParam("includeFields", (Object)SerializationUtils.toJsonString(Arrays.asList("number", "name", "starttime", "endtime")));
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, TEMPLATECALLBACK));
            view.showForm(parameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (TEMPLATECALLBACK.equals(actionId) && returnData != null) {
            Map dataMap = (Map)returnData;
            String content = (String)dataMap.get("customSubject");
            this.getModel().setValue("smsgcontent", (Object)content);
        }
    }

    private void setMsgChannelItem() {
        Map channelMap = BusinessDataServiceHelper.loadFromCache((String)"msg_channel", (String)"id,number,name,enable", null);
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(5);
        if (channelMap != null && !channelMap.isEmpty()) {
            Collection channels = channelMap.values();
            for (DynamicObject channelDo : channels) {
                OrmLocaleValue name = (OrmLocaleValue)channelDo.get("name");
                String number = channelDo.getString("number");
                boolean enable = channelDo.getBoolean("enable");
                if (!enable || "sysnotice".equalsIgnoreCase(number)) continue;
                enableTypes.add(number);
                ComboItem comboItem = new ComboItem();
                comboItem.setValue(number);
                comboItem.setCaption(new LocaleString(name != null ? name.getLocaleValue() : number));
                comboItemList.add(comboItem);
            }
        }
        ComboEdit combo = (ComboEdit)this.getControl("snotifytype");
        combo.setComboItems(comboItemList);
    }
}

