/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.formplugin.CronStruct;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.fsa.formplugin.util.FSAMemberF7Util;
import kd.data.fsa.olap.OlapServerDimMemberMetaInfo;
import kd.data.fsa.utils.FSABcmDataProvider;
import kd.data.fsa.utils.schedule.FSAScheduleHelper;

public class FSAScheduleTaskConfigFormPlugin
extends AbstractFormPlugin {
    private static final String[] CKMONTH = new String[]{"ckjan", "ckfeb", "ckmar", "ckapr", "ckmay", "ckjun", "ckjul", "ckaug", "cksep", "ckoct", "cknov", "ckdec"};
    private static final String[] CKWEEK = new String[]{"cksun", "ckmon", "cktues", "ckwed", "ckthur", "ckfri", "cksat"};
    private static final String[] CKDATE = new String[]{"ckone", "cktwo", "ckthree", "ckfour", "ckfive", "cksix", "ckseven", "ckeight", "cknine", "ckten", "ckeleven", "cktwelve", "ckthirteen", "ckfourteen", "ckfifteen", "cksixteen", "ckseventeen", "ckeighteen", "cknineteen", "cktwenty", "cktwentyone", "cktwentytwo", "cktwentythree", "cktwentyfour", "cktwentyfive", "cktwentysix", "cktwentyseven", "cktwentyeight", "cktwentynine", "ckthirty", "ckthirtyone"};

    public void initialize() {
        super.initialize();
        Tab tab = (Tab)this.getControl("tabapdateweek");
        tab.addTabSelectListener(tabSelectEvent -> {
            String key = tabSelectEvent.getTabKey();
            if ("tabweekpage".equals(key)) {
                this.getModel().setValue("combdorw", (Object)"w");
            } else {
                this.getModel().setValue("combdorw", (Object)"d");
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        this.setTxtDescColor(view);
        OperationStatus status = view.getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            model.setValue("starttime", (Object)new Date());
            this.adjustByRepeatMode(view, model);
        }
    }

    private void setTxtDescColor(IFormView view) {
        HashMap<String, String> cssMap = new HashMap<String, String>();
        cssMap.put("fc", "#CCCCCC");
        view.updateControlMetadata("txtdesc", cssMap);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        this.setTxtDescColor(view);
        OperationStatus status = view.getFormShowParameter().getStatus();
        if (!OperationStatus.ADDNEW.equals((Object)status)) {
            view.setEnable(Boolean.FALSE, new String[]{"number"});
        }
        String enable = (String)model.getValue("enable");
        model.setValue("enablebox", (Object)Integer.parseInt(enable));
        model.beginInit();
        this.adjustByRepeatMode(view, model);
        this.adjustByCron(model);
        this.adjustByDays(model);
        this.adjustByMonths(model);
        this.adjustByWeeks(model);
        String dayOrWeek = (String)model.getValue("combdorw");
        if ("w".equals(dayOrWeek)) {
            Tab tab = (Tab)this.getControl("tabapdateweek");
            tab.activeTab("tabweekpage");
        }
        String comNo = (String)model.getValue("comno");
        String comWeek = (String)model.getValue("comweek");
        String repeatMode = (String)model.getValue("repeatmode");
        if ("m".equals(repeatMode) && StringUtils.isNotEmpty((String)comNo) && StringUtils.isNotEmpty((String)comWeek)) {
            model.setValue("comnobyweek", (Object)comNo);
            model.setValue("comweekbyweek", (Object)comWeek);
        } else if ("y".equals(repeatMode)) {
            view.setVisible(Boolean.TRUE, new String[]{"comnobymonth", "comweekbymonth"});
            model.setValue("comnobymonth", (Object)comNo);
            model.setValue("comweekbymonth", (Object)comWeek);
        }
        model.endInit();
        view.updateView("tabschedule");
        model.setDataChanged(false);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"tasktext", "batchparam", "dimmember"});
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        switch (key) {
            case "tasktext": {
                String paramJson = (String)model.getValue("batchparamjson_tag", 0);
                if (StringUtils.isNotEmpty((String)paramJson)) {
                    view.showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u4efb\u52a1\u540e\u4f1a\u6e05\u7a7a\u6279\u91cf\u5fc5\u586b\u53c2\u6570\u7684\u914d\u7f6e\u5185\u5bb9\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u5207\u6362\u3002", (String)"FSAScheduleTaskConfigFormPlugin_10", (String)"data-fsa-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("callbackTaskClick", (IFormPlugin)this));
                    break;
                }
                this.showTaskSelect(view);
                break;
            }
            case "batchparam": {
                int cnt = model.getEntryRowCount("schtasktime");
                if (cnt <= 0) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e\u6267\u884c\u65f6\u95f4\u3002", (String)"FSAScheduleTaskConfigFormPlugin_2", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                    return;
                }
                cnt = model.getEntryRowCount("schtasktimesub");
                if (cnt <= 0) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u6bcf\u6b21\u5fc5\u586b\u53c2\u6570\uff0c\u65e0\u9700\u914d\u7f6e\u3002", (String)"FSAScheduleTaskConfigFormPlugin_3", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.showBatchCreateParam(view, model);
                break;
            }
            case "dimmember": {
                FSAMemberF7Util.memberF7(this, model.getEntryCurrentRowIndex("schtasktimesub"), model, Long.parseLong((String)model.getValue("taskid", 0)));
            }
        }
    }

    private void showTaskSelect(IFormView view) {
        ListShowParameter listShowParameter = new ListShowParameter();
        ListFilterParameter filterParam = listShowParameter.getListFilterParameter();
        filterParam.getQFilters().add(new QFilter("datasrctype", "=", (Object)"bcmParamSource").and("enable", "=", (Object)Character.valueOf('1')).and("tablenumber", "!=", (Object)Character.valueOf(' ')));
        listShowParameter.setLookUp(true);
        listShowParameter.setMultiSelect(false);
        listShowParameter.setBillFormId("fsa_syncparam");
        listShowParameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "closeCallbackTaskText"));
        listShowParameter.setFormId("bos_listf7");
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        listShowParameter.setShowTitle(false);
        StyleCss css = new StyleCss();
        css.setWidth("960");
        css.setHeight("580");
        listShowParameter.getOpenStyle().setInlineStyleCss(css);
        view.showForm((FormShowParameter)listShowParameter);
    }

    private void showBatchCreateParam(IFormView view, IDataModel model) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("fsa_batchcreateparam");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        parameter.setCustomParam("syncparam_id", model.getValue("taskid", 0));
        parameter.setCustomParam("starttime", (Object)sdf.format((Date)model.getValue("starttime")));
        Date endTime = (Date)model.getValue("endtime");
        if (endTime != null) {
            parameter.setCustomParam("endtime", (Object)sdf.format(endTime));
        }
        parameter.setCustomParam("repeatmode", model.getValue("repeatmode"));
        parameter.setCustomParam("cyclenum", model.getValue("cyclenum"));
        parameter.setCustomParam("batchparamjson_tag", model.getValue("batchparamjson_tag", 0));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closeCallbackBatchParam"));
        view.showForm(parameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        IFormView view = this.getView();
        MessageBoxResult messageBoxResult = messageBoxClosedEvent.getResult();
        String actionId = messageBoxClosedEvent.getCallBackId();
        if (MessageBoxResult.Yes == messageBoxResult && "callbackTaskClick".equalsIgnoreCase(actionId)) {
            this.showTaskSelect(view);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        IDataModel model = this.getModel();
        Object returnData = closedCallBackEvent.getReturnData();
        switch (key) {
            case "closeCallbackTaskText": {
                ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
                if (selectedRows == null || selectedRows.isEmpty()) {
                    return;
                }
                model.setValue("tasktext", (Object)selectedRows.get(0).getName(), 0);
                model.setValue("taskid", selectedRows.get(0).getPrimaryKeyValue(), 0);
                break;
            }
            case "closeCallbackSelectMember": {
                Set resultSet = (Set)returnData;
                if (resultSet == null) {
                    return;
                }
                ArrayList<Object[]> memberJsonList = new ArrayList<Object[]>(resultSet.size());
                ArrayList<String> memberNameList = new ArrayList<String>(resultSet.size());
                for (OlapServerDimMemberMetaInfo info : resultSet) {
                    String name = info.getName();
                    Object[] memberArr = new Object[]{name, info.getNumber(), info.getId(), info.getLongNumber()};
                    memberJsonList.add(memberArr);
                    memberNameList.add(name);
                }
                int curIdx = model.getEntryCurrentRowIndex("schtasktimesub");
                model.setValue("memberjson_tag", (Object)JSON.toJSONString(memberJsonList), curIdx);
                String dimMem = String.join((CharSequence)",", memberNameList);
                dimMem = dimMem.length() > 100 ? dimMem.substring(0, 96) + "..." : dimMem;
                model.setValue("dimmember", (Object)dimMem, curIdx);
                break;
            }
            case "closeCallbackBatchParam": {
                String paramJson = (String)returnData;
                if (!StringUtils.isNotEmpty((String)paramJson)) break;
                model.setValue("batchparamjson_tag", (Object)paramJson, 0);
                model.setValue("batchparam", (Object)ResManager.loadKDString((String)"\u5df2\u586b\u5199", (String)"FSAScheduleTaskConfigFormPlugin_0", (String)"data-fsa-formplugin", (Object[])new Object[0]), 0);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        if ("save".equals(operateKey)) {
            if (!this.checkData(view, model)) {
                args.setCancel(true);
                return;
            }
            this.updateCheckedDate(model);
            DynamicObject jobDyo = this.buildJobDyo(view, model);
            String jobId = FSAScheduleHelper.saveOrUpdate((DynamicObject)jobDyo);
            DynamicObject schDyo = this.buildSchDyo(view, model, jobId);
            String schId = FSAScheduleHelper.saveOrUpdate((DynamicObject)schDyo);
            model.setValue("schid", (Object)schId);
        }
    }

    private boolean checkData(IFormView view, IDataModel model) {
        String repeatMode;
        Date endTime;
        Date startTime = (Date)model.getValue("starttime");
        if (startTime.compareTo(endTime = (Date)model.getValue("endtime")) >= 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u5931\u6548\u65f6\u95f4\u3002", (String)"FSAScheduleTaskConfigFormPlugin_8", (String)"data-fsa-formplugin", (Object[])new Object[0]));
            return false;
        }
        String taskId = (String)model.getValue("taskid");
        if (StringUtils.isEmpty((String)taskId)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5b8c\u5584\u6267\u884c\u4efb\u52a1\u4fe1\u606f\u3002", (String)"FSAScheduleTaskConfigFormPlugin_9", (String)"data-fsa-formplugin", (Object[])new Object[0]));
            return false;
        }
        int schTaskTimeCnt = model.getEntryRowCount("schtasktime");
        if (schTaskTimeCnt > 0) {
            LinkedHashSet<Integer> timeCntSet = new LinkedHashSet<Integer>(schTaskTimeCnt);
            block0: for (int i = 0; i < schTaskTimeCnt; ++i) {
                model.setEntryCurrentRowIndex("schtasktime", i);
                DynamicObjectCollection memberEnt = model.getEntryEntity("schtasktimesub");
                if (memberEnt == null || memberEnt.isEmpty()) continue;
                for (DynamicObject memberDyo : memberEnt) {
                    if (!StringUtils.isEmpty((String)memberDyo.getString("memberjson_tag"))) continue;
                    timeCntSet.add(i + 1);
                    continue block0;
                }
            }
            model.setEntryCurrentRowIndex("schtasktime", 0);
            if (!timeCntSet.isEmpty()) {
                view.showMessage(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u9884\u8ba1\u6267\u884c\u65f6\u95f4\u5b58\u5728\u7ef4\u5ea6\u6ca1\u6709\u9009\u62e9\u6210\u5458\uff0c\u540e\u7eed\u8be5\u9884\u8ba1\u6267\u884c\u65f6\u95f4\u5c06\u65e0\u6cd5\u8fdb\u884c\u6b63\u5e38\u53d6\u6570\uff0c\u8bf7\u53ca\u65f6\u5b8c\u5584\u3002", (String)"FSAScheduleTaskConfigFormPlugin_1", (String)"data-fsa-formplugin", (Object[])new Object[0]), JSON.toJSONString(timeCntSet)));
            }
        }
        if ("n".equals(repeatMode = (String)model.getValue("repeatmode"))) {
            model.setValue("plan", (Object)"n");
        }
        return true;
    }

    private DynamicObject buildJobDyo(IFormView view, IDataModel model) {
        DynamicObject jobDyo;
        OperationStatus status = view.getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            jobDyo = BusinessDataServiceHelper.newDynamicObject((String)"sch_job");
        } else {
            String schId = (String)model.getValue("schid");
            DynamicObject schDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)schId, (String)"sch_schedule");
            DynamicObjectCollection entry = schDyo.getDynamicObjectCollection("entryentity");
            Object jobId = ((DynamicObject)entry.get(0)).get("jobnumber_id");
            jobDyo = BusinessDataServiceHelper.loadSingle((Object)jobId, (String)"sch_job");
        }
        Object configNum = model.getValue("number");
        String number = this.addNumberPrefixAndSuffix((String)configNum).replaceAll("_SKDP_S", "_SKDJ_S");
        jobDyo.set("number", (Object)number);
        jobDyo.set("name", model.getValue("name"));
        jobDyo.set("jobtype", (Object)"BIZ");
        jobDyo.set("taskclassname_id", (Object)"23LUOZ1C6OVR");
        HashMap<String, Object> paramMap = new HashMap<String, Object>(1);
        paramMap.put("schTaskConfigNumber", configNum);
        jobDyo.set("params", (Object)JSON.toJSONString(paramMap));
        jobDyo.set("classname", (Object)"kd.data.fsa.formplugin.task.FSAScheduleDefineConfigTask");
        jobDyo.set("status", model.getValue("enable"));
        jobDyo.set("runmode", (Object)"0");
        jobDyo.set("timeout", (Object)"0");
        jobDyo.set("retrytime", (Object)"0");
        jobDyo.set("strategy", (Object)"1");
        jobDyo.set("runconcurrent", (Object)"1");
        jobDyo.set("canstop", (Object)"0");
        jobDyo.set("runbyuser_id", (Object)13466739L);
        DynamicObjectCollection entry = jobDyo.getDynamicObjectCollection("entryentity");
        entry.clear();
        DynamicObject entryDyo = new DynamicObject(entry.getDynamicObjectType());
        entryDyo.set("paramname", (Object)"schTaskConfigNumber");
        entryDyo.set("must", (Object)"1");
        entryDyo.set("paramtype", (Object)"0");
        entryDyo.set("paramvalue", configNum);
        entry.add((Object)entryDyo);
        return jobDyo;
    }

    private DynamicObject buildSchDyo(IFormView view, IDataModel model, String jobId) {
        DynamicObject schDyo;
        OperationStatus status = view.getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            schDyo = BusinessDataServiceHelper.newDynamicObject((String)"sch_schedule");
        } else {
            String schId = (String)model.getValue("schid");
            schDyo = BusinessDataServiceHelper.loadSingle((Object)schId, (String)"sch_schedule");
        }
        String number = this.addNumberPrefixAndSuffix((String)model.getValue("number"));
        schDyo.set("number", (Object)number);
        schDyo.set("name", model.getValue("name"));
        schDyo.set("starttime", model.getValue("starttime"));
        schDyo.set("endtime", model.getValue("endtime"));
        schDyo.set("txthost", (Object)FSAScheduleHelper.getHostIpAddress());
        schDyo.set("status", model.getValue("enable"));
        if (jobId != null) {
            schDyo.set("job_id", (Object)jobId);
            DynamicObjectCollection entry = schDyo.getDynamicObjectCollection("entryentity");
            entry.clear();
            DynamicObject entryDyo = new DynamicObject(entry.getDynamicObjectType());
            entryDyo.set("jobnumber_id", (Object)jobId);
            entry.add((Object)entryDyo);
        }
        schDyo.set("sfailnotify", model.getValue("sfailnotify"));
        schDyo.set("ssuccessnotify", model.getValue("ssuccessnotify"));
        schDyo.set("stimeout", model.getValue("stimeout"));
        schDyo.set("snotifytype", model.getValue("snotifytype"));
        schDyo.set("msgreceiver_id", model.getValue("msgreceiver_id"));
        schDyo.set("smsgcontent", model.getValue("smsgcontent"));
        schDyo.set("txtdesc", model.getValue("txtdesc"));
        String repeatMode = (String)model.getValue("repeatmode");
        schDyo.set("repeatmode", (Object)("q".equals(repeatMode) ? "def" : repeatMode));
        schDyo.set("cyclenum", model.getValue("cyclenum"));
        schDyo.set("plan", FSAScheduleHelper.setCycleNumSingleAndGetIdx((String)((String)model.getValue("plan")))[1]);
        schDyo.set("combdorw", model.getValue("combdorw"));
        schDyo.set("ckbyweek", model.getValue("ckbyweek"));
        schDyo.set("comno", model.getValue("comno"));
        schDyo.set("comweek", model.getValue("comweek"));
        String days = (String)model.getValue("days");
        String weeks = (String)model.getValue("weeks");
        String months = (String)model.getValue("months");
        if (StringUtils.isNotEmpty((String)days) && !days.contains("32")) {
            String[] dayArr;
            for (String day : dayArr = days.split(",")) {
                schDyo.set(CKDATE[Integer.parseInt(day) - 1], (Object)"1");
            }
        }
        if (StringUtils.isNotEmpty((String)weeks)) {
            String[] weekArr;
            for (String week : weekArr = weeks.split(",")) {
                schDyo.set(CKWEEK[Integer.parseInt(week) - 1], (Object)"1");
            }
        }
        if (StringUtils.isNotEmpty((String)months)) {
            String[] monthArr;
            for (String month : monthArr = months.split(",")) {
                schDyo.set(CKMONTH[Integer.parseInt(month) - 1], (Object)"1");
            }
        }
        return schDyo;
    }

    private String addNumberPrefixAndSuffix(String number) {
        if (!number.startsWith("fsa_")) {
            number = "fsa_" + number;
        }
        if (!number.endsWith("_SKDP_S")) {
            number = number.endsWith("_SKDP") ? number + "_S" : number + "_SKDP_S";
        }
        return number;
    }

    private void updateCheckedDate(IDataModel model) {
        String repeatMode = (String)model.getValue("repeatmode");
        if ("w".equals(repeatMode)) {
            StringBuilder weekBuilder = new StringBuilder();
            for (int w = 1; w < 8; ++w) {
                String weekKey = "week" + w;
                boolean checked = (Boolean)model.getValue(weekKey);
                if (!checked) continue;
                weekBuilder.append(w).append(',');
            }
            model.setValue("days", null);
            model.setValue("months", null);
            model.setValue("weeks", weekBuilder.length() > 0 ? weekBuilder.substring(0, weekBuilder.length() - 1) : null);
        } else if (("m".equals(repeatMode) || "q".equals(repeatMode)) && "d".equals(model.getValue("combdorw"))) {
            StringBuilder dayBuilder = new StringBuilder();
            for (int d = 1; d < 33; ++d) {
                String dayKey = "day" + d;
                boolean checked = (Boolean)model.getValue(dayKey);
                if (!checked) continue;
                dayBuilder.append(d).append(',');
            }
            model.setValue("days", dayBuilder.length() > 0 ? dayBuilder.substring(0, dayBuilder.length() - 1) : null);
            model.setValue("months", null);
            model.setValue("weeks", null);
        } else if ("y".equals(repeatMode)) {
            StringBuilder monthBuilder = new StringBuilder();
            for (int m = 1; m < 13; ++m) {
                String monthKey = "mon" + m;
                boolean checked = (Boolean)model.getValue(monthKey);
                if (!checked) continue;
                monthBuilder.append(m).append(',');
            }
            model.setValue("days", null);
            model.setValue("months", monthBuilder.length() > 0 ? monthBuilder.substring(0, monthBuilder.length() - 1) : null);
            model.setValue("weeks", null);
        } else {
            model.setValue("days", null);
            model.setValue("months", null);
            model.setValue("weeks", null);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String repeatMode = (String)model.getValue("repeatmode");
        boolean changeCronFlag = false;
        switch (propertyName) {
            case "endtime": {
                changeCronFlag = true;
                break;
            }
            case "repeatmode": {
                this.adjustByRepeatMode(view, model);
                changeCronFlag = true;
                break;
            }
            case "combdorw": {
                this.adjustByDayOrWeek(view, model);
                changeCronFlag = true;
                break;
            }
            case "plan": {
                if ("def".equals(repeatMode)) {
                    if (!FSAScheduleHelper.checkCron((String)((String)model.getValue("plan")))) {
                        view.showTipNotification(ResManager.loadKDString((String)"\"cron\u8868\u8fbe\u5f0f\"\u8bbe\u7f6e\u9519\u8bef\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FSAScheduleTaskConfigFormPlugin_7", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                        model.setValue("plan", oldValue);
                        return;
                    }
                    changeCronFlag = true;
                    break;
                }
                return;
            }
            case "cyclenum": {
                if ("n".equals(repeatMode) || "w".equals(repeatMode) || "q".equals(repeatMode) || "y".equals(repeatMode) || "def".equals(repeatMode)) {
                    return;
                }
                if ("h".equals(repeatMode) && (Integer)newValue > 23) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u5468\u671f\u4e3a\u5c0f\u65f6\uff0c\u6700\u591a\u53ea\u80fd\u6bcf23\u5c0f\u65f6\u91cd\u590d\u3002", (String)"FSAScheduleTaskConfigFormPlugin_4", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                    model.setValue("cyclenum", (Object)23);
                    return;
                }
                if ("d".equals(repeatMode) && (Integer)newValue > 31) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u5468\u671f\u4e3a\u5929\uff0c\u6700\u591a\u53ea\u80fd\u6bcf31\u5929\u91cd\u590d\u3002", (String)"FSAScheduleTaskConfigFormPlugin_5", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                    model.setValue("cyclenum", (Object)31);
                    return;
                }
                if ("m".equals(repeatMode) && (Integer)newValue > 12) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u5468\u671f\u4e3a\u6708\uff0c\u6700\u591a\u53ea\u80fd\u6bcf12\u6708\u91cd\u590d\u3002", (String)"FSAScheduleTaskConfigFormPlugin_6", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                    model.setValue("cyclenum", (Object)12);
                    return;
                }
                changeCronFlag = true;
                break;
            }
            case "tasktext": {
                if (StringUtils.isEmpty((String)((String)newValue))) {
                    model.setValue("tasktext", oldValue);
                }
                return;
            }
            case "taskid": {
                String paramJson = (String)model.getValue("batchparamjson_tag", 0);
                if (StringUtils.isNotEmpty((String)paramJson)) {
                    view.getPageCache().put("pageCacheParamJsonMark", "true");
                    model.setValue("batchparam", null, 0);
                    model.setValue("batchparamjson_tag", null, 0);
                }
                this.updateSchTaskTimeSubByTaskId(view, model);
                break;
            }
            case "dimmember": {
                if (!StringUtils.isEmpty((String)((String)newValue))) break;
                model.setValue("memberjson_tag", null, model.getEntryCurrentRowIndex("schtasktimesub"));
                break;
            }
            case "batchparamjson_tag": {
                if (StringUtils.isNotEmpty((String)view.getPageCache().get("pageCacheParamJsonMark"))) {
                    view.getPageCache().remove("pageCacheParamJsonMark");
                    return;
                }
                this.updateSchTaskTimeSubByParamJson(view, model);
                break;
            }
            case "batchparam": {
                if (!StringUtils.isEmpty((String)((String)newValue))) break;
                model.setValue("batchparamjson_tag", null, 0);
            }
        }
        if (propertyName.startsWith("comnoby") || propertyName.startsWith("comweekby")) {
            model.setValue("comno", model.getValue(propertyName.replace("comweek", "comno")));
            model.setValue("comweek", model.getValue(propertyName.replace("comno", "comweek")));
            String comNo = (String)model.getValue("comno");
            String comWeek = (String)model.getValue("comweek");
            if (propertyName.endsWith("bymonth")) {
                model.setValue("ckbyweek", (Object)(StringUtils.isNotEmpty((String)comNo) && StringUtils.isNotEmpty((String)comWeek) ? 1 : 0));
            }
            boolean bl = changeCronFlag = StringUtils.isNotEmpty((String)comNo) && StringUtils.isNotEmpty((String)comWeek);
        }
        if (propertyName.startsWith("day") || propertyName.startsWith("week") || propertyName.startsWith("ckhour_")) {
            changeCronFlag = true;
        }
        if (propertyName.startsWith("mon")) {
            boolean isMonth = false;
            for (int m = 1; m < 13; ++m) {
                String monKey = "mon" + m;
                boolean checked = (Boolean)model.getValue(monKey);
                if (!checked) continue;
                isMonth = true;
                break;
            }
            view.setVisible(Boolean.valueOf(isMonth), new String[]{"comnobymonth", "comweekbymonth"});
            changeCronFlag = true;
        }
        if (changeCronFlag) {
            this.updateCronInfo(model);
            this.updateSchTaskTimeEntry(view, model);
        }
    }

    private void updateSchTaskTimeEntry(IFormView view, IDataModel model) {
        model.deleteEntryData("schtasktime");
        view.updateView("schtasktimesub");
        String cron = (String)model.getValue("plan");
        Date endTime = (Date)model.getValue("endtime");
        Calendar startTime = FSAScheduleHelper.getStartTime((Date)((Date)model.getValue("starttime")));
        List dates = FSAScheduleHelper.computeFireTimesDate((String)cron, (Date)startTime.getTime(), (Date)endTime, (Integer)100, (int)((Integer)model.getValue("cyclenum")));
        if (!dates.isEmpty()) {
            AbstractFormDataModel abstractModel = (AbstractFormDataModel)model;
            abstractModel.beginInit();
            TableValueSetter tvs = new TableValueSetter(new String[0]);
            tvs.addField("schtime", new Object[0]);
            for (Date date : dates) {
                tvs.addRow(new Object[]{date});
            }
            abstractModel.batchCreateNewEntryRow("schtasktime", tvs);
            abstractModel.endInit();
            view.updateView("schtasktime");
            this.updateSchTaskTimeSubByTaskId(view, model);
            String paramJson = (String)model.getValue("batchparamjson_tag", 0);
            if (StringUtils.isNotEmpty((String)paramJson)) {
                this.updateSchTaskTimeSubByParamJson(view, model);
            }
        }
    }

    private void updateSchTaskTimeSubByTaskId(IFormView view, IDataModel model) {
        int schTaskTimeCnt = model.getEntryRowCount("schtasktime");
        if (schTaskTimeCnt > 0) {
            String id = (String)model.getValue("taskid", 0);
            if (StringUtils.isEmpty((String)id)) {
                return;
            }
            DynamicObject syncParamDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(id), (String)"fsa_syncparam");
            DynamicObjectCollection dimEntryCol = syncParamDyo.getDynamicObjectCollection("dimentry");
            ArrayList<DynamicObject> requiredDimList = new ArrayList<DynamicObject>(4);
            for (DynamicObject dim : dimEntryCol) {
                if (!"2".equals(dim.getString("filtermode"))) continue;
                requiredDimList.add(dim);
            }
            for (int i = schTaskTimeCnt - 1; i >= 0; --i) {
                model.setEntryCurrentRowIndex("schtasktime", i);
                model.deleteEntryData("schtasktimesub");
                if (requiredDimList.isEmpty()) continue;
                AbstractFormDataModel abstractModel = (AbstractFormDataModel)model;
                abstractModel.beginInit();
                TableValueSetter tvs = new TableValueSetter(new String[0]);
                tvs.addField("dimname", new Object[0]);
                tvs.addField("dimnumber", new Object[0]);
                tvs.addField("srcnumber", new Object[0]);
                for (DynamicObject dim : requiredDimList) {
                    tvs.addRow(new Object[]{dim.getString("dimname"), dim.getString("dimnumber"), dim.getString("olddimnumber")});
                }
                abstractModel.batchCreateNewEntryRow("schtasktimesub", tvs);
                abstractModel.endInit();
                view.updateView("schtasktimesub");
            }
        }
    }

    private void updateSchTaskTimeSubByParamJson(IFormView view, IDataModel model) {
        String paramJson = (String)model.getValue("batchparamjson_tag", 0);
        String repeatMode = (String)model.getValue("repeatmode");
        if (StringUtils.isEmpty((String)paramJson)) {
            this.updateSchTaskTimeSubByTaskId(view, model);
            return;
        }
        Map paramMap = (Map)JSON.parseObject((String)paramJson, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
        Integer dateOffset = (Integer)paramMap.get("dateoffset");
        int cnt = model.getEntryRowCount("schtasktimesub");
        HashMap<String, Map> dimMemberMap = new HashMap<String, Map>(cnt);
        Map<String, Long> idMap = FSAMemberF7Util.getModuleIdAndViewId(Long.parseLong((String)model.getValue("taskid", 0)));
        Long moduleId = idMap.get("moduleId");
        Long viewId = idMap.get("OrgView");
        ArrayList<Object[]> memberJsonList = new ArrayList<Object[]>(8);
        ArrayList<String> memberNameList = new ArrayList<String>(8);
        for (int i = 0; i < cnt; ++i) {
            String dimSrcNumber = (String)model.getValue("srcnumber", i);
            String dimNumber = (String)model.getValue("dimnumber", i);
            Map memberMap = FSABcmDataProvider.loadDimensionMembers((Long)moduleId, (Long)viewId, (String)dimSrcNumber, null, null, (boolean)true);
            dimMemberMap.put(dimNumber, memberMap);
        }
        int schTaskTimeCnt = model.getEntryRowCount("schtasktime");
        for (int i = schTaskTimeCnt - 1; i >= 0; --i) {
            model.setEntryCurrentRowIndex("schtasktime", i);
            Date schTime = (Date)model.getValue("schtime", i);
            Calendar cal = this.getOffsetDate(dateOffset, schTime, repeatMode);
            for (int j = 0; j < cnt; ++j) {
                memberJsonList.clear();
                memberNameList.clear();
                String dimNumber = (String)model.getValue("dimnumber", j);
                JSONArray jsonArray = (JSONArray)paramMap.get(dimNumber);
                Object[] paramArr = jsonArray.toArray();
                Set<String> paramSet = this.patchParam(cal, ((String)(StringUtils.isNotEmpty((String)((String)paramArr[0])) ? paramArr[0] + (StringUtils.isNotEmpty((String)((String)paramArr[1])) ? "," + paramArr[1] : "") : paramArr[1])).split(","));
                Map memberMap = (Map)dimMemberMap.get(dimNumber);
                for (OlapServerDimMemberMetaInfo info : memberMap.values()) {
                    String name = info.getName();
                    String number = info.getNumber();
                    if (!paramSet.contains(name.toLowerCase(Locale.ENGLISH)) && !paramSet.contains(number.toLowerCase(Locale.ENGLISH))) continue;
                    Object[] memberArr = new Object[]{name, number, info.getId(), info.getLongNumber()};
                    memberJsonList.add(memberArr);
                    memberNameList.add(name);
                }
                model.setValue("memberjson_tag", (Object)JSON.toJSONString(memberJsonList), j);
                String dimMem = String.join((CharSequence)",", memberNameList);
                dimMem = dimMem.length() > 100 ? dimMem.substring(0, 96) + "..." : dimMem;
                model.setValue("dimmember", (Object)dimMem, j);
            }
        }
    }

    public Calendar getOffsetDate(Integer dateOffset, Date schTime, String repeatMode) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(schTime);
        if (dateOffset != 0) {
            switch (repeatMode) {
                case "mi": {
                    cal.add(12, dateOffset);
                    break;
                }
                case "h": {
                    cal.add(11, dateOffset);
                    break;
                }
                case "d": {
                    cal.add(5, dateOffset);
                    break;
                }
                case "w": {
                    cal.add(4, dateOffset);
                    break;
                }
                case "m": {
                    cal.add(2, dateOffset);
                    break;
                }
                case "q": {
                    cal.add(2, dateOffset * 3);
                    break;
                }
                case "y": {
                    cal.add(1, dateOffset);
                    break;
                }
                case "def": {
                    cal.add(1, dateOffset);
                    cal.add(2, dateOffset);
                    cal.add(5, dateOffset);
                    cal.add(11, dateOffset);
                    cal.add(12, dateOffset);
                    cal.add(13, dateOffset);
                }
            }
        }
        return cal;
    }

    private Set<String> patchParam(Calendar cal, String ... dimStr) {
        int[] monthQuarterArr = new int[]{1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4};
        HashSet<String> result = new HashSet<String>(dimStr.length);
        for (String str : dimStr) {
            String s1 = str.toLowerCase(Locale.ENGLISH).replaceAll("\\{yyyy}", String.valueOf(cal.get(1))).replaceAll("\\{qq}", String.format("%02d", monthQuarterArr[cal.get(2)])).replaceAll("\\{mm}", String.format("%02d", cal.get(2) + 1)).replaceAll("\\{dd}", String.format("%02d", cal.get(5))).replaceAll("\\{hh}", String.format("%02d", cal.get(11))).replaceAll("\\{mi}", String.format("%02d", cal.get(12))).replaceAll("\\{ss}", String.format("%02d", cal.get(13)));
            result.add(s1);
            String s2 = str.toLowerCase(Locale.ENGLISH).replaceAll("\\{yyyy}", String.valueOf(cal.get(1))).replaceAll("\\{qq}", String.valueOf(monthQuarterArr[cal.get(2)])).replaceAll("\\{mm}", String.valueOf(cal.get(2) + 1)).replaceAll("\\{dd}", String.valueOf(cal.get(5))).replaceAll("\\{hh}", String.valueOf(cal.get(11))).replaceAll("\\{mi}", String.valueOf(cal.get(12))).replaceAll("\\{ss}", String.valueOf(cal.get(13)));
            result.add(s2);
        }
        return result;
    }

    private void updateCronInfo(IDataModel model) {
        String repeatMode = (String)model.getValue("repeatmode");
        int cycleNum = (Integer)model.getValue("cyclenum");
        Date startTime = (Date)model.getValue("starttime");
        ArrayList<Integer> hourList = new ArrayList<Integer>(8);
        for (int h = 0; h < 24; ++h) {
            String hourKey = "ckhour_" + String.format("%02d", h);
            boolean checked = (Boolean)model.getValue(hourKey);
            if (!checked) continue;
            hourList.add(h);
        }
        int[] hour = hourList.stream().mapToInt(Integer::intValue).toArray();
        ArrayList<Integer> weekList = new ArrayList<Integer>(4);
        for (int w = 1; w < 8; ++w) {
            String weekKey = "week" + w;
            boolean checked = (Boolean)model.getValue(weekKey);
            if (!checked) continue;
            weekList.add(w);
        }
        int[] weekday = weekList.stream().mapToInt(Integer::intValue).toArray();
        ArrayList<Integer> dayList = new ArrayList<Integer>(8);
        for (int d = 1; d < 33; ++d) {
            String dayKey = "day" + d;
            boolean checked = (Boolean)model.getValue(dayKey);
            if (!checked) continue;
            dayList.add(d);
        }
        int[] day = dayList.stream().mapToInt(Integer::intValue).toArray();
        boolean weekFlag = (Boolean)model.getValue("ckbyweek");
        String th = (String)model.getValue("comno");
        String noWeek = (String)model.getValue("comweek");
        ArrayList<Integer> monList = new ArrayList<Integer>(6);
        for (int m = 1; m < 13; ++m) {
            String monKey = "mon" + m;
            boolean checked = (Boolean)model.getValue(monKey);
            if (!checked) continue;
            monList.add(m);
        }
        int[] month = monList.stream().mapToInt(Integer::intValue).toArray();
        String dayOrWeek = (String)model.getValue("combdorw");
        String cronStr = (String)model.getValue("plan");
        if ("q".equals(repeatMode)) {
            month = new int[]{1, 4, 7, 10};
        }
        Map resultMap = FSAScheduleHelper.scheduleCron((String)repeatMode, (Date)startTime, (int)cycleNum, (int[])hour, (int[])weekday, (int[])day, (boolean)weekFlag, (String)th, (String)noWeek, (int[])month, (String)dayOrWeek, (String)cronStr);
        model.setValue("txtdesc", resultMap.get("txtdesc"));
        CronStruct cron = (CronStruct)resultMap.get("plan");
        if (!"def".equals(repeatMode)) {
            if (cron != null) {
                model.setValue("plan", (Object)cron.toString());
            } else {
                model.setValue("plan", null);
            }
        }
    }

    private void adjustByRepeatMode(IFormView view, IDataModel model) {
        String repeatMode = (String)model.getValue("repeatmode");
        view.setVisible(Boolean.FALSE, new String[]{"flexpworday", "flexpmonths", "flexpweek", "flexpbyweek", "flexphour", "plan", "cyclenum"});
        if (StringUtils.isEmpty((String)repeatMode)) {
            model.setValue("repeatmode", (Object)"n");
            return;
        }
        switch (repeatMode) {
            case "mi": 
            case "d": {
                view.setVisible(Boolean.TRUE, new String[]{"flexphour", "cyclenum"});
                break;
            }
            case "h": {
                view.setVisible(Boolean.TRUE, new String[]{"cyclenum"});
                break;
            }
            case "w": {
                model.setValue("cyclenum", (Object)1);
                view.setVisible(Boolean.TRUE, new String[]{"flexpweek", "flexphour"});
                break;
            }
            case "m": {
                view.setVisible(Boolean.TRUE, new String[]{"flexpworday", "flexphour", "cyclenum"});
                this.adjustByDayOrWeek(view, model);
                break;
            }
            case "q": {
                model.setValue("cyclenum", (Object)1);
                view.setVisible(Boolean.TRUE, new String[]{"flexpworday", "flexphour"});
                break;
            }
            case "y": {
                model.setValue("cyclenum", (Object)1);
                view.setVisible(Boolean.TRUE, new String[]{"flexpmonths", "flexphour"});
                this.adjustByWeek(view, model);
                break;
            }
            case "def": {
                view.setVisible(Boolean.TRUE, new String[]{"plan"});
            }
        }
    }

    private void adjustByDayOrWeek(IFormView view, IDataModel model) {
        String byDayOrWeek = (String)model.getValue("combdorw");
        view.setVisible(Boolean.valueOf("w".equals(byDayOrWeek)), new String[]{"flexpbyweek"});
    }

    private void adjustByWeek(IFormView view, IDataModel model) {
        view.setVisible((Boolean)model.getValue("ckbyweek"), new String[]{"flexpbyweek"});
    }

    private void adjustByCron(IDataModel model) {
        String hourCron;
        String[] crones;
        for (int h = 0; h < 24; ++h) {
            String hour = "ckhour_" + String.format("%02d", h);
            model.setValue(hour, (Object)"0");
        }
        String cron = (String)model.getValue("plan");
        if (StringUtils.isNotEmpty((String)cron) && (crones = cron.split(" ")).length >= 6 && StringUtils.isNotEmpty((String)(hourCron = crones[2])) && !"*".equals(hourCron)) {
            String[] hours;
            for (String h : hours = hourCron.split(",")) {
                String hour = "ckhour_" + String.format("%02d", Integer.parseInt(h));
                model.setValue(hour, (Object)"1");
            }
        }
    }

    private void adjustByDays(IDataModel model) {
        for (int d = 1; d < 33; ++d) {
            model.setValue("day" + d, (Object)"0");
        }
        String days = (String)model.getValue("days");
        if (StringUtils.isNotEmpty((String)days)) {
            String[] dayArr;
            for (String d : dayArr = days.split(",")) {
                model.setValue("day" + d, (Object)"1");
            }
        }
    }

    private void adjustByMonths(IDataModel model) {
        for (int m = 1; m < 13; ++m) {
            model.setValue("mon" + m, (Object)"0");
        }
        String months = (String)model.getValue("months");
        if (StringUtils.isNotEmpty((String)months)) {
            String[] monthArr;
            for (String m : monthArr = months.split(",")) {
                model.setValue("mon" + m, (Object)"1");
            }
        }
    }

    private void adjustByWeeks(IDataModel model) {
        for (int w = 1; w < 8; ++w) {
            model.setValue("week" + w, (Object)"0");
        }
        String weeks = (String)model.getValue("weeks");
        if (StringUtils.isNotEmpty((String)weeks)) {
            String[] weekArr;
            for (String w : weekArr = weeks.split(",")) {
                model.setValue("week" + w, (Object)"1");
            }
        }
    }
}

