/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IPageCache;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.data.fsa.utils.schedule.FSAScheduleHelper;

public class FSAScheduleTaskConfigListPlugin
extends AbstractListPlugin {
    private static final String PAGE_CACHE_ID_MAP = "pageCacheIdMap";

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        String operateKey = args.getOperateKey();
        if (operationResult != null && operationResult.isSuccess()) {
            switch (operateKey) {
                case "delete": 
                case "disable": 
                case "enable": {
                    List successPkIds = operationResult.getSuccessPkIds();
                    if (successPkIds == null || successPkIds.isEmpty()) {
                        return;
                    }
                    IPageCache pageCache = this.getView().getPageCache();
                    String idMapJson = pageCache.get(PAGE_CACHE_ID_MAP);
                    pageCache.remove(PAGE_CACHE_ID_MAP);
                    Map idMap = (Map)JSON.parseObject((String)idMapJson, (TypeReference)new TypeReference<Map<Long, String>>(){}, (Feature[])new Feature[0]);
                    ArrayList schIdList = new ArrayList(successPkIds.size());
                    for (Object obj : successPkIds) {
                        schIdList.add(idMap.get(Long.parseLong(obj.toString())));
                    }
                    if ("delete".equalsIgnoreCase(operateKey)) {
                        FSAScheduleHelper.deleteScheduleAndJob(schIdList);
                        break;
                    }
                    this.setSchTimeStatus(successPkIds, "disable".equalsIgnoreCase(operateKey) ? "0" : "1");
                    FSAScheduleHelper.setScheduleAndJobStatus(schIdList, (String)("disable".equalsIgnoreCase(operateKey) ? "0" : "1"));
                }
            }
        }
    }

    private void setSchTimeStatus(List<Object> successPkIds, String status) {
        Date nowTime = new Date();
        Map dyoMap = BusinessDataServiceHelper.loadFromCache((Object[])successPkIds.toArray(), (String)"fsa_scheduletaskconfig");
        ArrayList<DynamicObject> dyoList = new ArrayList<DynamicObject>(dyoMap.size());
        Collection dyoCol = dyoMap.values();
        for (DynamicObject dyo : dyoCol) {
            DynamicObjectCollection schTimeCol = dyo.getDynamicObjectCollection("schtasktime");
            if (schTimeCol == null || schTimeCol.isEmpty()) continue;
            boolean addFlag = false;
            for (DynamicObject timeDyo : schTimeCol) {
                if (nowTime.compareTo(timeDyo.getDate("schtime")) > 0) continue;
                timeDyo.set("timestatus", (Object)status);
                if (addFlag) continue;
                addFlag = true;
            }
            if (!addFlag) continue;
            dyoList.add(dyo);
        }
        SaveServiceHelper.update((DynamicObject[])dyoList.toArray(new DynamicObject[0]));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        switch (((FormOperate)args.getSource()).getOperateKey()) {
            case "delete": 
            case "disable": 
            case "enable": {
                Object[] primaryKeyValues = args.getListSelectedData().getPrimaryKeyValues();
                Map<Long, String> idMap = this.getSchScheduleIdList(primaryKeyValues);
                this.getView().getPageCache().put(PAGE_CACHE_ID_MAP, JSON.toJSONString(idMap));
            }
        }
    }

    private Map<Long, String> getSchScheduleIdList(Object[] primaryKeyValues) {
        if (primaryKeyValues == null || primaryKeyValues.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<Long, String> resultMap = new HashMap<Long, String>(primaryKeyValues.length);
        Map dyoMap = BusinessDataServiceHelper.loadFromCache((Object[])primaryKeyValues, (String)"fsa_scheduletaskconfig");
        for (DynamicObject dyo : dyoMap.values()) {
            resultMap.put(dyo.getLong("id"), dyo.getString("schid"));
        }
        return resultMap;
    }
}

