/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.data.disf.model.impl.IDataBaseModel;
import kd.data.disf.utils.IDataValueUtil;

public class FSASchemeRptCustomFilterSetting
extends IDataBaseModel<Long, Map<Long, FSASchemeRptCustomFilterRow>, Map<List<Long>, Long>> {
    private static final long serialVersionUID = -6794935397184896872L;
    private transient Map<Long, Long> userFilterRowIndexs;
    private static final Random RANDOM = new SecureRandom();

    public FSASchemeRptCustomFilterRow getUserFilter(Long userId) {
        return (FSASchemeRptCustomFilterRow)((Object)((Map)this.v2).get(((Map)this.v3).get(userId)));
    }

    private void rebuildUserFilterIndexMap() {
        this.userFilterRowIndexs = new HashMap<Long, Long>(((Map)this.v3).size());
        for (Map.Entry en : ((Map)this.v3).entrySet()) {
            for (Long userId : (List)en.getKey()) {
                this.userFilterRowIndexs.put(userId, (Long)en.getValue());
            }
        }
    }

    protected void updateValueArray(Object[] v) {
        Map.Entry entry;
        Map.Entry en;
        Iterator iterator;
        this.v1 = this.getLong(v, 0);
        this.v2 = new HashMap(10);
        JSONObject jsonObject = IDataValueUtil.getJSONObject((Object[])v, (int)1);
        if (jsonObject != null) {
            iterator = ((Map)jsonObject.toJavaObject(Map.class)).entrySet().iterator();
            while (iterator.hasNext()) {
                entry = en = iterator.next();
                ((Map)this.v2).put(IDataValueUtil.getLong(entry.getKey()), IDataValueUtil.toBasePropObject(entry.getValue(), FSASchemeRptCustomFilterRow.class));
            }
        }
        this.v3 = new HashMap(10);
        jsonObject = IDataValueUtil.getJSONObject((Object[])v, (int)2);
        if (jsonObject != null) {
            iterator = ((Map)jsonObject.toJavaObject(Map.class)).entrySet().iterator();
            while (iterator.hasNext()) {
                entry = en = iterator.next();
                ((Map)this.v3).put(JSON.parseArray((String)entry.getKey().toString(), Long.class), IDataValueUtil.getLong(entry.getValue()));
            }
        }
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public Map<Long, FSASchemeRptCustomFilterRow> getFilterRowMap() {
        return (Map)this.v2;
    }

    public void setFilterRowMap(Map<Long, FSASchemeRptCustomFilterRow> v2) {
        this.v2 = v2;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public Map<Long, Long> getUserFilterRowIndexs() {
        return this.userFilterRowIndexs;
    }

    public void setUserFilterRowIndexs(Map<Long, Long> v3) {
        this.userFilterRowIndexs = v3;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public Long getPeriodType() {
        return (Long)this.v1;
    }

    public void setPeriodType(Long v1) {
        this.v1 = v1;
    }

    public FSASchemeRptCustomFilterRow getRowByID(long rowID) {
        return (FSASchemeRptCustomFilterRow)((Object)((Map)this.v2).get(rowID));
    }

    public FSASchemeRptCustomFilterSetting() {
    }

    public FSASchemeRptCustomFilterSetting(DynamicObjectCollection res) {
        this.v2 = new HashMap(10);
        this.userFilterRowIndexs = new HashMap<Long, Long>(10);
        this.v3 = new LinkedHashMap(res.size());
        for (DynamicObject dy : res) {
            Long rowId = (Long)dy.get("id");
            DynamicObjectCollection users = (DynamicObjectCollection)dy.get("user");
            DynamicObjectCollection orgs = (DynamicObjectCollection)dy.get("org");
            Long beginPeriodId = ((DynamicObject)dy.get("begin_period")).getLong("id");
            Long endPeriodId = ((DynamicObject)dy.get("end_period")).getLong("id");
            if (rowId == 0L) {
                rowId = System.currentTimeMillis() << (int)(RANDOM.nextLong() + 10L);
                dy.set("id", (Object)rowId);
            }
            ArrayList<Long> userIds = new ArrayList<Long>(users.size());
            for (int i = 0; i < users.size(); ++i) {
                userIds.add(((DynamicObject)users.get(i)).getLong(2));
            }
            LinkedList<Long> orgIds = new LinkedList<Long>();
            for (int i = 0; i < orgs.size(); ++i) {
                orgIds.add(((DynamicObject)orgs.get(i)).getLong(2));
            }
            ((Map)this.v2).put(rowId, new FSASchemeRptCustomFilterRow(orgIds, beginPeriodId, endPeriodId));
            ((Map)this.v3).put(userIds, rowId);
        }
        this.rebuildUserFilterIndexMap();
    }

    public FSASchemeRptCustomFilterSetting(Long periodType) {
        this.v1 = periodType;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public Map<List<Long>, Long> getUserOrgFilterList() {
        return (Map)this.v3;
    }

    public void setUserOrgFilterList(Map<List<Long>, Long> userOrgFilterList) {
        this.v3 = userOrgFilterList;
    }

    public static class FSASchemeRptCustomFilterRow
    extends IDataBaseModel<List<Long>, Long, Long> {
        public static final long serialVersionUID = 6938002623591215917L;

        public FSASchemeRptCustomFilterRow() {
        }

        public FSASchemeRptCustomFilterRow(List<Long> filterOrg, Long startPeriodId, Long endPeriodId) {
            this.v1 = filterOrg;
            this.v2 = startPeriodId;
            this.v3 = endPeriodId;
        }

        public FSASchemeRptCustomFilterRow(JSONArray jsonArray) {
            super(jsonArray);
        }

        protected void updateValueArray(Object[] v) {
            JSONArray jsonArray = this.getJSONArray(v, 0);
            this.v1 = jsonArray != null ? jsonArray.toJavaList(Long.class) : null;
            this.v2 = this.getLong(v, 1);
            this.v3 = this.getLong(v, 2);
        }

        @JSONField(serialize=false)
        @JsonIgnore
        public List<Long> getFilterOrg() {
            return (List)this.v1;
        }

        public void setFilterOrg(List<Long> filterOrg) {
            this.v1 = filterOrg;
        }

        @JSONField(serialize=false)
        @JsonIgnore
        public Long getStartPeriodId() {
            return (Long)this.v2;
        }

        public void setStartPeriodId(Long startPeriodId) {
            this.v2 = startPeriodId;
        }

        @JSONField(serialize=false)
        @JsonIgnore
        public Long getEndPeriodId() {
            return (Long)this.v3;
        }

        public void setEndPeriodId(Long endPeriodId) {
            this.v3 = endPeriodId;
        }
    }
}

