/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.data.disf.model.impl.IDataMapEntry;
import kd.data.fsa.formplugin.util.BaseDataUtil;
import kd.data.fsa.model.file.FSAFileInfoModel;
import kd.data.fsa.utils.FSADataCollectionHelper;
import kd.data.fsa.utils.FSAJSONUtils;
import kd.data.fsa.utils.FSAParamTemplateHelper;

public class FSASrcParamSettingFormPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final String DATA_SOURCE = "DATASOURCE_FIELD";
    private static final String PARAM = "COMBINATION_PARAM";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        JSONObject params = (JSONObject)this.getView().getFormShowParameter().getCustomParam("F7PARAM");
        this.getPageCache().put("pageType", params.getString("pageType"));
        if (DATA_SOURCE.equals(this.getPageCache().get("pageType"))) {
            this.dataSourceInit(params);
        } else if (PARAM.equals(this.getPageCache().get("pageType"))) {
            this.paramInit(params);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"save"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "save": {
                this.save();
                break;
            }
            default: {
                this.getView().close();
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        IDataModel model = this.getModel();
        int curIdx = model.getEntryCurrentRowIndex("entryentity");
        switch (key) {
            case "bcm_cslscheme_f7callback": {
                Object returnData = closedCallBackEvent.getReturnData();
                JSONObject params = (JSONObject)this.getView().getFormShowParameter().getCustomParam("F7PARAM");
                String paramNumber = params.getString("paramNumber");
                if ("fileParamSource".equals(paramNumber)) {
                    if (returnData == null) break;
                    model.setValue("param", returnData, curIdx);
                    String number = (String)model.getValue("number");
                    if ("fileUpload".equals(number)) {
                        FSAFileInfoModel fileInfoModel = (FSAFileInfoModel)FSAJSONUtils.cast((String)returnData.toString(), FSAFileInfoModel.class);
                        model.setValue("paramvalue", (Object)fileInfoModel.getFileName(), curIdx);
                        break;
                    }
                    if (!"selectSheet".equals(number)) break;
                    model.setValue("paramvalue", returnData, curIdx);
                    break;
                }
                ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
                if (selectedRows == null) {
                    return;
                }
                model.setValue("param", selectedRows.get(0).getPrimaryKeyValue(), curIdx);
                model.setValue("paramvalue", (Object)selectedRows.get(0).getName(), curIdx);
                break;
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        if (DATA_SOURCE.equals(this.getPageCache().get("pageType"))) {
            int row = evt.getRowIndex();
            String fieldKey = evt.getFieldName();
            if ("paramvalue".equals(fieldKey)) {
                DynamicObject entryentity = this.getModel().getEntryRowEntity("entryentity", row);
                String relynumber = entryentity.getString("relynumber");
                String datarequest = entryentity.getString("datarequest");
                String requesttype = entryentity.getString("requesttype");
                String filter = entryentity.getString("filter");
                String formId = entryentity.getString("formid");
                String caption = entryentity.getString("caption");
                String paramNumber = entryentity.getString("number");
                String param = entryentity.getString("param");
                this.getDataSetWithMethod(requesttype, filter, datarequest, relynumber, formId, caption, paramNumber, param);
            }
        }
    }

    private void dataSourceInit(JSONObject params) {
        String datarequest;
        DynamicObject objectType;
        String paramNumber = params.getString("paramNumber");
        IDataModel model = this.getModel();
        Map srcParam = FSADataCollectionHelper.getSrcParamMapFromJson((String)params.getString("paramsrc_tag"));
        DynamicObject entityLoad = FSAParamTemplateHelper.getParamDynamic((String)paramNumber);
        DynamicObjectCollection entryentity = entityLoad.getDynamicObjectCollection("entryentity");
        HashMap<String, String> number2name = new HashMap<String, String>(2);
        HashMap number2value = new HashMap(2);
        if (srcParam != null) {
            try {
                for (DynamicObject dynamicObject : entryentity) {
                    String paramNum = dynamicObject.getString("paramnumber");
                    Object paramValue = srcParam.get(paramNum);
                    if (paramValue == null) continue;
                    objectType = dynamicObject.getDynamicObject("objecttype");
                    datarequest = objectType == null ? "" : objectType.getString("number");
                    String value2name = null;
                    String requestType = dynamicObject.getString("requesttype");
                    if ("0".equals(requestType)) {
                        value2name = this.getValueWithJczl(datarequest, paramValue);
                    } else if ("1".equals(requestType)) {
                        value2name = this.getValueWithInterface(datarequest, Long.parseLong(paramValue.toString()));
                    } else if ("2".equalsIgnoreCase(requestType)) {
                        if ("fileUpload".equals(paramNum)) {
                            FSAFileInfoModel fileInfoModel = (FSAFileInfoModel)FSAJSONUtils.cast((String)paramValue.toString(), FSAFileInfoModel.class);
                            value2name = fileInfoModel.getFileName();
                        } else {
                            value2name = paramValue.toString();
                        }
                    }
                    number2name.put(paramNum, value2name);
                    number2value.put(paramNum, paramValue);
                }
            }
            catch (RuntimeException exception) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5931\u8d25\u3002\u539f\u56e0\uff1a\u5408\u5e76\u4f53\u7cfb\u6216\u7ec4\u7ec7\u89c6\u56fe\u5bf9\u5e94\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e", (String)"FSASrcParamSettingFormPlugin_1", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        int index = 0;
        model.batchCreateNewEntryRow("entryentity", entryentity.size());
        for (DynamicObject dynamicObject : entryentity) {
            String paramNum = dynamicObject.getString("paramNumber");
            model.setValue("name", (Object)dynamicObject.getString("paramname"), index);
            model.setValue("number", (Object)paramNum, index);
            model.setValue("datatype", (Object)this.getDataType(dynamicObject.getString("datatype")), index);
            model.setValue("isnecessary", (Object)(dynamicObject.getBoolean("isinput") ? "1" : "0"), index);
            model.setValue("paramvalue", (Object)number2name.getOrDefault(paramNum, dynamicObject.getString("operatename")), index);
            model.setValue("param", number2value.get(paramNum), index);
            objectType = dynamicObject.getDynamicObject("objecttype");
            datarequest = objectType == null ? "" : objectType.getString("number");
            model.setValue("datarequest", (Object)datarequest, index);
            model.setValue("relynumber", (Object)dynamicObject.getString("relyparamnumber"), index);
            model.setValue("requesttype", (Object)dynamicObject.getString("requesttype"), index);
            model.setValue("filter", (Object)dynamicObject.getString("filter"), index);
            model.setValue("formid", (Object)dynamicObject.getString("formid"), index);
            model.setValue("caption", (Object)dynamicObject.getString("caption"), index);
            this.getView().setEnable(Boolean.FALSE, index, new String[]{"isnecessary", "paramvalue"});
            ++index;
        }
    }

    private String getDataType(String dataTypeValue) {
        switch (dataTypeValue) {
            case "0": {
                return ResManager.loadKDString((String)"\u65e5\u671f", (String)"FSASrcParamSettingFormPlugin_5", (String)"data-fsa-formplugin", (Object[])new Object[0]);
            }
            case "1": {
                return ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599", (String)"FSASrcParamSettingFormPlugin_6", (String)"data-fsa-formplugin", (Object[])new Object[0]);
            }
            case "2": {
                return ResManager.loadKDString((String)"\u6d6e\u70b9\u6570", (String)"FSASrcParamSettingFormPlugin_7", (String)"data-fsa-formplugin", (Object[])new Object[0]);
            }
            case "3": {
                return ResManager.loadKDString((String)"\u6574\u6570", (String)"FSASrcParamSettingFormPlugin_8", (String)"data-fsa-formplugin", (Object[])new Object[0]);
            }
            case "4": {
                return ResManager.loadKDString((String)"\u5e03\u5c14\u578b", (String)"FSASrcParamSettingFormPlugin_9", (String)"data-fsa-formplugin", (Object[])new Object[0]);
            }
            case "5": {
                return ResManager.loadKDString((String)"\u5b57\u7b26\u4e32", (String)"FSASrcParamSettingFormPlugin_10", (String)"data-fsa-formplugin", (Object[])new Object[0]);
            }
            case "6": {
                return ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20", (String)"FSASrcParamSettingFormPlugin_11", (String)"data-fsa-formplugin", (Object[])new Object[0]);
            }
        }
        return "";
    }

    private String getValueWithInterface(String datarequest, Long paramvalue) {
        return null;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        IDataModel model = this.getModel();
        if ("param".equals(name)) {
            int curIdx = model.getEntryCurrentRowIndex("entryentity");
            String number = (String)model.getValue("number", curIdx);
            int rowCount = model.getEntryRowCount("entryentity");
            JSONObject params = (JSONObject)this.getView().getFormShowParameter().getCustomParam("F7PARAM");
            String paramNumber = params.getString("paramNumber");
            DynamicObject entityLoad = FSAParamTemplateHelper.getParamDynamic((String)paramNumber);
            DynamicObjectCollection entryentity = entityLoad.getDynamicObjectCollection("entryentity");
            for (int i = 0; i < rowCount; ++i) {
                String relyNumber = (String)model.getValue("relynumber", i);
                if ("fileUpload".equalsIgnoreCase(number) && "selectSheet".equalsIgnoreCase(((DynamicObject)entryentity.get(i)).getString("paramnumber"))) {
                    String fileParam = (String)model.getValue("param", 0);
                    if (!StringUtils.isNotEmpty((CharSequence)fileParam)) continue;
                    FSAFileInfoModel fileInfoModel = (FSAFileInfoModel)FSAJSONUtils.cast((String)fileParam, FSAFileInfoModel.class);
                    List sheetNameList = fileInfoModel.getSheetNameList();
                    model.setValue("param", sheetNameList.get(0), i);
                    model.setValue("paramvalue", sheetNameList.get(0), i);
                    continue;
                }
                if (!StringUtils.isNotEmpty((CharSequence)relyNumber) || !number.equals(relyNumber)) continue;
                model.setValue("param", null, i);
                model.setValue("paramvalue", (Object)((DynamicObject)entryentity.get(i)).getString("operatename"), i);
            }
        }
    }

    private String getValueWithJczl(String datarequest, Object ... paramValue) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)paramValue[0], (String)datarequest);
        return dynamicObject.getString("name");
    }

    private void getDataSetWithMethod(String requestTpye, String filter, String datarequest, String relynumber, String formId, String caption, String paramNumber, String param) {
        IDataMapEntry<Boolean, DynamicObject> booleanLongIDataMapEntry = this.checkAndGetRelyValue(relynumber);
        Boolean rely = (Boolean)booleanLongIDataMapEntry.getKey();
        DynamicObject relyDynamicObject = (DynamicObject)booleanLongIDataMapEntry.getValue();
        if (rely.booleanValue() && !StringUtils.isNotEmpty((CharSequence)relyDynamicObject.getString("param"))) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9%s", (String)"FSASrcParamSettingFormPlugin_0", (String)"data-fsa-formplugin", (Object[])new Object[0]), relyDynamicObject.getString("name")));
            return;
        }
        if ("0".equals(requestTpye)) {
            this.openjczlF7(datarequest, filter, booleanLongIDataMapEntry);
        } else if ("1".equals(requestTpye)) {
            this.openf7withInteface(datarequest, booleanLongIDataMapEntry);
        } else if ("2".equals(requestTpye)) {
            this.openDynForm(paramNumber, formId, caption, booleanLongIDataMapEntry, param);
        }
    }

    private void openDynForm(String paramNumber, String formId, String caption, IDataMapEntry<Boolean, DynamicObject> booleanLongIDataMapEntry, String param) {
        FormShowParameter formShowParameter = new FormShowParameter();
        Boolean rely = (Boolean)booleanLongIDataMapEntry.getKey();
        if (rely.booleanValue()) {
            DynamicObject value = (DynamicObject)booleanLongIDataMapEntry.getValue();
            formShowParameter.setCustomParam("customDependOn", (Object)value.getString("param"));
        }
        if ("fileUpload".equals(paramNumber)) {
            formShowParameter.setCustomParam("customHiddenOperatePanel", (Object)Boolean.TRUE);
        }
        formShowParameter.setCustomParam("customEcho", (Object)param);
        formShowParameter.setFormId(formId);
        formShowParameter.setCaption(caption);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bcm_cslscheme_f7callback");
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(formShowParameter);
    }

    private void openf7withInteface(String datarequest, IDataMapEntry<Boolean, DynamicObject> booleanLongIDataMapEntry) {
    }

    private void openjczlF7(String datarequest, String filter, IDataMapEntry<Boolean, DynamicObject> booleanLongIDataMapEntry) {
        ListShowParameter listShowParameter = new ListShowParameter();
        Boolean rely = (Boolean)booleanLongIDataMapEntry.getKey();
        String filterName = null;
        Set<Long> filterCollections = null;
        if (rely.booleanValue()) {
            filterName = filter;
            DynamicObject value = (DynamicObject)booleanLongIDataMapEntry.getValue();
            long paramfilter = value.getLong("param");
            filterCollections = Collections.singleton(paramfilter);
        }
        if ("bcm_cslscheme".equals(datarequest)) {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
            qFilters.add(new QFilter(filterName, "in", filterCollections));
            qFilters.add(new QFilter("number", "!=", (Object)"DefaultRateScheme"));
            BaseDataUtil.openF7List(this, datarequest, "bcm_cslscheme_f7callback", qFilters, Collections.singletonMap("custom", "fsa"));
            return;
        }
        BaseDataUtil.openF7List(this, datarequest, "bcm_cslscheme_f7callback", filterName, filterCollections, Collections.singletonMap("custom", "fsa"));
    }

    private IDataMapEntry<Boolean, DynamicObject> checkAndGetRelyValue(String relynumber) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)relynumber)) {
            return new IDataMapEntry((Object)Boolean.FALSE, null);
        }
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        Optional<DynamicObject> paramnumber = entryentity.stream().filter(p -> p.getString("number").equals(relynumber)).findFirst();
        DynamicObject dynamicObject = paramnumber.get();
        return new IDataMapEntry((Object)Boolean.TRUE, (Object)dynamicObject);
    }

    private void paramInit(JSONObject params) {
        IDataModel model = this.getModel();
        int length = model.createNewEntryRow("entryentity");
        int defaultValue = model.createNewEntryRow("entryentity");
        model.setValue("name", (Object)"\u5b57\u6bb5\u957f\u5ea6", length);
        model.setValue("number", (Object)"length", length);
        model.setValue("datatype", (Object)"\u57fa\u7840\u8d44\u6599", length);
        model.setValue("isnecessary", (Object)1, length);
        model.setValue("name", (Object)"\u9ed8\u8ba4\u503c", defaultValue);
        model.setValue("number", (Object)"DefaultValue", defaultValue);
        model.setValue("datatype", (Object)"\u57fa\u7840\u8d44\u6599", defaultValue);
        model.setValue("isnecessary", (Object)0, defaultValue);
        if (((Boolean)params.get((Object)"isQuote")).booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, 0, new String[]{"paramvalue"});
            this.getView().setEnable(Boolean.FALSE, 1, new String[]{"paramvalue"});
            this.getView().setEnable(Boolean.FALSE, 1, new String[]{"isnecessary"});
        }
        this.getView().setEnable(Boolean.FALSE, 0, new String[]{"isnecessary"});
        if (params.size() == 3) {
            int createtype = Integer.parseInt((String)params.get((Object)"createtype"));
            switch (createtype) {
                case 0: {
                    model.setValue("paramvalue", (Object)255, length);
                    break;
                }
                case 1: {
                    model.setValue("paramvalue", (Object)50, length);
                    break;
                }
                case 2: {
                    model.setValue("paramvalue", (Object)23, length);
                }
            }
        } else {
            model.setValue("paramvalue", params.get((Object)"length"), length);
            model.setValue("paramvalue", params.get((Object)"DefaultValue"), defaultValue);
        }
    }

    private void save() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        for (DynamicObject dynamicObject : entryentity) {
            Object paramObjectValue;
            String isNecessary;
            block9: {
                isNecessary = dynamicObject.getString("isnecessary");
                String number = dynamicObject.getString("number");
                paramObjectValue = dynamicObject.get("paramvalue");
                if (DATA_SOURCE.equals(this.getPageCache().get("pageType"))) {
                    String value = (String)dynamicObject.get("param");
                    JSONObject params = (JSONObject)view.getFormShowParameter().getCustomParam("F7PARAM");
                    String paramNumber = params.getString("paramNumber");
                    if ("fileParamSource".equals(paramNumber)) {
                        returnData.put(number, value);
                    } else {
                        returnData.put(number, StringUtils.isNotEmpty((CharSequence)value) ? Long.valueOf(Long.parseLong(value)) : null);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)value)) {
                        returnData.put(number + "name", paramObjectValue);
                    }
                } else {
                    try {
                        int paramValue;
                        if (number.equals("length") && (paramValue = Integer.parseInt((String)paramObjectValue)) < 0) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b57\u6bb5\u957f\u5ea6\u7684\u53c2\u6570\u503c\u5e94\u4e3a\u5927\u4e8e\u7b49\u4e8e0\u7684\u6574\u6570", (String)"FSASrcParamSettingFormPlugin_2", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        returnData.put(dynamicObject.getString("number"), paramObjectValue);
                    }
                    catch (NumberFormatException e) {
                        if (!"1".equals(isNecessary)) break block9;
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u53c2\u6570\u503c\u5e94\u4e3a\u6574\u6570\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165", (String)"FSASrcParamSettingFormPlugin_3", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                        return;
                    }
                }
            }
            if (!"1".equals(isNecessary) || (!DATA_SOURCE.equals(this.getPageCache().get("pageType")) || !StringUtils.isBlank((Object)dynamicObject.get("param"))) && (!PARAM.equals(this.getPageCache().get("pageType")) || !StringUtils.isBlank((Object)paramObjectValue))) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u5fc5\u586b\u9879\u672a\u586b\uff0c\u8bf7\u586b\u5199\u5b8c\u6bd5\u540e\u518d\u4fdd\u5b58", (String)"FSASrcParamSettingFormPlugin_4", (String)"data-fsa-formplugin", (Object[])new Object[0]));
            return;
        }
        view.returnDataToParent(returnData);
        view.close();
    }
}

