/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.data.disf.utils.IDataStringUtil;
import kd.data.fsa.model.rpt.config.FSAStandardReportItemModel;

public class FSAStdReportsFormPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        String reportType = (String)model.getValue("rpttype");
        Long id = (Long)model.getValue("id");
        if (id != 0L) {
            String userId;
            DynamicObjectCollection stdItemCol;
            DynamicObject stdReport = BusinessDataServiceHelper.loadSingle((Object)id, (String)"fsa_stdrpts");
            if (stdReport != null && (stdItemCol = stdReport.getDynamicObjectCollection("fsa_stdrptent")) != null && !stdItemCol.isEmpty()) {
                HashMap<String, FSAStandardReportItemModel> stdReportEntMap = new HashMap<String, FSAStandardReportItemModel>();
                for (DynamicObject stdItem : stdItemCol) {
                    String longNumber = stdItem.getString("longnumber");
                    long rptItemId = stdItem.getDynamicObject("rptitem").getLong("id");
                    int level = stdItem.getInt("level");
                    stdReportEntMap.put(longNumber, new FSAStandardReportItemModel(Long.valueOf(rptItemId), Long.valueOf(stdItem.getLong("rootitemid")), stdItem.getString("isleaf"), stdItem.getDynamicObject("rptitem").getString("name"), stdItem.getDynamicObject("rptitem").getString("number"), Integer.valueOf(level), Integer.valueOf(level + 1), Integer.valueOf(stdItem.getInt("lineno")), longNumber, stdItem.getString("itemtype"), Long.valueOf(stdItem.getLong("rootcategory_id")), Long.valueOf(stdItem.getLong("seccategory_id"))));
                }
                this.getView().getPageCache().put("stdReportEntry", JSON.toJSONString(stdReportEntMap));
            }
            if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(userId = RequestContext.getOrCreate().getUserId()), (String)"fsa", (String)"fsa_stdrpts", (String)"4715a0df000000ac")) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"bar_save", "btnaddsamelevel", "btnaddnextlevel", "btnremove"});
            }
        }
        this.initPage(reportType, this.getPageCache().get("searchTextItems"));
        this.initStdItems(this.getPageCache().get("searchTextStdItems"), null, null);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnaddsamelevel", "btnaddnextlevel", "btnremove"});
        IDataModel model = this.getModel();
        String rptType = (String)model.getValue("rpttype");
        Search search = (Search)this.getControl("searchitems");
        search.addEnterListener(see -> {
            String searchText = see.getText();
            this.getPageCache().put("searchTextItems", searchText);
            this.initPage(rptType, searchText);
        });
        Search searchStd = (Search)this.getControl("searchstditems");
        searchStd.addEnterListener(see -> {
            String searchText = see.getText();
            this.getPageCache().put("searchTextStdItems", searchText);
            this.initStdItems(searchText, null, null);
        });
        BasedataEdit rootCategoryF7 = (BasedataEdit)this.getControl("rootcategory");
        rootCategoryF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("rpttype", "=", (Object)rptType);
            qFilter.and("itemtype", "=", (Object)Character.valueOf('3'));
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
        BasedataEdit secCategoryF7 = (BasedataEdit)this.getControl("seccategory");
        secCategoryF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("rpttype", "=", (Object)rptType);
            qFilter.and("itemtype", "=", (Object)Character.valueOf('3'));
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        switch (key = ctl.getKey()) {
            case "btnaddnextlevel": {
                this.addNextLevel();
                break;
            }
            case "btnaddsamelevel": {
                this.addSameLevel();
                break;
            }
            case "btnremove": {
                EntryGrid stdItemEntryGrid = (EntryGrid)this.getControl("fsa_stdrptent");
                int[] stdItemSelectRows = stdItemEntryGrid.getSelectRows();
                String stdReportJsonStr = this.getView().getPageCache().get("stdReportEntry");
                if (!this.checkRemove(stdItemSelectRows, stdReportJsonStr)) {
                    return;
                }
                if (!StringUtils.isNotBlank((CharSequence)stdReportJsonStr)) break;
                Map stdReportEntMap = (Map)JSON.parseObject((String)stdReportJsonStr, (TypeReference)new TypeReference<Map<String, FSAStandardReportItemModel>>(){}, (Feature[])new Feature[0]);
                IDataModel model = this.getModel();
                boolean hasNext = false;
                for (int index : stdItemSelectRows) {
                    String longNumber = (String)model.getValue("longnumber", index);
                    int showLevel = (Integer)model.getValue("showlevel", index);
                    FSAStandardReportItemModel itemModel = (FSAStandardReportItemModel)stdReportEntMap.get(longNumber + '|' + (showLevel + 1) + 1);
                    if (itemModel == null) continue;
                    hasNext = true;
                    break;
                }
                if (hasNext) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u82e5\u79fb\u9664\uff0c\u9009\u4e2d\u7684\u62a5\u8868\u9879\u76ee\u53ca\u5176\u6240\u6709\u4e0b\u7ea7\u62a5\u8868\u9879\u76ee\u5747\u4f1a\u88ab\u79fb\u9664\uff0c\u662f\u5426\u786e\u8ba4\u64cd\u4f5c\uff1f", (String)"FSAStdReportsFormPlugin_8", (String)"data-fsa-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("callbackRemove", (IFormPlugin)this));
                    break;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u786e\u8ba4\u79fb\u9664\uff1f", (String)"FSAStdReportsFormPlugin_9", (String)"data-fsa-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("callbackRemove", (IFormPlugin)this));
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        MessageBoxResult messageBoxResult = messageBoxClosedEvent.getResult();
        String actionId = messageBoxClosedEvent.getCallBackId();
        if (MessageBoxResult.Yes == messageBoxResult && "callbackRemove".equalsIgnoreCase(actionId)) {
            this.removeItems();
        }
    }

    private void removeItems() {
        List<DynamicObject> stdRemoveItems = this.getRemoveStdItems();
        AbstractFormDataModel abstractModel = (AbstractFormDataModel)this.getModel();
        abstractModel.beginInit();
        TableValueSetter tvs = new TableValueSetter(new String[0]);
        tvs.addField("item", new Object[0]);
        tvs.addField("itemnumber", new Object[0]);
        tvs.addField("itemname", new Object[0]);
        tvs.addField("itemsrctype", new Object[0]);
        for (DynamicObject stdItem : stdRemoveItems) {
            DynamicObject item = stdItem.getDynamicObject("rptitem");
            tvs.addRow(new Object[]{item.getLong("id"), item.getString("number"), item.getString("name"), item.getString("rptitemsrctype")});
        }
        abstractModel.batchCreateNewEntryRow("itemsentryentity", tvs);
        abstractModel.endInit();
        this.getView().updateView("itemsentryentity");
    }

    private List<DynamicObject> getRemoveStdItems() {
        String longNumber;
        IDataModel model = this.getModel();
        EntryGrid stdItemEntryGrid = (EntryGrid)this.getControl("fsa_stdrptent");
        int[] stdItemSelectRows = stdItemEntryGrid.getSelectRows();
        ArrayList<DynamicObject> stdItemsSelect = new ArrayList<DynamicObject>(stdItemSelectRows.length);
        for (int index : stdItemSelectRows) {
            stdItemsSelect.add(model.getEntryRowEntity("fsa_stdrptent", index));
        }
        if (StringUtils.isNotBlank((CharSequence)this.getPageCache().get("searchTextStdItems"))) {
            this.initStdItems(null, null, null);
        }
        DynamicObjectCollection stdItemCol = model.getEntryEntity("fsa_stdrptent");
        ArrayList<DynamicObject> stdItemsRemoveList = new ArrayList<DynamicObject>(stdItemSelectRows.length);
        block1: for (DynamicObject stdItem : stdItemCol) {
            String longNumber2 = stdItem.getString("longnumber");
            for (DynamicObject stdItemSelect : stdItemsSelect) {
                String selectLongNumber = stdItemSelect.getString("longnumber");
                if (!longNumber2.equals(selectLongNumber) && !longNumber2.startsWith(selectLongNumber + '|')) continue;
                stdItemsRemoveList.add(stdItem);
                continue block1;
            }
        }
        stdItemCol.removeAll(stdItemsRemoveList);
        HashMap<String, Integer> locationMap = new HashMap<String, Integer>(stdItemCol.size());
        HashMap<String, String> longNumberChangeMap = new HashMap<String, String>();
        HashMap<String, FSAStandardReportItemModel> stdReportEntMap = new HashMap<String, FSAStandardReportItemModel>(stdItemCol.size());
        for (DynamicObject stdItem : stdItemCol) {
            String fatherLongNumber;
            String fatherNewLongNumber;
            int lineNo;
            longNumber = stdItem.getString("longnumber");
            int level = stdItem.getInt("level");
            int substringIndex = longNumber.lastIndexOf(124) + String.valueOf(level + 1).length() + 1;
            String locationKey = longNumber.substring(0, substringIndex);
            String oriLineNo = longNumber.substring(substringIndex);
            int n = lineNo = locationMap.get(locationKey) == null ? 0 : (Integer)locationMap.get(locationKey);
            if (level > 0 && (fatherNewLongNumber = (String)longNumberChangeMap.get(fatherLongNumber = longNumber.substring(0, longNumber.lastIndexOf(124)))) != null) {
                locationKey = fatherNewLongNumber + locationKey.substring(fatherNewLongNumber.length());
            }
            String newLongNumber = locationKey + ++lineNo;
            if (Integer.parseInt(oriLineNo) != lineNo) {
                longNumberChangeMap.put(longNumber, newLongNumber);
            }
            FSAStandardReportItemModel stdReportEnt = new FSAStandardReportItemModel(Long.valueOf(stdItem.getDynamicObject("rptitem").getLong("id")), Long.valueOf(stdItem.getLong("rootitemid")), "0", stdItem.getString("stditemname").replaceAll("\u3000", ""), stdItem.getString("stditemnumber"), Integer.valueOf(level), Integer.valueOf(level + 1), Integer.valueOf(lineNo), newLongNumber, stdItem.getString("itemtype"), Long.valueOf(stdItem.getLong("rootcategory_id")), Long.valueOf(stdItem.getLong("seccategory_id")));
            locationMap.put(locationKey, lineNo);
            stdReportEntMap.put(newLongNumber, stdReportEnt);
        }
        for (Map.Entry entry : stdReportEntMap.entrySet()) {
            longNumber = (String)entry.getKey();
            Integer level = ((FSAStandardReportItemModel)entry.getValue()).getLevel();
            if (stdReportEntMap.get(longNumber = longNumber + '|' + (level + 2) + 1) != null) continue;
            ((FSAStandardReportItemModel)entry.getValue()).setIsLeaf("1");
        }
        this.getView().getPageCache().put("stdReportEntry", stdReportEntMap.isEmpty() ? null : JSON.toJSONString(stdReportEntMap));
        this.initStdItems(this.getPageCache().get("searchTextStdItems"), null, null);
        return stdItemsRemoveList;
    }

    private boolean checkRemove(int[] stdItemSelectRows, String stdReportJsonStr) {
        if ((stdItemSelectRows == null || stdItemSelectRows.length == 0) && StringUtils.isNotBlank((CharSequence)stdReportJsonStr)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6807\u51c6\u62a5\u8868\u9879\u76ee\u6570\u636e\u3002", (String)"FSAStdReportsFormPlugin_6", (String)"data-fsa-formplugin", (Object[])new Object[0]));
            return false;
        }
        return stdItemSelectRows != null && stdItemSelectRows.length != 0 || !StringUtils.isBlank((CharSequence)stdReportJsonStr);
    }

    private void addSameLevel() {
        if (!this.checkAdd()) {
            return;
        }
        String stdReportJsonStr = this.getView().getPageCache().get("stdReportEntry");
        Map stdReportEntMap = StringUtils.isNotBlank((CharSequence)stdReportJsonStr) ? (Map)JSON.parseObject((String)stdReportJsonStr, (TypeReference)new TypeReference<Map<String, FSAStandardReportItemModel>>(){}, (Feature[])new Feature[0]) : new HashMap();
        List<DynamicObject> items = this.getSelectItems();
        EntryGrid stdItemEntryGrid = (EntryGrid)this.getControl("fsa_stdrptent");
        int[] stdItemSelectRows = stdItemEntryGrid.getSelectRows();
        ArrayList<FSAStandardReportItemModel> stdReportEntAddList = new ArrayList<FSAStandardReportItemModel>();
        if (stdItemSelectRows == null || stdItemSelectRows.length == 0) {
            this.addFirst(stdReportEntMap, items, stdReportEntAddList);
        } else {
            DynamicObject stdSelectItem = this.getModel().getEntryRowEntity("fsa_stdrptent", stdItemSelectRows[0]);
            int level = stdSelectItem.getInt("level");
            long rootItemId = stdSelectItem.getLong("rootitemid");
            String longNumber = stdSelectItem.getString("longnumber");
            int selectLineNo = stdSelectItem.getInt("lineno");
            this.handleSameLevelItem(items.size(), stdReportEntMap, longNumber, selectLineNo);
            this.getView().getPageCache().put("stdReportEntry", JSON.toJSONString(stdReportEntMap));
            Object[] obj = this.getSameLineNoAndOther(stdReportEntMap, longNumber, level);
            int lineNo = selectLineNo + 1;
            long preItemId = (Long)obj[0];
            for (DynamicObject item : items) {
                DynamicObject itemDo = item.getDynamicObject("item");
                FSAStandardReportItemModel stdReportEnt = new FSAStandardReportItemModel(Long.valueOf(itemDo.getLong("id")), Long.valueOf(rootItemId), "1", item.getString("itemname"), item.getString("itemnumber"), Integer.valueOf(level), Integer.valueOf(level + 1), Integer.valueOf(lineNo), longNumber.substring(0, longNumber.lastIndexOf(124) + String.valueOf(level + 1).length() + 1) + lineNo++, itemDo.getString("itemtype"), Long.valueOf(itemDo.getLong("rootcategory_id")), Long.valueOf(itemDo.getLong("seccategory_id")));
                stdReportEntAddList.add(stdReportEnt);
                stdReportEntMap.put((String)stdReportEnt.getLongNumber(), (FSAStandardReportItemModel)stdReportEnt);
            }
            this.initStdItems(this.getPageCache().get("searchTextStdItems"), stdReportEntAddList, preItemId);
        }
        this.getView().getPageCache().put("stdReportEntry", JSON.toJSONString(stdReportEntMap));
    }

    private void handleSameLevelItem(int insertSize, Map<String, FSAStandardReportItemModel> stdReportEntMap, String longNumber, int selectLineNo) {
        String partLongNumber = longNumber.substring(0, longNumber.length() - String.valueOf(selectLineNo).length());
        ArrayList stdRptEntList = new ArrayList(stdReportEntMap.size());
        stdReportEntMap.forEach((key, value) -> {
            stdRptEntList.add(value);
            if (key.startsWith(partLongNumber)) {
                if (!key.substring(partLongNumber.length()).contains("|") && value.getLineNo() > selectLineNo) {
                    value.setLineNo(Integer.valueOf(value.getLineNo() + insertSize));
                    value.setLongNumber(partLongNumber + value.getLineNo());
                } else {
                    int firstIndex = key.substring(partLongNumber.length()).indexOf(124);
                    if (firstIndex > 0) {
                        int lineNo = Integer.parseInt(key.substring(partLongNumber.length(), partLongNumber.length() + firstIndex));
                        String partLongNumberSub = key.substring(partLongNumber.length() + firstIndex);
                        if (partLongNumberSub.startsWith("|") && lineNo > selectLineNo) {
                            value.setLongNumber(partLongNumber + (lineNo + insertSize) + partLongNumberSub);
                        }
                    }
                }
            }
        });
        stdReportEntMap.clear();
        stdRptEntList.forEach(e -> stdReportEntMap.put(e.getLongNumber(), (FSAStandardReportItemModel)e));
    }

    private Object[] getSameLineNoAndOther(Map<String, FSAStandardReportItemModel> stdReportEntMap, String longNumberOri, int level) {
        Object[] obj = new Object[]{0L};
        DynamicObjectCollection strItemCol = this.getModel().getEntryEntity("fsa_stdrptent");
        if (strItemCol != null && !strItemCol.isEmpty()) {
            for (DynamicObject item : strItemCol) {
                String partLongNumber = item.getString("longnumber");
                if (!partLongNumber.equals(longNumberOri) && !partLongNumber.startsWith(longNumberOri + '|')) continue;
                obj[0] = item.getDynamicObject("rptitem").getLong("id");
            }
        }
        return obj;
    }

    private void addNextLevel() {
        if (!this.checkAdd()) {
            return;
        }
        String stdReportJsonStr = this.getView().getPageCache().get("stdReportEntry");
        Map stdReportEntMap = StringUtils.isNotBlank((CharSequence)stdReportJsonStr) ? (Map)JSON.parseObject((String)stdReportJsonStr, (TypeReference)new TypeReference<Map<String, FSAStandardReportItemModel>>(){}, (Feature[])new Feature[0]) : new HashMap();
        List<DynamicObject> items = this.getSelectItems();
        EntryGrid stdItemEntryGrid = (EntryGrid)this.getControl("fsa_stdrptent");
        int[] stdItemSelectRows = stdItemEntryGrid.getSelectRows();
        ArrayList<FSAStandardReportItemModel> stdReportEntAddList = new ArrayList<FSAStandardReportItemModel>();
        if (stdItemSelectRows == null || stdItemSelectRows.length == 0) {
            this.addFirst(stdReportEntMap, items, stdReportEntAddList);
        } else {
            DynamicObject stdSelectItem = this.getModel().getEntryRowEntity("fsa_stdrptent", stdItemSelectRows[0]);
            int level = stdSelectItem.getInt("level") + 1;
            long itemId = stdSelectItem.getDynamicObject("rptitem").getLong("id");
            long rootItemId = stdSelectItem.getLong("rootitemid");
            String longNumber = stdSelectItem.getString("longnumber");
            Object[] obj = this.getNextLineNoAndOther(stdReportEntMap, longNumber, level);
            int lineNo = (Integer)obj[0];
            long preItemId = (Long)obj[1];
            for (DynamicObject item : items) {
                DynamicObject itemDo = item.getDynamicObject("item");
                FSAStandardReportItemModel stdReportEnt = new FSAStandardReportItemModel(Long.valueOf(itemDo.getLong("id")), Long.valueOf(level == 1 ? itemId : rootItemId), "1", item.getString("itemname"), item.getString("itemnumber"), Integer.valueOf(level), Integer.valueOf(level + 1), Integer.valueOf(lineNo), longNumber + '|' + (level + 1) + lineNo++, itemDo.getString("itemtype"), Long.valueOf(itemDo.getLong("rootcategory_id")), Long.valueOf(itemDo.getLong("seccategory_id")));
                stdReportEntAddList.add(stdReportEnt);
                stdReportEntMap.put((String)stdReportEnt.getLongNumber(), (FSAStandardReportItemModel)stdReportEnt);
            }
            ((FSAStandardReportItemModel)stdReportEntMap.get(longNumber)).setIsLeaf("0");
            this.initStdItems(this.getPageCache().get("searchTextStdItems"), stdReportEntAddList, preItemId);
        }
        this.getView().getPageCache().put("stdReportEntry", JSON.toJSONString(stdReportEntMap));
    }

    private List<DynamicObject> getSelectItems() {
        IDataModel model = this.getModel();
        EntryGrid itemEntryGrid = (EntryGrid)this.getControl("itemsentryentity");
        int[] itemSelectRows = itemEntryGrid.getSelectRows();
        ArrayList<DynamicObject> items = new ArrayList<DynamicObject>(itemSelectRows.length);
        for (int i : itemSelectRows) {
            items.add(model.getEntryRowEntity("itemsentryentity", i));
        }
        model.deleteEntryRows("itemsentryentity", itemSelectRows);
        itemEntryGrid.clearEntryState();
        return items;
    }

    private void addFirst(Map<String, FSAStandardReportItemModel> stdReportEntMap, List<DynamicObject> items, List<FSAStandardReportItemModel> stdReportEntAddList) {
        AbstractFormDataModel abstractModel = (AbstractFormDataModel)this.getModel();
        abstractModel.beginInit();
        TableValueSetter tvs = new TableValueSetter(new String[0]);
        tvs.addField("rptitem", new Object[0]);
        tvs.addField("rootitemid", new Object[0]);
        tvs.addField("isleaf", new Object[0]);
        tvs.addField("stditemname", new Object[0]);
        tvs.addField("stditemnumber", new Object[0]);
        tvs.addField("level", new Object[0]);
        tvs.addField("showlevel", new Object[0]);
        tvs.addField("lineno", new Object[0]);
        tvs.addField("longnumber", new Object[0]);
        tvs.addField("itemtype", new Object[0]);
        tvs.addField("rootcategory", new Object[0]);
        tvs.addField("seccategory", new Object[0]);
        int lineNo = 1;
        int level = 0;
        for (DynamicObject item : items) {
            DynamicObject itemDo = item.getDynamicObject("item");
            tvs.addRow(new Object[]{itemDo.getLong("id"), null, "1", IDataStringUtil.getFullSpace((int)level) + item.getString("itemname"), item.getString("itemnumber"), level, level + 1, lineNo, level + 1 + "" + lineNo, itemDo.getString("itemtype"), itemDo.getLong("rootcategory_id"), itemDo.getLong("seccategory_id")});
            FSAStandardReportItemModel stdReportEnt = new FSAStandardReportItemModel(Long.valueOf(itemDo.getLong("id")), null, "1", item.getString("itemname"), item.getString("itemnumber"), Integer.valueOf(level), Integer.valueOf(level + 1), Integer.valueOf(lineNo), level + 1 + "" + lineNo++, itemDo.getString("itemtype"), Long.valueOf(itemDo.getLong("rootcategory_id")), Long.valueOf(itemDo.getLong("seccategory_id")));
            stdReportEntAddList.add(stdReportEnt);
            stdReportEntMap.put(stdReportEnt.getLongNumber(), stdReportEnt);
        }
        abstractModel.batchCreateNewEntryRow("fsa_stdrptent", tvs);
        abstractModel.endInit();
        this.getView().updateView("fsa_stdrptent");
    }

    private Object[] getNextLineNoAndOther(Map<String, FSAStandardReportItemModel> stdReportEntMap, String longNumber, int level) {
        Object[] obj = new Object[2];
        int lineNo = 0;
        while (stdReportEntMap.get(longNumber + '|' + (level + 1) + ++lineNo) != null) {
        }
        obj[0] = lineNo;
        obj[1] = 0L;
        DynamicObjectCollection strItemCol = this.getModel().getEntryEntity("fsa_stdrptent");
        if (strItemCol != null && !strItemCol.isEmpty()) {
            for (DynamicObject item : strItemCol) {
                String partLongNumber = item.getString("longnumber");
                if (!partLongNumber.startsWith(longNumber + '|')) continue;
                obj[1] = item.getDynamicObject("rptitem").getLong("id");
            }
        }
        return obj;
    }

    private boolean checkAdd() {
        EntryGrid itemEntryGrid = (EntryGrid)this.getControl("itemsentryentity");
        int[] itemSelectRows = itemEntryGrid.getSelectRows();
        if (itemSelectRows == null || itemSelectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u62a5\u8868\u9879\u76ee\u6570\u636e\u3002", (String)"FSAStdReportsFormPlugin_5", (String)"data-fsa-formplugin", (Object[])new Object[0]));
            return false;
        }
        EntryGrid stdItemEntryGrid = (EntryGrid)this.getControl("fsa_stdrptent");
        int[] stdItemSelectRows = stdItemEntryGrid.getSelectRows();
        String stdReportJsonStr = this.getView().getPageCache().get("stdReportEntry");
        if ((stdItemSelectRows == null || stdItemSelectRows.length == 0) && StringUtils.isNotBlank((CharSequence)stdReportJsonStr)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6807\u51c6\u62a5\u8868\u9879\u76ee\u6570\u636e\u3002", (String)"FSAStdReportsFormPlugin_6", (String)"data-fsa-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (stdItemSelectRows != null && stdItemSelectRows.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6807\u51c6\u62a5\u8868\u9879\u76ee\u6570\u636e\u3002", (String)"FSAStdReportsFormPlugin_7", (String)"data-fsa-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        switch (propertyName) {
            case "rpttype": {
                model.deleteEntryData("fsa_stdrptent");
                view.getPageCache().put("stdReportEntry", "");
                String reportType = (String)newValue;
                this.initPage(reportType, this.getPageCache().get("searchTextItems"));
                break;
            }
            case "hidelongnumber": {
                this.showOrHideLongNumber((Boolean)newValue);
                break;
            }
            case "rootcategory": 
            case "seccategory": {
                Long categoryId;
                String stdReportJsonStr = view.getPageCache().get("stdReportEntry");
                Map stdReportEntMap = (Map)JSON.parseObject((String)stdReportJsonStr, (TypeReference)new TypeReference<Map<String, FSAStandardReportItemModel>>(){}, (Feature[])new Feature[0]);
                int rowIndex = model.getEntryCurrentRowIndex("fsa_stdrptent");
                String longNumber = (String)model.getValue("longnumber", rowIndex);
                Long l = categoryId = newValue == null ? null : Long.valueOf(((DynamicObject)newValue).getLong("id"));
                if ("rootcategory".equals(propertyName)) {
                    ((FSAStandardReportItemModel)stdReportEntMap.get(longNumber)).setRootCategory(categoryId);
                } else {
                    ((FSAStandardReportItemModel)stdReportEntMap.get(longNumber)).setSecCategory(categoryId);
                }
                view.getPageCache().put("stdReportEntry", JSON.toJSONString((Object)stdReportEntMap));
            }
        }
    }

    private void initPage(String reportType, String searchText) {
        this.getModel().deleteEntryData("itemsentryentity");
        searchText = searchText == null ? "" : searchText;
        this.showOrHideLongNumber((Boolean)this.getModel().getValue("hidelongnumber"));
        if (StringUtils.isNotBlank((CharSequence)reportType)) {
            String stdReportJsonStr;
            Label itemDescLabel = (Label)this.getView().getControl("labelitemdesc");
            itemDescLabel.setText(this.getItemDesc(reportType));
            QFilter qFilter = new QFilter("enable", "=", (Object)Character.valueOf('1'));
            qFilter.and("rpttype", "=", (Object)reportType);
            qFilter.and("itemtype", "!=", (Object)Character.valueOf('3'));
            DynamicObjectCollection itemCol = QueryServiceHelper.query((String)"fsa_rptitems", (String)"id,number,name,rpttype,rptitemsrctype", (QFilter[])qFilter.toArray(), (String)"modifytime desc");
            if (itemCol != null && !itemCol.isEmpty() && StringUtils.isNotBlank((CharSequence)(stdReportJsonStr = this.getView().getPageCache().get("stdReportEntry")))) {
                Map stdReportMap = (Map)JSON.parseObject((String)stdReportJsonStr, (TypeReference)new TypeReference<Map<String, FSAStandardReportItemModel>>(){}, (Feature[])new Feature[0]);
                ArrayList stdReportIdList = new ArrayList(stdReportMap.size());
                for (Map.Entry entry : stdReportMap.entrySet()) {
                    stdReportIdList.add(Long.parseLong(((FSAStandardReportItemModel)entry.getValue()).getId().toString()));
                }
                itemCol.removeIf(itemColDo -> stdReportIdList.contains(itemColDo.getLong("id")));
            }
            DynamicObjectCollection searchItemCol = new DynamicObjectCollection();
            if (itemCol != null && !itemCol.isEmpty()) {
                HashMap<String, String> srcMap = new HashMap<String, String>(){
                    private static final long serialVersionUID = -2439720624218332911L;
                    {
                        this.put("0", ResManager.loadKDString((String)"\u7cfb\u7edf\u9884\u7f6e", (String)"FSAStdReportsFormPlugin_3", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                        this.put("1", ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49", (String)"FSAStdReportsFormPlugin_4", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                    }
                };
                for (DynamicObject item : itemCol) {
                    if (!item.getString("number").contains(searchText) && !item.getString("name").contains(searchText) && !((String)srcMap.get(item.getString("rptitemsrctype"))).contains(searchText)) continue;
                    searchItemCol.add((Object)item);
                }
                if (!searchItemCol.isEmpty()) {
                    AbstractFormDataModel abstractModel = (AbstractFormDataModel)this.getModel();
                    abstractModel.beginInit();
                    TableValueSetter tvs = new TableValueSetter(new String[0]);
                    tvs.addField("item", new Object[0]);
                    tvs.addField("itemnumber", new Object[0]);
                    tvs.addField("itemname", new Object[0]);
                    tvs.addField("itemsrctype", new Object[0]);
                    for (DynamicObject item : searchItemCol) {
                        tvs.addRow(new Object[]{item.getLong("id"), item.getString("number"), item.getString("name"), item.getString("rptitemsrctype")});
                    }
                    abstractModel.batchCreateNewEntryRow("itemsentryentity", tvs);
                    abstractModel.endInit();
                    this.getView().updateView("itemsentryentity");
                }
            }
        } else {
            this.getModel().deleteEntryData("fsa_stdrptent");
            this.getView().getPageCache().put("stdReportEntry", "");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("save".equals(operateKey)) {
            this.initStdItems(null, null, null);
            this.initPage((String)this.getModel().getValue("rpttype"), null);
            this.getPageCache().put("searchTextStdItems", null);
            this.getPageCache().put("searchTextItems", null);
        }
    }

    private void initStdItems(String searchText, List<FSAStandardReportItemModel> stdReportEntAddList, Long preItemId) {
        this.getModel().deleteEntryData("fsa_stdrptent");
        searchText = searchText == null ? "" : searchText;
        String stdReportJsonStr = this.getView().getPageCache().get("stdReportEntry");
        if (StringUtils.isNotBlank((CharSequence)stdReportJsonStr)) {
            Map stdReportEntMap = (Map)JSON.parseObject((String)stdReportJsonStr, (TypeReference)new TypeReference<Map<String, FSAStandardReportItemModel>>(){}, (Feature[])new Feature[0]);
            AbstractFormDataModel abstractModel = (AbstractFormDataModel)this.getModel();
            abstractModel.beginInit();
            TableValueSetter tvs = new TableValueSetter(new String[0]);
            tvs.addField("rptitem", new Object[0]);
            tvs.addField("rootitemid", new Object[0]);
            tvs.addField("isleaf", new Object[0]);
            tvs.addField("stditemname", new Object[0]);
            tvs.addField("stditemnumber", new Object[0]);
            tvs.addField("level", new Object[0]);
            tvs.addField("showlevel", new Object[0]);
            tvs.addField("lineno", new Object[0]);
            tvs.addField("longnumber", new Object[0]);
            tvs.addField("itemtype", new Object[0]);
            tvs.addField("rootcategory", new Object[0]);
            tvs.addField("seccategory", new Object[0]);
            int partLevel = 0;
            String longNumber = partLevel + 1 + "" + 1;
            ArrayList<String> addLongNumberList = null;
            while (true) {
                FSAStandardReportItemModel stdReportEnt;
                if ((stdReportEnt = (FSAStandardReportItemModel)stdReportEntMap.get(longNumber)) != null) {
                    if (stdReportEnt.getName().contains(searchText) || stdReportEnt.getNumber().contains(searchText) || stdReportEnt.getShowLevel().toString().contains(searchText)) {
                        tvs.addRow(new Object[]{stdReportEnt.getId(), stdReportEnt.getRootItemId(), stdReportEnt.getIsLeaf(), IDataStringUtil.getFullSpace((int)stdReportEnt.getLevel()) + stdReportEnt.getName(), stdReportEnt.getNumber(), stdReportEnt.getLevel(), stdReportEnt.getLevel() + 1, stdReportEnt.getLineNo(), stdReportEnt.getLongNumber(), stdReportEnt.getItemType(), stdReportEnt.getRootCategory(), stdReportEnt.getSecCategory()});
                        if (stdReportEntAddList != null) {
                            String oneLongNumber = stdReportEntAddList.get(0).getLongNumber();
                            if (stdReportEnt.getId().equals(preItemId) || preItemId.equals(0L) && oneLongNumber.substring(0, oneLongNumber.lastIndexOf(124)).equals(longNumber)) {
                                addLongNumberList = new ArrayList<String>(stdReportEntAddList.size());
                                for (FSAStandardReportItemModel item : stdReportEntAddList) {
                                    tvs.addRow(new Object[]{item.getId(), item.getRootItemId(), item.getIsLeaf(), IDataStringUtil.getFullSpace((int)item.getLevel()) + item.getName(), item.getNumber(), item.getLevel(), item.getLevel() + 1, item.getLineNo(), item.getLongNumber(), item.getItemType(), item.getRootCategory(), item.getSecCategory()});
                                    addLongNumberList.add(item.getLongNumber());
                                }
                            }
                        }
                    }
                    longNumber = longNumber + '|' + (++partLevel + 1) + 1;
                    continue;
                }
                if (longNumber.contains("|")) {
                    longNumber = longNumber.substring(0, longNumber.lastIndexOf(124));
                    longNumber = this.excludeLongNumber(longNumber, addLongNumberList, --partLevel);
                    continue;
                }
                if (stdReportEntMap.get(longNumber = this.excludeLongNumber(longNumber, addLongNumberList, partLevel)) == null) break;
            }
            abstractModel.batchCreateNewEntryRow("fsa_stdrptent", tvs);
            abstractModel.endInit();
            this.getView().updateView("fsa_stdrptent");
        }
    }

    private String excludeLongNumber(String longNumber, List<String> addLongNumberList, int partLevel) {
        int lineNoIndex = longNumber.lastIndexOf(124) + String.valueOf(partLevel + 1).length() + 1;
        int partLineNo = Integer.parseInt(longNumber.substring(lineNoIndex)) + 1;
        String partLongNumber = longNumber.substring(0, lineNoIndex);
        longNumber = partLongNumber + partLineNo;
        if (addLongNumberList != null) {
            while (addLongNumberList.contains(longNumber)) {
                longNumber = partLongNumber + ++partLineNo;
            }
        }
        return longNumber;
    }

    private void showOrHideLongNumber(Boolean flag) {
        this.getView().setVisible(Boolean.valueOf(flag == false), new String[]{"longnumber"});
    }

    private String getItemDesc(String reportType) {
        String itemDesc = "";
        switch (reportType) {
            case "0": {
                itemDesc = ResManager.loadKDString((String)"\u8d44\u4ea7\u8d1f\u503a\u8868-\u62a5\u8868\u9879\u76ee", (String)"FSAStdReportsFormPlugin_0", (String)"data-fsa-formplugin", (Object[])new Object[0]);
                break;
            }
            case "1": {
                itemDesc = ResManager.loadKDString((String)"\u5229\u6da6\u8868-\u62a5\u8868\u9879\u76ee", (String)"FSAStdReportsFormPlugin_1", (String)"data-fsa-formplugin", (Object[])new Object[0]);
                break;
            }
            case "2": {
                itemDesc = ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u91cf\u8868-\u62a5\u8868\u9879\u76ee", (String)"FSAStdReportsFormPlugin_2", (String)"data-fsa-formplugin", (Object[])new Object[0]);
            }
        }
        return itemDesc;
    }
}

