/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.formplugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.disf.utils.IDataValueUtil;
import kd.data.fsa.common.enums.FSADataCollectionParamSrcTypeEnum;
import kd.data.fsa.common.enums.FSADimensionTypeEnum;
import kd.data.fsa.common.enums.FSAFieldTypeEnum;
import kd.data.fsa.common.enums.FSAFilterModeEnum;
import kd.data.fsa.common.enums.FSAWorkTaskTypeEnum;
import kd.data.fsa.formplugin.FSAMultipleMemberF7BasePlugin;
import kd.data.fsa.formplugin.util.FSAPermissionUtil;
import kd.data.fsa.olap.OlapServerDimMemberMetaInfo;
import kd.data.fsa.olap.OlapServerDimemsionMetaInfo;
import kd.data.fsa.utils.FSABcmDataProvider;
import kd.data.fsa.utils.FSADataCollectionHelper;
import kd.data.fsa.utils.FSATableUtil;

public class FSASyncParamFormPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final Log logger = LogFactory.getLog(FSASyncParamFormPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain", "advcontoolbarap"});
        EntryGrid eg = (EntryGrid)this.getControl("dimentry");
        eg.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String dataSrcType = (String)view.getFormShowParameter().getCustomParams().get("datasrctype");
        if (StringUtils.isNotEmpty((String)dataSrcType)) {
            model.setValue("datasrctype", (Object)dataSrcType);
        } else {
            model.setValue("datasrctype", (Object)FSADataCollectionParamSrcTypeEnum.XH_BCM.getCodeString());
            view.setEnable(Boolean.TRUE, new String[]{"name", "number"});
            view.setEnable(Boolean.valueOf(StringUtils.isEmpty((String)((String)model.getValue("tablenumber")))), new String[]{"datacollection", "ignoredimnull", "syncfilter"});
        }
    }

    public void afterBindData(EventObject e) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Long id = (Long)model.getValue("id");
        view.setEnable(Boolean.valueOf(0L == id), new String[]{"name", "number"});
        if (0L == id) {
            view.setVisible(Boolean.TRUE, new String[]{"createtable"});
        }
        BasedataEdit dataCollectionEdit = (BasedataEdit)this.getControl("datacollection");
        String dataSrcType = (String)model.getValue("datasrctype");
        if (StringUtils.isNotEmpty((String)dataSrcType)) {
            QFilter srcTypeFilter = new QFilter("datasrctype", "=", (Object)dataSrcType);
            dataCollectionEdit.setQFilter(srcTypeFilter);
        }
        int totalRow = model.getEntryRowCount("dimentry");
        for (int idx = 0; idx < totalRow; ++idx) {
            String filterMode = (String)model.getValue("filtermode", idx);
            if (FSAFilterModeEnum.FIXED_CONDITION.getCodeString().equals(filterMode)) {
                view.setEnable(Boolean.FALSE, idx, new String[]{"filtermode"});
            }
            model.setValue("datacollectionselect", (Object)(FSAFilterModeEnum.FIXED_CONDITION.getCodeString().equals(filterMode) ? "0" : "1"), idx);
        }
        Long collectionId = (Long)model.getValue("datacollection_id");
        if (collectionId == null || collectionId == 0L) {
            return;
        }
        this.showTipsAndSetVisibleByJudgeCol(collectionId, true);
        if (StringUtils.isNotEmpty((String)((String)model.getValue("tablenumber")))) {
            view.setEnable(Boolean.FALSE, new String[]{"datacollection", "ignoredimnull", "syncfilter"});
            view.setVisible(Boolean.FALSE, new String[]{"createtable"});
        }
        this.showSourceColumnEntry(collectionId, dataSrcType);
        this.showCombinationColumnEntry(collectionId, dataSrcType);
        this.showCustomDimensionEntry(collectionId);
        model.setDataChanged(false);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        Long syncParamId;
        DynamicObject syncParam;
        FormOperate fo;
        Object source;
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Long collectionId = (Long)model.getValue("datacollection_id");
        int totalRow = model.getEntryRowCount("sourcecolumnentry");
        String dataSrcType = (String)model.getValue("datasrctype");
        if (0L != collectionId && totalRow < 1) {
            this.showSourceColumnEntry(collectionId, dataSrcType);
            this.showCombinationColumnEntry(collectionId, dataSrcType);
            this.showCustomDimensionEntry(collectionId);
        }
        if ((source = args.getSource()) instanceof FormOperate && "deletefilterentry".equalsIgnoreCase((fo = (FormOperate)source).getOperateKey())) {
            view.updateView("dimfilterentry");
        }
        if ((syncParam = BusinessDataServiceHelper.loadSingleFromCache((Object)(syncParamId = (Long)model.getValue("id")), (String)"fsa_syncparam", (String)"enable")) != null && "0".equals(syncParam.getString("enable"))) {
            view.showConfirm(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\uff0c\u662f\u5426\u9a6c\u4e0a\u542f\u7528\uff1f", (String)"FSASyncParamFormPlugin_5", (String)"data-fsa-formplugin", (Object[])new Object[0]), null, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("fsa_syncparam", (IFormPlugin)this), null, syncParamId.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void showSourceColumnEntry(Long collectionId, String dataSrcType) {
        IDataModel model = this.getModel();
        model.deleteEntryData("sourcecolumnentry");
        AbstractFormDataModel abstractModel = (AbstractFormDataModel)model;
        abstractModel.beginInit();
        TableValueSetter columnEntryTvs = new TableValueSetter(new String[0]);
        columnEntryTvs.addField("columnname", new Object[0]);
        columnEntryTvs.addField("columnnumber", new Object[0]);
        columnEntryTvs.addField("members", new Object[0]);
        if ("fileParamSource".equalsIgnoreCase(dataSrcType)) {
            DynamicObject dataCol = BusinessDataServiceHelper.loadSingle((Object)collectionId, (String)"fsa_data_collection");
            DynamicObjectCollection dataEntryEntity = dataCol.getDynamicObjectCollection("dataentryentity");
            for (DynamicObject entity : dataEntryEntity) {
                String dimType = entity.getString("dimtype");
                if (!FSADimensionTypeEnum.MEASURE_DIM.getCodeString().equals(dimType)) continue;
                columnEntryTvs.addRow(new Object[]{entity.getString("dimname"), entity.getString("dimnumber"), null});
            }
        } else {
            HashMap<String, String> dataMap = new HashMap<String, String>();
            String sql = "select a.fsrcfieldname,a.fsrcfieldnumber,a.fsrcfieldmemnumber from t_fsa_datacolcombmappings a left join t_fsa_datacolcombfields b on a.fentryid = b.fentryid where b.fid = ?";
            try (DataSet dataSet = DB.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".showSourceColumnEntry"), (DBRoute)DBRoute.of((String)"bdai"), (String)sql, (Object[])new Object[]{collectionId});){
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    String srcFieldName = row.getString("fsrcfieldname");
                    String srcFieldNumber = row.getString("fsrcfieldnumber");
                    String srcFieldMemNumber = row.getString("fsrcfieldmemnumber");
                    String mapKey = srcFieldName + "," + srcFieldNumber;
                    String memberStr = (String)dataMap.get(mapKey);
                    if (StringUtils.isNotEmpty((String)memberStr)) {
                        if (!memberStr.contains(srcFieldMemNumber)) {
                            memberStr = memberStr + "," + srcFieldMemNumber;
                        }
                    } else {
                        memberStr = srcFieldMemNumber;
                    }
                    dataMap.put(mapKey, memberStr);
                }
                if (!dataMap.isEmpty()) {
                    for (Map.Entry entry : dataMap.entrySet()) {
                        String[] keyArr = ((String)entry.getKey()).split(",");
                        if (2 != keyArr.length) continue;
                        columnEntryTvs.addRow(new Object[]{keyArr[0], keyArr[1], entry.getValue()});
                    }
                }
            }
            catch (Exception e) {
                logger.error(String.format("\u5ea6\u91cf\u7ef4\u67e5\u8be2\u51fa\u9519\uff0c\u539f\u56e0\uff1a%s", e.getMessage()));
            }
        }
        abstractModel.batchCreateNewEntryRow("sourcecolumnentry", columnEntryTvs);
        abstractModel.endInit();
        this.getView().updateView("sourcecolumnentry");
    }

    private void showCombinationColumnEntry(Long collectionId, String dataSrcType) {
        if ("fileParamSource".equalsIgnoreCase(dataSrcType)) {
            return;
        }
        DynamicObject dataCol = BusinessDataServiceHelper.loadSingle((Object)collectionId, (String)"fsa_data_collection");
        if (dataCol != null) {
            IDataModel model = this.getModel();
            model.deleteEntryData("combinationcolumnentry");
            AbstractFormDataModel abstractModel = (AbstractFormDataModel)model;
            abstractModel.beginInit();
            TableValueSetter combinationTvs = new TableValueSetter(new String[0]);
            combinationTvs.addField("combinationname", new Object[0]);
            combinationTvs.addField("combinationnumber", new Object[0]);
            combinationTvs.addField("dimdatatype", new Object[0]);
            DynamicObjectCollection dataEntryEntity = dataCol.getDynamicObjectCollection("dataentryentity");
            for (DynamicObject entity : dataEntryEntity) {
                if (!FSADimensionTypeEnum.MEASURE_DIM.getCodeString().equals(entity.getString("dimtype"))) continue;
                combinationTvs.addRow(new Object[]{entity.getString("dimname"), entity.getString("dimnumber"), entity.getString("dimdatatype")});
            }
            abstractModel.batchCreateNewEntryRow("combinationcolumnentry", combinationTvs);
            abstractModel.endInit();
            this.getView().updateView("combinationcolumnentry");
        }
    }

    private void showCustomDimensionEntry(Long collectionId) {
        DynamicObject dataCollectionDyn = BusinessDataServiceHelper.loadSingle((Object)collectionId, (String)"fsa_data_collection", (String)"dataentryentity,dataentryentity.dimnumber,dataentryentity.dimname,dataentryentity.fieldcreatetype,dataentryentity.dimtype,subentryentity,subentryentity.paramnumber,subentryentity.paramvalue");
        DynamicObjectCollection dataEntryCol = dataCollectionDyn.getDynamicObjectCollection("dataentryentity");
        if (dataEntryCol != null) {
            IDataModel model = this.getModel();
            model.deleteEntryData("customentry");
            AbstractFormDataModel abstractModel = (AbstractFormDataModel)model;
            abstractModel.beginInit();
            TableValueSetter customTvs = new TableValueSetter(new String[0]);
            customTvs.addField("customname", new Object[0]);
            customTvs.addField("customnumber", new Object[0]);
            customTvs.addField("customvalue", new Object[0]);
            for (DynamicObject dataEnt : dataEntryCol) {
                if (FSADimensionTypeEnum.MEASURE_DIM.getCodeString().equals(dataEnt.getString("dimtype")) || !FSAFieldTypeEnum.CUSTOM_FIELD.getCodeString().equals(dataEnt.getString("fieldcreatetype"))) continue;
                DynamicObjectCollection subCol = dataEnt.getDynamicObjectCollection("subentryentity");
                String columnDefaultValue = null;
                if (subCol != null && !subCol.isEmpty()) {
                    for (DynamicObject sub : subCol) {
                        if (!"DefaultValue".equals(sub.getString("paramnumber"))) continue;
                        columnDefaultValue = sub.getString("paramvalue");
                    }
                }
                customTvs.addRow(new Object[]{dataEnt.getString("dimname"), dataEnt.getString("dimnumber"), columnDefaultValue});
            }
            abstractModel.batchCreateNewEntryRow("customentry", customTvs);
            abstractModel.endInit();
            this.getView().updateView("customentry");
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        IFormView view = this.getView();
        switch (itemKey) {
            case "createtable": {
                if (!FSAPermissionUtil.hasSpecificPerm(view, "fsa_syncparam", "2/F32KBFDZ72").booleanValue()) {
                    return;
                }
                this.showCreateTable();
                break;
            }
            case "deletetable": {
                if (!FSAPermissionUtil.hasSpecificPerm(view, "fsa_syncparam", "2/F34T1WDSAH").booleanValue()) {
                    return;
                }
                this.deleteTable();
                break;
            }
            case "add": {
                this.showDimMember();
                break;
            }
        }
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        block4 : switch (e.getProperty().getName()) {
            case "datacollection": {
                if (!"1".equals(this.getPageCache().get("restoreBySystem"))) {
                    Long newCollectionId;
                    Object newValue = e.getChangeSet()[0].getNewValue();
                    if (newValue != null && !this.showTipsAndSetVisibleByJudgeCol(newCollectionId = Long.valueOf(((DynamicObject)newValue).getLong("id")), true)) {
                        this.getPageCache().put("restoreBySystem", "1");
                        model.setValue("datacollection", oldValue);
                        return;
                    }
                    if (oldValue != null) {
                        long dataCollectionId = ((DynamicObject)oldValue).getLong("id");
                        view.showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u6570\u636e\u96c6\u5408\uff0c\u5c06\u6e05\u7a7a\u540c\u6b65\u53d6\u6570\u8fc7\u6ee4\u6761\u4ef6\u3001\u7ec4\u5408\u5b57\u6bb5\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u64cd\u4f5c\uff1f", (String)"FSASyncParamFormPlugin_7", (String)"data-fsa-formplugin", (Object[])new Object[0]), null, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("datacollection", (IFormPlugin)this), null, Long.toString(dataCollectionId));
                    } else {
                        this.showData();
                    }
                }
                this.getPageCache().remove("restoreBySystem");
                break;
            }
            case "filtermode": {
                int currentRow = model.getEntryCurrentRowIndex("dimentry");
                String filterMode = (String)model.getValue("filtermode", currentRow);
                FSAFilterModeEnum anEnum = FSAFilterModeEnum.getEnum((String)filterMode);
                switch (anEnum) {
                    case REQUIRED: {
                        view.showConfirm(ResManager.loadKDString((String)"\u5c06\u8fc7\u6ee4\u6a21\u5f0f\u4fee\u6539\u4e3a\u6bcf\u6b21\u5fc5\u586b\u540e\uff0c\u5c06\u6e05\u7a7a\u5df2\u8bbe\u7f6e\u7684\u7ef4\u5ea6\u8fc7\u6ee4\u6761\u4ef6\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"FSASyncParamFormPlugin_0", (String)"data-fsa-formplugin", (Object[])new Object[0]), null, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("filtermode", (IFormPlugin)this), null, oldValue.toString());
                        break block4;
                    }
                    case PRESET: {
                        Long collectionId = (Long)model.getValue("datacollection_id");
                        this.showTipsAndSetVisibleByJudgeCol(collectionId, false);
                        break block4;
                    }
                }
                break;
            }
        }
    }

    private void showDimMember() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        EntryGrid entryGrid = (EntryGrid)this.getControl("dimentry");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length < 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ef4\u5ea6", (String)"FSASyncParamFormPlugin_6", (String)"data-fsa-formplugin", (Object[])new Object[0]));
            return;
        }
        int selectRowIndex = selectRows[0];
        String filterMode = (String)model.getValue("filtermode", selectRowIndex);
        if (!FSAFilterModeEnum.PRESET.getCodeString().equals(filterMode)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u201c\u8fc7\u6ee4\u6a21\u5f0f\u201d\u4e3a\u201c\u9884\u7f6e\u6a21\u5f0f\u201d\u624d\u53ef\u4ee5\u65b0\u589e", (String)"FSASyncParamFormPlugin_8", (String)"data-fsa-formplugin", (Object[])new Object[0]));
            return;
        }
        String dimName = (String)model.getValue("dimname", selectRowIndex);
        String sourceNumber = (String)model.getValue("olddimnumber", selectRowIndex);
        Boolean autoComplete = (Boolean)model.getValue("load_compete_member", selectRowIndex);
        Long dataCollectionId = (Long)model.getValue("datacollection_id");
        Map paramMap = FSADataCollectionHelper.getSrcParamFromCol((Long)dataCollectionId);
        Long moduleId = paramMap == null ? null : IDataValueUtil.getLong(paramMap.get("moduleId"));
        Long viewId = paramMap == null ? null : IDataValueUtil.getLong(paramMap.get("OrgView"));
        HashSet<Long> initIds = null;
        int memberFilterRow = model.getEntryRowCount("dimfilterentry");
        if (memberFilterRow > 0) {
            initIds = new HashSet<Long>(memberFilterRow);
            for (int i = 0; i < memberFilterRow; ++i) {
                Long id = (Long)model.getValue("memberid", i);
                initIds.add(id);
            }
        }
        FSAMultipleMemberF7BasePlugin.openF7(this, dimName, moduleId, sourceNumber, viewId, "fsa_mulmemberf7base", autoComplete, Boolean.TRUE, null, null, initIds);
    }

    private void showData() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        model.deleteEntryData("dimentry");
        model.deleteEntryData("dimfilterentry");
        model.deleteEntryData("sourcecolumnentry");
        model.deleteEntryData("combinationcolumnentry");
        model.deleteEntryData("customentry");
        Long collectionId = (Long)model.getValue("datacollection_id");
        if (collectionId == null || collectionId == 0L) {
            return;
        }
        this.showTipsAndSetVisibleByJudgeCol(collectionId, true);
        HashSet<Integer> notEnableIndex = new HashSet<Integer>();
        int rowIndex = -1;
        HashMap<Integer, String[]> filterMap = new HashMap<Integer, String[]>();
        DynamicObject dataCol = BusinessDataServiceHelper.loadSingle((Object)collectionId, (String)"fsa_data_collection");
        if (dataCol != null) {
            String dataSrcType = (String)model.getValue("datasrctype");
            if (dataSrcType == null || dataSrcType.isEmpty()) {
                dataSrcType = dataCol.getString("datasrctype");
            }
            boolean bcmSrc = "bcmParamSource".equalsIgnoreCase(dataSrcType);
            Map olapDimensionInfoMap = null;
            if (bcmSrc) {
                Map paramMap = FSADataCollectionHelper.getSrcParamFromCol((DynamicObject)dataCol);
                Long moduleId = paramMap == null ? null : IDataValueUtil.getLong(paramMap.get("moduleId"));
                olapDimensionInfoMap = FSABcmDataProvider.loadModuleAllDimensionMetas((Long)moduleId);
            }
            AbstractFormDataModel abstractModel = (AbstractFormDataModel)model;
            abstractModel.beginInit();
            TableValueSetter dimensionTvs = new TableValueSetter(new String[0]);
            dimensionTvs.addField("dimname", new Object[0]);
            dimensionTvs.addField("dimnumber", new Object[0]);
            dimensionTvs.addField("olddimnumber", new Object[0]);
            dimensionTvs.addField("filtermode", new Object[0]);
            dimensionTvs.addField("datacollectionselect", new Object[0]);
            DynamicObjectCollection dataEntryEntity = dataCol.getDynamicObjectCollection("dataentryentity");
            for (DynamicObject entity : dataEntryEntity) {
                String dimType = entity.getString("dimtype");
                if (FSADimensionTypeEnum.MEASURE_DIM.getCodeString().equals(dimType) || FSAFieldTypeEnum.CUSTOM_FIELD.getCodeString().equals(entity.getString("fieldcreatetype"))) continue;
                dimensionTvs.addRow(new Object[]{entity.getString("dimname"), entity.getString("dimnumber"), entity.getString("srcnumber"), bcmSrc ? "1" : "3", "1"});
                ++rowIndex;
                if (bcmSrc) continue;
                notEnableIndex.add(rowIndex);
            }
            DynamicObjectCollection sourceColumnEntry = dataCol.getDynamicObjectCollection("datacolsrcfilter");
            for (DynamicObject dyc : sourceColumnEntry) {
                String srcNumber = dyc.getString("srcdimnumber");
                notEnableIndex.add(++rowIndex);
                if (olapDimensionInfoMap != null) {
                    dimensionTvs.addRow(new Object[]{((OlapServerDimemsionMetaInfo)olapDimensionInfoMap.get(srcNumber)).getName(), srcNumber, srcNumber, "3", "0"});
                    filterMap.put(rowIndex, new String[]{dyc.getString("srcdimnamedefault"), dyc.getString("srcdimdefault")});
                    continue;
                }
                dimensionTvs.addRow(new Object[]{dyc.getString("srcdimname"), srcNumber, srcNumber, "3", "0"});
            }
            abstractModel.batchCreateNewEntryRow("dimentry", dimensionTvs);
            if (bcmSrc) {
                for (Map.Entry entry : filterMap.entrySet()) {
                    String[] memberNameAndNumber = (String[])entry.getValue();
                    model.setEntryCurrentRowIndex("dimentry", ((Integer)entry.getKey()).intValue());
                    TableValueSetter filterTvs = new TableValueSetter(new String[0]);
                    filterTvs.addField("membername", new Object[0]);
                    filterTvs.addField("membernumber", new Object[0]);
                    filterTvs.addField("memberid", new Object[0]);
                    filterTvs.addField("memberlongnumber", new Object[0]);
                    filterTvs.addRow(new Object[]{memberNameAndNumber[0], memberNameAndNumber[1], null, null});
                    abstractModel.batchCreateNewEntryRow("dimfilterentry", filterTvs);
                }
            }
            abstractModel.endInit();
            this.showSourceColumnEntry(collectionId, dataSrcType);
            this.showCombinationColumnEntry(collectionId, dataSrcType);
            this.showCustomDimensionEntry(collectionId);
        }
        view.updateView("dimentry");
        view.updateView("dimfilterentry");
        if (!notEnableIndex.isEmpty()) {
            for (Integer idx : notEnableIndex) {
                view.setEnable(Boolean.FALSE, idx.intValue(), new String[]{"filtermode"});
            }
        }
    }

    private void showCreateTable() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        DynamicObject dataCollection = (DynamicObject)model.getValue("datacollection");
        Long id = (Long)model.getValue("id");
        if (id == 0L) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u540c\u6b65\u53c2\u6570\u8bbe\u7f6e", (String)"FSASyncParamFormPlugin_9", (String)"data-fsa-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShow = new FormShowParameter();
        formShow.setFormId("fsa_number_name_config");
        formShow.getOpenStyle().setShowType(ShowType.Modal);
        formShow.getCustomParams().put("tablenumber", model.getValue("tablenumber"));
        formShow.getCustomParams().put("tablename", model.getValue("tablename"));
        formShow.getCustomParams().put("syncparam_id", model.getValue("id"));
        formShow.getCustomParams().put("collectionName", dataCollection.getString("name"));
        formShow.getCustomParams().put("synParamName", ((OrmLocaleValue)model.getValue("name")).get((Object)Lang.get().toString()));
        formShow.getCustomParams().put("collectionNum", dataCollection.getString("number"));
        formShow.getCustomParams().put("synParamNum", model.getValue("number"));
        formShow.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "fsa_number_name_config"));
        view.showForm(formShow);
    }

    private void deleteTable() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Long paramId = (Long)model.getValue("id");
        String tableNumber = (String)model.getValue("tablenumber");
        String tableName = (String)model.getValue("tablename");
        if (paramId == 0L || StringUtils.isEmpty((String)tableNumber) || StringUtils.isEmpty((String)tableName)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u60a8\u8fd8\u672a\u521b\u5efa\u8868\uff0c\u65e0\u9700\u5220\u9664", (String)"FSASyncParamFormPlugin_1", (String)"data-fsa-formplugin", (Object[])new Object[0]));
        } else if (FSATableUtil.createOrDropTable((Long)paramId, (FSAWorkTaskTypeEnum)FSAWorkTaskTypeEnum.Drop_Table_Task, (String)tableNumber, (String)tableName, (boolean)false)) {
            model.setValue("tablenumber", null);
            model.setValue("tablename", null);
            model.setDataChanged(false);
            view.setEnable(Boolean.TRUE, new String[]{"datacollection", "ignoredimnull", "syncfilter"});
            view.showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u8868\u6210\u529f", (String)"FSASyncParamFormPlugin_2", (String)"data-fsa-formplugin", (Object[])new Object[0]));
            view.setVisible(Boolean.TRUE, new String[]{"createtable"});
            DynamicObject syncParamObj = BusinessDataServiceHelper.loadSingle((Object)model.getValue("id"), (String)"fsa_syncparam");
            syncParamObj.set("tablenumber", null);
            syncParamObj.set("tablename", null);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{syncParamObj});
        } else {
            view.showErrorNotification(ResManager.loadKDString((String)"\u5220\u9664\u8868\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"FSASyncParamFormPlugin_3", (String)"data-fsa-formplugin", (Object[])new Object[0]));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object obj = closedCallBackEvent.getReturnData();
        switch (closedCallBackEvent.getActionId()) {
            case "fsa_number_name_config": {
                this.setTableFromReturnData(obj);
                break;
            }
            case "fsa_mulmemberf7base": {
                this.showFilterCondition(obj);
                break;
            }
        }
    }

    private void setTableFromReturnData(Object obj) {
        if (obj instanceof Map) {
            IDataModel model = this.getModel();
            IFormView view = this.getView();
            Map result = (Map)obj;
            boolean success = Boolean.parseBoolean((String)result.get("res"));
            if (success) {
                model.setValue("tablenumber", result.get("tablenumber"));
                model.setValue("tablename", result.get("tablename"));
                model.setDataChanged(false);
                view.setEnable(Boolean.FALSE, new String[]{"datacollection", "ignoredimnull", "syncfilter"});
                view.showSuccessNotification(String.format(ResManager.loadKDString((String)"\u6570\u636e\u8868[%s]\u521b\u5efa\u6210\u529f", (String)"FSASyncParamFormPlugin_10", (String)"data-fsa-formplugin", (Object[])new Object[0]), result.get("tablename")));
                view.setVisible(Boolean.FALSE, new String[]{"createtable"});
                DynamicObject syncParamObj = BusinessDataServiceHelper.loadSingle((Object)model.getValue("id"), (String)"fsa_syncparam");
                syncParamObj.set("tablenumber", result.get("tablenumber"));
                syncParamObj.set("tablename", result.get("tablename"));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{syncParamObj});
            }
        }
    }

    private void showFilterCondition(Object obj) {
        if (obj instanceof HashSet) {
            IDataModel model = this.getModel();
            HashSet memberMetaSet = (HashSet)obj;
            int entryRow = model.getEntryRowCount("dimfilterentry");
            HashSet<String> hasExistLongNumberSet = new HashSet<String>(entryRow + memberMetaSet.size());
            if (entryRow > 0) {
                for (int i = 0; i < entryRow; ++i) {
                    hasExistLongNumberSet.add((String)model.getValue("memberlongnumber", i));
                }
            }
            AbstractFormDataModel abstractModel = (AbstractFormDataModel)model;
            abstractModel.beginInit();
            TableValueSetter tvs = new TableValueSetter(new String[0]);
            tvs.addField("membername", new Object[0]);
            tvs.addField("membernumber", new Object[0]);
            tvs.addField("memberid", new Object[0]);
            tvs.addField("memberlongnumber", new Object[0]);
            for (OlapServerDimMemberMetaInfo info : memberMetaSet) {
                if (!hasExistLongNumberSet.add(info.getLongNumber())) continue;
                tvs.addRow(new Object[]{info.getName(), info.getNumber(), info.getId(), info.getLongNumber()});
            }
            abstractModel.batchCreateNewEntryRow("dimfilterentry", tvs);
            abstractModel.endInit();
            this.getView().updateView("dimfilterentry");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate fo;
        super.beforeDoOperation(args);
        Object source = args.getSource();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if (source instanceof FormOperate && "deletefilterentry".equalsIgnoreCase((fo = (FormOperate)source).getOperateKey())) {
            int currentDimEntryRow = model.getEntryCurrentRowIndex("dimentry");
            String filterMode = (String)model.getValue("filtermode", currentDimEntryRow);
            if (FSAFilterModeEnum.FIXED_CONDITION.getCodeString().equals(filterMode)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u201c\u8fc7\u6ee4\u6a21\u5f0f\u201d\u4e3a\u201c\u56fa\u5b9a\u6761\u4ef6\u201d\u7684\u7ef4\u5ea6\uff0c\u4e0d\u53ef\u5220\u9664\u7ef4\u5ea6\u8fc7\u6ee4\u6761\u4ef6", (String)"FSASyncParamFormPlugin_11", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String actionId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult messageBoxResult = messageBoxClosedEvent.getResult();
        IDataModel model = this.getModel();
        if (MessageBoxResult.Yes == messageBoxResult) {
            if ("fsa_syncparam".equalsIgnoreCase(actionId)) {
                Long syncParamId = Long.parseLong(messageBoxClosedEvent.getCustomVaule());
                DynamicObject syncParam = BusinessDataServiceHelper.loadSingle((Object)syncParamId, (String)"fsa_syncparam");
                if (syncParam != null) {
                    syncParam.set("enable", (Object)"1");
                    SaveServiceHelper.update((DynamicObject)syncParam);
                }
            } else if ("datacollection".equalsIgnoreCase(actionId)) {
                this.getPageCache().remove("restoreBySystem");
                this.showData();
            } else if ("filtermode".equalsIgnoreCase(actionId)) {
                model.deleteEntryData("dimfilterentry");
                this.getView().setVisible(Boolean.FALSE, new String[]{"advcontoolbarap"});
            }
        } else if ("datacollection".equalsIgnoreCase(actionId)) {
            this.getPageCache().put("restoreBySystem", "1");
            model.setValue("datacollection", (Object)messageBoxClosedEvent.getCustomVaule());
        } else if ("filtermode".equalsIgnoreCase(actionId)) {
            int currentRow = model.getEntryCurrentRowIndex("dimentry");
            model.setValue("filtermode", (Object)messageBoxClosedEvent.getCustomVaule(), currentRow);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        int row = evt.getRow();
        if (row != -1) {
            String filterMode = (String)model.getValue("filtermode", row);
            FSAFilterModeEnum anEnum = FSAFilterModeEnum.getEnum((String)filterMode);
            switch (anEnum) {
                case REQUIRED: 
                case FIXED_CONDITION: {
                    view.setVisible(Boolean.FALSE, new String[]{"advcontoolbarap"});
                    break;
                }
                case PRESET: {
                    Long collectionId = (Long)model.getValue("datacollection_id");
                    this.showTipsAndSetVisibleByJudgeCol(collectionId, false);
                    break;
                }
            }
        }
    }

    private boolean showTipsAndSetVisibleByJudgeCol(Long collectionId, boolean needShowTips) {
        String tips = FSADataCollectionHelper.preJudgeDataCollection((Long)collectionId);
        IFormView view = this.getView();
        if (StringUtils.isNotEmpty((String)tips)) {
            if (needShowTips) {
                view.showTipNotification(tips);
            }
            view.setVisible(Boolean.FALSE, new String[]{"advcontoolbarap"});
            return false;
        }
        view.setVisible(Boolean.TRUE, new String[]{"advcontoolbarap"});
        return true;
    }
}

