/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.Collections;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.bos.util.StringUtils;
import kd.data.disf.utils.CustomizedDynamicFormBuilderUtil;
import kd.data.fsa.common.constant.FSACommonConstant;
import kd.data.fsa.file.FSAFileReaderFactory;
import kd.data.fsa.formplugin.util.FSAPermissionUtil;
import kd.data.fsa.model.file.FSAFileInfoModel;
import kd.data.fsa.utils.FSADataCollectionHelper;
import kd.data.fsa.utils.FSADataversionUtils;

public class FSASyncParamListPlugin
extends AbstractListPlugin {
    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"excutefetch", "import_offlinedata"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object source = args.getSource();
        if (source instanceof FormOperate) {
            String operateKey;
            IFormView view = this.getView();
            switch (operateKey = ((FormOperate)source).getOperateKey()) {
                case "new": {
                    args.setCancel(true);
                    FormShowParameter formShow = new FormShowParameter();
                    formShow.getOpenStyle().setShowType(ShowType.Modal);
                    formShow.setFormId("fsa_choosedatasrctype");
                    view.showForm(formShow);
                    break;
                }
                case "delete": {
                    ListSelectedRowCollection listSelectedData = args.getListSelectedData();
                    for (ListSelectedRow row : listSelectedData) {
                        Long rowId = (Long)row.getPrimaryKeyValue();
                        if (BaseDataRefrenceHelper.isRefrenced((String)"fsa_syncparam", (Object)rowId)) continue;
                        this.deleteTableIfExist(rowId);
                    }
                    break;
                }
                case "excutefetch": 
                case "import_offlinedata": {
                    if (!FSAPermissionUtil.hasSpecificPerm(view, "fsa_syncparam", "excutefetch".equalsIgnoreCase(operateKey) ? "2/F11GP8ZICX" : "2/F3/SJEW21/").booleanValue()) {
                        return;
                    }
                    ListSelectedRowCollection rows = ((BillList)this.getControl("billlistap")).getSelectedRows();
                    if (!this.billVerification(view, rows)) break;
                    Long id = (Long)rows.get(0).getPrimaryKeyValue();
                    FormShowParameter formShow = new FormShowParameter();
                    formShow.getOpenStyle().setShowType(ShowType.Modal);
                    formShow.getCustomParams().put("syncparam_id", id);
                    QFilter paramIdFilter = new QFilter("id", "=", (Object)id);
                    DynamicObject syncParam = QueryServiceHelper.queryOne((String)"fsa_syncparam", (String)"datacollection,datasrctype", (QFilter[])paramIdFilter.toArray());
                    if (syncParam == null) {
                        view.showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0", (String)"FSASyncParamListPlugin_3", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    Long collectionId = syncParam.getLong("datacollection");
                    if ("excutefetch".equalsIgnoreCase(operateKey)) {
                        String dataSrcType = syncParam.getString("datasrctype");
                        if ("fileParamSource".equalsIgnoreCase(dataSrcType)) {
                            Map configMap = FSADataCollectionHelper.getSrcParamFromCol((Long)collectionId);
                            if (configMap == null || configMap.isEmpty()) break;
                            FSAFileInfoModel fileInfo = (FSAFileInfoModel)JSON.parseObject((String)((String)configMap.get("fileUpload")), (TypeReference)new TypeReference<FSAFileInfoModel>(){}, (Feature[])new Feature[0]);
                            FSAFileInfoModel detailInfo = FSAFileReaderFactory.getFileReader((String)fileInfo.getFileName()).getFileInfoOnSheet(fileInfo, fileInfo.getSheetName(), fileInfo.getTitleRow().intValue(), fileInfo.getPreviewRow().intValue());
                            if (detailInfo == null) {
                                view.showTipNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u5df2\u8fc7\u671f\uff0c\u8bf7\u5728\u5bfc\u822a\u6307\u5f15\u4e2d\u91cd\u65b0\u4e0a\u4f20\u6587\u4ef6", (String)"FSASyncParamListPlugin_2", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                                formShow.getCustomParams().put("datacollection", collectionId);
                                formShow.setFormId("fsa_data_import_wizard");
                            } else {
                                formShow.setFormId("fsa_syncparamtask");
                            }
                            view.showForm(formShow);
                            break;
                        }
                        if (!"bcmParamSource".equalsIgnoreCase(dataSrcType)) break;
                        formShow.setFormId("fsa_syncparamtask");
                        view.showForm(formShow);
                        break;
                    }
                    formShow.getCustomParams().put("datacollection", collectionId);
                    formShow.setFormId("fsa_data_import_wizard");
                    view.showForm(formShow);
                    break;
                }
            }
        }
    }

    private boolean billVerification(IFormView view, ListSelectedRowCollection rows) {
        if (rows == null) {
            return false;
        }
        if (1 != rows.size()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u6761\u8bb0\u5f55", (String)"FSASyncParamListPlugin_0", (String)"data-fsa-formplugin", (Object[])new Object[0]));
            return false;
        }
        Long id = (Long)rows.get(0).getPrimaryKeyValue();
        QFilter filter = new QFilter("id", "=", (Object)id).and("enable", "=", (Object)"1");
        if (!QueryServiceHelper.exists((String)"fsa_syncparam", (QFilter[])filter.toArray())) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u6570\u636e\u53c2\u6570\u5df2\u88ab\u7981\u7528\uff0c\u8bf7\u5148\u542f\u7528", (String)"FSASyncParamListPlugin_1", (String)"data-fsa-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void deleteTableIfExist(Long syncParamId) {
        String entity;
        String tableNumber;
        DynamicObject syncParam = BusinessDataServiceHelper.loadSingle((Object)syncParamId, (String)"fsa_syncparam", (String)"tablenumber,tablename");
        if (syncParam != null && StringUtils.isNotEmpty((String)(tableNumber = syncParam.getString("tablenumber"))) && MetadataDao.checkNumber((String)(entity = FSACommonConstant.buildEntityName((String)tableNumber)))) {
            CustomizedDynamicFormBuilderUtil.deleteForm((String)entity, (boolean)false);
            FSADataversionUtils.deleteWithParamId(Collections.singleton(syncParamId));
        }
    }
}

