/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.disf.cache.DistributeCache;
import kd.data.disf.cache.IDataCacheModule;
import kd.data.disf.task.IDataAbstractWorkTask;
import kd.data.disf.task.IDataWorkTask;
import kd.data.disf.task.IDataWorkTaskManager;
import kd.data.disf.task.IWorkTaskTransLog;
import kd.data.disf.utils.IDataValueUtil;
import kd.data.fsa.common.constant.FSACommonConstant;
import kd.data.fsa.common.enums.FSAFilterModeEnum;
import kd.data.fsa.common.enums.FSAWorkTaskTypeEnum;
import kd.data.fsa.engine.task.FSAWorkTaskFactory;
import kd.data.fsa.engine.task.FSAWorkTaskMeta;
import kd.data.fsa.formplugin.FSAMultipleMemberF7BasePlugin;
import kd.data.fsa.model.file.FSAFieldMappingModel;
import kd.data.fsa.model.file.FSAFieldMappingWithTimePatternModel;
import kd.data.fsa.model.file.FSAFileInfoModel;
import kd.data.fsa.model.sync.FSADataSyncTaskDimFilterModel;
import kd.data.fsa.model.sync.FSADataSyncTaskMemberModel;
import kd.data.fsa.model.sync.FSADataSyncTaskParamModel;
import kd.data.fsa.olap.OlapServerDimMemberMetaInfo;
import kd.data.fsa.utils.FSABcmDataProvider;
import kd.data.fsa.utils.FSADataCollectionHelper;
import kd.data.fsa.utils.FSADataversionUtils;
import kd.data.fsa.utils.FSASyncTaskLogHelper;
import kd.data.fsa.utils.FSATableUtil;

public class FSASyncParamTaskFormPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(FSASyncParamTaskFormPlugin.class);
    private final DistributeCache cache = DistributeCache.getCache((IDataCacheModule)IDataCacheModule.FSA);
    private static final String FIELD_DIMNAME = "dimname";
    private static final String FIELD_DIMNUMBER = "dimnumber";
    private static final String FIELD_FILTERMODE = "filtermode";
    private static final String FIELD_MEMBERNAME = "membername";
    private static final String FIELD_MEMBERNUMBER = "membernumber";
    private static final String FIELD_OLDDIMNUMBER = "olddimnumber";
    private static final String FIELD_ENTRYENTITY = "entryentity";
    private static final String FIELD_SUBENTRYENTITY = "subentryentity";
    private static final String FIELD_DATASRCTYPE = "datasrctype";
    private static final String FIELD_VERSION = "version";
    private static final String FIELD_TABLENAME = "tablename";
    private static final String FIELD_TABLENUMBER = "tablenumber";
    private static final String BTN_OK = "btnok";
    private static final String ACTION_MEMBER = "actionMember";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"filtertoolbar"});
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        view.setEnable(Boolean.FALSE, new String[]{"bar_add", "bar_delete"});
        Long id = this.getSyncParam();
        if (this.hasSyncParam(id)) {
            DynamicObject syncParam = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"fsa_syncparam");
            IDataModel dataModel = this.getModel();
            String dataSrcType = syncParam.getString(FIELD_DATASRCTYPE);
            dataModel.setValue(FIELD_DATASRCTYPE, (Object)dataSrcType);
            dataModel.setValue("sycnparam", (Object)syncParam.getString("name"));
            String tableName = syncParam.getString(FIELD_TABLENAME);
            String tableNumber = syncParam.getString(FIELD_TABLENUMBER);
            boolean isEnable = true;
            if (StringUtils.isEmpty((String)tableNumber)) {
                DynamicObject dataCollection = syncParam.getDynamicObject("datacollection");
                tableNumber = dataCollection.getString("number").toLowerCase() + "_" + syncParam.getString("number").toLowerCase();
                tableName = dataCollection.getString("name") + "_" + syncParam.getString("name");
            } else if (this.isExistEntity(tableNumber)) {
                isEnable = false;
            }
            dataModel.setValue(FIELD_TABLENAME, (Object)tableName);
            dataModel.setValue(FIELD_TABLENUMBER, (Object)tableNumber);
            view.setEnable(Boolean.valueOf(isEnable), new String[]{FIELD_TABLENAME, FIELD_TABLENUMBER});
            Boolean filtertoolbarShow = Boolean.FALSE;
            if ("bcmParamSource".equalsIgnoreCase(dataSrcType)) {
                DynamicObjectCollection cols = syncParam.getDynamicObjectCollection("dimentry");
                if (cols != null && !cols.isEmpty()) {
                    for (DynamicObject dob : cols) {
                        String filterMode = dob.getString(FIELD_FILTERMODE);
                        if (!FSAFilterModeEnum.REQUIRED.getCodeString().equals(filterMode)) continue;
                        filtertoolbarShow = Boolean.TRUE;
                        int rowIndex = dataModel.createNewEntryRow(FIELD_ENTRYENTITY);
                        dataModel.setValue(FIELD_DIMNAME, dob.get(FIELD_DIMNAME), rowIndex);
                        dataModel.setValue(FIELD_DIMNUMBER, dob.get(FIELD_DIMNUMBER), rowIndex);
                        dataModel.setValue(FIELD_OLDDIMNUMBER, dob.get(FIELD_OLDDIMNUMBER), rowIndex);
                        dataModel.setValue(FIELD_FILTERMODE, (Object)filterMode, rowIndex);
                        dataModel.setValue("load_compete_member", dob.get("load_compete_member"), rowIndex);
                    }
                    int entryRowCount = dataModel.getEntryRowCount(FIELD_ENTRYENTITY);
                    for (int i = 0; i < entryRowCount; ++i) {
                        view.setEnable(Boolean.valueOf(isEnable), i, new String[]{"load_compete_member"});
                    }
                    AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
                    model.setEntryCurrentRowIndex(FIELD_ENTRYENTITY, 0, true);
                }
                if (filtertoolbarShow.booleanValue()) {
                    view.setEnable(filtertoolbarShow, new String[]{"bar_add", "bar_delete"});
                }
            } else {
                view.setEnable(Boolean.FALSE, new String[]{"bar_add", "bar_delete"});
            }
            dataModel.setValue(FIELD_VERSION, (Object)FSADataversionUtils.getVersionToDateLong());
        }
    }

    private Long getSyncParam() {
        Object paramId = this.getView().getFormShowParameter().getCustomParam("syncparam_id");
        Long result = null;
        if (paramId != null) {
            result = Long.parseLong(String.valueOf(paramId));
        }
        return result;
    }

    private boolean hasSyncParam(Long id) {
        return id != null && id.compareTo(Long.parseLong("0")) > 0;
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("bar_add".equals(itemKey)) {
            IDataModel model = this.getModel();
            IFormView view = this.getView();
            String dataSrcType = (String)model.getValue(FIELD_DATASRCTYPE);
            if ("fileParamSource".equalsIgnoreCase(dataSrcType)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u7c7b\u578b\u662f\u201c\u79bb\u7ebf\u6587\u4ef6\u5bfc\u5165\u201d\uff0c\u4e0d\u5141\u8bb8\u6dfb\u52a0\u8fc7\u6ee4\u6761\u4ef6", (String)"FSASyncParamFormPlugin_12", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                return;
            }
            int rowIndex = model.getEntryCurrentRowIndex(FIELD_ENTRYENTITY);
            int rowCount = model.getEntryRowCount(FIELD_ENTRYENTITY);
            if (rowCount > 0 && rowIndex >= 0) {
                this.showMemberForm(rowIndex);
            } else {
                view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6", (String)"FSASyncParamTaskFormPlugin_0", (String)"data-fsa-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        IDataModel model = this.getModel();
        if (BTN_OK.equals(control.getKey()) && this.validateTable() && this.validateFilter()) {
            String tableName;
            String tableNumber;
            boolean isSuccess;
            String dataSrcType = (String)model.getValue(FIELD_DATASRCTYPE);
            FSAWorkTaskTypeEnum taskType = "fileParamSource".equalsIgnoreCase(dataSrcType) ? FSAWorkTaskTypeEnum.File_Upload_Data_Task : FSAWorkTaskTypeEnum.BCM_OLAP_GROUP_Data_Sync_Task;
            Long version = (Long)model.getValue(FIELD_VERSION);
            Long taskId = FSASyncTaskLogHelper.createSyncTask((Long)this.getSyncParam(), (String)String.valueOf(version), (FSAWorkTaskTypeEnum)taskType);
            int tableStatus = this.getTableStatus();
            boolean isExistTable = this.isExistTable(tableStatus);
            if (!isExistTable && !(isSuccess = this.createTableTask(tableNumber = (String)model.getValue(FIELD_TABLENUMBER), tableName = (String)model.getValue(FIELD_TABLENAME)))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u521b\u5efa\u6570\u636e\u8868\u5931\u8d25", (String)"FSASyncParamTaskFormPlugin_6", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                this.updateTaskFail(taskId);
                return;
            }
            if ("fileParamSource".equalsIgnoreCase(dataSrcType)) {
                this.createFileImportSyncTask(taskId, version);
            } else if ("bcmParamSource".equalsIgnoreCase(dataSrcType)) {
                IDataAbstractWorkTask task = this.createBcmSyncTask(isExistTable, taskId, version);
                IFormView view = this.getView();
                if (task != null) {
                    IDataWorkTaskManager.getInstance().submit((IDataWorkTask)task);
                    IFormView parentView = view.getParentView();
                    parentView.showSuccessNotification(ResManager.loadKDString((String)"\u540c\u6b65\u4efb\u52a1\u63d0\u4ea4\u6210\u529f\u3002", (String)"FSARptDataSyncTaskFormPlugin_0", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                    view.sendFormAction(parentView);
                }
                view.returnDataToParent((Object)String.valueOf(version));
                view.close();
            }
        }
    }

    private void updateTaskFail(Long taskId) {
        DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"fsa_rptdata_synctask", (String)"status");
        task.set("status", (Object)"9");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{task});
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (ACTION_MEMBER.equals(actionId)) {
            Collection<String> longNumberSet = this.dealMember(returnData);
            if (longNumberSet == null || longNumberSet.size() == 0) {
                return;
            }
            int rowIndex = this.getModel().getEntryCurrentRowIndex(FIELD_ENTRYENTITY);
            boolean loadCompeteMember = (Boolean)this.getModel().getValue("load_compete_member", rowIndex);
            if (loadCompeteMember) {
                String sourceNumber = (String)this.getModel().getValue(FIELD_OLDDIMNUMBER, rowIndex);
                Long collectionId = this.getCollectionId();
                Map paramMap = FSADataCollectionHelper.getSrcParamFromCol((Long)collectionId);
                Long moduleId = paramMap == null ? null : IDataValueUtil.getLong(paramMap.get("moduleId"));
                Long viewId = paramMap == null ? null : IDataValueUtil.getLong(paramMap.get("OrgView"));
                Set olapServerDimMemberMetaInfos = FSAMultipleMemberF7BasePlugin.loadCompeteMember(this, longNumberSet, moduleId, sourceNumber, viewId, null, null);
                this.dealMember(olapServerDimMemberMetaInfos);
            }
        }
    }

    private Collection<String> dealMember(Object memberData) {
        if (memberData instanceof HashSet) {
            HashSet memberMetaSet = (HashSet)memberData;
            int rowCount = this.getModel().getEntryRowCount(FIELD_SUBENTRYENTITY);
            HashSet<String> repeatSet = new HashSet<String>(rowCount + memberMetaSet.size());
            for (int i = 0; i < rowCount; ++i) {
                String memberLongNumber = (String)this.getModel().getValue("memberlongnumber", i);
                repeatSet.add(memberLongNumber);
            }
            AbstractFormDataModel abstractModel = (AbstractFormDataModel)this.getModel();
            abstractModel.beginInit();
            TableValueSetter tvs = new TableValueSetter(new String[0]);
            tvs.addField(FIELD_MEMBERNUMBER, new Object[0]);
            tvs.addField(FIELD_MEMBERNAME, new Object[0]);
            tvs.addField("memberid", new Object[0]);
            tvs.addField("memberlongnumber", new Object[0]);
            for (OlapServerDimMemberMetaInfo info : memberMetaSet) {
                if (repeatSet.contains(info.getLongNumber())) continue;
                repeatSet.add(info.getLongNumber());
                tvs.addRow(new Object[]{info.getNumber(), info.getName(), info.getId(), info.getLongNumber()});
            }
            abstractModel.batchCreateNewEntryRow(FIELD_SUBENTRYENTITY, tvs);
            abstractModel.endInit();
            this.getView().updateView(FIELD_SUBENTRYENTITY);
            return repeatSet;
        }
        return null;
    }

    private boolean validateTable() {
        QFilter filter;
        String tableNumber = (String)this.getModel().getValue(FIELD_TABLENUMBER);
        String tableName = (String)this.getModel().getValue(FIELD_TABLENAME);
        String regx = "^[a-z0-9_]{1,19}$";
        Pattern pattern = Pattern.compile(regx);
        Matcher matcher = pattern.matcher(tableNumber);
        boolean isFormater = matcher.matches();
        if (!isFormater) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u8868\u7f16\u7801\u8bf7\u4f7f\u7528\u4e0d\u8d85\u8fc719\u4f4d\u5c0f\u5199\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u7ec4\u5408", (String)"FSASyncParamTaskFormPlugin_3", (String)"data-fsa-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (StringUtils.isNotEmpty((String)tableName) && tableName.trim().length() > 30) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u8868\u540d\u79f0\u4e0d\u80fd\u8d85\u8fc730\u4f4d", (String)"FSASyncParamTaskFormPlugin_4", (String)"data-fsa-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (StringUtils.isEmpty((String)tableName)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6570\u636e\u8868\u540d\u79f0\u3002", (String)"FSASyncParamTaskFormPlugin_8", (String)"data-fsa-formplugin", (Object[])new Object[0]));
            return false;
        }
        Long id = this.getSyncParam();
        if (this.hasSyncParam(id) && QueryServiceHelper.exists((String)"fsa_syncparam", (QFilter[])new QFilter[]{filter = QFilter.of((String)" id != ? and tablenumber = ? ", (Object[])new Object[]{id, tableNumber})})) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u8868\u7f16\u7801\u91cd\u590d", (String)"FSASyncParamTaskFormPlugin_5", (String)"data-fsa-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean validateFilter() {
        boolean hasEmpty = false;
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount(FIELD_ENTRYENTITY);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < rowCount; ++i) {
            model.setEntryCurrentRowIndex(FIELD_ENTRYENTITY, i);
            int subRowCount = model.getEntryRowCount(FIELD_SUBENTRYENTITY);
            if (subRowCount > 0) continue;
            hasEmpty = true;
            sb.append(model.getValue(FIELD_DIMNAME, i)).append(',');
        }
        if (hasEmpty) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u7ef4\u5ea6\u5fc5\u5f55\u8fc7\u6ee4\u6761\u4ef6", (String)"FSASyncParamTaskFormPlugin_2", (String)"data-fsa-formplugin", (Object[])new Object[0]), sb.substring(0, sb.length() - 1)));
        }
        return !hasEmpty;
    }

    private boolean isExistTable(int tableStatus) {
        return 2 == tableStatus;
    }

    private int getTableStatus() {
        Long id = this.getSyncParam();
        int status = 1;
        if (this.hasSyncParam(id)) {
            DynamicObject syncParam = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"fsa_syncparam");
            String tableName = syncParam.getString(FIELD_TABLENAME);
            String tableNumber = syncParam.getString(FIELD_TABLENUMBER);
            String newTableNumber = (String)this.getModel().getValue(FIELD_TABLENUMBER);
            String newTableName = (String)this.getModel().getValue(FIELD_TABLENAME);
            if (StringUtils.isNotEmpty((String)tableNumber)) {
                int n = status = this.isExistEntity(tableNumber) ? 2 : status;
            }
            if (!(status == 2 || newTableNumber.equals(tableNumber) && newTableName.equals(tableName))) {
                syncParam = BusinessDataServiceHelper.loadSingle((Object)id, (String)"fsa_syncparam", (String)"tablename,tablenumber");
                syncParam.set(FIELD_TABLENAME, (Object)newTableName);
                syncParam.set(FIELD_TABLENUMBER, (Object)newTableNumber);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{syncParam});
            }
        }
        return status;
    }

    private boolean isExistEntity(String tableNumber) {
        boolean result = false;
        try {
            result = MetadataDao.checkNumber((String)FSACommonConstant.buildEntityName((String)tableNumber));
        }
        catch (Throwable throwable) {
            logger.error(throwable);
        }
        return result;
    }

    private void showMemberForm(int rowIndex) {
        String sourceNumber = (String)this.getModel().getValue(FIELD_OLDDIMNUMBER, rowIndex);
        String dimName = (String)this.getModel().getValue(FIELD_DIMNAME, rowIndex);
        Long collectionId = this.getCollectionId();
        Map paramMap = FSADataCollectionHelper.getSrcParamFromCol((Long)collectionId);
        Long moduleId = paramMap == null ? null : IDataValueUtil.getLong(paramMap.get("moduleId"));
        Long viewId = paramMap == null ? null : IDataValueUtil.getLong(paramMap.get("OrgView"));
        FSAMultipleMemberF7BasePlugin.openF7(this, dimName, moduleId, sourceNumber, viewId, ACTION_MEMBER, Boolean.TRUE, null, null);
    }

    private void createFileImportSyncTask(Long taskId, long version) {
        Long id = this.getSyncParam();
        IFormView view = this.getView();
        if (this.hasSyncParam(id)) {
            Long collectionId = this.getCollectionId();
            try {
                Map configMap;
                DynamicObject colDoj = BusinessDataServiceHelper.loadSingleFromCache((String)"fsa_data_collection", (String)"paramsrc_tag,dataentryentity,dataentryentity.dimtype,dataentryentity.dimnumber,dataentryentity.srcname", (QFilter[])new QFilter("id", "=", (Object)collectionId).toArray());
                if (colDoj != null && (configMap = FSADataCollectionHelper.getSrcParamFromCol((DynamicObject)colDoj)) != null && !configMap.isEmpty()) {
                    FSAFileInfoModel fileInfoModel = (FSAFileInfoModel)JSON.parseObject((String)((String)configMap.get("fileUpload")), (TypeReference)new TypeReference<FSAFileInfoModel>(){}, (Feature[])new Feature[0]);
                    if (fileInfoModel == null) {
                        return;
                    }
                    DynamicObject syncParam = QueryServiceHelper.queryOne((String)"fsa_syncparam", (String)"ignoredimnull,tablenumber", (QFilter[])new QFilter("id", "=", (Object)id).toArray());
                    boolean ignoreDimNull = syncParam.getBoolean("ignoredimnull");
                    String tableNumber = syncParam.getString(FIELD_TABLENUMBER);
                    DynamicObjectCollection dyCol = colDoj.getDynamicObjectCollection("dataentryentity");
                    if (dyCol != null && !dyCol.isEmpty()) {
                        LinkedList<FSAFieldMappingModel> fieldMappingModelList = new LinkedList<FSAFieldMappingModel>();
                        for (DynamicObject dyObj : dyCol) {
                            String dimensionType = dyObj.getString("dimtype");
                            String paramFieldNumber = dyObj.getString(FIELD_DIMNUMBER);
                            String fileSrcField = dyObj.getString("srcname");
                            FSAFieldMappingModel mappingModel = new FSAFieldMappingModel(dimensionType, paramFieldNumber, fileSrcField, null);
                            fieldMappingModelList.add(mappingModel);
                        }
                        FSAFieldMappingWithTimePatternModel fieldMappingWithTimePatternModel = new FSAFieldMappingWithTimePatternModel("1", fieldMappingModelList);
                        Boolean createVersion = (Boolean)view.getFormShowParameter().getCustomParam("create_version");
                        FSAWorkTaskMeta meta = new FSAWorkTaskMeta(id.toString(), taskId, id, FSAWorkTaskTypeEnum.File_Upload_Data_Task, Long.valueOf(version), fileInfoModel, Boolean.TRUE, Boolean.valueOf(ignoreDimNull), fieldMappingWithTimePatternModel, tableNumber, createVersion == null ? Boolean.TRUE : createVersion);
                        IDataAbstractWorkTask task = FSAWorkTaskFactory.createFSAWorkTask((Integer)FSAWorkTaskTypeEnum.File_Upload_Data_Task.getValue(), (IWorkTaskTransLog)meta, (boolean)true);
                        IDataWorkTaskManager.getInstance().submit((IDataWorkTask)task);
                    }
                }
            }
            catch (Throwable e) {
                this.updateTaskFail(taskId);
                throw new KDBizException(e, new ErrorCode("", e.getMessage()), new Object[0]);
            }
            IFormView parentView = view.getParentView();
            parentView.showSuccessNotification(ResManager.loadKDString((String)"\u540c\u6b65\u4efb\u52a1\u63d0\u4ea4\u6210\u529f\u3002", (String)"FSARptDataSyncTaskFormPlugin_0", (String)"data-fsa-formplugin", (Object[])new Object[0]));
            view.sendFormAction(parentView);
        }
        view.returnDataToParent((Object)String.valueOf(version));
        view.close();
    }

    private IDataAbstractWorkTask createBcmSyncTask(boolean isNeedDelete, Long taskId, long version) {
        Long id = this.getSyncParam();
        IDataModel model = this.getModel();
        IDataAbstractWorkTask task = null;
        if (this.hasSyncParam(id)) {
            Long collectionId = this.getCollectionId();
            Map paramMap = FSADataCollectionHelper.getSrcParamFromCol((Long)collectionId);
            String tableNumber = (String)model.getValue(FIELD_TABLENUMBER);
            Long moduleId = paramMap == null ? null : IDataValueUtil.getLong(paramMap.get("moduleId"));
            String modelNumber = FSABcmDataProvider.getModelNumber((Long)moduleId);
            FSADataSyncTaskParamModel taskParamModel = this.getDimFilter();
            taskParamModel.setModelNumber(modelNumber);
            String paramDetail = JSON.toJSONString((Object)taskParamModel, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
            try {
                DynamicObject dataCollection = QueryServiceHelper.queryOne((String)"fsa_data_collection", (String)"allowdimnull", (QFilter[])new QFilter("id", "=", (Object)collectionId).toArray());
                boolean allowDimNull = dataCollection.getBoolean("allowdimnull");
                DynamicObject syncParam = QueryServiceHelper.queryOne((String)"fsa_syncparam", (String)"ignoredimnull", (QFilter[])new QFilter("id", "=", (Object)id).toArray());
                boolean ignoreDimNull = syncParam.getBoolean("ignoredimnull");
                FSAWorkTaskMeta meta = new FSAWorkTaskMeta(Long.valueOf(0L), Long.valueOf(0L), id.toString(), taskId, id, FSAWorkTaskTypeEnum.BCM_OLAP_Data_Sync_Task, paramDetail, true, tableNumber, Boolean.valueOf(allowDimNull), Boolean.valueOf(ignoreDimNull), Long.valueOf(version));
                this.cache.put("cacheMeta", (Object)(id + "&&&" + modelNumber + "&&&" + taskId), 1800);
                meta.setNeedDelete(isNeedDelete);
                task = FSAWorkTaskFactory.createFSAWorkTask((Integer)FSAWorkTaskTypeEnum.BCM_OLAP_GROUP_Data_Sync_Task.getValue(), (IWorkTaskTransLog)meta, (boolean)true);
            }
            catch (Throwable e) {
                this.updateTaskFail(taskId);
                throw new KDBizException(e, new ErrorCode("", e.getMessage()), new Object[0]);
            }
        }
        return task;
    }

    private FSADataSyncTaskParamModel getDimFilter() {
        DynamicObjectCollection dimEntry = this.getModel().getEntryEntity(FIELD_ENTRYENTITY);
        ArrayList<FSADataSyncTaskDimFilterModel> dimFilter = new ArrayList<FSADataSyncTaskDimFilterModel>(dimEntry.size());
        for (DynamicObject dim : dimEntry) {
            String dimNumber = dim.getString(FIELD_DIMNUMBER);
            String dimName = dim.getString(FIELD_DIMNAME);
            String dimFilterMode = dim.getString(FIELD_FILTERMODE);
            String dimOldNumber = dim.getString(FIELD_OLDDIMNUMBER);
            DynamicObjectCollection dimFilterEntry = dim.getDynamicObjectCollection(FIELD_SUBENTRYENTITY);
            ArrayList<FSADataSyncTaskMemberModel> members = new ArrayList<FSADataSyncTaskMemberModel>(dimFilterEntry.size());
            FSADataSyncTaskDimFilterModel dimFilterModel = new FSADataSyncTaskDimFilterModel(dimName, dimNumber, dimOldNumber, dimFilterMode, members);
            dimFilter.add(dimFilterModel);
            if (CollectionUtils.isEmpty((Collection)dimFilterEntry)) continue;
            for (DynamicObject member : dimFilterEntry) {
                member.getString(FIELD_MEMBERNUMBER);
                FSADataSyncTaskMemberModel memberModel = new FSADataSyncTaskMemberModel(member.getString(FIELD_MEMBERNAME), member.getString(FIELD_MEMBERNUMBER), Long.valueOf(member.getLong("memberid")), member.getString("memberlongnumber"));
                members.add(memberModel);
            }
        }
        return new FSADataSyncTaskParamModel("syncParamTask", dimFilter);
    }

    private boolean createTableTask(String tableNumber, String tableName) {
        Long id = this.getSyncParam();
        if (this.hasSyncParam(id)) {
            return FSATableUtil.createOrDropTable((Long)id, (FSAWorkTaskTypeEnum)FSAWorkTaskTypeEnum.Create_Table_Task, (String)tableNumber, (String)tableName, (boolean)false);
        }
        return false;
    }

    private Long getCollectionId() {
        Long id = this.getSyncParam();
        if (this.hasSyncParam(id)) {
            DynamicObject syncParam = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"fsa_syncparam");
            return syncParam.getLong("datacollection_id");
        }
        return null;
    }
}

