/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.formplugin;

import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.StringUtils;
import kd.data.fsa.utils.FSAJSONUtils;

public class FSAVersionFilterFormPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String enableVersionJson = (String)view.getFormShowParameter().getCustomParam("enableVersion");
        if (StringUtils.isNotEmpty((String)enableVersionJson)) {
            List versionList = (List)FSAJSONUtils.cast((String)enableVersionJson, List.class);
            model.beginInit();
            if (versionList != null && !versionList.isEmpty()) {
                for (Object versionObj : versionList) {
                    int currentIndex = model.createNewEntryRow("entryentity");
                    Long version = (Long)versionObj;
                    model.setValue("version", (Object)version, currentIndex);
                }
            }
            model.endInit();
            view.updateView("entryentity");
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equalsIgnoreCase(key)) {
            IDataModel model = this.getModel();
            IFormView view = this.getView();
            EntryGrid eg = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = eg.getSelectRows();
            int totalRows = model.getEntryRowCount("entryentity");
            if (totalRows > 0 && 0 == selectRows.length) {
                view.showTipNotification(ResManager.loadKDString((String)"\u81f3\u5c11\u9700\u8981\u9009\u62e9\u4e00\u4e2a\u7248\u672c", (String)"FSAVersionFilterFormPlugin_0", (String)"data-fsa-formplugin", (Object[])new Object[0]));
                return;
            }
            LinkedList<Long> chooseVersion = new LinkedList<Long>();
            for (int index : selectRows) {
                Long version = (Long)model.getValue("version", index);
                chooseVersion.add(version);
            }
            view.returnDataToParent((Object)FSAJSONUtils.toJsonString(chooseVersion));
            view.close();
        }
    }
}

