/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.formplugin;

import com.alibaba.fastjson.JSONArray;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.data.fsa.olap.OlapConnectionInformation;
import kd.data.fsa.olap.OlapDimensionLookupMetaInfo;
import kd.data.fsa.olap.OlapServerDimMemberMetaInfo;
import kd.data.fsa.olap.OlapServerDimemsionMetaInfo;
import kd.data.fsa.olap.Template;
import kd.data.fsa.olap.TemplateCatalog;
import kd.data.fsa.utils.FSABcmDataProvider;
import org.apache.commons.lang.StringUtils;

public class FsaQueryerUtilsFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public static final String MODULE = "module";
    public static final String ORGVIEW = "orgview";
    public static final String CUBENUM = "cubenum";
    public static final String OLAPATTRNAME = "olapattributename";
    public static final String OLAPATTRVALUE = "olapattributevalue";
    public static final String QUERYINTERFACE = "queryinterface";
    public static final String BTN_QUERY = "query";
    public static final String DIMLIST = "dimlist";
    public static final String DIMMENLIST = "dimmemlist";
    public static final String DIMNAME = "dimname";
    public static final String DIMENTITYNAME = "dimentityname";
    public static final String DIMNUMBER = "dimnum";
    public static final String PARAM = "param";
    public static final String LOG = "log";
    public static final String DIMID = "dimid";
    public static final String BTN_CHANGE_DISPALY = "changedisplay";
    public static final String CONN_LIST = "connlist";
    public static final String MENBERACCOUNT = "menberaccount";
    private StringBuilder log = null;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgView = (BasedataEdit)this.getControl(ORGVIEW);
        orgView.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{BTN_QUERY, BTN_CHANGE_DISPALY});
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        DynamicObject model = (DynamicObject)this.getModel().getValue(MODULE);
        if (model != null) {
            ListShowParameter showParam = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParam.setCustomParam("custom", (Object)"fsa");
            ListFilterParameter filterParam = showParam.getListFilterParameter();
            filterParam.getQFilters().add(new QFilter("model", "=", model.get("id")));
        } else {
            beforeF7SelectEvent.setCancel(true);
            this.getView().showTipNotification("\u8bf7\u5148\u9009\u62e9\u5408\u5e76\u4f53\u7cfb");
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Button source = (Button)evt.getSource();
        switch (key = source.getKey()) {
            case "query": {
                this.query();
                break;
            }
            case "changedisplay": {
                this.changeDisplay();
                break;
            }
        }
    }

    private void changeDisplay() {
        int[] selectRows;
        IDataModel model = this.getModel();
        EntryGrid dimListCtrl = (EntryGrid)this.getControl(DIMLIST);
        for (int selectRow : selectRows = dimListCtrl.getSelectRows()) {
            int diplaytype = Integer.parseInt((String)model.getValue("diplaytype", selectRow));
            if (diplaytype == 1) {
                model.setValue("diplaytype", (Object)0, selectRow);
                continue;
            }
            model.setValue("diplaytype", (Object)1, selectRow);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "module": {
                this.getModel().setValue(CUBENUM, (Object)FSABcmDataProvider.getModelNumber((Long)((DynamicObject)this.getModel().getValue(MODULE)).getLong("id")));
                break;
            }
        }
    }

    private void query() {
        IDataModel model = this.getModel();
        int queryType = Integer.parseInt((String)this.getModel().getValue(QUERYINTERFACE));
        Long modelId = ((DynamicObject)model.getValue(MODULE)).getLong("id");
        Long cslScheme = null;
        if (model.getValue(ORGVIEW) != null) {
            cslScheme = ((DynamicObject)model.getValue(ORGVIEW)).getLong("id");
        }
        this.logInit();
        try {
            switch (queryType) {
                case 0: {
                    this.loadModuleAllDimensionMetas(modelId);
                    break;
                }
                case 1: {
                    this.loadModuleDimensionMeta(modelId, (String)model.getValue(PARAM));
                    break;
                }
                case 2: {
                    this.loadModuleDimensionMetas(modelId, cslScheme);
                    break;
                }
                case 3: {
                    this.loadDimensionMembers(modelId, cslScheme);
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    String dimId = (String)model.getValue(DIMID);
                    if (kd.bos.util.StringUtils.isNotEmpty((String)dimId)) {
                        this.loadCurrentUserVisiableEntities(modelId, Long.parseLong(dimId));
                        break;
                    }
                    this.getView().showTipNotification("\u65e0\u6cd5\u83b7\u53d6\u7ef4\u5ea6ID\uff0c\u8bf7\u5148\u6267\u884c\u83b7\u53d6\u7ef4\u5ea6\u7684\u76f8\u5173\u65b9\u6cd5\uff01");
                    break;
                }
                case 6: {
                    String dimId = (String)model.getValue(DIMID);
                    String entityName = (String)model.getValue(DIMENTITYNAME);
                    if (kd.bos.util.StringUtils.isNotEmpty((String)dimId) && kd.bos.util.StringUtils.isNotEmpty((String)entityName)) {
                        this.loadDimensionMemberNumberNames(Long.parseLong(dimId), entityName);
                        break;
                    }
                    this.getView().showTipNotification("\u65e0\u6cd5\u83b7\u53d6\u7ef4\u5ea6ID\u6216\u5b9e\u4f53\u5bf9\u8c61\u540d\u79f0");
                    break;
                }
                case 7: {
                    String dimId = (String)model.getValue(DIMID);
                    String entityName = (String)model.getValue(DIMENTITYNAME);
                    if (kd.bos.util.StringUtils.isNotEmpty((String)dimId) && kd.bos.util.StringUtils.isNotEmpty((String)entityName)) {
                        this.loadDimensionMemberNumberId(Long.parseLong(dimId), entityName);
                        break;
                    }
                    this.getView().showTipNotification("\u65e0\u6cd5\u83b7\u53d6\u7ef4\u5ea6ID\u6216\u5b9e\u4f53\u5bf9\u8c61\u540d\u79f0");
                    break;
                }
                case 8: {
                    this.getModelNumber(modelId);
                    break;
                }
                case 9: {
                    this.getOlapConnectionInformation(modelId);
                    break;
                }
                case 10: {
                    this.loadScenaio(modelId);
                    break;
                }
                case 11: {
                    this.loadtemplate(modelId);
                    break;
                }
                case 12: {
                    this.loadtemplateCatalogs(modelId);
                    break;
                }
                case 13: {
                    this.loadDimMemberFromTemplates();
                    break;
                }
                case 14: {
                    this.loadModules();
                    break;
                }
                case 15: {
                    this.loadCslSchemeInfo();
                    break;
                }
            }
        }
        catch (Exception e) {
            this.logAppend("Exception massage: " + e.getMessage());
            this.logAppend("Stack trace: " + Arrays.toString(e.getStackTrace()));
        }
        model.setValue(LOG, (Object)this.log.toString());
    }

    private void loadCslSchemeInfo() {
        IDataModel model = this.getModel();
        String param = (String)model.getValue(PARAM);
        if (org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)param)) {
            boolean isexit = FSABcmDataProvider.exitCslSchemeInfo((long)Long.parseLong(param));
            model.setValue(LOG, (Object)("isexit = " + isexit));
        } else {
            model.setValue(LOG, (Object)"\u8bf7\u8f93\u5165\u957f\u6574\u578b");
        }
    }

    private void loadModules() {
        IDataModel model = this.getModel();
        String param = (String)model.getValue(PARAM);
        if (org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)param)) {
            boolean isexit = FSABcmDataProvider.exitMoudleId((long)Long.parseLong(param));
            model.setValue(LOG, (Object)("isexit = " + isexit));
        } else {
            model.setValue(LOG, (Object)"\u8bf7\u8f93\u5165\u957f\u6574\u578b");
        }
    }

    private void loadDimMemberFromTemplates() {
        IDataModel model = this.getModel();
        String param = (String)model.getValue(PARAM);
        long tmepid = 1275175571919220736L;
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)param) && StringUtils.isNumeric((String)param)) {
            tmepid = Long.parseLong(param);
        }
        Template template = FSABcmDataProvider.loadDimMemberFromTemplate((Long)tmepid);
        this.log.append(template);
        model.setValue(LOG, (Object)this.log.toString());
    }

    private void loadtemplate(Long modelId) {
        IDataModel model = this.getModel();
        String value = (String)model.getValue(PARAM);
        Long templateCatalogId = null;
        Object[][] params = null;
        int[] filter = null;
        if (value != null) {
            JSONArray jsonArray3;
            String[] split = value.split(";");
            if (split.length < 3) {
                model.setValue(LOG, (Object)this.log.append("\u53c2\u6570\u8bbe\u7f6e\u9519\u8bef\uff0c\u8bf7\u7528';'\u5206\u9694\u53c2\u6570\u3002\u7b2c\u4e00\u4e2a\u53c2\u6570\u662f\u6a21\u677fId,\u662f\u4e2along\u7c7b\u578b\uff1b\u7b2c\u4e8c\u53c2\u6570\u662f\u8fc7\u6ee4\u5668\u96c6\u5408\uff0c\u662f\u4e00\u4e2aint\u6570\u7ec4,\u7528\u7b26\u53f7'[]'\u8868\u793a\uff0c\u4f8b\u5982\uff1a[1,2,3]\uff1b\u7b2c\u4e09\u4e2a\u53c2\u6570\u662f\u8fc7\u6ee4\u5668\u53c2\u6570\u96c6\u5408\uff0c\u662f\u4e00\u4e2a\u4e8c\u7ef4\u6570\u7ec4,\u4f7f\u7528\u7b26\u53f7'[[]]'\u8868\u793a\uff0c\u4f8b\u5982[[937477542388971520,937477542464468992],[937477542439302144]]"));
                this.log.append("\u4e09\u4e2a\u53c2\u6570\u5fc5\u987b\u90fd\u6709\uff0c\u8bbe\u7f6e\u4e3anull\u65f6\u53ea\u9700';'\u4e0e';'\u4e4b\u95f4\u4e0d\u586b\u4efb\u4f55\u503c\u3002");
                return;
            }
            String param1 = split[0].trim();
            templateCatalogId = kd.bos.util.StringUtils.isEmpty((String)param1) ? null : Long.valueOf(Long.parseLong(param1));
            String param2 = split[1].trim();
            JSONArray jsonArray2 = JSONArray.parseArray((String)param2);
            if (jsonArray2 != null) {
                filter = new int[jsonArray2.size()];
                for (int i = 0; i < jsonArray2.size(); ++i) {
                    filter[i] = (Integer)jsonArray2.get(i);
                }
            }
            if ((jsonArray3 = JSONArray.parseArray((String)split[2].trim())) != null) {
                params = new Object[jsonArray3.size()][];
                for (int i = 0; i < jsonArray3.size(); ++i) {
                    JSONArray jsonArray = (JSONArray)jsonArray3.get(i);
                    Object[] obj = new Object[jsonArray.size()];
                    for (int i1 = 0; i1 < jsonArray.size(); ++i1) {
                        obj[i1] = jsonArray.get(i1);
                    }
                    params[i] = obj;
                }
            }
        }
        List templates = FSABcmDataProvider.loadTemplate((long)modelId, templateCatalogId, filter, (Object[][])params);
        for (int i = 0; i < templates.size(); ++i) {
            this.log.append(((Template)templates.get(i)).toString());
        }
    }

    private void loadtemplateCatalogs(Long modelId) {
        IDataModel model = this.getModel();
        String value = (String)model.getValue(PARAM);
        Object[][] params = null;
        int[] filter = null;
        if (value != null) {
            JSONArray jsonArray2;
            String[] split = value.split(";");
            if (split.length < 2) {
                model.setValue(LOG, (Object)this.log.append("\u53c2\u6570\u8bbe\u7f6e\u9519\u8bef\uff0c\u8bf7\u7528';'\u5206\u9694\u53c2\u6570\u3002\u7b2c\u4e00\u53c2\u6570\u662f\u8fc7\u6ee4\u5668\u96c6\u5408\uff0c\u662f\u4e00\u4e2aint\u6570\u7ec4,\u7528\u7b26\u53f7'[]'\u8868\u793a\uff0c\u4f8b\u5982\uff1a[1,2,3]\uff1b\u7b2c\u4e8c\u4e2a\u53c2\u6570\u662f\u8fc7\u6ee4\u5668\u53c2\u6570\u96c6\u5408\uff0c\u662f\u4e00\u4e2a\u4e8c\u7ef4\u6570\u7ec4,\u4f7f\u7528\u7b26\u53f7'[[]]'\u8868\u793a\uff0c\u4f8b\u5982[[937477542388971520,937477542464468992],[937477542439302144]]"));
                this.log.append("\u4e24\u4e2a\u53c2\u6570\u5fc5\u987b\u90fd\u6709\uff0c\u8bbe\u7f6e\u4e3anull\u65f6\u53ea\u9700';'\u4e0e';'\u4e4b\u95f4\u4e0d\u586b\u4efb\u4f55\u503c\u3002");
                return;
            }
            String param1 = split[0].trim();
            JSONArray jsonArray1 = JSONArray.parseArray((String)param1);
            if (jsonArray1 != null) {
                filter = new int[jsonArray1.size()];
                for (int i = 0; i < jsonArray1.size(); ++i) {
                    filter[i] = (Integer)jsonArray1.get(i);
                }
            }
            if ((jsonArray2 = JSONArray.parseArray((String)split[1].trim())) != null) {
                params = new Object[jsonArray2.size()][];
                for (int i = 0; i < jsonArray2.size(); ++i) {
                    JSONArray jsonArray = (JSONArray)jsonArray2.get(i);
                    Object[] obj = new Object[jsonArray.size()];
                    for (int i1 = 0; i1 < jsonArray.size(); ++i1) {
                        obj[i1] = jsonArray.get(i1);
                    }
                    params[i] = obj;
                }
            }
        }
        List templateCatalogs = FSABcmDataProvider.loadTemplateCatalog((long)modelId, filter, (Object[][])params);
        for (int i = 0; i < templateCatalogs.size(); ++i) {
            this.log.append(((TemplateCatalog)templateCatalogs.get(i)).toString());
        }
    }

    private void loadDimensionMemberNumberId(long dimId, String srcEntityName) {
        IDataModel model = this.getModel();
        Map numNameMap = FSABcmDataProvider.loadDimensionMemberNumberId((String)srcEntityName, (long)dimId, null, (boolean)false);
        Iterator iterator = numNameMap.entrySet().iterator();
        model.deleteEntryData(DIMMENLIST);
        while (iterator.hasNext()) {
            Map.Entry next = iterator.next();
            int newRow = model.createNewEntryRow(DIMMENLIST);
            model.setValue("memnum", next.getKey(), newRow);
            model.setValue("memid", next.getValue(), newRow);
        }
    }

    private void loadModuleDimensionMetas(Long modelId, Long viewId) {
        IDataModel model = this.getModel();
        EntryGrid dimListCtrl = (EntryGrid)this.getControl(DIMLIST);
        int[] selectRows = dimListCtrl.getSelectRows();
        DynamicObjectCollection dimList = model.getEntryEntity(DIMLIST);
        LinkedList<String> hierarchyNumbers = new LinkedList<String>();
        LinkedList<String> commonNumbers = new LinkedList<String>();
        for (int selectRow : selectRows) {
            DynamicObject dim = (DynamicObject)dimList.get(selectRow);
            if ("1".equals(dim.getString("diplaytype"))) {
                hierarchyNumbers.add(dim.getString(DIMNUMBER));
                continue;
            }
            commonNumbers.add(dim.getString(DIMNUMBER));
        }
        Map[] dimMemberLookupMaps = FSABcmDataProvider.loadModuleDimensionMetas((long)modelId, (String[])hierarchyNumbers.toArray(new String[0]), (String[])commonNumbers.toArray(new String[0]), (Long)viewId, null).getDimMemberLookupMaps();
        for (int i = 0; i < selectRows.length; ++i) {
            Map dimMemLookupMap = dimMemberLookupMaps[i];
            model.setEntryCurrentRowIndex(DIMLIST, selectRows[i]);
            model.deleteEntryData(DIMMENLIST);
            for (Map.Entry next : dimMemLookupMap.entrySet()) {
                int newRow = model.createNewEntryRow(DIMMENLIST);
                for (Object[] share : ((OlapDimensionLookupMetaInfo.BaseDimMemLookupValueItem)next.getValue()).getValueArray(new Object[0])) {
                    if (share.length == 3) {
                        model.setValue("memnum", next.getKey(), newRow);
                        model.setValue("memname", share[2], newRow);
                        model.setValue("memid", share[0], newRow);
                        model.setValue("parentid", share[1], newRow);
                        continue;
                    }
                    model.setValue("memnum", next.getKey(), newRow);
                    model.setValue("memname", share[0], newRow);
                }
            }
        }
        model.setEntryCurrentRowIndex(DIMLIST, -1);
    }

    private void loadCurrentUserVisiableEntities(long moduleId, Long dimId) {
        IDataModel model = this.getModel();
        Map numNameMap = FSABcmDataProvider.loadCurrentUserVisiableEntities((long)moduleId, (Long)dimId);
        Iterator iterator = numNameMap.entrySet().iterator();
        model.deleteEntryData(DIMMENLIST);
        while (iterator.hasNext()) {
            Map.Entry next = iterator.next();
            int newRow = model.createNewEntryRow(DIMMENLIST);
            model.setValue("memnum", next.getKey(), newRow);
            model.setValue("memname", next.getValue(), newRow);
        }
    }

    private void loadDimensionMemberNumberNames(long dimId, String srcEntityName) {
        IDataModel model = this.getModel();
        Map numNameMap = FSABcmDataProvider.loadDimensionMemberNumberNames((String)srcEntityName, (long)dimId, null, (boolean)false);
        Iterator iterator = numNameMap.entrySet().iterator();
        model.deleteEntryData(DIMMENLIST);
        while (iterator.hasNext()) {
            Map.Entry next = iterator.next();
            int newRow = model.createNewEntryRow(DIMMENLIST);
            model.setValue("memnum", next.getKey(), newRow);
            model.setValue("memname", next.getValue(), newRow);
        }
    }

    private void getModelNumber(long modelId) {
        String modelNumber = FSABcmDataProvider.getModelNumber((Long)modelId);
        this.logAppend(modelNumber);
    }

    private void loadModuleAllDimensionMetas(Long modelId) {
        IDataModel model = this.getModel();
        model.deleteEntryData(DIMLIST);
        model.deleteEntryData(DIMMENLIST);
        Map infoMap = FSABcmDataProvider.loadModuleAllDimensionMetas((Long)modelId);
        for (OlapServerDimemsionMetaInfo info : infoMap.values()) {
            int newRow = model.createNewEntryRow(DIMLIST);
            model.setValue(DIMID, (Object)info.getId(), newRow);
            model.setValue(DIMNAME, (Object)info.getName(), newRow);
            model.setValue(DIMNUMBER, (Object)info.getNumber(), newRow);
            model.setValue(DIMENTITYNAME, (Object)info.getDimEntityName(), newRow);
        }
    }

    private void loadModuleDimensionMeta(Long modelId, String dimNumber) {
        IFormView view = this.getView();
        if (kd.bos.util.StringUtils.isEmpty((String)dimNumber)) {
            view.showErrorNotification("\u8bf7\u5148\u586b\u5199\u5bf9\u5e94\u7684\u53c2\u6570");
            return;
        }
        IDataModel model = this.getModel();
        model.deleteEntryData(DIMLIST);
        model.deleteEntryData(DIMMENLIST);
        OlapServerDimemsionMetaInfo cslScheme = null;
        try {
            cslScheme = FSABcmDataProvider.loadModuleDimensionMeta((Long)modelId, (String)dimNumber);
        }
        catch (Exception e) {
            model.setValue(LOG, (Object)Arrays.toString(e.getStackTrace()));
        }
        if (cslScheme == null) {
            view.showErrorNotification("\u83b7\u53d6\u5230\u7684\u7ef4\u5ea6\u4e3anull");
            return;
        }
        int newRow = model.createNewEntryRow(DIMLIST);
        model.setValue(DIMNAME, (Object)cslScheme.getName(), newRow);
        model.setValue(DIMNUMBER, (Object)cslScheme.getNumber(), newRow);
        model.setValue(DIMENTITYNAME, (Object)cslScheme.getDimEntityName(), newRow);
        model.setValue(DIMID, (Object)cslScheme.getId().toString(), newRow);
        model.setValue(MENBERACCOUNT, (Object)cslScheme.getDimMembers().size(), newRow);
    }

    private void loadScenaio(long modelId) {
        Map olapServerDimMemberMetaInfoMap = FSABcmDataProvider.loadScenaio((Long)modelId);
        IDataModel model = this.getModel();
        Set entries = olapServerDimMemberMetaInfoMap.entrySet();
        Iterator iterator = entries.iterator();
        model.deleteEntryData(DIMLIST);
        model.createNewEntryRow(DIMLIST);
        model.setValue(DIMNAME, (Object)"\u60c5\u666f");
        model.setValue(DIMNUMBER, (Object)"Scenario");
        model.setEntryCurrentRowIndex(DIMLIST, 0);
        while (iterator.hasNext()) {
            int newEntryRow = model.createNewEntryRow(DIMMENLIST);
            Map.Entry next = iterator.next();
            OlapServerDimMemberMetaInfo value = (OlapServerDimMemberMetaInfo)next.getValue();
            model.setValue("memnum", (Object)value.getNumber(), newEntryRow);
            model.setValue("memname", (Object)value.getName(), newEntryRow);
            model.setValue("memid", (Object)value.getId(), newEntryRow);
            model.setValue("parentid", (Object)value.getParent(), newEntryRow);
            model.setValue("longnum", (Object)value.getLongNumber(), newEntryRow);
            model.setValue("level", (Object)value.getLevel(), newEntryRow);
            model.setValue("isleaf", (Object)value.isLeaf(), newEntryRow);
        }
    }

    private void loadDimensionMembers(long modelId, Long viewId) {
        IDataModel model = this.getModel();
        EntryGrid dimListCtrl = (EntryGrid)this.getControl(DIMLIST);
        int[] selectRows = dimListCtrl.getSelectRows();
        DynamicObjectCollection dimList = model.getEntryEntity(DIMLIST);
        for (int selectRow : selectRows) {
            model.setEntryCurrentRowIndex(DIMLIST, selectRow);
            model.deleteEntryData(DIMMENLIST);
            String entityName = ((DynamicObject)dimList.get(selectRow)).getString(DIMENTITYNAME);
            long dimId = Long.parseLong((String)model.getValue(DIMID));
            Collection members = FSABcmDataProvider.loadDimensionMembers((Long)modelId, (Long)viewId, (String)entityName, (Long)dimId, null, null, (boolean)true, null).values();
            for (OlapServerDimMemberMetaInfo member : members) {
                int newRow = model.createNewEntryRow(DIMMENLIST);
                model.setValue("memnum", (Object)member.getNumber(), newRow);
                model.setValue("memname", (Object)member.getName(), newRow);
                model.setValue("memid", (Object)member.getId(), newRow);
                model.setValue("parentid", (Object)member.getParent(), newRow);
                model.setValue("longnum", (Object)member.getLongNumber(), newRow);
                model.setValue("level", (Object)member.getLevel(), newRow);
                model.setValue("isleaf", (Object)member.isLeaf(), newRow);
            }
        }
        model.setEntryCurrentRowIndex(DIMLIST, -1);
    }

    private void getOlapConnectionInformation(long modelId) {
        IDataModel model = this.getModel();
        String cube = FSABcmDataProvider.getModelNumber((Long)modelId);
        OlapConnectionInformation olapConnInfo = FSABcmDataProvider.getOlapConnectionInformation((String)cube, (Integer)null);
        model.deleteEntryData(CONN_LIST);
        int username = model.createNewEntryRow(CONN_LIST);
        model.setValue(OLAPATTRNAME, (Object)"username", username);
        model.setValue(OLAPATTRVALUE, (Object)olapConnInfo.getUsername(), username);
        int password = model.createNewEntryRow(CONN_LIST);
        model.setValue(OLAPATTRNAME, (Object)"password", password);
        model.setValue(OLAPATTRVALUE, (Object)olapConnInfo.getPassword(), password);
        int address = model.createNewEntryRow(CONN_LIST);
        model.setValue(OLAPATTRNAME, (Object)"address", address);
        model.setValue(OLAPATTRVALUE, (Object)olapConnInfo.getAddress(), address);
        int url = model.createNewEntryRow(CONN_LIST);
        model.setValue(OLAPATTRNAME, (Object)"connect serial", url);
        model.setValue(OLAPATTRVALUE, (Object)olapConnInfo.getConnectSerial(), url);
    }

    private void logInit() {
        this.log = new StringBuilder();
        RequestContext requestContext = RequestContext.get();
        this.log.append("request id: ").append(requestContext.getRequestId()).append('\n');
        this.log.append("trace id: ").append(requestContext.getTraceId()).append('\n');
    }

    private void logAppend(String str) {
        this.log.append(str).append('\n');
    }
}

