/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.formplugin.qing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.entity.qing.IQingDataProvider;
import kd.bos.entity.qing.QingData;
import kd.bos.entity.qing.QingMeta;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.disf.algo.IDataSetRowDataPageReader;
import kd.data.disf.cache.DistributeCache;
import kd.data.disf.cache.IDataCacheEntry;
import kd.data.disf.cache.IDataCacheHelper;
import kd.data.disf.cache.IDataCacheModule;
import kd.data.disf.qing.IDataQingDataProviderCacheParam;
import kd.data.disf.utils.IDataJsonUtil;
import kd.data.disf.utils.IDataStringUtil;
import kd.data.disf.utils.QFilterBuilder;
import kd.data.disf.utils.QingAPITableBuilder;
import kd.data.fsa.cacheservice.FSAQingDataProviderCacheParamCacheServiceDynamicEntity;

public abstract class IDataAbstractQingDataProvider
extends AbstractFormPlugin
implements IQingDataProvider {
    private static Log logger = LogFactory.getLog(IDataAbstractQingDataProvider.class);
    private static final String CACHE_ID = "IDataQingTableDataProvider_CacheId.";
    public static final String QingDataProviderCacheParam = "cacheParam.";
    public static final String RemainRowCacheParam = "remainRow.";
    protected IDataQingDataProviderCacheParam cacheParam;
    protected QingAPITableBuilder qingTabBuilder;
    protected CachedDataSet cacheDataSet;
    protected QingMeta qingMeta;
    protected Map<String, Integer> fieldSeqIndexs;

    protected abstract DistributeCache getDistributeCache();

    protected abstract IDataSetRowDataPageReader createDataSetRowDataPageReader(String var1, int var2, IDataQingDataProviderCacheParam var3);

    public String getFilterParameter() {
        if (logger.isInfoEnabled()) {
            logger.info(String.format("Start getFilterParameter: PageId=%s, TraceId=%s, FormShowParameter=%s", this.getPageIdFromView(), RequestContext.getOrCreate().getTraceId(), this.getView() != null ? this.getView().getFormShowParameter() : null));
        }
        if (this.getView() == null) {
            throw new KDBizException("\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7684\u9875\u9762\u89c6\u56feView\uff01\u8bf7\u91cd\u65b0\u767b\u5f55");
        }
        FSAQingDataProviderCacheParamCacheServiceDynamicEntity cacheService = new FSAQingDataProviderCacheParamCacheServiceDynamicEntity((IDataCacheEntry)IDataCacheHelper.getDistributeCache((IDataCacheModule)IDataCacheModule.FSA));
        String cacheParamStr = (String)this.getView().getFormShowParameter().getCustomParam(QingDataProviderCacheParam);
        if (StringUtils.isEmpty((String)cacheParamStr)) {
            throw new KDBizException("\u901a\u8fc7\u9875\u9762\u53c2\u6570\u83b7\u53d6\u8f7b\u5206\u6790\u542f\u52a8\u53c2\u6570\u4fe1\u606f\u5931\u8d25: \u7f13\u5b58\u4fe1\u606f\u4e3aNull");
        }
        String[] schemeAndSyncParamId = cacheParamStr.split("&&");
        HashMap<String, String> paramMap = new HashMap<String, String>(2);
        paramMap.put("schemeId", schemeAndSyncParamId[0]);
        paramMap.put("syncParamId", schemeAndSyncParamId[1]);
        this.cacheParam = (IDataQingDataProviderCacheParam)cacheService.reloadCache(paramMap, new Object[]{Boolean.FALSE});
        this.cacheParam.validateCacheParam();
        this.saveCacheParamToDistributedCache(this.getPageIdFromView(), this.cacheParam);
        this.dispose();
        return "p=" + cacheParamStr;
    }

    public void setFilterParameter(String customeCallBackDataFilterParam) {
        if (logger.isInfoEnabled()) {
            logger.info(String.format("Start setFilterParameter: PageId=%s, TraceId=%s, customeCallBackDataFilterParam=%s", this.getPageIdFromView(), RequestContext.getOrCreate().getTraceId(), customeCallBackDataFilterParam));
        }
        if (StringUtils.isEmpty((String)customeCallBackDataFilterParam) || !customeCallBackDataFilterParam.startsWith("p=")) {
            throw new KDBizException("\u65e0\u6cd5\u89e3\u6790\u8f7b\u5206\u6790\u4f20\u5165\u7684\u8f7b\u5206\u6790\u6570\u636e\u63d0\u4f9b\u5668\u7684\u542f\u52a8\u53c2\u6570: " + customeCallBackDataFilterParam);
        }
        customeCallBackDataFilterParam = customeCallBackDataFilterParam.substring(2);
        FSAQingDataProviderCacheParamCacheServiceDynamicEntity cacheService = new FSAQingDataProviderCacheParamCacheServiceDynamicEntity((IDataCacheEntry)IDataCacheHelper.getDistributeCache((IDataCacheModule)IDataCacheModule.FSA));
        String[] schemeAndSyncParamId = customeCallBackDataFilterParam.split("&&");
        HashMap<String, String> paramMap = new HashMap<String, String>(2);
        paramMap.put("schemeId", schemeAndSyncParamId[0]);
        paramMap.put("syncParamId", schemeAndSyncParamId[1]);
        this.cacheParam = (IDataQingDataProviderCacheParam)cacheService.reloadCache(paramMap, new Object[]{Boolean.FALSE});
        this.cacheParam.validateCacheParam();
        this.saveCacheParamToDistributedCache(this.getPageIdFromView(), this.cacheParam);
    }

    public String getSchemaAdditionalTag(String pageId) {
        if (this.cacheParam != null && this.cacheParam.getSyncParamId() != null) {
            return String.valueOf(this.cacheParam.getSyncParamId());
        }
        String cacheParamStr = (String)this.getView().getFormShowParameter().getCustomParam(QingDataProviderCacheParam);
        if (StringUtils.isEmpty((String)cacheParamStr)) {
            throw new KDBizException("\u901a\u8fc7\u9875\u9762\u53c2\u6570\u83b7\u53d6\u8f7b\u5206\u6790\u542f\u52a8\u53c2\u6570\u4fe1\u606f\u5931\u8d25: \u7f13\u5b58\u4fe1\u606f\u4e3aNull");
        }
        String[] schemeAndSyncParamId = cacheParamStr.split("&&");
        return schemeAndSyncParamId.length < 2 ? null : schemeAndSyncParamId[1];
    }

    protected IDataQingDataProviderCacheParam getCacheParam(String pageId) {
        boolean needSaveToDistCache = false;
        this.cacheParam = this.getCacheParamFromDistributedCache(pageId);
        if (this.cacheParam == null) {
            this.cacheParam = this.getCacheParamFromFormShowParameter();
            needSaveToDistCache = true;
        }
        this.cacheParam.validateCacheParam();
        if (needSaveToDistCache) {
            this.saveCacheParamToDistributedCache(this.getPageIdFromView(), this.cacheParam);
        }
        return this.cacheParam;
    }

    public QingMeta getMeta(String pageId) {
        if (logger.isInfoEnabled()) {
            logger.info(String.format("Start getMeta: PageId=%s", pageId));
        }
        if (this.qingMeta == null) {
            this.cacheParam = this.getCacheParam(pageId);
            this.qingTabBuilder = this.cacheParam.getQingAPITableBuilder();
            if (logger.isInfoEnabled()) {
                logger.info(String.format("getMeta: pageId=%s, qingTabBuilder Field Count=%s", pageId, this.qingTabBuilder.getQingFieldMap().size()));
            }
            this.qingMeta = this.qingTabBuilder.buildQingMeta();
        }
        if (logger.isInfoEnabled()) {
            logger.info(String.format("End getMeta: pageId=%s, qingMeta=%s", pageId, IDataJsonUtil.toJSONString((Object)this.qingMeta)));
        }
        this.getQueryCacheData(pageId);
        return this.qingMeta;
    }

    public QingData getData(String pageId, int startRow, int limit) {
        if (logger.isInfoEnabled()) {
            logger.info(String.format("Start getQingData: pageId=%s, startRow=%s, limit=%s", pageId, startRow, limit));
        }
        QingData qingData = new QingData();
        qingData.setDataindex(this.getFieldSeqIndexs(pageId));
        qingData.setRows(this.getCacheData(pageId, startRow, limit));
        return qingData;
    }

    protected String getPageIdFromView() {
        return this.getView() != null ? this.getView().getPageId() : null;
    }

    protected IDataQingDataProviderCacheParam getCacheParamFromFormShowParameter() {
        String cacheParamStr = (String)this.getView().getFormShowParameter().getCustomParam(QingDataProviderCacheParam);
        if (StringUtils.isEmpty((String)cacheParamStr)) {
            throw new KDBizException("\u901a\u8fc7\u9875\u9762\u53c2\u6570\u83b7\u53d6\u8f7b\u5206\u6790\u542f\u52a8\u53c2\u6570\u4fe1\u606f\u5931\u8d25: \u7f13\u5b58\u4fe1\u606f\u4e3aNull");
        }
        return this.deSerializeCacheParam(cacheParamStr);
    }

    protected IDataQingDataProviderCacheParam deSerializeCacheParam(String paramStr) {
        if (logger.isInfoEnabled()) {
            logger.info(String.format("Start deSerializeCacheParam: paramStr=%s", paramStr));
        }
        try {
            this.cacheParam = (IDataQingDataProviderCacheParam)IDataJsonUtil.deSerializeFromBase64((String)paramStr);
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", "\u901a\u8fc7\u9875\u9762\u53c2\u6570\u83b7\u53d6\u8f7b\u5206\u6790\u542f\u52a8\u53c2\u6570\u4fe1\u606f\u5931\u8d25: " + e.getMessage()), new Object[0]);
        }
        if (this.cacheParam == null) {
            throw new KDBizException("\u901a\u8fc7\u9875\u9762\u53c2\u6570\u83b7\u53d6\u7684\u8f7b\u5206\u6790\u542f\u52a8\u53c2\u6570\u4fe1\u606f\u4e3a\u7a7a\uff01 ");
        }
        this.cacheParam.validateCacheParam();
        if (logger.isInfoEnabled()) {
            logger.info(String.format("End deSerializeCacheParam: cacheParam=%s", this.cacheParam));
        }
        return this.cacheParam;
    }

    protected IDataQingDataProviderCacheParam getCacheParamFromDistributedCache(String pageId) {
        if (logger.isInfoEnabled()) {
            logger.info(String.format("Start getCacheParamFromDistributedCache: pageId=%s", pageId));
        }
        try {
            String str = this.getDistributeCache().get(this.buildDistributedCacheKeyId(pageId, QingDataProviderCacheParam));
            this.cacheParam = (IDataQingDataProviderCacheParam)IDataJsonUtil.deSerializeFromBase64((String)str);
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", "\u83b7\u53d6\u7f13\u5b58\u7684\u8f7b\u5206\u6790\u542f\u52a8\u53c2\u6570\u4fe1\u606f\u5931\u8d25: " + e.getMessage()), new Object[0]);
        }
        this.cacheParam.validateCacheParam();
        return this.cacheParam;
    }

    protected void saveCacheParamToDistributedCache(String pageId, IDataQingDataProviderCacheParam srcCacheParam) {
        try {
            this.getDistributeCache().put(this.buildDistributedCacheKeyId(pageId, QingDataProviderCacheParam), (Object)IDataJsonUtil.serializeToBase64((Object)srcCacheParam));
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", "\u7f13\u5b58\u7684\u8f7b\u5206\u6790\u542f\u52a8\u53c2\u6570\u4fe1\u606f\u5931\u8d25: " + e.getMessage()), new Object[0]);
        }
    }

    public Map<String, Integer> getFieldSeqIndexs(String pageId) {
        if (this.fieldSeqIndexs == null) {
            this.cacheParam = this.getCacheParam(pageId);
            this.fieldSeqIndexs = this.cacheParam.getQingAPITableBuilder().buildIndexMap();
        }
        if (logger.isInfoEnabled()) {
            logger.info(String.format("getFieldSeqIndexs: fieldSeqIndexs=%s", this.fieldSeqIndexs));
        }
        return this.fieldSeqIndexs;
    }

    protected String buildDistributedCacheKeyId(String pageId, String ... params) {
        StringBuilder buf = new StringBuilder();
        buf.append(CACHE_ID).append(pageId);
        if (params != null && params.length > 0) {
            for (String p : params) {
                buf.append('.').append(p);
            }
        }
        return buf.toString();
    }

    protected CachedDataSet getQueryCacheData(String pageId) {
        long queryTime = System.currentTimeMillis();
        if (logger.isInfoEnabled()) {
            logger.info(String.format("Start getQueryCacheData: PageId=%s", pageId));
        }
        if (this.cacheDataSet != null) {
            return this.cacheDataSet;
        }
        DistributeCache distributeCache = this.getDistributeCache();
        if (distributeCache == null) {
            throw new KDBizException("\u83b7\u53d6\u5206\u5e03\u5f0f\u7f13\u5b58\u5931\u8d25\uff01");
        }
        String cacheKey = this.buildDistributedCacheKeyId(pageId, new String[0]);
        String cacheDataSetId = distributeCache.get(cacheKey);
        if (!StringUtils.isEmpty((String)cacheDataSetId)) {
            try {
                this.cacheDataSet = Algo.getCacheDataSet((String)cacheDataSetId);
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                throw new KDBizException((Throwable)ex, new ErrorCode("", "\u83b7\u53d6CacheDataSet\u5931\u8d25\uff1acacheDataSetId=" + cacheDataSetId + ", Error: " + ex.getMessage()), new Object[0]);
            }
        }
        if (this.cacheDataSet == null) {
            QFilterBuilder qFilterBuilder = this.cacheParam.buildQueryMeasureFilter(1);
            if (logger.isInfoEnabled()) {
                logger.info(String.format("QueryCacheData Filter: %s", qFilterBuilder != null ? qFilterBuilder.toFilterString() : "null"));
            }
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"data/IDataAbstractQingDataProvider/getQueryCacheData", (String)this.cacheParam.getFactEntityName(), (String)this.cacheParam.getFactTableSelectFields(), (QFilter[])(qFilterBuilder != null ? qFilterBuilder.toArray() : null), (String)(IDataStringUtil.arrayToString((Object[])this.cacheParam.getFactTableOrderFields(), (String)",") + " ASC, version DESC"));){
                if (!ds.isEmpty() && (this.cacheDataSet = ds.cache(CacheHint.getDefault())) != null) {
                    cacheDataSetId = this.cacheDataSet.getCacheId();
                    distributeCache.put(cacheKey, (Object)cacheDataSetId);
                }
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info(String.format("End getQueryCacheData: status=%s, cacheDataSetId=%s, queryTime(ms)=%s", this.cacheDataSet != null, cacheDataSetId, System.currentTimeMillis() - queryTime));
        }
        return this.cacheDataSet;
    }

    public List<Object[]> getCacheData(String pageId, int startRow, int pageSize) {
        int totalRowCnt;
        CachedDataSet cacheDs = this.getQueryCacheData(pageId);
        if (cacheDs == null || (totalRowCnt = cacheDs.getRowCount()) <= 0) {
            return new ArrayList<Object[]>(0);
        }
        Map<String, Integer> fieldSeqIndexMap = this.getFieldSeqIndexs(pageId);
        if (fieldSeqIndexMap == null || fieldSeqIndexMap.isEmpty()) {
            logger.info("Qing Filed Index Map is Null or Empty!");
            return new ArrayList<Object[]>(0);
        }
        ArrayList<Integer> columnIndexList = new ArrayList<Integer>(fieldSeqIndexMap.values());
        Collections.sort(columnIndexList);
        int remainRows = this.getRemainRowCntToDistributedCache(pageId) == null ? totalRowCnt : this.getRemainRowCntToDistributedCache(pageId);
        startRow = totalRowCnt - remainRows;
        boolean columnToRowMode = this.cacheParam.isNeedColumnToRowTransformation();
        int fetchPageSize = pageSize;
        fetchPageSize = pageSize * 5;
        int fetchPageCnt = remainRows / fetchPageSize + 1;
        IDataSetRowDataPageReader dataRowBufferReader = this.createDataSetRowDataPageReader(pageId, pageSize, this.cacheParam);
        if (logger.isInfoEnabled()) {
            logger.info(String.format("getCacheData: fetchPageCnt=%s, fetchPageSize=%s", fetchPageCnt, fetchPageSize));
        }
        while (fetchPageCnt > 0) {
            List bufferDataRowList = cacheDs.getList(startRow, fetchPageSize);
            for (Row dataRow : bufferDataRowList) {
                --remainRows;
                if (dataRow == null || dataRowBufferReader.fetchFromDataRow(dataRow) < pageSize) continue;
                this.saveRemainRowCntToDistributedCache(pageId, ++remainRows);
                return dataRowBufferReader.getPageValues();
            }
            --fetchPageCnt;
            startRow += fetchPageSize;
            if (remainRows >= fetchPageSize) continue;
            fetchPageSize = remainRows;
        }
        this.saveRemainRowCntToDistributedCache(pageId, remainRows);
        return dataRowBufferReader.flush();
    }

    protected void saveRemainRowCntToDistributedCache(String pageId, int RemainRow) {
        if (logger.isInfoEnabled()) {
            logger.info(String.format("saveRemainRowCntToDistributedCache: pageId=%s, RemainRow=%s", pageId, RemainRow));
        }
        try {
            this.getDistributeCache().put(this.buildDistributedCacheKeyId(pageId, RemainRowCacheParam), (Object)RemainRow);
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", String.format("\u7f13\u5b58\u7684CacheDataSet\u7684\u5269\u4f59\u6570\u636e\u884c\u6570\u5931\u8d25: pageId=%s, RemainRow=%s, Error=%s", pageId, RemainRow, e.getMessage())), new Object[0]);
        }
    }

    protected Integer getRemainRowCntToDistributedCache(String pageId) {
        try {
            String cntValue = this.getDistributeCache().get(this.buildDistributedCacheKeyId(pageId, RemainRowCacheParam));
            if (StringUtils.isNotEmpty((String)cntValue)) {
                return Integer.valueOf(cntValue);
            }
            return null;
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", "\u83b7\u53d6\u7f13\u5b58\u7684CacheDataSet\u7684\u5269\u4f59\u6570\u636e\u884c\u6570\u5931\u8d25: " + e.getMessage()), new Object[0]);
        }
    }

    public void dispose() {
        String pageId = this.getPageIdFromView();
        DistributeCache distributeCache = this.getDistributeCache();
        if (distributeCache == null) {
            throw new KDBizException("\u83b7\u53d6\u5206\u5e03\u5f0f\u7f13\u5b58\u5931\u8d25\uff01");
        }
        String cacheKey = this.buildDistributedCacheKeyId(pageId, new String[0]);
        String cacheDataSetId = distributeCache.get(cacheKey);
        if (!StringUtils.isEmpty((String)cacheDataSetId)) {
            distributeCache.remove(cacheKey);
            try {
                Algo.removeCacheDataSet((String)cacheDataSetId);
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                throw new KDBizException((Throwable)ex, new ErrorCode("", "\u5220\u9664CacheDataSet\u5931\u8d25\uff1acacheDataSetId=" + cacheDataSetId + ", Error: " + ex.getMessage()), new Object[0]);
            }
        }
        distributeCache.remove(this.buildDistributedCacheKeyId(pageId, RemainRowCacheParam));
    }
}

