/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.formplugin.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.disf.cache.DistributeCache;
import kd.data.disf.cache.IDataCacheModule;
import kd.data.disf.task.IDataAbstractWorkTask;
import kd.data.disf.task.IDataWorkTask;
import kd.data.disf.task.IDataWorkTaskManager;
import kd.data.disf.task.IWorkTaskTransLog;
import kd.data.disf.utils.IDataValueUtil;
import kd.data.fsa.common.enums.FSAWorkTaskTypeEnum;
import kd.data.fsa.engine.task.FSAWorkTaskFactory;
import kd.data.fsa.engine.task.FSAWorkTaskMeta;
import kd.data.fsa.model.sync.FSADataSyncTaskDimFilterModel;
import kd.data.fsa.model.sync.FSADataSyncTaskMemberModel;
import kd.data.fsa.model.sync.FSADataSyncTaskParamModel;
import kd.data.fsa.utils.FSABcmDataProvider;
import kd.data.fsa.utils.FSADataversionUtils;
import kd.data.fsa.utils.FSASyncTaskLogHelper;

public class FSAScheduleDefineConfigTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(FSAScheduleDefineConfigTask.class);
    private final DistributeCache cache = DistributeCache.getCache((IDataCacheModule)IDataCacheModule.FSA);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        Date curTime = new Date();
        logger.info("FSA\u5b9a\u65f6\u53d6\u6570\u5f00\u59cb\uff0c\u5165\u53c2\u5b9a\u65f6\u4efb\u52a1\u8bbe\u7f6e\u7f16\u7801\uff1a" + JSON.toJSONString(map));
        String configNum = (String)map.get("schTaskConfigNumber");
        QFilter filter = new QFilter("number", "=", (Object)configNum);
        DynamicObject schDyo = BusinessDataServiceHelper.loadSingle((String)"fsa_scheduletaskconfig", (QFilter[])filter.toArray());
        String schId = schDyo.getString("schid");
        DynamicObjectCollection taskCol = schDyo.getDynamicObjectCollection("schtaskentity");
        Long syncParamId = Long.parseLong(((DynamicObject)taskCol.get(0)).getString("taskid"));
        DynamicObject syncParam = BusinessDataServiceHelper.loadSingleFromCache((Object)syncParamId, (String)"fsa_syncparam");
        DynamicObjectCollection schTimeCol = schDyo.getDynamicObjectCollection("schtasktime");
        DynamicObject nowTimeDyo = null;
        DynamicObjectCollection schTimeSubCol = null;
        if (StringUtils.isNotEmpty((String)this.cache.get(schId))) {
            this.cache.remove(schId);
            schTimeSubCol = ((DynamicObject)schTimeCol.get(0)).getDynamicObjectCollection("schtasktimesub");
        } else {
            if (schTimeCol == null || schTimeCol.isEmpty()) {
                logger.info("FSA\u5b9a\u65f6\u53d6\u6570\u7ed3\u675f\uff0c\u6ca1\u6709\u6267\u884c\u65f6\u95f4\u3002" + JSON.toJSONString(map));
                return;
            }
            Date endTime = schDyo.getDate("endtime");
            if (curTime.compareTo(endTime) > 0) {
                logger.info("FSA\u5b9a\u65f6\u53d6\u6570\u7ed3\u675f\uff0c\u5df2\u7ecf\u8fc7\u4e86\u5931\u6548\u65f6\u95f4\u3002" + JSON.toJSONString(map));
                return;
            }
            ArrayList<DynamicObject> unRunSchTimeList = new ArrayList<DynamicObject>(1);
            for (DynamicObject timeDyo : schTimeCol) {
                Date schTime = timeDyo.getDate("schtime");
                long mi = (curTime.getTime() - schTime.getTime()) / 60000L;
                if (mi == 0L) {
                    schTimeSubCol = timeDyo.getDynamicObjectCollection("schtasktimesub");
                    nowTimeDyo = timeDyo;
                    break;
                }
                if (schTime.compareTo(curTime) >= 0 || timeDyo.getBoolean("isexecuted") || !"1".equals(timeDyo.getString("timestatus"))) continue;
                DynamicObjectCollection unRunSchTimeSubCol = timeDyo.getDynamicObjectCollection("schtasktimesub");
                boolean runFlag = true;
                if (unRunSchTimeSubCol != null && !unRunSchTimeSubCol.isEmpty()) {
                    for (DynamicObject dim : unRunSchTimeSubCol) {
                        if (!StringUtils.isEmpty((String)dim.getString("memberjson_tag"))) continue;
                        runFlag = false;
                        break;
                    }
                }
                if (!runFlag) continue;
                unRunSchTimeList.add(timeDyo);
            }
            if (schTimeSubCol != null && !schTimeSubCol.isEmpty()) {
                for (DynamicObject dim : schTimeSubCol) {
                    if (!StringUtils.isEmpty((String)dim.getString("memberjson_tag"))) continue;
                    logger.info("FSA\u5b9a\u65f6\u53d6\u6570\u7ed3\u675f\uff0c\u5b58\u5728\u6bcf\u6b21\u5fc5\u586b\u7684\u7ef4\u5ea6\u8fc7\u6ee4\u6761\u4ef6\u6ca1\u6709\u586b\u5199\u3002" + JSON.toJSONString(map));
                    return;
                }
            }
            if (syncParam == null || StringUtils.isEmpty((String)syncParam.getString("tablenumber"))) {
                logger.info("FSA\u5b9a\u65f6\u53d6\u6570\u7ed3\u675f\uff0c\u540c\u6b65\u53c2\u6570\u4e0d\u5b58\u5728\u6216\u672a\u521b\u5efa\u8868\u3002" + JSON.toJSONString(map));
                return;
            }
            if (!unRunSchTimeList.isEmpty()) {
                for (DynamicObject timeDyo : unRunSchTimeList) {
                    Long version = FSADataversionUtils.getVersionToDateLong();
                    Long taskId = FSASyncTaskLogHelper.createSyncTask((Long)syncParamId, (String)String.valueOf(version), (FSAWorkTaskTypeEnum)FSAWorkTaskTypeEnum.BCM_OLAP_GROUP_Data_Sync_Task);
                    IDataAbstractWorkTask task = this.createBcmSyncTask(taskId, version, syncParamId, syncParam, timeDyo.getDynamicObjectCollection("schtasktimesub"));
                    if (task == null) continue;
                    IDataWorkTaskManager.getInstance().submit((IDataWorkTask)task);
                    timeDyo.set("isexecuted", (Object)Character.valueOf('1'));
                }
                SaveServiceHelper.update((DynamicObject)schDyo);
            }
            if (nowTimeDyo == null) {
                logger.info("FSA\u5b9a\u65f6\u53d6\u6570\u7ed3\u675f\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u6267\u884c\u65f6\u95f4\u70b9\u3002" + JSON.toJSONString(map));
                return;
            }
            nowTimeDyo.set("isexecuted", (Object)Character.valueOf('1'));
        }
        Long version = FSADataversionUtils.getVersionToDateLong();
        Long taskId = FSASyncTaskLogHelper.createSyncTask((Long)syncParamId, (String)String.valueOf(version), (FSAWorkTaskTypeEnum)FSAWorkTaskTypeEnum.BCM_OLAP_GROUP_Data_Sync_Task);
        IDataAbstractWorkTask task = this.createBcmSyncTask(taskId, version, syncParamId, syncParam, schTimeSubCol);
        if (task != null) {
            IDataWorkTaskManager.getInstance().submit((IDataWorkTask)task);
            SaveServiceHelper.update((DynamicObject)schDyo);
            logger.info("FSA\u5b9a\u65f6\u53d6\u6570\u7ed3\u675f\uff0c\u5165\u53c2\u5b9a\u65f6\u4efb\u52a1\u8bbe\u7f6e\u7f16\u7801\uff1a" + JSON.toJSONString(map));
        } else {
            logger.info("FSA\u5b9a\u65f6\u53d6\u6570\u7ed3\u675f\uff0c\u6ca1\u6709\u6210\u529f\u83b7\u53d6\u5230\u53d6\u6570task\u3002\u5bf9\u5e94\u53c2\u6570\uff1ataskId, version, syncParamId", new Object[]{taskId, version, syncParamId + JSON.toJSONString(map)});
        }
    }

    private IDataAbstractWorkTask createBcmSyncTask(Long taskId, Long version, Long syncParamId, DynamicObject syncParam, DynamicObjectCollection schTimeSubCol) {
        Long collectionId = syncParam.getLong("datacollection_id");
        DynamicObject dataCollection = QueryServiceHelper.queryOne((String)"fsa_data_collection", (String)"allowdimnull,paramsrc_tag", (QFilter[])new QFilter("id", "=", (Object)collectionId).toArray());
        String srcParamJson = dataCollection.getString("paramsrc_tag");
        Map paramMap = (Map)JSONObject.parseObject((String)srcParamJson, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
        String tableNumber = syncParam.getString("tablenumber");
        Long moduleId = paramMap == null ? null : IDataValueUtil.getLong(paramMap.get("moduleId"));
        String modelNumber = FSABcmDataProvider.getModelNumber((Long)moduleId);
        FSADataSyncTaskParamModel taskParamModel = this.getDimFilter(schTimeSubCol);
        taskParamModel.setModelNumber(modelNumber);
        String paramDetail = JSON.toJSONString((Object)taskParamModel, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
        try {
            boolean allowDimNull = dataCollection.getBoolean("allowdimnull");
            boolean ignoreDimNull = syncParam.getBoolean("ignoredimnull");
            FSAWorkTaskMeta meta = new FSAWorkTaskMeta(Long.valueOf(0L), Long.valueOf(0L), syncParamId.toString(), taskId, syncParamId, FSAWorkTaskTypeEnum.BCM_OLAP_Data_Sync_Task, paramDetail, true, tableNumber, Boolean.valueOf(allowDimNull), Boolean.valueOf(ignoreDimNull), version);
            this.cache.put("cacheMeta", (Object)(syncParamId + "&&&" + modelNumber + "&&&" + taskId), 1800);
            meta.setNeedDelete(true);
            return FSAWorkTaskFactory.createFSAWorkTask((Integer)FSAWorkTaskTypeEnum.BCM_OLAP_GROUP_Data_Sync_Task.getValue(), (IWorkTaskTransLog)meta, (boolean)true);
        }
        catch (Throwable e) {
            this.updateTaskFail(taskId);
            throw new KDBizException(e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
    }

    private FSADataSyncTaskParamModel getDimFilter(DynamicObjectCollection schTimeSubCol) {
        if (schTimeSubCol == null || schTimeSubCol.isEmpty()) {
            return new FSADataSyncTaskParamModel("syncParamTask", new ArrayList(0));
        }
        ArrayList<FSADataSyncTaskDimFilterModel> dimFilter = new ArrayList<FSADataSyncTaskDimFilterModel>(schTimeSubCol.size());
        for (DynamicObject dim : schTimeSubCol) {
            ArrayList<FSADataSyncTaskMemberModel> members;
            String dimNumber = dim.getString("dimnumber");
            String dimName = dim.getString("dimname");
            String dimFilterMode = "2";
            String dimSrcNumber = dim.getString("srcnumber");
            String memberJson = dim.getString("memberjson_tag");
            List memberJsonList = (List)JSON.parseObject((String)memberJson, (TypeReference)new TypeReference<List<Object[]>>(){}, (Feature[])new Feature[0]);
            if (memberJsonList != null && !memberJsonList.isEmpty()) {
                members = new ArrayList(memberJsonList.size());
                for (Object[] objArr : memberJsonList) {
                    FSADataSyncTaskMemberModel memberModel = new FSADataSyncTaskMemberModel(String.valueOf(objArr[0]), String.valueOf(objArr[1]), Long.valueOf(Long.parseLong(String.valueOf(objArr[2]))), String.valueOf(objArr[3]));
                    members.add(memberModel);
                }
            } else {
                members = new ArrayList<FSADataSyncTaskMemberModel>(0);
            }
            FSADataSyncTaskDimFilterModel dimFilterModel = new FSADataSyncTaskDimFilterModel(dimName, dimNumber, dimSrcNumber, dimFilterMode, members);
            dimFilter.add(dimFilterModel);
        }
        return new FSADataSyncTaskParamModel("syncParamTask", dimFilter);
    }

    private void updateTaskFail(Long taskId) {
        DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"fsa_rptdata_synctask", (String)"status");
        task.set("status", (Object)"9");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{task});
    }
}

