/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.formplugin.util;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.data.disf.model.impl.ThreeValueTuple;
import kd.data.disf.utils.CustomizedDynamicFormBuilderUtil;
import kd.data.fsa.common.constant.FSACommonConstant;
import kd.data.fsa.common.enums.FSAFilterModeEnum;
import kd.data.fsa.common.enums.FSAWorkTaskTypeEnum;
import kd.data.fsa.formplugin.FSAEasyModelBusFormPlugin;
import kd.data.fsa.formplugin.util.BaseDataUtil;
import kd.data.fsa.utils.FSADataversionUtils;
import kd.data.fsa.utils.FSATableUtil;
import org.apache.commons.lang.StringUtils;

public class FSAWriteBackQueryInfoWorkService {
    private static final FSAWriteBackQueryInfoWorkService instance = new FSAWriteBackQueryInfoWorkService();
    private static final String SYNCPARAM_TABLENAME = "t_fsa_dsyncparam";
    private static final String DATACOLLECTIONTABLENAME = "t_fsa_datacollection";
    private static final String DATASCHEMETABLENAME = "t_fsa_dstoryscheme";
    protected long currUserId = RequestContext.get().getCurrUserId();

    public static FSAWriteBackQueryInfoWorkService getInstance() {
        return instance;
    }

    public void reWriteDataInfo(FSAEasyModelBusFormPlugin.EasyModel easyModel) {
        try {
            String templateNumber = easyModel.getTemplateNumber().length() > 17 ? easyModel.getTemplateNumber().substring(0, 17) : easyModel.getTemplateNumber();
            String templateName = easyModel.getTemplateName().length() > 37 ? easyModel.getTemplateName().substring(0, 37) : easyModel.getTemplateName();
            easyModel.setDataCollectionId(this.saveDataCollection(easyModel, templateNumber, templateName));
            easyModel.setSyncParamId(this.saveSyncParam(easyModel, templateNumber, templateName));
            easyModel.setDataSchemeId(this.saveDataScheme(easyModel, templateNumber, templateName));
        }
        catch (Exception e) {
            this.deleteQueryInfoData(easyModel);
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
    }

    private Long saveDataCollection(FSAEasyModelBusFormPlugin.EasyModel easyModel, String templateNumber, String templateName) {
        MainEntityType outputDynEntity = EntityMetadataCache.getDataEntityType((String)"fsa_data_collection");
        Object[] writeDataBuffer = new DynamicObject[1];
        Long id = DBServiceHelper.genLongIds((String)DATACOLLECTIONTABLENAME, (int)1)[0];
        DynamicObject dynRow = new DynamicObject((DynamicObjectType)outputDynEntity);
        String timeFormatString = easyModel.getTimeFormatString();
        String collectionNumber = templateNumber + '_' + timeFormatString;
        QFilter qFilter = new QFilter("number", "=", (Object)collectionNumber);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"fsa_data_collection", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (dynamicObject != null) {
            SimpleDateFormat sbf = new SimpleDateFormat("yyMMddHHmmss");
            timeFormatString = sbf.format(new Date());
            easyModel.setTimeFormatString(timeFormatString);
            collectionNumber = templateNumber + '_' + timeFormatString;
        }
        dynRow.set("id", (Object)id);
        dynRow.set("number", (Object)collectionNumber);
        dynRow.set("name", (Object)new LocaleString(templateName + '_' + timeFormatString));
        dynRow.set("creator", (Object)this.currUserId);
        dynRow.set("modifier", (Object)this.currUserId);
        dynRow.set("status", (Object)"C");
        dynRow.set("enable", (Object)"1");
        dynRow.set("masterid", (Object)id);
        dynRow.set("superlongdata", (Object)easyModel.getSuperLongData());
        dynRow.set("datasrctype", (Object)"bcmParamSource");
        HashMap<String, Object> paramSrc = new HashMap<String, Object>(4);
        paramSrc.put("OrgView", easyModel.getCslScheme());
        paramSrc.put("OrgViewname", easyModel.getCslSchemeName());
        paramSrc.put("moduleId", easyModel.getModuleId());
        paramSrc.put("moduleIdname", easyModel.getModuleName());
        dynRow.set("paramsrc_tag", (Object)SerializationUtils.toJsonString(paramSrc));
        dynRow.set("allowdimnull", (Object)Boolean.TRUE);
        dynRow.set("paramsrcname", (Object)(easyModel.getModuleName() + "," + easyModel.getCslSchemeName()));
        ArrayList<List<String>> columnDimensionList = new ArrayList<List<String>>(5);
        ArrayList<List<String>> descartesResultList = new ArrayList<List<String>>(5);
        DynamicObjectCollection dataColSrcFilterCol = dynRow.getDynamicObjectCollection("datacolsrcfilter");
        DynamicObjectCollection dataEntryEntityCol = dynRow.getDynamicObjectCollection("dataentryentity");
        DynamicObjectCollection dataColCombFieldCol = dynRow.getDynamicObjectCollection("datacolcombfields");
        HashMap<String, ThreeValueTuple> dataColCombMapping = new HashMap<String, ThreeValueTuple>(10);
        List<FSAEasyModelBusFormPlugin.DimFilter> dimFilters = easyModel.getDimFilters();
        for (FSAEasyModelBusFormPlugin.DimFilter dimFilter : dimFilters) {
            if (dimFilter == null) continue;
            FSAFilterModeEnum anEnum = FSAFilterModeEnum.getEnum((String)dimFilter.getFilterMode());
            switch (anEnum) {
                case FIXED_CONDITION: {
                    DynamicObject dataColSrcFilter = new DynamicObject(dataColSrcFilterCol.getDynamicObjectType());
                    dataColSrcFilter.set("srcdimnumber", (Object)dimFilter.getNumber());
                    dataColSrcFilter.set("srcdimname", (Object)new LocaleString(dimFilter.getName()));
                    dataColSrcFilter.set("srcdimdatatype", (Object)"4");
                    dataColSrcFilter.set("srcdimtype", (Object)"1");
                    FSAEasyModelBusFormPlugin.MemberFilter memberFilter = dimFilter.getMemberFilters().get(0);
                    dataColSrcFilter.set("srcdimdefault", (Object)memberFilter.getNumber());
                    dataColSrcFilter.set("srcdimnamedefault", (Object)memberFilter.getName());
                    dataColSrcFilterCol.add((Object)dataColSrcFilter);
                    break;
                }
                case PRESET: 
                case ROW_DIMENSION: 
                case REQUIRED: {
                    DynamicObject dataEntryEntity = new DynamicObject(dataEntryEntityCol.getDynamicObjectType());
                    dataEntryEntity.set("dimnumber", (Object)dimFilter.getNumber());
                    dataEntryEntity.set("dimname", (Object)dimFilter.getName());
                    dataEntryEntity.set("fieldcreatetype", (Object)"1");
                    dataEntryEntity.set("dimtype", (Object)"1");
                    dataEntryEntity.set("dimdatatype", (Object)"4");
                    dataEntryEntity.set("srcnumber", (Object)dimFilter.getNumber());
                    dataEntryEntity.set("srcname", (Object)dimFilter.getName());
                    dataEntryEntity.set("dimid", (Object)ID.genLongId());
                    dataEntryEntityCol.add((Object)dataEntryEntity);
                    break;
                }
                case COLUMN_DIMENSION: {
                    ArrayList<String> columnMembers = new ArrayList<String>(10);
                    for (FSAEasyModelBusFormPlugin.MemberFilter filter : dimFilter.getMemberFilters()) {
                        dataColCombMapping.put(filter.getNumber(), new ThreeValueTuple((Object)filter.getName(), (Object)dimFilter.getNumber(), (Object)dimFilter.getName()));
                        columnMembers.add(filter.getNumber());
                    }
                    columnDimensionList.add(columnMembers);
                    break;
                }
            }
        }
        BaseDataUtil.descartes(columnDimensionList, descartesResultList, 0, new ArrayList<String>(0));
        for (List list : descartesResultList) {
            StringBuilder joinNameSb = new StringBuilder();
            DynamicObject dataColCombField = new DynamicObject(dataColCombFieldCol.getDynamicObjectType());
            DynamicObjectCollection dataColMappingsCol = dataColCombField.getDynamicObjectCollection("datacolcombmappings");
            for (String columnField : list) {
                joinNameSb.append(((ThreeValueTuple)dataColCombMapping.get(columnField)).getKey()).append('_');
                DynamicObject dataColMapping = new DynamicObject(dataColMappingsCol.getDynamicObjectType());
                dataColMapping.set("srcfieldname", ((ThreeValueTuple)dataColCombMapping.get(columnField)).getValue());
                dataColMapping.set("srcfieldnumber", ((ThreeValueTuple)dataColCombMapping.get(columnField)).getElement());
                dataColMapping.set("comsrcdatatype", (Object)"2");
                dataColMapping.set("srcfieldmemname", ((ThreeValueTuple)dataColCombMapping.get(columnField)).getKey());
                dataColMapping.set("srcfieldmemnumber", (Object)columnField);
                dataColMappingsCol.add((Object)dataColMapping);
            }
            String dimMemberName = joinNameSb.substring(0, joinNameSb.length() - 1);
            String dimMemberNumber = StringUtils.join((Collection)list, (char)'_');
            long dimId = ID.genLongId();
            DynamicObject dataEntryEntity = new DynamicObject(dataEntryEntityCol.getDynamicObjectType());
            dataEntryEntity.set("dimnumber", (Object)dimMemberNumber);
            dataEntryEntity.set("dimname", (Object)dimMemberName);
            dataEntryEntity.set("fieldcreatetype", (Object)"2");
            dataEntryEntity.set("dimtype", (Object)"2");
            dataEntryEntity.set("dimdatatype", (Object)"2");
            dataEntryEntity.set("srcnumber", (Object)dimMemberNumber);
            dataEntryEntity.set("srcname", (Object)dimMemberName);
            dataEntryEntity.set("dimid", (Object)dimId);
            dataEntryEntityCol.add((Object)dataEntryEntity);
            dataColCombField.set("combofieldfname", (Object)dimMemberName);
            dataColCombField.set("combofieldnumber", (Object)dimMemberNumber);
            dataColCombField.set("comdatatype", (Object)"2");
            dataColCombField.set("COMBINATIONID", (Object)dimId);
            dataColCombFieldCol.add((Object)dataColCombField);
        }
        writeDataBuffer[0] = dynRow;
        Object[] save = BusinessDataWriter.save((IDataEntityType)outputDynEntity, (Object[])writeDataBuffer);
        return ((DynamicObject)save[0]).getLong("id");
    }

    private Long saveSyncParam(FSAEasyModelBusFormPlugin.EasyModel easyModel, String templateNumber, String templateName) {
        List<FSAEasyModelBusFormPlugin.DimFilter> dimFilterList = easyModel.getDimFilters();
        if (dimFilterList == null || dimFilterList.isEmpty()) {
            return null;
        }
        DynamicObject syncParam = BusinessDataServiceHelper.newDynamicObject((String)"fsa_syncparam");
        String tableName = easyModel.getTableName();
        String tableNumber = easyModel.getTableNumber();
        String timeFormatString = easyModel.getTimeFormatString();
        Long id = DBServiceHelper.genLongIds((String)SYNCPARAM_TABLENAME, (int)1)[0];
        syncParam.set("id", (Object)id);
        syncParam.set("number", (Object)(templateNumber + '_' + timeFormatString));
        syncParam.set("name", (Object)new LocaleString(templateName + '_' + timeFormatString));
        syncParam.set("creator", (Object)this.currUserId);
        syncParam.set("modifier", (Object)this.currUserId);
        syncParam.set("createtime", (Object)new Date());
        syncParam.set("status", (Object)"C");
        syncParam.set("enable", (Object)"1");
        syncParam.set("masterid", (Object)id);
        syncParam.set("datacollection", (Object)easyModel.getDataCollectionId());
        syncParam.set("datasrctype", (Object)"bcmParamSource");
        syncParam.set("tablename", (Object)tableName);
        syncParam.set("tablenumber", (Object)tableNumber);
        DynamicObjectCollection dimEntry = syncParam.getDynamicObjectCollection("dimentry");
        for (FSAEasyModelBusFormPlugin.DimFilter dimension : dimFilterList) {
            List<FSAEasyModelBusFormPlugin.MemberFilter> memberFilterList;
            String filterMode = dimension.getFilterMode();
            if (!FSAFilterModeEnum.PRESET.getCodeString().equals(filterMode) && !FSAFilterModeEnum.REQUIRED.getCodeString().equals(filterMode) && !FSAFilterModeEnum.FIXED_CONDITION.getCodeString().equals(filterMode) && !FSAFilterModeEnum.ROW_DIMENSION.getCodeString().equals(filterMode)) continue;
            DynamicObject dimensionDoj = new DynamicObject(dimEntry.getDynamicObjectType());
            String dimensionNumber = dimension.getNumber();
            dimensionDoj.set("dimname", (Object)dimension.getName());
            dimensionDoj.set("dimnumber", (Object)dimensionNumber);
            dimensionDoj.set("olddimnumber", (Object)dimensionNumber);
            dimensionDoj.set("filtermode", (Object)(FSAFilterModeEnum.ROW_DIMENSION.getCodeString().equals(filterMode) || FSAFilterModeEnum.REQUIRED.getCodeString().equals(filterMode) ? FSAFilterModeEnum.PRESET.getCodeString() : filterMode));
            if (!FSAFilterModeEnum.FIXED_CONDITION.getCodeString().equals(filterMode)) {
                dimensionDoj.set("load_compete_member", (Object)"1");
            }
            if ((memberFilterList = dimension.getMemberFilters()) != null && !memberFilterList.isEmpty()) {
                DynamicObjectCollection dimFilterEntry = dimensionDoj.getDynamicObjectCollection("dimfilterentry");
                for (FSAEasyModelBusFormPlugin.MemberFilter memberFilter : memberFilterList) {
                    DynamicObject dimMemberDoj = new DynamicObject(dimFilterEntry.getDynamicObjectType());
                    dimMemberDoj.set("membername", (Object)memberFilter.getName());
                    dimMemberDoj.set("membernumber", (Object)memberFilter.getNumber());
                    dimMemberDoj.set("memberid", (Object)memberFilter.getId());
                    dimMemberDoj.set("memberlongnumber", (Object)memberFilter.getLongNumber());
                    dimFilterEntry.add((Object)dimMemberDoj);
                }
            }
            dimEntry.add((Object)dimensionDoj);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{syncParam});
        boolean createTableSuccess = FSATableUtil.createOrDropTable((Long)id, (FSAWorkTaskTypeEnum)FSAWorkTaskTypeEnum.Create_Table_Task, (String)tableNumber, (String)tableName, (boolean)false);
        if (!createTableSuccess) {
            throw new KDBizException("easy mode Failed to create data table, please find the reason from the syncLog");
        }
        return id;
    }

    private Long saveDataScheme(FSAEasyModelBusFormPlugin.EasyModel easyModel, String templateNumber, String templateName) {
        MainEntityType outputDynEntity = EntityMetadataCache.getDataEntityType((String)"fsa_data_scheme");
        Object[] writeDataBuffer = new DynamicObject[1];
        String timeFormatString = easyModel.getTimeFormatString();
        Long id = DBServiceHelper.genLongIds((String)DATASCHEMETABLENAME, (int)1)[0];
        DynamicObject dynRow = new DynamicObject((DynamicObjectType)outputDynEntity);
        dynRow.set("id", (Object)id);
        dynRow.set("number", (Object)(templateNumber + '_' + timeFormatString));
        dynRow.set("name", (Object)new LocaleString(templateName + '_' + timeFormatString));
        dynRow.set("creator", (Object)this.currUserId);
        dynRow.set("modifier", (Object)this.currUserId);
        dynRow.set("status", (Object)"C");
        dynRow.set("enable", (Object)"1");
        dynRow.set("masterid", (Object)id);
        dynRow.set("data_collection", (Object)easyModel.getDataCollectionId());
        writeDataBuffer[0] = dynRow;
        Object[] save = BusinessDataWriter.save((IDataEntityType)outputDynEntity, (Object[])writeDataBuffer);
        return ((DynamicObject)save[0]).getLong("id");
    }

    public void deleteQueryInfoData(FSAEasyModelBusFormPlugin.EasyModel easyModel) {
        Long schemeId = easyModel.getDataSchemeId();
        Long syncParamId = easyModel.getSyncParamId();
        Long dataCollectionId = easyModel.getDataCollectionId();
        String tableNumber = easyModel.getTableNumber();
        if (schemeId != null) {
            DeleteServiceHelper.delete((String)"fsa_data_scheme", (QFilter[])new QFilter("id", "=", (Object)schemeId).toArray());
            easyModel.setDataSchemeId(null);
        }
        if (syncParamId != null) {
            DeleteServiceHelper.delete((String)"fsa_rptdata_synclog", (QFilter[])new QFilter("datasyncparam", "=", (Object)syncParamId).toArray());
            DeleteServiceHelper.delete((String)"fsa_rptdata_synctask", (QFilter[])new QFilter("rptdatasyncparam", "=", (Object)syncParamId).toArray());
            String entityName = FSACommonConstant.buildEntityName((String)tableNumber);
            if (MetadataDao.checkNumber((String)entityName)) {
                CustomizedDynamicFormBuilderUtil.deleteForm((String)entityName, (boolean)false);
                FSADataversionUtils.deleteWithParamId(Collections.singleton(syncParamId));
            }
            DeleteServiceHelper.delete((String)"fsa_syncparam", (QFilter[])new QFilter("id", "=", (Object)syncParamId).toArray());
            easyModel.setSyncParamId(null);
        }
        if (dataCollectionId != null) {
            DeleteServiceHelper.delete((String)"fsa_data_collection", (QFilter[])new QFilter("id", "=", (Object)dataCollectionId).toArray());
            easyModel.setDataCollectionId(null);
        }
    }
}

