/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.formplugin.validate;

import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.data.fsa.common.enums.FSADimensionTypeEnum;
import kd.data.fsa.common.enums.FSAFieldTypeEnum;
import org.apache.commons.lang3.ArrayUtils;

public class DataCollectionValidator
extends AbstractValidator {
    private static String[] illegalFields = new String[]{"del", "version", "id"};

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            this.validate(dataEntity);
        }
    }

    private void validate(ExtendedDataEntity dataEntity) {
        DynamicObject dynamicObject = dataEntity.getDataEntity();
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("dataentryentity");
        HashSet<String> nameSet = new HashSet<String>(16);
        HashSet<String> numberSet = new HashSet<String>(16);
        for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
            String name = ((DynamicObject)dynamicObjectCollection.get(i)).getString("dimname");
            String number = ((DynamicObject)dynamicObjectCollection.get(i)).getString("dimnumber");
            if (number.matches("[0-9]+")) {
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u5408\u7684\u7ef4\u5ea6\u7f16\u7801\uff1a%s \u4e0d\u80fd\u4e3a\u7eaf\u6570\u5b57\u3002", (String)"DataCollectionValidator_5", (String)"data-fsa-formplugin", (Object[])new Object[0]), number));
            }
            if (!number.matches("[0-9_A-Za-z]+")) {
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u5408\u7684\u7ef4\u5ea6\u7f16\u7801\uff1a%s \u53ea\u652f\u6301\u5b57\u6bcd+\u6570\u5b57+\u4e0b\u5212\u7ebf\u7684\u7ec4\u5408", (String)"DataCollectionValidator_8", (String)"data-fsa-formplugin", (Object[])new Object[0]), number));
            }
            if (ArrayUtils.contains((Object[])illegalFields, (Object)number)) {
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u5408\u7684\u7ef4\u5ea6\u7f16\u7801\uff1a%s\u4e3a\u975e\u6cd5\u7f16\u7801\u3002", (String)"DataCollectionValidator_7", (String)"data-fsa-formplugin", (Object[])new Object[0]), number));
            }
            if (numberSet.contains(number)) {
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u5408\u5b58\u5728\u76f8\u540c\u7684\u7ef4\u5ea6\u7f16\u7801\uff1a%s\u3002", (String)"DataCollectionValidator_4", (String)"data-fsa-formplugin", (Object[])new Object[0]), number));
            } else {
                numberSet.add(number);
            }
            if (nameSet.contains(name)) {
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u5408\u5b58\u5728\u76f8\u540c\u7684\u7ef4\u5ea6\u540d\u79f0\uff1a%s\u3002", (String)"DataCollectionValidator_3", (String)"data-fsa-formplugin", (Object[])new Object[0]), name));
                continue;
            }
            nameSet.add(name);
        }
        String dataSrcType = dynamicObject.getString("datasrctype");
        boolean exitMeasure = false;
        boolean exitDim = false;
        boolean isFileParamSource = "fileParamSource".equals(dataSrcType);
        for (DynamicObject dynamic : dynamicObjectCollection) {
            String dimType = dynamic.getString("dimtype");
            String fieldCreateType = dynamic.getString("fieldcreatetype");
            if (isFileParamSource && FSADimensionTypeEnum.MEASURE_DIM.getCodeString().equals(dimType)) {
                exitMeasure = true;
                continue;
            }
            if (isFileParamSource && (FSADimensionTypeEnum.DATA_DIM.getCodeString().equals(dimType) || FSADimensionTypeEnum.DATE_DIM.getCodeString().equals(dimType))) {
                exitDim = true;
                continue;
            }
            if (!isFileParamSource && FSAFieldTypeEnum.COMBINATION_FIELD.getCodeString().equals(fieldCreateType)) {
                exitMeasure = true;
                continue;
            }
            if (isFileParamSource || !FSAFieldTypeEnum.SOURCE_FIELD.getCodeString().equals(fieldCreateType)) continue;
            exitDim = true;
        }
        if (isFileParamSource) {
            if (!exitMeasure) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u4e3a\u6570\u636e\u96c6\u5408\u6dfb\u52a0\u5ea6\u91cf\u5c5e\u6027\u3002", (String)"DataCollectionValidator_9", (String)"data-fsa-formplugin", (Object[])new Object[0]));
            }
            if (!exitDim) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u4e3a\u6570\u636e\u96c6\u5408\u6dfb\u52a0\u7ef4\u5ea6\u6216\u65e5\u671f\u5c5e\u6027\u3002", (String)"DataCollectionValidator_10", (String)"data-fsa-formplugin", (Object[])new Object[0]));
            }
        } else {
            if (!exitMeasure) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u4e3a\u6570\u636e\u96c6\u5408\u6dfb\u52a0\u7ec4\u5408\u5ea6\u91cf\u5c5e\u6027\u3002", (String)"DataCollectionValidator_1", (String)"data-fsa-formplugin", (Object[])new Object[0]));
            }
            if (!exitDim) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u4e3a\u6570\u636e\u96c6\u5408\u6dfb\u52a0\u7ef4\u5ea6\u6e90\u5b57\u6bb5\u3002", (String)"DataCollectionValidator_2", (String)"data-fsa-formplugin", (Object[])new Object[0]));
            }
        }
    }
}

