/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.cacheservice;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.disf.cache.IDataCacheEntry;
import kd.data.disf.cacheservice.AbstractDataCacheService;
import kd.data.fsa.common.constant.FSACommonConstant;
import kd.data.fsa.model.version.FSADataVersionQueryFilterModel;

public class FSADataVersionQueryFilterCacheService
extends AbstractDataCacheService<FSADataVersionQueryFilterModel, Map<String, Long>> {
    private static Log logger = LogFactory.getLog(FSADataVersionQueryFilterCacheService.class);

    public FSADataVersionQueryFilterCacheService(IDataCacheEntry cacheEntry, int experiedTime) {
        super(cacheEntry, experiedTime);
    }

    public FSADataVersionQueryFilterCacheService(IDataCacheEntry cacheEntry) {
        super(cacheEntry);
    }

    public FSADataVersionQueryFilterModel reloadFromResource(Map<String, Long> param, Object ... keyParams) {
        QFilter qFilter;
        DynamicObject scheme;
        Long syncParamId;
        Long schemaId;
        if (param != null && (schemaId = param.get("schemaid")) != null && (syncParamId = param.get("syncparam_id")) != null && (scheme = BusinessDataServiceHelper.loadSingle((String)"fsa_data_scheme", (String)"data_entry.data_sync_param, data_entry.disable_versions_tag", (QFilter[])new QFilter[]{qFilter = new QFilter("id", "=", (Object)schemaId)})) != null) {
            DynamicObjectCollection dataEntrys = scheme.getDynamicObjectCollection("data_entry");
            for (DynamicObject dataEntry : dataEntrys) {
                if (syncParamId.longValue() != dataEntry.getDynamicObject("data_sync_param").getLong("id")) continue;
                String disableVersionTag = dataEntry.getString("disable_versions_tag");
                if (StringUtils.isEmpty((String)disableVersionTag)) {
                    return new FSADataVersionQueryFilterModel(Boolean.TRUE, null, null);
                }
                FSADataVersionQueryFilterModel dataVersionQueryFilterModel = (FSADataVersionQueryFilterModel)((Object)SerializationUtils.deSerializeFromBase64((String)disableVersionTag));
                return dataVersionQueryFilterModel;
            }
        }
        return null;
    }

    protected FSADataVersionQueryFilterModel deSerializeToModel(String jsonString) {
        return (FSADataVersionQueryFilterModel)((Object)SerializationUtils.deSerializeFromBase64((String)jsonString));
    }

    protected String serializeToString(Object source) {
        return SerializationUtils.serializeToBase64((Object)source);
    }

    public String getCacheRegion() {
        return FSACommonConstant.FSA_APP_CACHE_KEY;
    }

    protected Class<FSADataVersionQueryFilterModel> getSerializeClass() {
        return FSADataVersionQueryFilterModel.class;
    }

    protected boolean validateDataModel(FSADataVersionQueryFilterModel dataModel) {
        return dataModel != null;
    }

    public void updataFSADataVersionQueryFilterCacheService(Long schemeId, Long syncParamId, String value) {
        if (logger.isInfoEnabled()) {
            logger.info(String.format("updataFSADataVersionQueryFilterCacheService: schemeId=%s, syncParamId=%s , value = %s", schemeId, syncParamId, value));
        }
        try {
            HashMap<String, Long> paramMap = new HashMap<String, Long>();
            paramMap.put("schemaid", schemeId);
            paramMap.put("syncparam_id", syncParamId);
            String cacheTypeKey = this.buildCacheTypeKey(paramMap, new Object[0]);
            this.getCacheEntry().put(cacheTypeKey, (Object)value);
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", String.format("\u7f13\u5b58\u7684FSADataVersionQueryFilter\u5931\u8d25: schemeId=%s, syncParamId=%s , value = %s,  Error=%s", schemeId, syncParamId, value, e.getMessage())), new Object[0]);
        }
    }
}

