/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.cacheservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.data.disf.cache.IDataCacheEntry;
import kd.data.disf.cacheservice.AbstractDataCacheService;
import kd.data.disf.task.IDataWorkTaskManager;
import kd.data.disf.utils.IDataValueUtil;
import kd.data.fsa.cacheservice.FSADataCacheMgr;
import kd.data.fsa.common.constant.FSACommonConstant;
import kd.data.fsa.common.enums.FSAFieldTypeEnum;
import kd.data.fsa.common.enums.FSASelectTypeEnum;
import kd.data.fsa.engine.task.FSAOlapDataSyncTaskBuilder;
import kd.data.fsa.engine.task.status.FSAWorkTaskStatusConsumer;
import kd.data.fsa.olap.OlapDimensionLookupMetaInfo;
import kd.data.fsa.olap.OlapServerDimMemberMetaInfo;
import kd.data.fsa.olap.OlapServerDimemsionMetaInfo;
import kd.data.fsa.olap.Template;
import kd.data.fsa.utils.FSABcmDataProvider;
import kd.data.fsa.utils.FSADataCollectionHelper;

public class FSAOlapDataSyncTaskBuilderCacheService
extends AbstractDataCacheService<FSAOlapDataSyncTaskBuilder, Map<String, Object>> {
    private static final String[] excludeField = new String[]{"module", "version", "del", "mappingsrctype"};

    public FSAOlapDataSyncTaskBuilderCacheService(IDataCacheEntry cacheEntry, int experiedTime) {
        super(cacheEntry, experiedTime);
    }

    public FSAOlapDataSyncTaskBuilderCacheService(IDataCacheEntry cacheEntry) {
        super(cacheEntry);
    }

    protected Class<FSAOlapDataSyncTaskBuilder> getSerializeClass() {
        return FSAOlapDataSyncTaskBuilder.class;
    }

    protected boolean validateDataModel(FSAOlapDataSyncTaskBuilder fsaOlapDataSyncTaskBuilder) {
        fsaOlapDataSyncTaskBuilder.validateCacheParam();
        return false;
    }

    public FSAOlapDataSyncTaskBuilder reloadFromResource(Map<String, Object> param, Object ... objects) {
        FSAWorkTaskStatusConsumer statusConsumer = FSAWorkTaskStatusConsumer.getInstance();
        Long syncParamPkId = IDataValueUtil.getLong((Object)param.get("syncParamPkId"));
        Long taskId = IDataValueUtil.getLong((Object)param.get("datasynctask"));
        Long templateId = IDataValueUtil.getLong((Object)param.get("templateid"));
        DynamicObject syncParamDynObj = BusinessDataReader.loadSingle((Object)syncParamPkId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fsa_syncparam"));
        DynamicObjectCollection dimentry = syncParamDynObj.getDynamicObjectCollection("dimentry");
        Long dataCollectionPkId = syncParamDynObj.getLong("datacollection.id");
        boolean autoComplete = syncParamDynObj.getBoolean("autocomplete");
        DynamicObject datacollectionDynObj = BusinessDataReader.loadSingle((Object)dataCollectionPkId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fsa_data_collection"));
        String customRptEntity = "fsa_" + syncParamDynObj.getString("tablenumber");
        boolean superLongData = syncParamDynObj.getDynamicObject("datacollection").getBoolean("superlongdata");
        FSAOlapDataSyncTaskBuilder taskBuilder = new FSAOlapDataSyncTaskBuilder(customRptEntity);
        taskBuilder.setSuperLongData(superLongData);
        DynamicObjectCollection colcombfieldDynCol = datacollectionDynObj.getDynamicObjectCollection("datacolcombfields");
        DynamicObjectCollection dataEntryDynCol = datacollectionDynObj.getDynamicObjectCollection("dataentryentity");
        int colcomSize = colcombfieldDynCol.size();
        LinkedHashMap<String, HashSet<String>> measureMap = new LinkedHashMap<String, HashSet<String>>(10);
        statusConsumer.updateCachedWorkTaskStatusEvent(taskId, "\u6b63\u5728\u521d\u59cb\u5316\u5217\u8f6c\u6362\u6570\u636e");
        for (int i = 0; i < colcomSize; ++i) {
            DynamicObject colcombDynObj = (DynamicObject)colcombfieldDynCol.get(i);
            DynamicObjectCollection colCombMappings = ((DynamicObject)colcombfieldDynCol.get(i)).getDynamicObjectCollection("datacolcombmappings");
            long entryid = colcombDynObj.getLong("COMBINATIONID");
            for (DynamicObject dataEntryDyn : dataEntryDynCol) {
                long srcComboFieldId = dataEntryDyn.getLong("dimid");
                if (srcComboFieldId != entryid) continue;
                LinkedList<String> srcFields = new LinkedList<String>();
                for (DynamicObject colCombMapping : colCombMappings) {
                    srcFields.add(colCombMapping.getString("srcfieldmemnumber"));
                }
                taskBuilder.addTransformFieldMapping(dataEntryDyn.getString("dimnumber"), srcFields);
                break;
            }
            DynamicObjectCollection colComMapDynCol = colcombDynObj.getDynamicObjectCollection("datacolcombmappings");
            int comSize = colComMapDynCol.size();
            for (int j = 0; j < comSize; ++j) {
                DynamicObject comDynObj = (DynamicObject)colComMapDynCol.get(j);
                String srcFieldNumber = comDynObj.getString("srcfieldnumber");
                HashSet<String> mesureFieldsSet = (HashSet<String>)measureMap.get(srcFieldNumber);
                if (mesureFieldsSet == null) {
                    mesureFieldsSet = new HashSet<String>();
                }
                mesureFieldsSet.add(comDynObj.getString("srcfieldmemnumber"));
                measureMap.put(srcFieldNumber, mesureFieldsSet);
            }
        }
        for (Map.Entry mesureEntry : measureMap.entrySet()) {
            String mesureDim = (String)mesureEntry.getKey();
            taskBuilder.addDimensionFilters(mesureDim, ((Set)mesureEntry.getValue()).toArray(new String[0]));
        }
        taskBuilder.addSelectDimensions((Integer)FSASelectTypeEnum.TRANS_TYPE.getIntCode(), Arrays.asList(measureMap.keySet().toArray(new String[0])));
        for (DynamicObject dataEntryDyn : dataEntryDynCol) {
            if (!FSAFieldTypeEnum.CUSTOM_FIELD.getCodeString().equals(dataEntryDyn.getString("fieldcreatetype"))) continue;
            DynamicObjectCollection subEntryCol = dataEntryDyn.getDynamicObjectCollection("subentryentity");
            for (DynamicObject subEntry : subEntryCol) {
                if (!"DefaultValue".equals(subEntry.getString("paramNumber"))) continue;
                taskBuilder.addManuallyAddFieldMap(dataEntryDyn.getString("dimnumber"), subEntry.get("paramvalue"));
            }
        }
        int dimEntrySize = dimentry.size();
        statusConsumer.updateCachedWorkTaskStatusEvent(taskId, "\u6b63\u5728\u52a0\u8f7d\u5e76\u9a8c\u8bc1\u9884\u7f6e\u7ef4\u5ea6\u8fc7\u6ee4\u6761\u4ef6\u7684\u6709\u6548\u6027");
        ArrayList<String> dimNumberList = new ArrayList<String>(10);
        int maxThreadCnt = IDataWorkTaskManager.getInstance().getMaxThreadCnt();
        int iteratorCnt = 1;
        boolean ifHaveNoFilterDims = false;
        for (int i = 0; i < dimEntrySize; ++i) {
            DynamicObject dim = (DynamicObject)dimentry.get(i);
            String filtermode = dim.getString("filtermode");
            String dimNumber = dim.getString("dimnumber");
            String oldDimNumber = dim.getString("olddimnumber");
            String dimName = dim.getString("dimname");
            if (filtermode.equals("1") || filtermode.equals("3")) {
                DynamicObjectCollection dimfilterentry;
                int filterSize;
                if (filtermode.equals("1")) {
                    taskBuilder.addOriginalDimNumberMap(oldDimNumber, dimNumber);
                }
                if ((filterSize = (dimfilterentry = dim.getDynamicObjectCollection("dimfilterentry")).size()) > 0) {
                    String[] memeberValBuf = new String[filterSize];
                    for (int j = 0; j < filterSize; ++j) {
                        memeberValBuf[j] = (String)((DynamicObject)dimfilterentry.get(j)).get("membernumber");
                    }
                    taskBuilder.addDimensionFilters(oldDimNumber, memeberValBuf);
                    if (memeberValBuf.length > maxThreadCnt && (oldDimNumber.equals("Entity") || oldDimNumber.equals("Account"))) {
                        dimNumberList.add(oldDimNumber);
                    }
                    if (memeberValBuf.length > 1 && "1".equals(filtermode)) {
                        iteratorCnt *= filterSize;
                        taskBuilder.addSelectDimensions((Integer)FSASelectTypeEnum.CHANGE_ROWKEY_TYPE.getIntCode(), oldDimNumber);
                        continue;
                    }
                    if (memeberValBuf.length != 1 || !"1".equals(filtermode)) continue;
                    taskBuilder.addSelectDimensions((Integer)FSASelectTypeEnum.FIX_ROWKEY_TYPE.getIntCode(), oldDimNumber);
                    continue;
                }
                if (!filtermode.equals("1")) continue;
                autoComplete = false;
                ifHaveNoFilterDims = true;
                taskBuilder.addSelectDimensions((Integer)FSASelectTypeEnum.CHANGE_ROWKEY_TYPE.getIntCode(), oldDimNumber);
                dimNumberList.add(oldDimNumber);
                continue;
            }
            if (!filtermode.equals("2")) continue;
            taskBuilder.addOriginalDimNumberMap(oldDimNumber, dimNumber);
            taskBuilder.addSelectDimensions((Integer)FSASelectTypeEnum.CHANGE_ROWKEY_TYPE.getIntCode(), oldDimNumber);
        }
        statusConsumer.updateCachedWorkTaskStatusEvent(taskId, "\u6b63\u5728\u5bf9\u6ca1\u6dfb\u52a0\u8fc7\u6ee4\u6761\u4ef6\u7684\u7ef4\u5ea6\u8fdb\u884c\u6709\u6548\u6027\u6821\u9a8c\u548c\u67e5\u8be2\u5206\u7ec4");
        if (ifHaveNoFilterDims && !dimNumberList.isEmpty()) {
            LinkedList<String> splitDimNames = new LinkedList<String>();
            HashMap<String, Set<String>> splitDimMemberMap = new HashMap<String, Set<String>>();
            Map<String, Object> srcParam = FSADataCollectionHelper.getSrcParamFromCol(datacollectionDynObj);
            Long moduleId = srcParam == null ? null : IDataValueUtil.getLong((Object)srcParam.get("moduleId"));
            Long orgView = srcParam == null ? null : IDataValueUtil.getLong((Object)srcParam.get("OrgView"));
            param.put("organizationViewId", orgView);
            param.put("moduleId", moduleId);
            param.put("dimNumberMapMemberIdMap", new HashMap(10));
            if (templateId == null) {
                OlapDimensionLookupMetaInfo olapDimensionLookupMetaInfo = (OlapDimensionLookupMetaInfo)FSADataCacheMgr.instance.getFSABcmDimensionLookupCacheService().reloadCache(param, dimNumberList.toArray());
                if (olapDimensionLookupMetaInfo != null) {
                    Map<String, OlapDimensionLookupMetaInfo.BaseDimMemLookupValueItem>[] dimMemberLookupMaps = olapDimensionLookupMetaInfo.getDimMemberLookupMaps();
                    HashMap dimMemberAcount = new HashMap(dimNumberList.size());
                    if (dimNumberList.contains("Entity")) {
                        splitDimNames.add("Entity");
                    }
                    if (dimNumberList.contains("Account")) {
                        splitDimNames.add("Account");
                    }
                    int size = dimNumberList.size();
                    for (int i = 0; i < size; ++i) {
                        dimMemberAcount.put(dimNumberList.get(i), dimMemberLookupMaps[i].size());
                        splitDimMemberMap.put((String)dimNumberList.get(i), dimMemberLookupMaps[i].keySet());
                    }
                    ArrayList sortBufList = new ArrayList(dimMemberAcount.entrySet());
                    Collections.sort(sortBufList, (src, target) -> (Integer)target.getValue() - (Integer)src.getValue());
                    for (Map.Entry entry : sortBufList) {
                        String dimNumber = (String)entry.getKey();
                        if ("Entity".equals(dimNumber) || "Account".equals(dimNumber)) continue;
                        splitDimNames.add(dimNumber);
                    }
                }
            } else {
                Template template = FSABcmDataProvider.loadDimMemberFromTemplate(templateId);
                Set<String> existFilterDim = taskBuilder.getDimensionFilters().keySet();
                Map<String, List<Long>> pageDimMap = template.getPageDim();
                for (Map.Entry<String, List<Long>> pageDim : pageDimMap.entrySet()) {
                    Long memberId;
                    List<Long> memberIdList;
                    String string = pageDim.getKey();
                    if (existFilterDim.contains(string)) continue;
                    OlapServerDimemsionMetaInfo dimMeta = FSABcmDataProvider.loadModuleDimensionMeta(moduleId, string);
                    List<Long> list = memberIdList = pageDim.getValue().isEmpty() ? null : pageDim.getValue();
                    if (memberIdList != null && memberIdList.size() == 1 && ((Object)(memberId = memberIdList.get(0))).equals(0)) {
                        memberIdList = null;
                    }
                    Map<String, OlapServerDimMemberMetaInfo> olapServerDimMemberMetaInfoMap = FSABcmDataProvider.loadDimensionMembers(moduleId, orgView, dimMeta.getDimEntityName(), dimMeta.getId(), "id", memberIdList, true, null);
                    splitDimNames.add(string);
                    Collection<OlapServerDimMemberMetaInfo> metaInfoCollection = olapServerDimMemberMetaInfoMap.values();
                    HashSet<String> splitDimMemberSet = new HashSet<String>(metaInfoCollection.size());
                    for (OlapServerDimMemberMetaInfo metaInfo : metaInfoCollection) {
                        splitDimMemberSet.add(metaInfo.getNumber());
                    }
                    splitDimMemberMap.put(string, splitDimMemberSet);
                }
            }
            taskBuilder.setSplitDimNames(splitDimNames);
            taskBuilder.setSplitDimMemberMap(splitDimMemberMap);
        }
        taskBuilder.setAutoComplete(autoComplete);
        return taskBuilder;
    }

    public String getCacheRegion() {
        return FSACommonConstant.FSA_APP_CACHE_KEY;
    }
}

