/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.common.enums;

import java.util.Locale;
import kd.bos.util.StringUtils;
import kd.data.disf.enums.IByteCodeEnum;

public enum FSAStandardReportTypeEnum implements IByteCodeEnum<FSAStandardReportTypeEnum>
{
    Balance_Sheet(0, "fsa_rptbalance"),
    Income_Statement(1, "fsa_rptincomestat"),
    Cash_Flow(2, "fsa_rptcashflow");

    private byte code;
    private String factEntityName;

    private FSAStandardReportTypeEnum(byte code, String factEntityName) {
        this.code = code;
        this.factEntityName = factEntityName;
    }

    public byte getCode() {
        return this.code;
    }

    public static FSAStandardReportTypeEnum getEnum(Byte code) {
        if (code == null) {
            return null;
        }
        switch (code) {
            case 0: {
                return Balance_Sheet;
            }
            case 1: {
                return Income_Statement;
            }
            case 2: {
                return Cash_Flow;
            }
        }
        return null;
    }

    public static FSAStandardReportTypeEnum getEnumByEntityName(String entityName) {
        if (StringUtils.isEmpty((String)entityName)) {
            return null;
        }
        switch (entityName) {
            case "fsa_rptbalance": {
                return Balance_Sheet;
            }
            case "fsa_rptincomestat": {
                return Income_Statement;
            }
            case "fsa_rptcashflow": {
                return Cash_Flow;
            }
        }
        return null;
    }

    public FSAStandardReportTypeEnum parse(Byte code) {
        return FSAStandardReportTypeEnum.getEnum(code);
    }

    public static FSAStandardReportTypeEnum parseGLReportType(String reportTypeCode) {
        if (StringUtils.isNotEmpty((String)reportTypeCode)) {
            switch (reportTypeCode.toLowerCase(Locale.ENGLISH)) {
                case "gl_cashflowstat": 
                case "cashflow": {
                    return Cash_Flow;
                }
                case "gl_balancesheet": 
                case "balancesheet": {
                    return Balance_Sheet;
                }
                case "gl_showincome": 
                case "income": {
                    return Income_Statement;
                }
            }
        }
        return null;
    }

    public String getFactEntityName() {
        return this.factEntityName;
    }

    public static FSAStandardReportTypeEnum getEnum(String code) {
        if (code == null) {
            return null;
        }
        return FSAStandardReportTypeEnum.getEnum(Byte.valueOf(code));
    }

    public String getEntity() {
        switch (this) {
            case Balance_Sheet: {
                return "fsa_rptbalance";
            }
            case Income_Statement: {
                return "fsa_rptincomestat";
            }
            case Cash_Flow: {
                return "fsa_rptcashflow";
            }
        }
        return "";
    }

    public String getGLReportTypeCode() {
        switch (this) {
            case Balance_Sheet: {
                return "balancesheet";
            }
            case Income_Statement: {
                return "income";
            }
            case Cash_Flow: {
                return "cashflow";
            }
        }
        return "";
    }

    public static String getEntity(String reportType) {
        FSAStandardReportTypeEnum type = FSAStandardReportTypeEnum.getEnum(reportType);
        return type != null ? type.getEntity() : null;
    }

    public static String getGLReportTypeCode(String reportType) {
        FSAStandardReportTypeEnum type = FSAStandardReportTypeEnum.getEnum(reportType);
        return type != null ? type.getGLReportTypeCode() : null;
    }
}

