/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.engine.task;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.OlapDataReader;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.data.disf.event.IWorkTaskStatusEvent;
import kd.data.disf.model.impl.ThreeValueTuple;
import kd.data.disf.task.IDataAbstractParallelWorkTaskGroup;
import kd.data.disf.task.IDataAbstractWorkTask;
import kd.data.disf.task.status.IDataSimpleWorkTaskStatisticStatus;
import kd.data.disf.task.status.IDataWorkTaskStatusMgr;
import kd.data.fsa.engine.task.status.FSAWorkTaskStatusConsumer;
import kd.data.fsa.olap.OlapSQLBuilder;
import kd.data.fsa.utils.KdOlapServerHelper;

public abstract class AbstractOlapDataQueryTask
extends IDataAbstractParallelWorkTaskGroup<Long, Callable<Long>, IDataSimpleWorkTaskStatisticStatus> {
    private static final Log logger = LogFactory.getLog(AbstractOlapDataQueryTask.class);
    protected boolean multipleSQLQuery;
    protected OlapSQLBuilder sqlBuilder;
    protected Iterator<OlapSQLBuilder> sqlBuilderIterator;
    protected Map<Integer, List<String>> selectDimensionMap;
    protected MainEntityType outputDynEntity;
    protected Map<String, String> originalDimNumberMap;
    protected Map<String, Object> manuallyAddFieldMap;

    protected AbstractOlapDataQueryTask(Serializable taskKey, Serializable version, OlapSQLBuilder sqlBuilder, Map<String, String> originalDimNumberMap, Map<String, Object> manuallyAddFieldMap) {
        super(taskKey, version);
        this.sqlBuilder = sqlBuilder;
        this.setSqlBuilder(this.sqlBuilder);
        this.originalDimNumberMap = originalDimNumberMap;
        this.manuallyAddFieldMap = manuallyAddFieldMap;
    }

    protected IDataWorkTaskStatusMgr getWorkTaskStatusMgr() {
        return FSAWorkTaskStatusConsumer.getInstance();
    }

    protected abstract long processOlapQueryReader(OlapSQLBuilder var1, SelectCommandInfo var2, OlapDataReader var3);

    protected void updateTaskStatistics(int fetchDataCnt, int processDataCnt, int skipErrorDataCnt) {
        IDataSimpleWorkTaskStatisticStatus workTaskStatusEvent = ((IDataSimpleWorkTaskStatisticStatus)this.getWorkTaskStatusEvent()).copy();
        workTaskStatusEvent.updateTaskStatistics(fetchDataCnt, processDataCnt, skipErrorDataCnt, this.totalStatisticsPoints);
        try {
            this.getWorkTaskStatusMgr().updateTaskStatus((IWorkTaskStatusEvent)workTaskStatusEvent);
        }
        catch (InterruptedException e) {
            throw new KDBizException((Throwable)e, new ErrorCode("\u66f4\u65b0\u53d6\u6570\u4efb\u52a1\u6761\u6570\u5931\u8d25", e.getMessage()), new Object[0]);
        }
    }

    protected Long doTaskJob() {
        if (logger.isInfoEnabled()) {
            logger.info(String.format("Start Do Task Job: multipleSQLQuery=%s, outputDynEntity=%s", this.multipleSQLQuery, this.outputDynEntity));
        }
        this.updateTaskStatistics(0, 0, 0);
        if (this.multipleSQLQuery) {
            this.taskResult = super.doTaskJob();
        } else {
            this.initializeTaskJob();
            Callable<Long> singleQueryWorkTask = this.createOlapQuerySubTask("OLAPInnerSingleQueryTask", this.sqlBuilder);
            this.executeSubTask(0, new ThreeValueTuple(singleQueryWorkTask, (Object)Boolean.FALSE, (Object)Boolean.FALSE));
        }
        if (logger.isInfoEnabled()) {
            logger.info(String.format("Complete Do Task Job on [%sms]: multipleSQLQuery=%s, outputDynEntity=%s, taskResult=%s", this.getTaskExecutionTime(), this.multipleSQLQuery, this.outputDynEntity, this.taskResult));
        }
        return (Long)this.taskResult;
    }

    protected Long processTaskResult(int taskIndex, Callable<Long> task, Object taskResult) {
        AbstractOlapDataQueryTask abstractOlapDataQueryTask = this;
        abstractOlapDataQueryTask.taskResult = (Long)abstractOlapDataQueryTask.taskResult + (taskResult != null ? (Long)taskResult : 0L);
        return abstractOlapDataQueryTask.taskResult;
    }

    protected void doTaskFinallyCleanUp(boolean isCancelled, boolean withError) {
        this.sqlBuilder.close();
    }

    protected Callable<Long> createOlapQuerySubTask(String taskTypeName, final OlapSQLBuilder currentSqlBuilder) {
        return new IDataAbstractWorkTask<Long>((Object)taskTypeName, this.subTaskExceptionListener){
            OlapSQLBuilder _subTaskSqlBuilder;
            {
                super(x0, x1);
                this._subTaskSqlBuilder = currentSqlBuilder;
            }

            protected Long doTaskJob() {
                if (this._subTaskSqlBuilder == null) {
                    return 0L;
                }
                return KdOlapServerHelper.queryDataToReader(this._subTaskSqlBuilder, AbstractOlapDataQueryTask.this.outputDynEntity, (selectCommandInfo, dataReader) -> AbstractOlapDataQueryTask.this.processOlapQueryReader(this._subTaskSqlBuilder, (SelectCommandInfo)selectCommandInfo, (OlapDataReader)dataReader));
            }
        };
    }

    public ThreeValueTuple<Callable<Long>, Boolean, Boolean> doGetNextSubTask() {
        OlapSQLBuilder curSqlBuilder = this.sqlBuilderIterator.next();
        if (curSqlBuilder == null) {
            return null;
        }
        return new ThreeValueTuple(this.createOlapQuerySubTask("OLAPInnerMultiQueryTask", curSqlBuilder), (Object)Boolean.FALSE, (Object)Boolean.TRUE);
    }

    public boolean hasSubTask() {
        return this.multipleSQLQuery && this.sqlBuilderIterator.hasNext() && !this.isCancelled();
    }

    public OlapSQLBuilder getSqlBuilder() {
        return this.sqlBuilder;
    }

    public final void setSqlBuilder(OlapSQLBuilder sqlBuilder) {
        if (sqlBuilder == null) {
            throw new KDBizException("OLAP\u6570\u636e\u67e5\u8be2\u6784\u5efa\u5668\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.selectDimensionMap = sqlBuilder.getSelectDimensionMap();
        this.multipleSQLQuery = sqlBuilder instanceof Iterator;
        if (this.multipleSQLQuery) {
            this.sqlBuilderIterator = (Iterator)((Object)sqlBuilder);
            this.multipleSQLQuery = this.sqlBuilderIterator.hasNext();
        } else {
            this.sqlBuilderIterator = null;
        }
    }
}

