/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.engine.task;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.data.disf.enums.FSADataTypeEnum;
import kd.data.disf.model.impl.IDataMapEntry;
import kd.data.disf.task.IDataAbstractWorkTask;
import kd.data.disf.task.IWorkTaskTransLog;
import kd.data.disf.utils.CustomizedDynamicFormBuilderUtil;
import kd.data.disf.utils.CustomizedFormBuilderInfo;
import kd.data.fsa.common.constant.FSACommonConstant;
import kd.data.fsa.common.enums.FSADimensionTypeEnum;
import kd.data.fsa.common.enums.FSASyncLogStatusEnum;
import kd.data.fsa.common.enums.FSAWorkTaskTypeEnum;
import kd.data.fsa.engine.task.FSAWorkTaskMeta;
import kd.data.fsa.utils.FSADataversionUtils;

public class FSADataEntityCreateDelTask
extends IDataAbstractWorkTask<Object> {
    private IWorkTaskTransLog transLog;

    public FSADataEntityCreateDelTask(IWorkTaskTransLog transLog) {
        super((Object)FSADataEntityCreateDelTask.class.getSimpleName());
        this.transLog = transLog;
    }

    public void run() {
        this.doTaskJob();
    }

    protected Object doTaskJob() {
        IDataMapEntry<FSASyncLogStatusEnum, String> iDataMapEntry = null;
        if (this.transLog == null) {
            return null;
        }
        FSAWorkTaskMeta meta = (FSAWorkTaskMeta)this.transLog;
        Long syncParamId = meta.getSyncParamId();
        int taskType = meta.getTaskType().getValue();
        switch (FSAWorkTaskTypeEnum.getEnum(taskType)) {
            case Create_Table_Task: {
                iDataMapEntry = this.createTable(syncParamId, meta.getTableNumber(), meta.getTableName());
                break;
            }
            case Drop_Table_Task: {
                iDataMapEntry = this.dropTable(meta.getSyncParamId(), meta.getTableNumber());
                break;
            }
        }
        return iDataMapEntry;
    }

    private IDataMapEntry<FSASyncLogStatusEnum, String> dropTable(Long snycParam, String tableNumber) {
        Set<Long> syncParams = Collections.singleton(snycParam);
        FSADataversionUtils.tombstoneWithParamId(syncParams);
        CustomizedDynamicFormBuilderUtil.deleteForm((String)FSACommonConstant.buildEntityName(tableNumber.toLowerCase()), (boolean)false);
        FSADataversionUtils.deleteWithParamId(syncParams);
        return new IDataMapEntry((Object)FSASyncLogStatusEnum.SUCCESS, (Object)"success");
    }

    private IDataMapEntry<FSASyncLogStatusEnum, String> createTable(Long syncParamId, String inputTableNumber, String inputTableName) {
        DynamicObject syncParamDyn = this.getDataSyncParam(syncParamId);
        if (syncParamDyn == null) {
            return new IDataMapEntry((Object)FSASyncLogStatusEnum.FAILURE, (Object)"failure");
        }
        String tableNumber = FSACommonConstant.buildEntityName(inputTableNumber.toLowerCase());
        CustomizedFormBuilderInfo builderInfo = CustomizedDynamicFormBuilderUtil.createCustomizedFormBuilderInfo((String)tableNumber, (String)inputTableName, (String)"1GYTR6VI+493", (String)"BillFormModel");
        builderInfo.addBigIntField("del", "\u5220\u9664\u6807\u8bb0", null);
        builderInfo.addBigIntField("version", "\u7248\u672c", null);
        builderInfo.addTextField("datasourcetype", "\u6570\u636e\u6765\u6e90", 1, "0");
        long dataCollectionId = syncParamDyn.getDynamicObject("datacollection").getLong("id");
        DynamicObject dataCollectionDyn = BusinessDataServiceHelper.loadSingle((Object)dataCollectionId, (String)"fsa_data_collection", (String)"id,number,name,superlongdata,dataentryentity,dataentryentity.dimtype,dataentryentity.dimnumber,dataentryentity.dimname,dataentryentity.fieldcreatetype,dataentryentity.dimdatatype,subentryentity,subentryentity.paramnumber,subentryentity.paramvalue");
        DynamicObjectCollection dataEntryCol = dataCollectionDyn.getDynamicObjectCollection("dataentryentity");
        boolean superLongData = dataCollectionDyn.getBoolean("superlongdata");
        for (DynamicObject dataEnt : dataEntryCol) {
            String fieldNumber = dataEnt.getString("dimnumber");
            if ("version".equalsIgnoreCase(fieldNumber) || "del".equals(fieldNumber) || "datasourcetype".equals(fieldNumber)) {
                return new IDataMapEntry((Object)FSASyncLogStatusEnum.FAILURE, (Object)"failure");
            }
            FSADimensionTypeEnum dimType = FSADimensionTypeEnum.getEnum(dataEnt.getString("dimtype"));
            String fieldName = dataEnt.getString("dimname");
            DynamicObjectCollection subCol = dataEnt.getDynamicObjectCollection("subentryentity");
            int length = 0;
            String columnDefaultValue = null;
            if (subCol != null && !subCol.isEmpty()) {
                for (DynamicObject sub : subCol) {
                    String paramNumber = sub.getString("paramnumber");
                    if (paramNumber.equals("length")) {
                        length = Integer.parseInt(sub.getString("paramvalue"));
                        continue;
                    }
                    if (!paramNumber.equals("DefaultValue")) continue;
                    columnDefaultValue = sub.getString("paramvalue");
                }
            }
            if (FSADimensionTypeEnum.MEASURE_DIM == dimType) {
                if (superLongData) {
                    builderInfo.addTextField(fieldNumber, fieldName, length > 0 ? length : 30, columnDefaultValue);
                    continue;
                }
                builderInfo.addDecimalField(fieldNumber, fieldName, columnDefaultValue);
                continue;
            }
            String dimDataType = dataEnt.getString("dimdatatype");
            if (FSADataTypeEnum.STRING_TYPE.getCodeString().equals(dimDataType)) {
                builderInfo.addTextField(fieldNumber, fieldName, length > 0 ? length : 50, columnDefaultValue);
                continue;
            }
            builderInfo.addBasicField(FSADataTypeEnum.getEnum((String)dimDataType), fieldNumber, fieldName, columnDefaultValue);
        }
        HashMap<String, String> tableIndexMap = new HashMap<String, String>(1);
        tableIndexMap.put("idx_" + tableNumber + "_ver", "fversion");
        builderInfo.setTableIndexMap(tableIndexMap);
        builderInfo.setDeveloper(true);
        CustomizedDynamicFormBuilderUtil.checkDesignerDataSaveResult((Map)CustomizedDynamicFormBuilderUtil.saveEntityMetaDataAndCreateTable((CustomizedFormBuilderInfo)builderInfo), (boolean)true);
        return new IDataMapEntry((Object)FSASyncLogStatusEnum.SUCCESS, (Object)"success");
    }

    private DynamicObject getDataSyncParam(Long syncParamId) {
        return BusinessDataServiceHelper.loadSingle((Object)syncParamId, (String)"fsa_syncparam", (String)"id,number,name,datacollection");
    }
}

