/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.engine.task;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.disf.enums.FSAStatusEnum;
import kd.data.disf.event.IWorkTaskStatusEvent;
import kd.data.disf.task.IDataAbstractWorkTask;
import kd.data.disf.task.IWorkTaskTransLog;
import kd.data.disf.task.TaskGroupCondition;
import kd.data.disf.task.status.IDataSimpleWorkTaskStatisticStatus;
import kd.data.disf.utils.IDataStringUtil;
import kd.data.fsa.engine.task.FSAHierarchyCompleteTask;
import kd.data.fsa.engine.task.FSAWorkTaskMeta;
import kd.data.fsa.engine.task.common.FSAbstractWorkTask;
import kd.data.fsa.utils.FSAJSONUtils;
import kd.data.fsa.utils.FSARptDataSyncTaskUtils;
import kd.data.fsa.utils.FSASyncTaskLogHelper;

public class FSADataSyncWorkTaskWrapper<T>
extends FSAbstractWorkTask<T> {
    private static final Log logger = LogFactory.getLog(FSADataSyncWorkTaskWrapper.class);
    protected IDataAbstractWorkTask<T> actualTaskJob;
    protected IWorkTaskTransLog<Long> taskMeta;
    protected boolean needRequestDLock;
    private DynamicObject taskTransLogDync;

    public FSADataSyncWorkTaskWrapper(IDataAbstractWorkTask<T> actualTaskJob, IWorkTaskTransLog<Long> taskMeta) {
        super(actualTaskJob.getTaskKey());
        this.actualTaskJob = actualTaskJob;
        this.taskMeta = taskMeta;
        this.needRequestDLock = taskMeta.isNeedRequestLock();
        this.taskGroupCondition = actualTaskJob.getTaskGroupCondition();
    }

    public String toString() {
        return "FSADataSyncWorkTaskWrapper [actualTaskJob=" + this.actualTaskJob + ", taskMeta=" + this.taskMeta + ", needRequestDLock=" + this.needRequestDLock + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateTaskStageCode(int newStageCode) {
        super.updateTaskStageCode(newStageCode);
        Long taskId = this.taskMeta instanceof FSAWorkTaskMeta ? ((FSAWorkTaskMeta)this.taskMeta).getTaskId() : 0L;
        if (this.taskGroupCondition != null) {
            TaskGroupCondition taskGroupCondition = this.taskGroupCondition;
            synchronized (taskGroupCondition) {
                switch (newStageCode) {
                    case 1: {
                        this.taskTransLogDync = this.addTaskTransLog(this.taskMeta);
                        break;
                    }
                    case 2: {
                        this.updateTaskTransLog((Long)this.taskMeta.getId(), taskId, FSAStatusEnum.PROCESSING, null);
                        break;
                    }
                    case -9: 
                    case 9: 
                    case 10: {
                        FSAStatusEnum taskStatus;
                        String logMessage;
                        IWorkTaskStatusEvent workTaskStatusEvent = this.getWorkTaskStatusMgr().getCachedWorkTaskStatusEvent((Object)this.taskKey);
                        if (workTaskStatusEvent == null) {
                            workTaskStatusEvent = FSARptDataSyncTaskUtils.getWorkTaskStatusEvent(taskId) == null ? new IDataSimpleWorkTaskStatisticStatus(this.taskKey, null, 0) : FSARptDataSyncTaskUtils.getWorkTaskStatusEvent(taskId);
                        }
                        workTaskStatusEvent.setNeedMergeStatus(false);
                        String errorMsg = null;
                        if (this.taskGroupCondition.isCancelMode()) {
                            logMessage = ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u88ab\u624b\u52a8\u7ec8\u6b62\u3002", (String)"IDataAbstractWorkGroupMainTask_0", (String)"data-fsa-core", (Object[])new Object[0]);
                            taskStatus = FSAStatusEnum.TERMINATE;
                        } else if (this.taskGroupCondition.isWithError()) {
                            StringBuilder errorMessage = new StringBuilder("traceId:").append(RequestContext.getOrCreate().getTraceId()).append(",detailMessage:");
                            if (StringUtils.isNotEmpty((String)this.actualTaskJob.getException().getMessage())) {
                                errorMessage.append(this.actualTaskJob.getException().getMessage());
                            } else {
                                errorMessage.append(IDataStringUtil.printStackTraceToString((Throwable)this.actualTaskJob.getException()));
                            }
                            errorMsg = errorMessage.toString();
                            logMessage = ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u5f02\u5e38\u3002", (String)"IDataAbstractWorkGroupMainTask_1", (String)"data-fsa-core", (Object[])new Object[0]);
                            taskStatus = FSAStatusEnum.FAILURE;
                        } else {
                            taskStatus = FSAStatusEnum.SUCCESS;
                            logMessage = ResManager.loadKDString((String)"\u4efb\u52a1\u6210\u529f\u6267\u884c\u3002", (String)"IDataAbstractWorkGroupMainTask_2", (String)"data-fsa-core", (Object[])new Object[0]);
                        }
                        if (this.actualTaskJob instanceof FSAHierarchyCompleteTask) {
                            this.updateTaskTransLog((Long)this.taskMeta.getId(), 0L, taskStatus, errorMsg);
                            break;
                        }
                        this.updateTaskTransLog((Long)this.taskMeta.getId(), taskId, taskStatus, errorMsg);
                        this.updateWorkTaskStatusEvent(workTaskStatusEvent, logMessage, this.taskGroupCondition.isWithError() || this.taskGroupCondition.isCancelMode(), Boolean.TRUE);
                        try {
                            this.saveIWorkTaskStatusEvent(taskId, workTaskStatusEvent);
                            this.getWorkTaskStatusMgr().updateTaskStatus(workTaskStatusEvent);
                        }
                        catch (InterruptedException e) {
                            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage() + "\u66f4\u65b0\u5de5\u4f5c\u4efb\u52a1\u7684\u72b6\u6001\u4fe1\u606f\u65f6\u51fa\u73b0\u5f02\u5e38"), new Object[0]);
                        }
                        FSASyncTaskLogHelper.calExecutionTime(taskId);
                        break;
                    }
                }
            }
        }
    }

    protected void updateWorkTaskStatusEvent(IWorkTaskStatusEvent workTaskStatusEvent, String message, boolean isError, boolean endTaskStatus) {
        if (workTaskStatusEvent != null) {
            if (message != null) {
                if (isError) {
                    workTaskStatusEvent.errorUpdateStatus(message);
                } else {
                    workTaskStatusEvent.updateStatusMessage(message);
                }
            }
            if (endTaskStatus) {
                workTaskStatusEvent.updateTaskEndStatus(true);
            }
        }
    }

    protected T doTaskJob() {
        return (T)this.actualTaskJob.call();
    }

    protected String getDLockKeyPrefix() {
        return "data/fsa";
    }

    protected String buildDLockKey(IWorkTaskTransLog<Long> taskMeta) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getDLockKeyPrefix());
        buf.append(taskMeta.getLockKey());
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DLock requestTransLogLock(IWorkTaskTransLog<Long> taskMeta) {
        if (!this.needRequestDLock) {
            return null;
        }
        String dlockKeyBuf = this.buildDLockKey(taskMeta);
        DLock dlock = null;
        boolean lockSuccess = false;
        try {
            dlock = DLock.createReentrant((String)dlockKeyBuf);
            lockSuccess = dlock.tryLock();
        }
        catch (Exception ex) {
            try {
                this.onException(ex);
            }
            catch (Throwable throwable) {
                if (logger.isInfoEnabled()) {
                    logger.info(String.format("requestTransLogLock Get Lock Result=%s, LockInfo=%s, FSAWorkTaskMeta=%s", lockSuccess, dlock, taskMeta));
                }
                if (dlock != null && !lockSuccess) {
                    dlock.close();
                }
                throw throwable;
            }
            if (logger.isInfoEnabled()) {
                logger.info(String.format("requestTransLogLock Get Lock Result=%s, LockInfo=%s, FSAWorkTaskMeta=%s", lockSuccess, dlock, taskMeta));
            }
            if (dlock != null && !lockSuccess) {
                dlock.close();
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info(String.format("requestTransLogLock Get Lock Result=%s, LockInfo=%s, FSAWorkTaskMeta=%s", lockSuccess, dlock, taskMeta));
        }
        if (dlock != null && !lockSuccess) {
            dlock.close();
        }
        return lockSuccess ? dlock : null;
    }

    protected void releaseLock(DLock dlock) {
        if (dlock == null) {
            return;
        }
        try {
            dlock.close();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    protected DynamicObject addTaskTransLog(IWorkTaskTransLog<Long> taskMeta) {
        return FSASyncTaskLogHelper.createSyncLog(taskMeta);
    }

    protected DynamicObject updateTaskTransLog(Long taskTransLogId, Long taskId, FSAStatusEnum stepExecuteStatus, String message) {
        if (this.taskTransLogDync == null) {
            this.taskTransLogDync = BusinessDataServiceHelper.loadSingle((Object)taskTransLogId, (String)"fsa_rptdata_synclog");
        }
        if (this.taskTransLogDync == null) {
            throw new KDBizException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u4efb\u52a1\u4e8b\u52a1\u65e5\u5fd7\u8bb0\u5f55\uff1ataskTransLogId=" + taskTransLogId);
        }
        this.taskTransLogDync.set("status", (Object)String.valueOf(stepExecuteStatus.getCode()));
        this.taskTransLogDync.set("msg_tag", (Object)message);
        this.taskTransLogDync.set("instance", (Object)Instance.getInstanceId());
        this.taskTransLogDync.set("taskoperatetoken", (Object)System.currentTimeMillis());
        this.taskTransLogDync.set("updatetime", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.taskTransLogDync});
        if (taskId > 0L) {
            FSASyncTaskLogHelper.updateTaskStatus(taskId, stepExecuteStatus.getCodeString());
        }
        return this.taskTransLogDync;
    }

    private void saveIWorkTaskStatusEvent(Long taskId, IWorkTaskStatusEvent workTaskStatusEvent) {
        FSARptDataSyncTaskUtils.updateRptDataSyncTaskInfo(taskId, FSAJSONUtils.toJSONString((Object)workTaskStatusEvent));
    }

    public IDataAbstractWorkTask<T> getActualTaskJob() {
        return this.actualTaskJob;
    }

    public void setActualTaskJob(IDataAbstractWorkTask<T> actualTaskJob) {
        this.actualTaskJob = actualTaskJob;
    }

    public boolean isNeedRequestDLock() {
        return this.needRequestDLock;
    }

    public void setNeedRequestDLock(boolean needRequestDLock) {
        this.needRequestDLock = needRequestDLock;
    }
}

