/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.engine.task;

import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import kd.data.disf.enums.FSAStatusEnum;
import kd.data.disf.task.IDataWorkTask;
import kd.data.disf.task.IDataWorkTaskManager;
import kd.data.disf.task.IFinallyTask;
import kd.data.disf.task.IWorkTaskTransLog;
import kd.data.fsa.common.constant.FSACommonConstant;
import kd.data.fsa.engine.task.FSADavaVersionCleanTask;
import kd.data.fsa.engine.task.FSAWorkTaskMeta;
import kd.data.fsa.engine.task.common.FSAbstractWorkTask;
import kd.data.fsa.model.sync.FSADataSyncTaskDimFilterModel;
import kd.data.fsa.model.sync.FSADataSyncTaskParamModel;
import kd.data.fsa.utils.FSADataversionUtils;

public class FSADataVersionInsertTask
extends FSAbstractWorkTask<Long>
implements IFinallyTask {
    FSAWorkTaskMeta meta;
    FSAStatusEnum status;

    protected FSADataVersionInsertTask(IWorkTaskTransLog<Long> taskTransLog, FSAStatusEnum status) {
        super((Serializable)((Object)FSADataVersionInsertTask.class.getSimpleName()));
        FSAWorkTaskMeta meta = (FSAWorkTaskMeta)taskTransLog;
        this.status = status;
        this.meta = meta;
    }

    protected Long doTaskJob() {
        Long version = this.meta.getVersion();
        switch (this.status) {
            case NEW: {
                this.newOpera();
                break;
            }
            case SUCCESS: {
                this.successOpera();
                break;
            }
            case FAILURE: {
                this.faiureOpera();
                break;
            }
        }
        return version;
    }

    private void newOpera() {
        FSADataSyncTaskParamModel taskParamModel = (FSADataSyncTaskParamModel)JSON.parseObject((String)this.meta.getParamDetail(), FSADataSyncTaskParamModel.class);
        List<FSADataSyncTaskDimFilterModel> dimFilterList = taskParamModel == null ? null : taskParamModel.getDimFilter();
        FSADataversionUtils.insertDb(this.meta.getVersion(), FSACommonConstant.buildEntityName(this.meta.getTableNumber()), "0", this.meta.getSyncParamId(), dimFilterList);
    }

    private void faiureOpera() {
        Long version = this.meta.getVersion();
        Long paramId = this.meta.getSyncParamId();
        FSADataversionUtils.setStatus(paramId, Collections.singletonList(version), FSAStatusEnum.DELETED);
        FSADavaVersionCleanTask fsaDavaVersionCleanTask = new FSADavaVersionCleanTask();
        IDataWorkTaskManager.getInstance().submit((IDataWorkTask)fsaDavaVersionCleanTask);
    }

    private void successOpera() {
        Long version = this.meta.getVersion();
        Long paramId = this.meta.getSyncParamId();
        FSADataversionUtils.setStatus(paramId, Collections.singletonList(version), FSAStatusEnum.ENABLE);
    }

    public FSAWorkTaskMeta getMeta() {
        return this.meta;
    }

    public void setMeta(FSAWorkTaskMeta meta) {
        this.meta = meta;
    }

    public void setRollBack(boolean rollBack) {
        this.status = FSAStatusEnum.FAILURE;
    }
}

