/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.engine.task;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.data.disf.enums.FSAStatusEnum;
import kd.data.disf.enums.WorkTaskExecutionStatusEnum;
import kd.data.disf.task.IDataAbstractStriveWorkTask;
import kd.data.disf.task.IWorkTaskSetpResult;
import kd.data.disf.task.IWorkTaskTransLog;
import kd.data.disf.task.SimpleWorkTaskStepResult;
import kd.data.disf.utils.IDataDBUtil;
import kd.data.fsa.model.gdt.FSADataVersionModel;
import kd.data.fsa.utils.FSADataversionUtils;

public class FSADavaVersionCleanTask
extends IDataAbstractStriveWorkTask {
    private FSADeleteDataVersionStrategy fsaDeleteDataVersionStrategy;

    public FSADavaVersionCleanTask(FSADeleteDataVersionStrategy fsaDeleteDataVersionStrategy, IWorkTaskTransLog log) {
        super((Object)FSADavaVersionCleanTask.class.getSimpleName(), log);
        this.fsaDeleteDataVersionStrategy = fsaDeleteDataVersionStrategy;
    }

    public FSADavaVersionCleanTask() {
        this(new DeleteStrategy(), null);
    }

    public FSADavaVersionCleanTask(IWorkTaskTransLog log) {
        this(new DeleteStrategy(), log);
    }

    protected List<Object> queryWaitingJobLogRecords(IWorkTaskTransLog previouseLog, int batchCnt) {
        List<FSADataVersionModel> load = FSADataversionUtils.load(FSAStatusEnum.DELETED, batchCnt);
        return load;
    }

    protected IWorkTaskTransLog convertToWorkTaskTransLog(Object srcObj) {
        return (FSADataVersionModel)((Object)srcObj);
    }

    protected IWorkTaskSetpResult processTaskStep(IWorkTaskTransLog taskTransLog) {
        FSADataVersionModel fsaDataVersionModel = (FSADataVersionModel)taskTransLog;
        int deleteCount = this.fsaDeleteDataVersionStrategy.cleanVersion(Collections.singletonList(fsaDataVersionModel));
        return new SimpleWorkTaskStepResult((Object)deleteCount, WorkTaskExecutionStatusEnum.SUCCESS);
    }

    protected void processTaskStepResult(IWorkTaskTransLog taskTransLog, IWorkTaskSetpResult taskStepResult, Throwable exception) {
    }

    protected IWorkTaskTransLog updateTaskTransLogStatus(IWorkTaskTransLog taskTransLog, WorkTaskExecutionStatusEnum resultStatus, String msg, Throwable exception) {
        return taskTransLog;
    }

    protected String getDLockKeyPrefix() {
        return null;
    }

    protected boolean requestTransLogLock(IWorkTaskTransLog transLog) {
        return true;
    }

    public void cleanVersion(List<FSADataVersionModel> fsaDataVersionModels) {
        this.fsaDeleteDataVersionStrategy.cleanVersion(fsaDataVersionModels);
    }

    public void cleanAllVersion(List<FSADataVersionModel> fsaDataVersionModels) {
        this.fsaDeleteDataVersionStrategy.cleanAllVersion(fsaDataVersionModels);
    }

    public static class DeleteStrategy
    implements FSADeleteDataVersionStrategy {
        @Override
        public int cleanAllVersion(List<FSADataVersionModel> fsaDataVersionModels) {
            HashSet<Long> params = new HashSet<Long>(1);
            HashSet entitys = new HashSet(1);
            fsaDataVersionModels.forEach(p -> {
                params.add(p.getRefParam());
                entitys.add(p.getEntityTypeName());
            });
            FSADataversionUtils.tombstoneWithParamId(params);
            entitys.forEach(tableEntity -> IDataDBUtil.deleteFromEntity((String)tableEntity, null));
            Set collect = entitys.stream().map(tableEntity -> QueryServiceHelper.exists((String)tableEntity, null)).collect(Collectors.toSet());
            boolean exists = collect.stream().filter(Boolean::booleanValue).count() > 0L;
            int deleteCount = 0;
            if (!exists) {
                deleteCount = FSADataversionUtils.deleteWithParamId(params);
            }
            return deleteCount;
        }

        @Override
        public int cleanVersion(List<FSADataVersionModel> fsaDataVersionModels) {
            Map<String, List<FSADataVersionModel>> groupByEntity = fsaDataVersionModels.stream().collect(Collectors.groupingBy(FSADataVersionModel::getTargetEntity));
            FSADataversionUtils.tombstoneWithVersion(fsaDataVersionModels);
            for (Map.Entry<String, List<FSADataVersionModel>> next : groupByEntity.entrySet()) {
                String entity = next.getKey();
                Set versions = next.getValue().stream().map(FSADataVersionModel::getVersion).collect(Collectors.toSet());
                IDataDBUtil.deleteFromEntity((String)entity, (QFilter[])new QFilter[]{new QFilter("version", "in", versions)});
            }
            Iterator<Map.Entry<String, List<FSADataVersionModel>>> checkExistIterator = groupByEntity.entrySet().iterator();
            HashSet<Boolean> existCollect = new HashSet<Boolean>(1);
            while (checkExistIterator.hasNext()) {
                Map.Entry<String, List<FSADataVersionModel>> next = checkExistIterator.next();
                String entity = next.getKey();
                Set versions = next.getValue().stream().map(FSADataVersionModel::getVersion).collect(Collectors.toSet());
                existCollect.add(QueryServiceHelper.exists((String)entity, (QFilter[])new QFilter[]{new QFilter("version", "in", versions)}));
            }
            boolean exists = existCollect.stream().filter(Boolean::booleanValue).count() > 0L;
            int deleteCount = 0;
            if (!exists) {
                deleteCount = FSADataversionUtils.deleteWithVersins(fsaDataVersionModels);
            }
            return deleteCount;
        }
    }

    public static class TombstoneStrategy
    implements FSADeleteDataVersionStrategy {
        @Override
        public int cleanAllVersion(List<FSADataVersionModel> fsaDataVersionModels) {
            return FSADataversionUtils.tombstoneWithParamId(fsaDataVersionModels.stream().map(FSADataVersionModel::getRefParam).collect(Collectors.toSet()));
        }

        @Override
        public int cleanVersion(List<FSADataVersionModel> fsaDataVersionModels) {
            return FSADataversionUtils.tombstoneWithVersion(fsaDataVersionModels);
        }
    }

    public static interface FSADeleteDataVersionStrategy {
        public int cleanAllVersion(List<FSADataVersionModel> var1);

        public int cleanVersion(List<FSADataVersionModel> var1);
    }

    public static enum FSADataVersionCleanTypeEnum {
        CLEAN_ALL_VERSION,
        CLEAN_VERSION;

    }
}

