/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.engine.task;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.data.BusinessDataReader;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.data.disf.cache.DistributeCache;
import kd.data.disf.cache.IDataCacheHelper;
import kd.data.disf.cache.IDataCacheModule;
import kd.data.disf.event.IWorkTaskStatusEvent;
import kd.data.disf.listener.IExceptionListener;
import kd.data.disf.task.IWorkTaskTransLog;
import kd.data.disf.task.TaskGroupCondition;
import kd.data.disf.task.status.IDataSimpleWorkTaskStatisticStatus;
import kd.data.disf.utils.IDataStorageDimKeyMgr;
import kd.data.disf.utils.IDataValueUtil;
import kd.data.disf.utils.Tuple;
import kd.data.fsa.cacheservice.FSADataCacheMgr;
import kd.data.fsa.common.constant.FSACommonConstant;
import kd.data.fsa.engine.task.FSAWorkTaskMeta;
import kd.data.fsa.engine.task.common.FSAbstractWorkTask;
import kd.data.fsa.model.HierarchyTreeIterator;
import kd.data.fsa.model.RowKeyMergeModel;
import kd.data.fsa.olap.OlapDimensionLookupMetaInfo;
import kd.data.fsa.utils.FSADataCollectionHelper;
import kd.data.fsa.utils.FSAJSONUtils;
import org.apache.commons.lang.StringUtils;

public class FSAHierarchyCompleteTask
extends FSAbstractWorkTask<Long> {
    private static Log logger = LogFactory.getLog(FSAHierarchyCompleteTask.class);
    private static final String CACHE_ID = "FSAHierarchyCompleteTask_CacheId.";
    private FSAWorkTaskMeta meta;
    private String entityType;
    private HierarchyTreeIterator hierarchyTreeIterator;
    private List<String> fieldNames;
    private int dimensionCount;
    private int measureCount;
    private Integer yearIndex;
    private Integer periodIndex;
    private String polishDimension;
    private String polishFieldNumber;
    private OlapDimensionLookupMetaInfo olapDimensionLookupMetaInfo;
    private IDataStorageDimKeyMgr<String> storageDimKeyMgr;
    private Map<String, String> rigidConditionDimMemMap;

    protected FSAHierarchyCompleteTask(Serializable taskKey, IWorkTaskTransLog<Long> transLog, IExceptionListener exceptionListener, TaskGroupCondition taskGroupCondition, boolean throwException) {
        super(taskKey, exceptionListener, taskGroupCondition);
        if (exceptionListener == null) {
            this.exceptionListener = ex -> this.onTaskError(ex);
        }
        this.rigidConditionDimMemMap = new HashMap<String, String>(10);
        this.throwException = throwException;
        this.meta = (FSAWorkTaskMeta)transLog;
        this.entityType = FSACommonConstant.buildEntityName(this.meta.getTableNumber());
        this.storageDimKeyMgr = new IDataStorageDimKeyMgr();
        this.polishDimension = StringUtils.isEmpty((String)this.meta.getPolishDimension()) ? "Entity" : this.meta.getPolishDimension();
        this.fieldNames = this.getMeasureField();
        this.hierarchyTreeIterator = new HierarchyTreeIterator(this.polishDimension);
        this.initOlapDimensionLookupInfo();
    }

    protected boolean onTaskError(Throwable exception) {
        this.exception = exception;
        return true;
    }

    private void initOlapDimensionLookupInfo() {
        HashMap<String, Object> param = new HashMap<String, Object>();
        DynamicObject syncParamDyn = BusinessDataReader.loadSingle((Object)this.meta.getSyncParamId(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fsa_syncparam"));
        Long dataCollectionPkId = syncParamDyn.getDynamicObject("datacollection").getLong("id");
        Map<String, Object> srcParam = FSADataCollectionHelper.getSrcParamFromCol(dataCollectionPkId);
        Long moduleId = srcParam == null ? null : IDataValueUtil.getLong((Object)srcParam.get("moduleId"));
        Long orgView = srcParam == null ? null : IDataValueUtil.getLong((Object)srcParam.get("OrgView"));
        param.put("moduleId", moduleId);
        param.put("organizationViewId", orgView);
        param.put("hierarchyDims", new String[]{this.polishDimension});
        this.olapDimensionLookupMetaInfo = FSADataCacheMgr.instance.getOlapDimensionLookupMetaInfo(param, new String[]{"Period"});
    }

    protected Long doTaskJob() {
        Map<String, Set<String>> hierarchyTree;
        Long saveCount = 0L;
        this.hierarchyTreeIterator.initTree(this.meta.getSyncParamId(), this.meta.getTransLogId());
        DistributeCache cache = IDataCacheHelper.getDistributeCache((IDataCacheModule)IDataCacheModule.FSA);
        RowKeyMergeModel rowKeyMergeModel = null;
        while ((hierarchyTree = this.hierarchyTreeIterator.hierarchyNext()) != null) {
            int i = hierarchyTree.size();
            if (rowKeyMergeModel != null) {
                String targetNumber = rowKeyMergeModel.getTargetNumber();
                saveCount = saveCount + this.traversalHierarchyTree(targetNumber, hierarchyTree.remove(targetNumber), rowKeyMergeModel);
                if (--i != 0) {
                    cache.put(this.buildDistributedCacheKeyId(rowKeyMergeModel.getTargetNumber()), (Object)FSAJSONUtils.toJsonString((Object)rowKeyMergeModel));
                }
            }
            for (Map.Entry<String, Set<String>> hierarchyInfo : hierarchyTree.entrySet()) {
                String targetNumber = hierarchyInfo.getKey();
                String cacheString = cache.get(this.buildDistributedCacheKeyId(targetNumber));
                rowKeyMergeModel = StringUtils.isEmpty((String)cacheString) ? new RowKeyMergeModel() : FSAJSONUtils.cast(cacheString, RowKeyMergeModel.class);
                saveCount = saveCount + this.traversalHierarchyTree(targetNumber, hierarchyInfo.getValue(), rowKeyMergeModel);
                --i;
                String parentId = rowKeyMergeModel.getTargetNumber();
                cacheString = cache.get(this.buildDistributedCacheKeyId(parentId));
                if (!StringUtils.isEmpty((String)cacheString)) {
                    Map<String, Tuple<BigDecimal[], Boolean>> rowKeyMergeMap = rowKeyMergeModel.getRowKeyMergeMap();
                    RowKeyMergeModel rowKeyMergeModelCache = FSAJSONUtils.cast(cacheString, RowKeyMergeModel.class);
                    for (Map.Entry<String, Tuple<BigDecimal[], Boolean>> rowKeyEntry : rowKeyMergeModelCache.getRowKeyMergeMap().entrySet()) {
                        Tuple<BigDecimal[], Boolean> tuple = rowKeyMergeMap.get(rowKeyEntry.getKey());
                        if (tuple != null) {
                            BigDecimal[] measure = (BigDecimal[])tuple.getK();
                            BigDecimal[] cacheMeasure = (BigDecimal[])rowKeyEntry.getValue().getK();
                            for (int j = 0; j < measure.length; ++j) {
                                if (measure[j] == null && cacheMeasure[j] != null) {
                                    measure[j] = cacheMeasure[j];
                                    continue;
                                }
                                if (cacheMeasure[j] == null) continue;
                                measure[j] = measure[j].add(cacheMeasure[j]);
                            }
                            continue;
                        }
                        rowKeyMergeMap.put(rowKeyEntry.getKey(), rowKeyEntry.getValue());
                    }
                }
                if (i == 0) continue;
                cache.put(this.buildDistributedCacheKeyId(parentId), (Object)FSAJSONUtils.toJsonString((Object)rowKeyMergeModel));
            }
        }
        IWorkTaskStatusEvent workTaskStatusEvent = this.getWorkTaskStatusMgr().getCachedWorkTaskStatusEvent((Object)this.taskKey);
        if (workTaskStatusEvent instanceof IDataSimpleWorkTaskStatisticStatus) {
            IDataSimpleWorkTaskStatisticStatus workTaskStatisticStatus = (IDataSimpleWorkTaskStatisticStatus)workTaskStatusEvent;
            workTaskStatisticStatus.getTaskProcRecStatistics()[4] = saveCount;
            try {
                workTaskStatisticStatus.setNeedMergeStatus(false);
                this.getWorkTaskStatusMgr().updateTaskStatus((IWorkTaskStatusEvent)workTaskStatisticStatus);
            }
            catch (InterruptedException e) {
                throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage() + "\u66f4\u65b0\u5de5\u4f5c\u4efb\u52a1\u7684\u72b6\u6001\u4fe1\u606f\u65f6\u51fa\u73b0\u5f02\u5e38"), new Object[0]);
            }
        }
        return saveCount;
    }

    private List<String> getMeasureField() {
        ArrayList<String> dimensionFields = new ArrayList<String>();
        ArrayList<String> measureFields = new ArrayList<String>();
        Long syncParamId = this.meta.getSyncParamId();
        DynamicObject syncDynObj = BusinessDataReader.loadSingle((Object)syncParamId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fsa_syncparam"));
        long dataCollectionId = syncDynObj.getDynamicObject("datacollection").getLong("id");
        DynamicObject dataCollectionDynObj = BusinessDataReader.loadSingle((Object)dataCollectionId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fsa_data_collection"));
        DynamicObjectCollection dataEntryEntity = dataCollectionDynObj.getDynamicObjectCollection("dataentryentity");
        for (DynamicObject dynamicObject : dataEntryEntity) {
            if ("1".equals(dynamicObject.getString("dimtype"))) {
                if (this.polishDimension.equals(dynamicObject.getString("srcnumber"))) {
                    this.polishFieldNumber = dynamicObject.getString("dimnumber");
                    continue;
                }
                dimensionFields.add(dynamicObject.getString("dimnumber"));
                if ("year".equalsIgnoreCase(dynamicObject.getString("srcnumber"))) {
                    this.yearIndex = dimensionFields.size();
                    continue;
                }
                if (!"period".equalsIgnoreCase(dynamicObject.getString("srcnumber"))) continue;
                this.periodIndex = dimensionFields.size();
                continue;
            }
            if (!"2".equals(dynamicObject.getString("dimtype"))) continue;
            measureFields.add(dynamicObject.getString("dimnumber"));
        }
        this.dimensionCount = dimensionFields.size() + 1;
        this.measureCount = measureFields.size();
        dimensionFields.addAll(measureFields);
        DynamicObjectCollection dimEntrys = syncDynObj.getDynamicObjectCollection("dimentry");
        for (DynamicObject dimEntry : dimEntrys) {
            String filterMode = dimEntry.getString("filtermode");
            if (!"3".equals(filterMode)) continue;
            String dimNumber = dimEntry.getString("olddimnumber");
            DynamicObjectCollection dimfilterEntrys = dimEntry.getDynamicObjectCollection("dimfilterentry");
            if (dimfilterEntrys == null) continue;
            DynamicObject dimFilter = (DynamicObject)dimfilterEntrys.get(0);
            this.rigidConditionDimMemMap.put(dimNumber, dimFilter.getString("membernumber"));
        }
        return dimensionFields;
    }

    private long traversalHierarchyTree(String parentId, Set<String> childNumbers, RowKeyMergeModel rowKeyMergeModel) {
        Long version;
        ArrayList<DynamicObject> dynamicObjectList;
        Map<String, Tuple<BigDecimal[], Boolean>> rowKeyMergeMap;
        String parentNumber;
        Set<String> shareMemberNumberSet;
        long saveCount;
        block36: {
            saveCount = 0L;
            shareMemberNumberSet = this.hierarchyTreeIterator.getShareMemberNumberSet();
            Tuple<String, String> parentTuple = this.hierarchyTreeIterator.matchParent(parentId);
            if (parentTuple == null) {
                return saveCount;
            }
            parentNumber = (String)parentTuple.getV();
            HashSet<String> fieldSet = new HashSet<String>(childNumbers.size() + 1);
            for (String childNumber : childNumbers) {
                String[] split = childNumber.split("!");
                fieldSet.add(split[split.length - 1]);
            }
            fieldSet.add(parentNumber);
            rowKeyMergeMap = rowKeyMergeModel.getRowKeyMergeMap();
            dynamicObjectList = new ArrayList<DynamicObject>(10);
            version = this.meta.getVersion();
            String selectFields = this.polishFieldNumber + ',' + StringUtils.join(this.fieldNames, (String)",");
            QFilter qFilter = new QFilter(this.polishFieldNumber, "in", fieldSet);
            qFilter.and(new QFilter("version", "=", (Object)version));
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)this.entityType, (String)selectFields, (QFilter[])qFilter.toArray(), null);){
                if (ds == null) break block36;
                while (ds.hasNext()) {
                    String period;
                    String year;
                    Object[][] dimGroupInfoBuf;
                    Row row = ds.next();
                    String polishMember = row.getString(0);
                    StringBuilder rowKeyValBuilder = new StringBuilder();
                    Boolean isParent = Boolean.FALSE;
                    if (parentNumber.equals(polishMember)) {
                        isParent = Boolean.TRUE;
                    } else if (shareMemberNumberSet.contains(polishMember) && ((dimGroupInfoBuf = this.validateEffectiveDate(year = this.yearIndex == null ? this.rigidConditionDimMemMap.get("Year") : row.getString(this.yearIndex.intValue()), period = this.periodIndex == null ? this.rigidConditionDimMemMap.get("Period") : row.getString(this.periodIndex.intValue()), polishMember)) == null || !parentId.equals(dimGroupInfoBuf[0][1]))) continue;
                    for (int i = 1; i < this.dimensionCount; ++i) {
                        Integer dimKeyInnerIndex = this.storageDimKeyMgr.getDimKeyInnerIndex(i - 1, (Object)row.getString(i), true);
                        rowKeyValBuilder.append(dimKeyInnerIndex).append(',');
                    }
                    String rowKeyValue = rowKeyValBuilder.toString();
                    Tuple valueTuple = rowKeyMergeMap.get(rowKeyValue);
                    int isNeedCreateTuple = valueTuple == null || isParent != false ? 0 : ((Boolean)valueTuple.getV() == false ? 1 : 2);
                    int i = this.dimensionCount;
                    int pos = 0;
                    while (i < this.dimensionCount + this.measureCount) {
                        block38: {
                            BigDecimal measure;
                            block37: {
                                try {
                                    String measureString;
                                    Object value = row.get(i);
                                    if (value instanceof BigDecimal) {
                                        measure = (BigDecimal)value;
                                        break block37;
                                    }
                                    if (value == null || !StringUtils.isNotEmpty((String)(measureString = value.toString()))) break block38;
                                    measure = new BigDecimal(measureString);
                                }
                                catch (AlgoException e) {
                                    if (!(e.getCause() instanceof NumberFormatException)) {
                                        throw new KDException(new ErrorCode("", String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u8868\u4e2d\u8bb0\u5f55\u65f6\u51fa\u9519\uff0c\u539f\u56e0\uff1a%s", (String)"FSAHierarchyCompleteTask_0", (String)"data-fsa-core", (Object[])new Object[0]), e.getMessage())), new Object[0]);
                                    }
                                    break block38;
                                }
                            }
                            switch (isNeedCreateTuple) {
                                case 0: {
                                    BigDecimal[] measureValues = new BigDecimal[this.measureCount];
                                    measureValues[pos] = measure;
                                    valueTuple = new Tuple((Object)measureValues, (Object)isParent);
                                    isNeedCreateTuple = 1;
                                    break;
                                }
                                case 1: {
                                    BigDecimal[] measureValues;
                                    if (valueTuple == null) {
                                        measureValues = new BigDecimal[this.measureCount];
                                        measureValues[pos] = measure;
                                        valueTuple = new Tuple((Object)measureValues, (Object)isParent);
                                    }
                                    BigDecimal bigDecimal = (measureValues = (BigDecimal[])valueTuple.getK())[pos] == null ? BigDecimal.ZERO : measureValues[pos];
                                    measureValues[pos] = measure.add(bigDecimal);
                                    break;
                                }
                            }
                        }
                        ++i;
                        ++pos;
                    }
                    rowKeyMergeMap.put(rowKeyValue, valueTuple);
                }
            }
            catch (Exception e) {
                throw new KDException(new ErrorCode("", String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u8868\u4e2d\u8bb0\u5f55\u65f6\u51fa\u9519\uff0c\u539f\u56e0\uff1a%s", (String)"FSAHierarchyCompleteTask_0", (String)"data-fsa-core", (Object[])new Object[0]), e.getMessage())), new Object[0]);
            }
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)FSACommonConstant.buildEntityName(this.meta.getTableNumber()));
        String year = null;
        String period = null;
        ArrayList<String> removeKeys = new ArrayList<String>(10);
        for (Map.Entry<String, Tuple<BigDecimal[], Boolean>> tupleEntry : rowKeyMergeMap.entrySet()) {
            String[] rowKeyValue;
            if (!((Boolean)tupleEntry.getValue().getV()).booleanValue()) {
                DynamicObject dynRow = new DynamicObject((DynamicObjectType)dataEntityType);
                dynRow.set(this.polishFieldNumber, (Object)parentNumber);
                dynRow.set("version", (Object)version);
                dynRow.set("datasourcetype", (Object)"0");
                dynRow.set("del", (Object)2);
                rowKeyValue = tupleEntry.getKey().split(",");
                for (int i = 0; i < rowKeyValue.length; ++i) {
                    String memberNumber = (String)this.storageDimKeyMgr.getDimMemberByIndex(i, Integer.parseInt(rowKeyValue[i]));
                    dynRow.set(this.fieldNames.get(i), (Object)memberNumber);
                }
                BigDecimal[] measureValues = (BigDecimal[])tupleEntry.getValue().getK();
                for (int i = 0; i < measureValues.length; ++i) {
                    dynRow.set(this.fieldNames.get(rowKeyValue.length + i), (Object)measureValues[i]);
                }
                dynamicObjectList.add(dynRow);
            } else {
                tupleEntry.getValue().setV((Object)Boolean.FALSE);
            }
            if (!shareMemberNumberSet.contains(parentNumber)) continue;
            String grandpaId = (String)this.hierarchyTreeIterator.matchParent(parentId).getK();
            rowKeyValue = tupleEntry.getKey().split(",");
            year = this.yearIndex == null ? this.rigidConditionDimMemMap.get("Year") : (String)this.storageDimKeyMgr.getDimMemberByIndex(this.yearIndex - 1, Integer.parseInt(rowKeyValue[this.yearIndex - 1]));
            Object[][] dimGroupInfoBuf = this.validateEffectiveDate(year, period = this.periodIndex == null ? this.rigidConditionDimMemMap.get("Period") : (String)this.storageDimKeyMgr.getDimMemberByIndex(this.periodIndex - 1, Integer.parseInt(rowKeyValue[this.periodIndex - 1])), parentNumber);
            if (dimGroupInfoBuf != null && grandpaId.equals(dimGroupInfoBuf[0][1])) continue;
            removeKeys.add(tupleEntry.getKey());
        }
        for (String removeKey : removeKeys) {
            rowKeyMergeMap.remove(removeKey);
        }
        saveCount = BusinessDataWriter.save((IDataEntityType)dataEntityType, (Object[])dynamicObjectList.toArray()).length;
        rowKeyMergeModel.setTargetNumber((String)this.hierarchyTreeIterator.matchParent(parentId).getK());
        return saveCount;
    }

    protected String buildDistributedCacheKeyId(String memberNumber) {
        StringBuilder buf = new StringBuilder();
        buf.append(CACHE_ID).append(memberNumber).append('_').append(this.meta.getTaskId());
        return buf.toString();
    }

    private Object[][] validateEffectiveDate(String year, String period, String dimMember) {
        Object[][] dimGroupInfoBuf = null;
        if (StringUtils.isEmpty((String)year) || StringUtils.isEmpty((String)period)) {
            return null;
        }
        Object[][] periodDimGroupInfo = this.olapDimensionLookupMetaInfo.convert(1, period, new Object[0]);
        if (periodDimGroupInfo != null) {
            StringBuilder dateStringBuilder = new StringBuilder();
            dateStringBuilder.append(year.substring(2));
            dateStringBuilder.append(periodDimGroupInfo[0][1]);
            dimGroupInfoBuf = this.olapDimensionLookupMetaInfo.convert(0, dimMember, Integer.parseInt(dateStringBuilder.toString()));
        }
        return dimGroupInfoBuf;
    }
}

