/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.engine.task;

import java.io.Serializable;
import java.util.Objects;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.data.disf.event.IWorkTaskStatusEvent;
import kd.data.disf.listener.IExceptionListener;
import kd.data.disf.task.IDataAbstractWorkTask;
import kd.data.disf.task.IWorkTaskTransLog;
import kd.data.disf.task.TaskGroupCondition;
import kd.data.disf.task.status.IDataSimpleWorkTaskStatisticStatus;
import kd.data.fsa.common.enums.FSAWorkTaskTypeEnum;
import kd.data.fsa.engine.task.AbstractOlapDataQueryTask;
import kd.data.fsa.engine.task.FSAWorkTaskFactory;
import kd.data.fsa.engine.task.common.FSAbstractWorkTask;

public class FSALazyOlapDataQueryWrapperTask
extends FSAbstractWorkTask<Long> {
    protected boolean initActualTask;
    protected IWorkTaskTransLog<Long> taskTransLog;

    public FSALazyOlapDataQueryWrapperTask(Serializable taskKey, Serializable version, IWorkTaskTransLog<Long> taskTransLog, IExceptionListener exceptionListener, TaskGroupCondition taskGroupCondition) {
        super(taskKey, exceptionListener, taskGroupCondition);
        this.version = version;
        this.initActualTask = false;
        this.taskTransLog = taskTransLog;
    }

    public FSALazyOlapDataQueryWrapperTask(Serializable taskKey, Serializable version, IWorkTaskTransLog<Long> taskTransLog) {
        super(taskKey);
        this.version = version;
        this.initActualTask = false;
        this.taskTransLog = taskTransLog;
    }

    protected Long doTaskJob() {
        IDataSimpleWorkTaskStatisticStatus workTaskStatusEvent = new IDataSimpleWorkTaskStatisticStatus(this.getTaskKey(), this.version, this.calcTaskTotalStatisticsPoints());
        try {
            this.getWorkTaskStatusMgr().updateTaskStatus((IWorkTaskStatusEvent)workTaskStatusEvent);
        }
        catch (InterruptedException e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
        IDataAbstractWorkTask syncDataTask = FSAWorkTaskFactory.createFSAWorkTask(FSAWorkTaskTypeEnum.BCM_OLAP_Data_Sync_Task.getValue(), this.taskTransLog, false);
        Objects.requireNonNull(syncDataTask);
        syncDataTask.setExceptionListener(this.exceptionListener);
        syncDataTask.setTaskGroupCondition(this.taskGroupCondition);
        ((AbstractOlapDataQueryTask)syncDataTask).getSqlBuilder().setParentTaskGroupCondition(this.taskGroupCondition);
        return (Long)syncDataTask.call();
    }
}

