/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.engine.task;

import java.math.BigDecimal;
import kd.bos.exception.KDBizException;
import kd.bos.olap.dataSources.OlapDataReader;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.data.disf.model.impl.IDataMapEntry;
import kd.data.disf.task.IDataAbstractWorkTask;
import kd.data.fsa.olap.FSAOlapDataStatisticsInfo;

public class FSAOlapDataStatisticsTask
extends IDataAbstractWorkTask<FSAOlapDataStatisticsInfo> {
    protected boolean ignoreMeasureNull;
    IDataMapEntry<String, Integer>[] primayDim;

    public FSAOlapDataStatisticsTask() {
        super((Object)FSAOlapDataStatisticsTask.class.getSimpleName());
    }

    public FSAOlapDataStatisticsTask(boolean ignoreMeasureNull, IDataMapEntry<String, Integer>[] primayDim) {
        super((Object)FSAOlapDataStatisticsTask.class.getSimpleName());
        this.ignoreMeasureNull = ignoreMeasureNull;
        this.primayDim = primayDim;
    }

    protected FSAOlapDataStatisticsTask(String taskKey) {
        super((Object)taskKey);
    }

    public FSAOlapDataStatisticsInfo processOlapQueryReader(SelectCommandInfo selectCommandInfo, OlapDataReader dataReader) {
        FSAOlapDataStatisticsInfo olapDataStatisticsInfo = null;
        if (this.primayDim != null && this.primayDim.length == 1) {
            olapDataStatisticsInfo = new FSAOlapDataStatisticsInfo(this.primayDim[0]);
        } else if (this.primayDim != null && this.primayDim.length == 2) {
            olapDataStatisticsInfo = new FSAOlapDataStatisticsInfo(this.primayDim[0], this.primayDim[1]);
        } else {
            throw new KDBizException("Invalid Parameter on initialize FSAOlapDataStatisticsInfo");
        }
        Object[] measureValue = new Object[1];
        Object[] rowBuffer = new Object[dataReader.getFieldCount()];
        while (dataReader.next()) {
            dataReader.getValues(rowBuffer);
            olapDataStatisticsInfo.updateTotalCnt();
            if (!this.fetchMeasureValue(0, rowBuffer, measureValue)) {
                olapDataStatisticsInfo.updateSkipCnt();
            }
            olapDataStatisticsInfo.updateDimMemberCnt(rowBuffer);
        }
        olapDataStatisticsInfo.refreshStatistics();
        return olapDataStatisticsInfo;
    }

    protected boolean fetchMeasureValue(int fetchIndex, Object[] srcRowBuffer, Object[] measureValue) {
        measureValue[0] = srcRowBuffer[fetchIndex];
        if (measureValue[0] == null) {
            return !this.ignoreMeasureNull;
        }
        if (!(measureValue[0] instanceof Number)) {
            try {
                measureValue[0] = new BigDecimal(measureValue[0].toString());
            }
            catch (Exception ex) {
                return !this.ignoreMeasureNull;
            }
        }
        return true;
    }

    protected FSAOlapDataStatisticsInfo doTaskJob() {
        return null;
    }
}

