/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.engine.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.OlapDataReader;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.data.disf.algo.IColumnValueConverter;
import kd.data.fsa.common.constant.FSASystemParameters;
import kd.data.fsa.engine.task.FSASimpleOlapDataSyncTask;
import kd.data.fsa.engine.transformer.ColumnValueWritePosTransformer;
import kd.data.fsa.olap.OlapSQLBuilder;

public class FSAOlapDataSyncTask
extends FSASimpleOlapDataSyncTask {
    private static final Log logger = LogFactory.getLog(FSAOlapDataSyncTask.class);
    private IColumnValueConverter<Object[], IDataEntityProperty> columnWritePosLookupService;
    private Map<List<String>, String> transformFieldIndexMap;

    public FSAOlapDataSyncTask(long taskId, Long version, OlapSQLBuilder sqlBuilder, String outputTargetEntityName, IColumnValueConverter<Object[], IDataEntityProperty> columnWritePosLookupService, Map<String, String> originalDimNumberMap, boolean allowDimNull, boolean ignoreDimNull, boolean autoCompleteint, int totalStatisticsPoints, boolean superLongData, Map<String, Object> manuallyAddFieldMap) {
        super(taskId, version, sqlBuilder, outputTargetEntityName, originalDimNumberMap, allowDimNull, ignoreDimNull, autoCompleteint, null, totalStatisticsPoints, superLongData, manuallyAddFieldMap);
        this.columnWritePosLookupService = columnWritePosLookupService;
    }

    public FSAOlapDataSyncTask(long taskId, Long version, OlapSQLBuilder sqlBuilder, String outputTargetEntityName, Map<List<String>, String> transformFieldIndexMap, Map<String, String> originalDimNumberMap, boolean allowDimNull, boolean ignoreDimNull, boolean autoComplete, int totalStatisticsPoints, boolean superLongData, Map<String, Object> manuallyAddFieldMap) {
        super(taskId, version, sqlBuilder, outputTargetEntityName, originalDimNumberMap, allowDimNull, ignoreDimNull, autoComplete, null, totalStatisticsPoints, superLongData, manuallyAddFieldMap);
        this.transformFieldIndexMap = transformFieldIndexMap;
    }

    @Override
    protected void initializeTaskJob() {
        super.initializeTaskJob();
        if (this.columnWritePosLookupService == null) {
            List<Integer> srcFieldValueReadIndexs;
            logger.info("columnWritePosLookupService is null, need to create: transformFieldIndexMap=" + this.transformFieldIndexMap);
            if (this.measureTypeFieldReadIndex == null) {
                srcFieldValueReadIndexs = Collections.emptyList();
            } else {
                srcFieldValueReadIndexs = new ArrayList(this.measureTypeFieldReadIndex.length);
                for (Object idx : (Object)this.measureTypeFieldReadIndex) {
                    srcFieldValueReadIndexs.add((int)idx);
                }
            }
            this.columnWritePosLookupService = ColumnValueWritePosTransformer.buildMulToSingleFieldTransformer(this.getOutputTargetEntityName(), srcFieldValueReadIndexs, this.transformFieldIndexMap);
        }
        if (this.autoComplete.booleanValue()) {
            this.needTransformFieldProp = new IDataEntityProperty[this.transformFieldIndexMap.size()];
            int i = 0;
            for (String transformField : this.transformFieldIndexMap.values()) {
                this.needTransformFieldProp[i++] = this.outputDynEntity.getProperty(transformField);
            }
        }
    }

    @Override
    protected long processOlapQueryReader(OlapSQLBuilder olapSQLBuilder, SelectCommandInfo selectCommandInfo, OlapDataReader dataReader) {
        Object[] measureValue = new Object[1];
        olapSQLBuilder.clean();
        selectCommandInfo.getDimensions().clear();
        selectCommandInfo.getFilter().clear();
        selectCommandInfo.getMeasures().clear();
        int batchSize = FSASystemParameters.getTaskDBWriteBatchSize() * this.transformFieldIndexMap.size();
        HashMap<String, Integer> writeDataIndex = new HashMap<String, Integer>(olapSQLBuilder.getDimCombCnt());
        DynamicObject[] writeDataBuffer = new DynamicObject[olapSQLBuilder.getDimCombCnt()];
        Object[] rowBuffer = new Object[dataReader.getFieldCount()];
        int fetchCnt = 0;
        int skipCnt = 0;
        int lastBufferWriteIndex = -1;
        boolean active = true;
        long totalFetchCnt = 0L;
        while (active && dataReader.next()) {
            dataReader.getValues(rowBuffer);
            ++fetchCnt;
            if (!this.fetchMeasureValue(0, rowBuffer, measureValue)) {
                ++skipCnt;
                continue;
            }
            int currentWriteIndex = this.processRowKeyValues(rowBuffer, writeDataIndex, writeDataBuffer, lastBufferWriteIndex + 1);
            if (currentWriteIndex > lastBufferWriteIndex) {
                lastBufferWriteIndex = currentWriteIndex;
            }
            if (measureValue[0] != null) {
                this.processMeasureValues(measureValue, rowBuffer, writeDataBuffer[currentWriteIndex]);
            }
            if (fetchCnt < batchSize) continue;
            this.updateTaskStatistics(fetchCnt, 0, skipCnt);
            totalFetchCnt += (long)fetchCnt;
            fetchCnt = 0;
            skipCnt = 0;
            active = !this.isCancelled();
        }
        writeDataIndex.clear();
        this.saveBufferRecords(fetchCnt, skipCnt, Arrays.copyOf(writeDataBuffer, lastBufferWriteIndex + 1));
        writeDataBuffer = null;
        return totalFetchCnt += (long)fetchCnt;
    }

    @Override
    protected void processMeasureValues(Object measureValue, Object[] srcRowBuffer, DynamicObject outputTarget) {
        IDataEntityProperty valueProp = (IDataEntityProperty)this.columnWritePosLookupService.defaultConvert((Object)srcRowBuffer, new Object[0]);
        if (valueProp != null) {
            valueProp.setValueFast((Object)outputTarget, measureValue);
        } else {
            logger.error(String.format("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5ea6\u91cf\u5b57\u6bb5\u5c5e\u6027: measureValue=%s, srcRowBuffer=%s", measureValue, Arrays.deepToString(srcRowBuffer)));
        }
        if (this.manuallyAddFieldMap != null) {
            for (Map.Entry manuallyAddField : this.manuallyAddFieldMap.entrySet()) {
                outputTarget.set(((String)manuallyAddField.getKey()).toLowerCase(), manuallyAddField.getValue());
            }
        }
    }

    protected int processRowKeyValues(Object[] rowBuffer, Map<String, Integer> writeDataIndex, DynamicObject[] writeDataBuffer, int lastBufferWriteIndex) {
        String rowKey = this.buildRowKey(rowBuffer, this.dimReadIndex).toString();
        Integer dynIndex = null;
        DynamicObject dynRow = null;
        dynIndex = writeDataIndex.get(rowKey);
        if (dynIndex == null) {
            dynRow = new DynamicObject((DynamicObjectType)this.outputDynEntity);
            if (!this.autoComplete.booleanValue()) {
                this.dataVersionProp.setValueFast((Object)dynRow, (Object)this.version);
            }
            this.dataSrcTypeProp.setValueFast((Object)dynRow, (Object)"0");
            int i = 0;
            for (int dimIndex : this.dimReadIndex) {
                this.outputDimDynProps[i++].setValueFast((Object)dynRow, rowBuffer[dimIndex]);
            }
            dynIndex = lastBufferWriteIndex;
            writeDataBuffer[dynIndex.intValue()] = dynRow;
            writeDataIndex.put(rowKey, dynIndex);
        }
        return dynIndex;
    }

    public IColumnValueConverter<Object[], IDataEntityProperty> getColumnWritePosLookupService() {
        return this.columnWritePosLookupService;
    }

    public void setColumnWritePosLookupService(IColumnValueConverter<Object[], IDataEntityProperty> columnWritePosLookupService) {
        this.columnWritePosLookupService = columnWritePosLookupService;
    }

    public Map<List<String>, String> getTransformFieldIndexMap() {
        return this.transformFieldIndexMap;
    }

    public void setTransformFieldIndexMap(Map<List<String>, String> transformFieldIndexMap) {
        this.transformFieldIndexMap = transformFieldIndexMap;
    }
}

