/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.engine.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.data.disf.engine.IBuilder;
import kd.data.disf.iterators.impl.IntArraySequenceIterator;
import kd.data.disf.iterators.impl.IntArraySequenceIteratorBuilder;
import kd.data.disf.task.IDataWorkTaskManager;
import kd.data.disf.utils.IDataValueUtil;
import kd.data.fsa.cacheservice.FSADataCacheMgr;
import kd.data.fsa.common.enums.FSASelectTypeEnum;
import kd.data.fsa.engine.task.AbstractOlapDataQueryTask;
import kd.data.fsa.engine.task.FSAOlapDataSyncTask;
import kd.data.fsa.engine.task.FSASimpleOlapDataSyncTask;
import kd.data.fsa.engine.task.status.FSAWorkTaskStatusConsumer;
import kd.data.fsa.model.FSAConfigModel;
import kd.data.fsa.olap.FSAOlapDataStatisticsInfo;
import kd.data.fsa.olap.OlapMultipleSQLBuilder;
import kd.data.fsa.olap.OlapMultipleSplitSQLBuilder;
import kd.data.fsa.olap.OlapSQLBuilder;
import kd.data.fsa.utils.KdOlapServerHelper;

public class FSAOlapDataSyncTaskBuilder
implements IBuilder<AbstractOlapDataQueryTask> {
    public static final String KEY_DATA_COLLECTION_PKID = "dataCollectionPkId";
    public static final String KEY_SYNCPARAM_PKID = "syncParamPkId";
    public static final String KEY_CUSTOMRPT_ENTITY = "customrptentity";
    public static final String KEY_MODELNUMBER = "modelNumber";
    public static final String KEY_USEPARALLELSUBTASK = "useParallelSubTask";
    public static final String KEY_VERSION = "version";
    public static final String KEY_TEMPLATEID = "templateid";
    private Map<String, Set<String>> dimensionFilters;
    private Map<String, List<String>> transformFieldIndexMap;
    private String outputTargetEntityName;
    private Map<Integer, List<String>> selectDimensions;
    private Map<String, String> originalDimNumberMap;
    private boolean needTransformField = true;
    private boolean superLongData;
    private boolean autoComplete;
    private LinkedList<String> splitDimNames;
    private int recordCnt;
    private Map<String, Set<String>> splitDimMemberMap = new HashMap<String, Set<String>>(20);
    private Map<String, Object> manuallyAddFieldMap;

    public FSAOlapDataSyncTaskBuilder() {
        this.dimensionFilters = new HashMap<String, Set<String>>(20);
        this.splitDimNames = new LinkedList();
    }

    public FSAOlapDataSyncTaskBuilder(String outputTargetEntityName) {
        this();
        this.outputTargetEntityName = outputTargetEntityName;
    }

    protected IntArraySequenceIterator buildDimGroupIterator(Map<String, Set<String>> fixDimFilterMap, Set<String> changeDimNames) {
        IntArraySequenceIteratorBuilder arraySeqIterbuilder = new IntArraySequenceIteratorBuilder();
        List<String> measureDimensions = this.selectDimensions.get(FSASelectTypeEnum.TRANS_TYPE.getIntCode());
        for (Map.Entry<String, Set<String>> en : this.dimensionFilters.entrySet()) {
            if (en.getValue().isEmpty()) continue;
            if (en.getValue().size() > 1 && !measureDimensions.contains(en.getKey())) {
                changeDimNames.add(en.getKey());
                arraySeqIterbuilder.addArrayValue((Object[])en.getValue().toArray(new String[0]));
                continue;
            }
            fixDimFilterMap.put(en.getKey(), en.getValue());
        }
        IntArraySequenceIterator fieldsIterator = arraySeqIterbuilder.build();
        return fieldsIterator != null ? fieldsIterator : IntArraySequenceIteratorBuilder.EMPTY_Iterator;
    }

    protected OlapSQLBuilder buildOlapSQLBuilder(IntArraySequenceIterator fieldsIterator, Map<String, Set<String>> fixDimFilterMap, Set<String> changeDimNames, String modelNumber) {
        OlapSQLBuilder sqlBuilder = fieldsIterator == null || !fieldsIterator.hasNext() ? new OlapSQLBuilder(modelNumber) : new OlapMultipleSQLBuilder(modelNumber, fieldsIterator, (rowKey, olapMultipleSQLBuilder) -> {
            if (!changeDimNames.isEmpty()) {
                int dimIdx = 0;
                for (String changeDimName : changeDimNames) {
                    if (changeDimName != null) {
                        olapMultipleSQLBuilder.addChangedDimFilter(changeDimName, rowKey[dimIdx]);
                    }
                    ++dimIdx;
                }
            }
        });
        sqlBuilder.batchAddSelectDimensions(this.selectDimensions);
        for (Map.Entry<String, Set<String>> en : fixDimFilterMap.entrySet()) {
            sqlBuilder.addDimFilter(en.getKey(), en.getValue().toArray(new String[0]));
        }
        return sqlBuilder;
    }

    protected OlapSQLBuilder buildOlapSplitSQLBuilder(String cubeNumber, boolean ignoreMeasureNull, Long taskId) {
        FSAConfigModel fsaConfigModel;
        int limitCount = this.getTransformFieldIndexMap().size() == 1 ? ((fsaConfigModel = FSADataCacheMgr.instance.getFSAConfigModel("single_measure_limitCount")) != null ? Integer.parseInt(fsaConfigModel.getValue()) : 50000) : ((fsaConfigModel = FSADataCacheMgr.instance.getFSAConfigModel("multi_measure_limitCount")) != null ? Integer.parseInt(fsaConfigModel.getValue()) : 5000);
        HashSet measureDimensions = new HashSet(this.selectDimensions.get(FSASelectTypeEnum.TRANS_TYPE.getIntCode()));
        ArrayList<String> oneFilterDimNames = new ArrayList<String>(10);
        for (Map.Entry<String, Set<String>> en : this.dimensionFilters.entrySet()) {
            if (measureDimensions.contains(en.getKey()) || en.getValue() == null) continue;
            if (en.getValue().size() == 1) {
                oneFilterDimNames.add(en.getKey());
                continue;
            }
            if (en.getValue().size() <= 1) continue;
            this.splitDimNames.add(en.getKey());
        }
        this.splitDimNames.addAll(oneFilterDimNames);
        FSAWorkTaskStatusConsumer statusConsumer = FSAWorkTaskStatusConsumer.getInstance();
        LinkedList<Future> validateDimMemTasks = new LinkedList<Future>();
        this.splitDimMemberMap.putAll(this.dimensionFilters);
        AtomicInteger validateDimMemTaskCnt = new AtomicInteger(0);
        for (Map.Entry<String, Set<String>> dimMemberEntry : this.splitDimMemberMap.entrySet()) {
            String verifyDimNumber = dimMemberEntry.getKey();
            validateDimMemTasks.add(IDataWorkTaskManager.getInstance().submit(() -> {
                int taskCnt = validateDimMemTaskCnt.incrementAndGet();
                statusConsumer.updateCachedWorkTaskStatusEvent(taskId, String.format("\u542f\u52a8\u6210\u5458\u7684\u6709\u6548\u6027\u6821\u9a8c\u4e2d: [\u9a8c\u8bc1\u4efb\u52a1\u6570:%s: \u5df2\u5b8c\u6210\u9a8c\u8bc1\u6570:%s]", taskCnt, 0));
                Set<String> validDimMemberSet = KdOlapServerHelper.getValidDimMemberSet(cubeNumber, verifyDimNumber, ((Set)dimMemberEntry.getValue()).toArray(new String[0]));
                HashMap<String, Set<String>> resultMap = new HashMap<String, Set<String>>(1);
                resultMap.put(verifyDimNumber, validDimMemberSet);
                return resultMap;
            }, true));
        }
        HashMap<String, Set<String>> fullDimFilterMap = new HashMap<String, Set<String>>(this.splitDimMemberMap.size());
        int i = 0;
        StringBuilder invalidDimensions = new StringBuilder();
        for (Future f : validateDimMemTasks) {
            try {
                Map dimFilters = (Map)f.get();
                Map.Entry dimFilterEntry = dimFilters.entrySet().iterator().next();
                if (((Set)dimFilterEntry.getValue()).isEmpty()) {
                    invalidDimensions.append((String)dimFilterEntry.getKey()).append(", ");
                    continue;
                }
                fullDimFilterMap.putAll(dimFilters);
                statusConsumer.updateCachedWorkTaskStatusEvent(taskId, String.format("\u7b49\u5f85\u6210\u5458\u7684\u6709\u6548\u6027\u6821\u9a8c\u5b8c\u6210: [\u9a8c\u8bc1\u4efb\u52a1\u6570:%s: \u5df2\u5b8c\u6210\u9a8c\u8bc1\u6570:%s]", validateDimMemTaskCnt.get(), i++));
            }
            catch (Exception e) {
                throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
            }
        }
        if (!invalidDimensions.toString().isEmpty()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s \u7ef4\u5ea6\u6240\u9009\u62e9\u7684\u6210\u5458\u5747\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"FSAOlapDataSyncTaskBuilderCacheService_0", (String)"data-fsa-core", (Object[])new Object[0]), invalidDimensions.substring(0, invalidDimensions.length() - 2)));
        }
        FSAOlapDataStatisticsInfo olapDataStatisticsInfo = KdOlapServerHelper.queryDimMemComboStatistics(cubeNumber, this.splitDimNames.getFirst(), null, fullDimFilterMap, ignoreMeasureNull, this.superLongData);
        OlapMultipleSplitSQLBuilder sqlBuilder = new OlapMultipleSplitSQLBuilder(cubeNumber, fullDimFilterMap, ignoreMeasureNull, olapDataStatisticsInfo, limitCount, this.splitDimNames, this.superLongData);
        sqlBuilder.batchAddSelectDimensions(this.selectDimensions);
        this.setRecordCnt((int)olapDataStatisticsInfo.getTotalRecCnt());
        sqlBuilder.startSplitTask();
        return sqlBuilder;
    }

    public AbstractOlapDataQueryTask build(Map<String, Object> param, Object ... objects) {
        String modelNumber = IDataValueUtil.getString((Object)param.get(KEY_MODELNUMBER));
        if (StringUtils.isEmpty((String)modelNumber)) {
            throw new KDBizException("\u9700\u8981\u4f20\u5165\u76ee\u6807OLAP\u7684\u5206\u7ec4\u540d\u79f0\u3002");
        }
        Long version = IDataValueUtil.getLong((Object)param.get(KEY_VERSION));
        if (version == null) {
            throw new KDBizException("\u9700\u8981\u4f20\u5165\u76ee\u6807OLAP\u7684\u7248\u672c\u53f7\u3002");
        }
        if (this.dimensionFilters == null || this.dimensionFilters.isEmpty()) {
            throw new KDBizException("\u7ef4\u5ea6\u8fc7\u6ee4\u6761\u4ef6\u4e0d\u80fd\u5168\u90e8\u4e3a\u7a7a\uff01");
        }
        if (this.needTransformField && (this.transformFieldIndexMap == null || this.transformFieldIndexMap.isEmpty())) {
            throw new KDBizException("\u9700\u8981\u8fdb\u884c\u5217\u8f6c\u6362\u884c\uff0c\u5219\u7f3a\u5931\u8f6c\u6362\u7684\u6620\u5c04\u4fe1\u606f\uff01");
        }
        Long taskId = (Long)param.get("datasynctask");
        LinkedHashMap<List<String>, String> transformIndexMap = null;
        if (this.needTransformField) {
            transformIndexMap = new LinkedHashMap<List<String>, String>(this.transformFieldIndexMap.size());
            for (Map.Entry<String, List<String>> en : this.transformFieldIndexMap.entrySet()) {
                transformIndexMap.put(en.getValue(), en.getKey());
            }
        }
        Boolean allowDimNull = (Boolean)param.get("allowdimnull");
        Boolean ignoreMeasureNull = (Boolean)param.get("ignoredimnull");
        OlapSQLBuilder multipleSQLBuilder = this.buildOlapSplitSQLBuilder(modelNumber, ignoreMeasureNull, taskId);
        if (this.needTransformField && transformIndexMap != null && transformIndexMap.size() > 1) {
            return new FSAOlapDataSyncTask((long)taskId, version, multipleSQLBuilder, this.outputTargetEntityName, transformIndexMap, this.originalDimNumberMap, (boolean)allowDimNull, (boolean)ignoreMeasureNull, this.autoComplete, this.recordCnt, this.superLongData, this.manuallyAddFieldMap);
        }
        String dimMemberNumber = transformIndexMap == null ? "FMONEY" : transformIndexMap.values().toArray(new String[0])[0];
        return new FSASimpleOlapDataSyncTask(taskId, version, multipleSQLBuilder, this.outputTargetEntityName, this.originalDimNumberMap, allowDimNull, ignoreMeasureNull, this.autoComplete, dimMemberNumber, this.recordCnt, this.superLongData, this.manuallyAddFieldMap);
    }

    public boolean validateCacheParam() {
        if (this.dimensionFilters == null || this.dimensionFilters.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u8fc7\u6ee4\u6761\u4ef6\u4e0d\u80fd\u5168\u90e8\u4e3a\u7a7a\u3002", (String)"FSAOlapDataSyncTaskBuilderException_0", (String)"data-fsa-core", (Object[])new Object[0]));
        }
        if (this.needTransformField && (this.transformFieldIndexMap == null || this.transformFieldIndexMap.isEmpty())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9700\u8981\u8fdb\u884c\u5217\u8f6c\u6362\u884c\uff0c\u5219\u7f3a\u5931\u8f6c\u6362\u7684\u6620\u5c04\u4fe1\u606f\u3002", (String)"FSAOlapDataSyncTaskBuilderException_1", (String)"data-fsa-core", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)this.outputTargetEntityName)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u76ee\u6807\u8f93\u51fa\u7684\u5b9e\u4f53\u5bf9\u8c61\u540d\u79f0\u4e3a\u7a7a\u3002", (String)"FSAOlapDataSyncTaskBuilderException_2", (String)"data-fsa-core", (Object[])new Object[0]));
        }
        if (this.originalDimNumberMap == null || this.originalDimNumberMap.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u539f\u59cb\u7ef4\u5ea6\u7f16\u7801\u4e0e\u5b9e\u4f53\u7ef4\u5ea6\u7f16\u7801\u6620\u5c04\u4e3a\u7a7a\u3002", (String)"FSAOlapDataSyncTaskBuilderException_3", (String)"data-fsa-core", (Object[])new Object[0]));
        }
        return true;
    }

    public boolean addDimensionFilters(String dimNumber, String ... filterDimMemberNumbers) {
        if (dimNumber == null || filterDimMemberNumbers == null || filterDimMemberNumbers.length <= 0) {
            return false;
        }
        Set<String> filterSet = this.dimensionFilters.get(dimNumber);
        if (filterSet == null) {
            HashSet<String> dimFilter = new HashSet<String>();
            dimFilter.addAll(Arrays.asList(filterDimMemberNumbers));
            this.dimensionFilters.put(dimNumber, dimFilter);
        } else {
            filterSet.addAll(Arrays.asList(filterDimMemberNumbers));
        }
        return true;
    }

    public boolean addDimensionFilters(Map<String, Set<String>> dimFilters) {
        if (dimFilters == null || dimFilters.size() <= 0) {
            return false;
        }
        for (Map.Entry<String, Set<String>> filterSetEntry : dimFilters.entrySet()) {
            this.dimensionFilters.put(filterSetEntry.getKey(), filterSetEntry.getValue());
        }
        return true;
    }

    public boolean addSelectDimensions(Integer key, List<String> dimNumber) {
        if (dimNumber.isEmpty()) {
            return false;
        }
        if (this.selectDimensions == null) {
            this.selectDimensions = new HashMap<Integer, List<String>>(10);
        }
        this.selectDimensions.put(key, dimNumber);
        return true;
    }

    public boolean addSelectDimensions(Integer key, String ... dimNumbers) {
        if (key == null || dimNumbers == null || dimNumbers.length <= 0) {
            return false;
        }
        List<String> dimNumberList = this.selectDimensions.get(key);
        if (dimNumberList == null) {
            dimNumberList = new ArrayList<String>(10);
            dimNumberList.addAll(Arrays.asList(dimNumbers));
            this.selectDimensions.put(key, dimNumberList);
        } else {
            dimNumberList.addAll(Arrays.asList(dimNumbers));
        }
        return true;
    }

    public boolean addOriginalDimNumberMap(String originalNumber, String entityNumber) {
        if (StringUtils.isEmpty((String)originalNumber) || StringUtils.isEmpty((String)entityNumber)) {
            return false;
        }
        if (this.originalDimNumberMap == null) {
            this.originalDimNumberMap = new HashMap<String, String>(10);
        }
        this.originalDimNumberMap.putIfAbsent(originalNumber, entityNumber);
        return true;
    }

    public boolean addManuallyAddFieldMap(String dimensionNumber, Object defaultValue) {
        if (StringUtils.isEmpty((String)dimensionNumber) || defaultValue == null) {
            return false;
        }
        if (this.manuallyAddFieldMap == null) {
            this.manuallyAddFieldMap = new HashMap<String, Object>(10);
        }
        this.manuallyAddFieldMap.putIfAbsent(dimensionNumber, defaultValue);
        return true;
    }

    public void resetDimensionFilters(String ... dimNumbers) {
        if (dimNumbers == null || dimNumbers.length <= 0) {
            return;
        }
        for (String dimNumber : dimNumbers) {
            this.dimensionFilters.put(dimNumber, new HashSet(10));
        }
    }

    public void addTransformFieldMapping(String outputField, List<String> srcFields) {
        if (this.transformFieldIndexMap == null) {
            this.transformFieldIndexMap = new LinkedHashMap<String, List<String>>(10);
        }
        this.transformFieldIndexMap.put(outputField, srcFields);
    }

    public Map<String, List<String>> getTransformFieldIndexMap() {
        return this.transformFieldIndexMap;
    }

    public void setTransformFieldIndexMap(Map<String, List<String>> transformFieldIndexMap) {
        this.transformFieldIndexMap = transformFieldIndexMap;
    }

    public String getOutputTargetEntityName() {
        return this.outputTargetEntityName;
    }

    public void setOutputTargetEntityName(String outputTargetEntityName) {
        this.outputTargetEntityName = outputTargetEntityName;
    }

    public Map<String, Set<String>> getDimensionFilters() {
        return this.dimensionFilters;
    }

    public void setDimensionFilters(Map<String, Set<String>> dimensionFilters) {
        this.dimensionFilters = dimensionFilters;
    }

    public boolean isNeedTransformField() {
        return this.needTransformField;
    }

    public void setNeedTransformField(boolean needTransformField) {
        this.needTransformField = needTransformField;
    }

    public Map<String, String> getOriginalDimNumberMap() {
        return this.originalDimNumberMap;
    }

    public void setOriginalDimNumberMap(Map<String, String> originalDimNumberMap) {
        this.originalDimNumberMap = originalDimNumberMap;
    }

    public Map<Integer, List<String>> getSelectDimensions() {
        return this.selectDimensions;
    }

    public boolean isAutoComplete() {
        return this.autoComplete;
    }

    public void setAutoComplete(boolean autoComplete) {
        this.autoComplete = autoComplete;
    }

    public boolean isSuperLongData() {
        return this.superLongData;
    }

    public void setSuperLongData(boolean superLongData) {
        this.superLongData = superLongData;
    }

    public LinkedList<String> getSplitDimNames() {
        return this.splitDimNames;
    }

    public void setSplitDimNames(LinkedList<String> splitDimNames) {
        this.splitDimNames = splitDimNames;
    }

    public int getRecordCnt() {
        return this.recordCnt;
    }

    public void setRecordCnt(int recordCnt) {
        this.recordCnt = recordCnt;
    }

    public void setSplitDimMemberMap(Map<String, Set<String>> splitDimMemberMap) {
        this.splitDimMemberMap = splitDimMemberMap;
    }
}

