/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.engine.task;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.OlapDataReader;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.bos.util.StringUtils;
import kd.data.disf.iterators.impl.IntArraySequenceIterator;
import kd.data.disf.iterators.impl.IntArraySequenceIteratorBuilder;
import kd.data.disf.model.impl.ThreeValueTuple;
import kd.data.disf.stream.pipe.AsyncStreamPipe;
import kd.data.disf.utils.IDataValueUtil;
import kd.data.fsa.common.constant.FSASystemParameters;
import kd.data.fsa.common.enums.FSASelectTypeEnum;
import kd.data.fsa.engine.task.AbstractOlapDataQueryTask;
import kd.data.fsa.olap.OlapMultipleSQLBuilder;
import kd.data.fsa.olap.OlapSQLBuilder;

public class FSASimpleOlapDataSyncTask
extends AbstractOlapDataQueryTask {
    private static final Log logger = LogFactory.getLog(FSASimpleOlapDataSyncTask.class);
    protected int[] dimReadIndex;
    protected int dimRowKeyReadStartIndex;
    protected int[] measureTypeFieldReadIndex;
    protected IDataEntityProperty[] outputDimDynProps;
    protected IDataEntityProperty dataVersionProp;
    protected IDataEntityProperty dataSrcTypeProp;
    protected IDataEntityProperty measureValueProp;
    protected Boolean autoComplete;
    protected IDataEntityProperty[] needTransformFieldProp;
    protected boolean allowDimNull;
    protected boolean ignoreDimNull;
    protected String transformField;
    protected AsyncStreamPipe<ThreeValueTuple<Integer, Integer, Object[]>> outputTaskPipe;
    private boolean superLongData;
    static final int[] DimTypes = new int[]{FSASelectTypeEnum.FIX_ROWKEY_TYPE.getIntCode(), FSASelectTypeEnum.CHANGE_ROWKEY_TYPE.getIntCode()};

    public FSASimpleOlapDataSyncTask(long taskId, Long version, OlapSQLBuilder sqlBuilder, String outputTargetEntityName, Map<String, String> originalDimNumberMap, boolean allowDimNull, boolean ignoreDimNull, boolean autoComplete, String transformField, int totalStatisticsPoints, boolean superLongData, Map<String, Object> manuallyAddFieldMap) {
        super(Long.valueOf(taskId), version, sqlBuilder, originalDimNumberMap, manuallyAddFieldMap);
        this.autoComplete = autoComplete;
        this.allowDimNull = allowDimNull;
        this.ignoreDimNull = ignoreDimNull;
        this.version = version;
        this.transformField = transformField;
        this.superLongData = superLongData;
        this.taskResult = 0L;
        this.totalStatisticsPoints = totalStatisticsPoints;
        this.outputDynEntity = EntityMetadataCache.getDataEntityType((String)outputTargetEntityName);
    }

    public String toString() {
        return "FSASimpleOlapDataSyncTask [outputTargetEntityName=" + this.outputDynEntity.getName() + ", dimReadIndex=" + Arrays.toString(this.dimReadIndex) + ", measureTypeReadIndex=" + Arrays.toString(this.measureTypeFieldReadIndex) + ", outputDimDynProps=" + Arrays.toString(this.outputDimDynProps) + ", measureValueProp=" + this.measureValueProp + "]";
    }

    protected void initializeTaskJob() {
        LinkedList<DynamicProperty> dimPropList = new LinkedList<DynamicProperty>();
        LinkedList<Integer> dimReadIndexList = new LinkedList<Integer>();
        LinkedList<Integer> measureTypeReadIndexList = new LinkedList<Integer>();
        int i = 1;
        if (StringUtils.isNotEmpty((String)this.transformField)) {
            this.measureValueProp = this.outputDynEntity.getProperty(this.transformField);
        }
        List transTypeDImFields = (List)this.selectDimensionMap.get(FSASelectTypeEnum.TRANS_TYPE.getIntCode());
        for (int j = 0; j < transTypeDImFields.size(); ++j) {
            measureTypeReadIndexList.add(i);
            ++i;
        }
        for (int dimType : DimTypes) {
            for (String rowKeyTypeDimField : (List)this.selectDimensionMap.get(dimType)) {
                dimReadIndexList.add(i);
                dimPropList.add(this.outputDynEntity.getProperty((String)this.originalDimNumberMap.get(rowKeyTypeDimField)));
                ++i;
            }
        }
        this.dataVersionProp = this.outputDynEntity.getProperty("version");
        this.dataSrcTypeProp = this.outputDynEntity.getProperty("datasourcetype");
        this.outputDimDynProps = dimPropList.toArray(new IDataEntityProperty[0]);
        this.dimReadIndex = IDataValueUtil.convertIntListToArray(dimReadIndexList, (int)-1);
        this.dimRowKeyReadStartIndex = this.dimReadIndex[0];
        this.measureTypeFieldReadIndex = IDataValueUtil.convertIntListToArray(measureTypeReadIndexList, (int)-1);
        if (logger.isInfoEnabled()) {
            logger.info("initializeTaskJob: " + this.toString());
        }
    }

    protected boolean fetchMeasureValue(int fetchIndex, Object[] srcRowBuffer, Object[] measureValue) {
        measureValue[0] = srcRowBuffer[fetchIndex];
        if (measureValue[0] == null) {
            if (this.ignoreDimNull) {
                return false;
            }
            if (!this.allowDimNull) {
                measureValue[0] = 0L;
            }
        } else if (!(measureValue[0] instanceof Number)) {
            try {
                measureValue[0] = new BigDecimal(measureValue[0].toString());
            }
            catch (Exception ex) {
                if (this.ignoreDimNull) {
                    return false;
                }
                measureValue[0] = this.allowDimNull ? null : Long.valueOf(0L);
            }
        }
        return true;
    }

    protected int calcTaskTotalStatisticsPoints() {
        return this.totalStatisticsPoints;
    }

    protected Map<String, DynamicObject> createWriterBufferMap(OlapSQLBuilder olapSQLBuilder, SelectCommandInfo selectCommandInfo, boolean needAutoCompleted) {
        HashMap<String, Object> writeBufferMap;
        if (Boolean.TRUE.equals(needAutoCompleted)) {
            IntArraySequenceIteratorBuilder arraySeqIterbuilder = new IntArraySequenceIteratorBuilder();
            Map<String, Set<String>> dimFilters = olapSQLBuilder.getDimFilters();
            Map<String, Set<String>> changeDimFilters = null;
            if (olapSQLBuilder instanceof OlapMultipleSQLBuilder) {
                changeDimFilters = ((OlapMultipleSQLBuilder)olapSQLBuilder).getChangedDimFilters();
            }
            List transTypeDImFields = (List)this.selectDimensionMap.get(FSASelectTypeEnum.TRANS_TYPE.getIntCode());
            for (String dimension : selectCommandInfo.getDimensions()) {
                if (transTypeDImFields.contains(dimension)) continue;
                if (dimFilters.get(dimension) != null) {
                    arraySeqIterbuilder.addArrayValue((Object[])dimFilters.get(dimension).toArray(new String[0]));
                    continue;
                }
                if (changeDimFilters == null || changeDimFilters.get(dimension) == null) continue;
                arraySeqIterbuilder.addArrayValue((Object[])changeDimFilters.get(dimension).toArray(new String[0]));
            }
            IntArraySequenceIterator autoCompletedDimIter = arraySeqIterbuilder.build();
            writeBufferMap = new HashMap((int)autoCompletedDimIter.getTotalStepCnt());
            this.fillAutoCompletedDataMap(autoCompletedDimIter, writeBufferMap, this.allowDimNull ? null : Long.valueOf(0L));
        } else {
            writeBufferMap = new HashMap<String, DynamicObject>(FSASystemParameters.getTaskDBWriteBatchSize());
        }
        return writeBufferMap;
    }

    protected void fillAutoCompletedDataMap(IntArraySequenceIterator autoCompletedDimIter, Map<String, DynamicObject> writeBufferMap, Object defaultMeasureValue) {
        while (autoCompletedDimIter.hasNext()) {
            List rowKeyValueList = autoCompletedDimIter.next();
            StringBuilder rowKeyStr = new StringBuilder(20 * rowKeyValueList.size());
            for (Object rowKey : rowKeyValueList) {
                rowKeyStr.append(rowKey).append('|');
            }
            DynamicObject dynRowBuf = new DynamicObject((DynamicObjectType)this.outputDynEntity);
            writeBufferMap.put(rowKeyStr.toString(), dynRowBuf);
            this.dataVersionProp.setValueFast((Object)dynRowBuf, (Object)this.version);
            this.dataSrcTypeProp.setValueFast((Object)dynRowBuf, (Object)"0");
            for (int i = 0; i < this.dimReadIndex.length; ++i) {
                this.outputDimDynProps[i].setValueFast((Object)dynRowBuf, rowKeyValueList.get(i));
            }
            if (this.allowDimNull) continue;
            for (IDataEntityProperty iDataEntityProperty : this.needTransformFieldProp) {
                iDataEntityProperty.setValueFast((Object)dynRowBuf, defaultMeasureValue);
            }
        }
    }

    protected void saveBufferRecords(int fetchCnt, int skipCnt, Object[] srcDatas) {
        try {
            int writeCnt = BusinessDataWriter.save((IDataEntityType)this.outputDynEntity, (Object[])srcDatas).length;
            this.updateTaskStatistics(fetchCnt, writeCnt, skipCnt);
        }
        catch (Exception e) {
            this.onException(e);
        }
    }

    @Override
    protected long processOlapQueryReader(OlapSQLBuilder olapSQLBuilder, SelectCommandInfo selectCommandInfo, OlapDataReader dataReader) {
        Object[] measureValue = new Object[1];
        int batchSize = FSASystemParameters.getTaskDBWriteBatchSize();
        Object[] writeDataBuffer = new DynamicObject[batchSize];
        Object[] rowBuffer = new Object[dataReader.getFieldCount()];
        this.cleanExTraCache(olapSQLBuilder, selectCommandInfo);
        int fetchCnt = 0;
        int skipCnt = 0;
        int bufferCnt = 0;
        long totalFetchCnt = 0L;
        boolean active = true;
        while (active && dataReader.next()) {
            DynamicObject dynRow;
            dataReader.getValues(rowBuffer);
            ++fetchCnt;
            if (!this.fetchMeasureValue(0, rowBuffer, measureValue)) {
                ++skipCnt;
                continue;
            }
            writeDataBuffer[bufferCnt++] = dynRow = this.createNewDynamicObject(rowBuffer);
            if (measureValue[0] != null) {
                this.processMeasureValues(measureValue, rowBuffer, dynRow);
            }
            if (bufferCnt < batchSize) continue;
            if (!this.autoComplete.booleanValue()) {
                this.saveBufferRecords(fetchCnt, skipCnt, writeDataBuffer);
                totalFetchCnt += (long)fetchCnt;
                writeDataBuffer = new DynamicObject[FSASystemParameters.getTaskDBWriteBatchSize()];
            } else {
                this.updateTaskStatistics(fetchCnt, 0, skipCnt);
            }
            fetchCnt = 0;
            skipCnt = 0;
            bufferCnt = 0;
            active = !this.isCancelled();
        }
        if (bufferCnt > 0) {
            this.saveBufferRecords(fetchCnt, skipCnt, Arrays.copyOf(writeDataBuffer, bufferCnt));
            totalFetchCnt += (long)fetchCnt;
        } else {
            this.updateTaskStatistics(fetchCnt, 0, skipCnt);
        }
        return totalFetchCnt;
    }

    protected StringBuilder buildRowKey(Object[] rowBuffer, int[] dimReadIndexs) {
        StringBuilder rowKeyStr = new StringBuilder(20 * rowBuffer.length);
        for (int dimIndex : dimReadIndexs) {
            rowKeyStr.append(rowBuffer[dimIndex]).append('|');
        }
        return rowKeyStr;
    }

    protected DynamicObject createNewDynamicObject(Object[] rowBuffer) {
        DynamicObject dynRow = new DynamicObject((DynamicObjectType)this.outputDynEntity);
        if (!this.autoComplete.booleanValue()) {
            this.dataVersionProp.setValueFast((Object)dynRow, (Object)this.version);
        }
        this.dataSrcTypeProp.setValueFast((Object)dynRow, (Object)"0");
        int i = 0;
        for (int dimIndex : this.dimReadIndex) {
            this.outputDimDynProps[i++].setValueFast((Object)dynRow, rowBuffer[dimIndex]);
        }
        return dynRow;
    }

    public void cleanExTraCache(OlapSQLBuilder olapSQLBuilder, SelectCommandInfo selectCommandInfo) {
        olapSQLBuilder.clean();
        selectCommandInfo.getDimensions().clear();
        selectCommandInfo.getFilter().clear();
        selectCommandInfo.getMeasures().clear();
    }

    protected void processMeasureValues(Object measureValue, Object[] srcRowBuffer, DynamicObject outputTarget) {
        this.measureValueProp.setValueFast((Object)outputTarget, measureValue);
        if (this.manuallyAddFieldMap != null) {
            for (Map.Entry manuallyAddField : this.manuallyAddFieldMap.entrySet()) {
                outputTarget.set(((String)manuallyAddField.getKey()).toLowerCase(), manuallyAddField.getValue());
            }
        }
    }

    public String getOutputTargetEntityName() {
        return this.outputDynEntity != null ? this.outputDynEntity.getName() : null;
    }

    public void setOutputTargetEntityName(String outputTargetEntityName) {
        this.outputDynEntity = EntityMetadataCache.getDataEntityType((String)outputTargetEntityName);
    }

    public IDataEntityProperty[] getOutputDimDynProps() {
        return this.outputDimDynProps;
    }

    public void setOutputDimDynProps(IDataEntityProperty[] outputDimDynProps) {
        this.outputDimDynProps = outputDimDynProps;
    }

    public int[] getDimReadIndex() {
        return this.dimReadIndex;
    }

    public void setDimReadIndex(int[] dimReadIndex) {
        this.dimReadIndex = dimReadIndex;
    }

    public MainEntityType getOutputDynEntity() {
        return this.outputDynEntity;
    }

    public boolean isAllowDimNull() {
        return this.allowDimNull;
    }

    public void setAllowDimNull(boolean allowDimNull) {
        this.allowDimNull = allowDimNull;
    }

    public boolean isIgnoreDimNull() {
        return this.ignoreDimNull;
    }

    public void setIgnoreDimNull(boolean ignoreDimNull) {
        this.ignoreDimNull = ignoreDimNull;
    }

    public boolean isSuperLongData() {
        return this.superLongData;
    }

    public void setSuperLongData(boolean superLongData) {
        this.superLongData = superLongData;
    }
}

