/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.engine.task;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.data.disf.enums.FSAStatusEnum;
import kd.data.disf.task.IDataAbstractWorkTask;
import kd.data.disf.task.IDataEntityCleanTask;
import kd.data.disf.task.IFinallyTask;
import kd.data.disf.task.IWorkTaskTransLog;
import kd.data.disf.task.TaskGroupCondition;
import kd.data.fsa.cacheservice.FSADataCacheMgr;
import kd.data.fsa.common.enums.FSAWorkTaskTypeEnum;
import kd.data.fsa.engine.task.AbstractOlapDataQueryTask;
import kd.data.fsa.engine.task.FSADataEntityCleanTask;
import kd.data.fsa.engine.task.FSADataEntityCreateDelTask;
import kd.data.fsa.engine.task.FSADataSyncWorkTaskWrapper;
import kd.data.fsa.engine.task.FSADataVersionInsertTask;
import kd.data.fsa.engine.task.FSAFileUploadDataTask;
import kd.data.fsa.engine.task.FSAGLRptDataSyncTask;
import kd.data.fsa.engine.task.FSAHierarchyCompleteTask;
import kd.data.fsa.engine.task.FSALazyOlapDataQueryWrapperTask;
import kd.data.fsa.engine.task.FSAOlapDataSyncTaskBuilder;
import kd.data.fsa.engine.task.FSAWorkTaskMeta;
import kd.data.fsa.engine.task.common.FSADataSequenceWorkTaskGroup;
import kd.data.fsa.model.FSAConfigModel;
import kd.data.fsa.model.sync.FSADataSyncTaskDimFilterModel;
import kd.data.fsa.model.sync.FSADataSyncTaskMemberModel;
import kd.data.fsa.model.sync.FSADataSyncTaskParamModel;
import kd.data.fsa.utils.KdOlapServerHelper;

public class FSAWorkTaskFactory {
    private static final Log logger = LogFactory.getLog(FSAWorkTaskFactory.class);

    public static IDataAbstractWorkTask createFSAWorkTask(Integer taskType, IWorkTaskTransLog<Long> taskTransLog, boolean needWrapper) {
        FSAWorkTaskTypeEnum workTaskType;
        if (logger.isInfoEnabled()) {
            logger.info(String.format("createFSAWorkTask: taskType:%s, taskTransLog=%s", taskType, taskTransLog));
        }
        if ((workTaskType = FSAWorkTaskTypeEnum.getEnum(taskType)) == null) {
            throw new KDBizException("\u5f85\u521b\u5efa\u7684\u5de5\u4f5c\u4efb\u52a1\u7c7b\u578b\u65e0\u6cd5\u8bc6\u522b\u6216\u4e3a\u7a7a\uff01WorkTaskType=" + taskType);
        }
        Object workTask = null;
        switch (workTaskType) {
            case Create_Table_Task: 
            case Drop_Table_Task: {
                workTask = FSAWorkTaskFactory.createDataEntityCreateDelTask(taskTransLog);
                break;
            }
            case Del_Table_Data_Task: {
                workTask = FSAWorkTaskFactory.createDataEntityCleanTask(taskTransLog, false, true);
                break;
            }
            case Rollback_Del_Table_Data_Task: {
                workTask = FSAWorkTaskFactory.createDataEntityCleanTask(taskTransLog, false, false);
                break;
            }
            case Change_DataVersionStatus_OR_RollBack: {
                workTask = FSAWorkTaskFactory.createChangeDataVersionStatusOrRollBackTask(taskTransLog, FSAStatusEnum.SUCCESS);
                break;
            }
            case Insert_DataVersionTask: {
                workTask = FSAWorkTaskFactory.createChangeDataVersionStatusOrRollBackTask(taskTransLog, FSAStatusEnum.NEW);
                break;
            }
            case GL_Rpt_Data_Sync_Task: {
                workTask = FSAWorkTaskFactory.createGLRptDataSyncTask(taskTransLog);
                break;
            }
            case BCM_OLAP_Data_Sync_Task: {
                workTask = FSAWorkTaskFactory.createOlapDataQueryTask(taskTransLog);
                break;
            }
            case Single_Tab_Indicator_Calc_Task: {
                break;
            }
            case Multi_Tab_Indicator_Calc_Task: {
                break;
            }
            case BCM_OLAP_GROUP_Data_Sync_Task: {
                workTask = FSAWorkTaskFactory.createOlapDataQueryTaskGroup(taskTransLog);
                break;
            }
            case File_Upload_Data_Task: {
                workTask = FSAWorkTaskFactory.createFileUploadDataTask(taskTransLog);
                break;
            }
            case Hierarchy_Complete_Task: {
                workTask = FSAWorkTaskFactory.createHierarchyCompleteTask(taskTransLog);
                break;
            }
            default: {
                throw new KDBizException("\u6682\u4e0d\u652f\u6301\u7684\u5de5\u4f5c\u4efb\u52a1\u7c7b\u578b\uff01WorkTaskType=" + taskType);
            }
        }
        return needWrapper ? FSAWorkTaskFactory.createWrapperTask(workTask, taskTransLog) : workTask;
    }

    public static IDataAbstractWorkTask createFSAWorkTask(Integer taskType, IWorkTaskTransLog<Long> taskTransLog) {
        return FSAWorkTaskFactory.createFSAWorkTask(taskType, taskTransLog, true);
    }

    public static FSADataSyncWorkTaskWrapper createWrapperTask(IDataAbstractWorkTask srcTask, IWorkTaskTransLog<Long> taskTransLog) {
        return new FSADataSyncWorkTaskWrapper(srcTask, taskTransLog);
    }

    public static IDataEntityCleanTask createDataEntityCleanTask(IWorkTaskTransLog<Long> taskTransLog, boolean rollbackMode, boolean markDelete) {
        return new FSADataEntityCleanTask(taskTransLog, rollbackMode, markDelete);
    }

    public static FSADataVersionInsertTask createChangeDataVersionStatusOrRollBackTask(IWorkTaskTransLog<Long> taskTransLog, FSAStatusEnum fsaStatusEnum) {
        return new FSADataVersionInsertTask(taskTransLog, fsaStatusEnum);
    }

    public static FSADataEntityCreateDelTask createDataEntityCreateDelTask(IWorkTaskTransLog<Long> taskTransLog) {
        return new FSADataEntityCreateDelTask(taskTransLog);
    }

    public static AbstractOlapDataQueryTask createOlapDataQueryTask(IWorkTaskTransLog<Long> taskTransLog) {
        if (taskTransLog instanceof FSAWorkTaskMeta) {
            FSAWorkTaskMeta meta = (FSAWorkTaskMeta)taskTransLog;
            FSADataSyncTaskParamModel taskParamModel = (FSADataSyncTaskParamModel)JSON.parseObject((String)meta.getParamDetail(), FSADataSyncTaskParamModel.class);
            List<FSADataSyncTaskDimFilterModel> dimFilterList = taskParamModel.getDimFilter();
            FSAOlapDataSyncTaskBuilder syncTaskBuilder = FSADataCacheMgr.instance.getFSAOlapDataSyncTaskBuilder(meta.getSyncParamId(), taskParamModel.getModelNumber(), meta.getTaskId(), meta.getTemplateId());
            for (FSADataSyncTaskDimFilterModel dimFilterModel : dimFilterList) {
                List<FSADataSyncTaskMemberModel> taskMemberModels = dimFilterModel.getMembers();
                String[] memeberValBuf = new String[taskMemberModels.size()];
                int i = 0;
                for (FSADataSyncTaskMemberModel memberModel : taskMemberModels) {
                    memeberValBuf[i++] = memberModel.getNumber();
                }
                Set<String> validDimMemberSet = KdOlapServerHelper.getValidDimMemberSet(taskParamModel.getModelNumber(), dimFilterModel.getNumber(), memeberValBuf);
                if (validDimMemberSet == null || validDimMemberSet.size() == 0) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%s \u7ef4\u5ea6\u6240\u9009\u62e9\u7684\u6210\u5458\u5747\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"FSAOlapDataSyncTaskBuilderCacheService_0", (String)"data-fsa-core", (Object[])new Object[0]), dimFilterModel.getName()));
                }
                syncTaskBuilder.addDimensionFilters(dimFilterModel.getNumber(), memeberValBuf);
            }
            HashMap<String, Object> buildParam = new HashMap<String, Object>(2);
            buildParam.put("modelNumber", taskParamModel.getModelNumber());
            buildParam.put("useParallelSubTask", Boolean.TRUE);
            buildParam.put("allowdimnull", meta.isAllowDimNull());
            buildParam.put("ignoredimnull", meta.isIgnoreDimNull());
            buildParam.put("datasynctask", meta.getTaskId());
            buildParam.put("version", meta.getVersion());
            AbstractOlapDataQueryTask queryTask = syncTaskBuilder.build(buildParam, new Object[0]);
            FSAConfigModel maxThreadCntModel = FSADataCacheMgr.instance.getFSAConfigModel("maxWorker_ThreadCnt");
            if (maxThreadCntModel != null) {
                queryTask.setMaxWorkerThreadCnt(Integer.parseInt(maxThreadCntModel.getValue()));
            }
            return queryTask;
        }
        return null;
    }

    public static FSAGLRptDataSyncTask createGLRptDataSyncTask(IWorkTaskTransLog<Long> taskTransLog) {
        return null;
    }

    public static FSADataSequenceWorkTaskGroup createOlapDataQueryTaskGroup(IWorkTaskTransLog<Long> taskTransLog) {
        if (taskTransLog instanceof FSAWorkTaskMeta) {
            FSAWorkTaskMeta meta = (FSAWorkTaskMeta)taskTransLog;
            FSADataSequenceWorkTaskGroup groupTask = new FSADataSequenceWorkTaskGroup(meta.getTaskId(), meta.getVersion(), null);
            groupTask.addSubTask((Callable)FSAWorkTaskFactory.createFSAWorkTask(FSAWorkTaskTypeEnum.Insert_DataVersionTask.getValue(), meta, false));
            groupTask.addSubTask((Callable)((Object)new FSALazyOlapDataQueryWrapperTask(meta.getTaskId(), meta.getVersion(), meta, groupTask.getExceptionListener(), groupTask.getTaskGroupCondition())));
            groupTask.setEndingTask((IFinallyTask)FSAWorkTaskFactory.createFSAWorkTask(FSAWorkTaskTypeEnum.Change_DataVersionStatus_OR_RollBack.getValue(), taskTransLog, false));
            return groupTask;
        }
        return null;
    }

    public static IDataAbstractWorkTask createFileUploadDataTask(IWorkTaskTransLog<Long> taskTransLog) {
        if (taskTransLog instanceof FSAWorkTaskMeta) {
            FSAWorkTaskMeta meta = (FSAWorkTaskMeta)taskTransLog;
            if (meta.getCreateVersion().booleanValue()) {
                FSADataSequenceWorkTaskGroup groupTask = new FSADataSequenceWorkTaskGroup(meta.getTaskId(), meta.getVersion(), null);
                IFinallyTask finallyTask = (IFinallyTask)FSAWorkTaskFactory.createFSAWorkTask(FSAWorkTaskTypeEnum.Change_DataVersionStatus_OR_RollBack.getValue(), taskTransLog, false);
                groupTask.setEndingTask(finallyTask);
                FSAFileUploadDataTask fsaFileUploadDataTask = new FSAFileUploadDataTask(meta);
                IDataAbstractWorkTask insertDataVersion = FSAWorkTaskFactory.createFSAWorkTask(FSAWorkTaskTypeEnum.Insert_DataVersionTask.getValue(), meta, false);
                groupTask.addSubTask((Callable)insertDataVersion);
                groupTask.addSubTask((Callable)((Object)fsaFileUploadDataTask));
                return groupTask;
            }
            return new FSAFileUploadDataTask(meta);
        }
        return null;
    }

    public static FSAHierarchyCompleteTask createHierarchyCompleteTask(IWorkTaskTransLog<Long> taskTransLog) {
        FSAWorkTaskMeta meta = (FSAWorkTaskMeta)taskTransLog;
        return new FSAHierarchyCompleteTask(meta.getTaskId(), taskTransLog, null, new TaskGroupCondition(), true);
    }

    public static FSAWorkTaskMeta copyNewTaskTypeMeta(FSAWorkTaskMeta taskMeta, FSAWorkTaskTypeEnum taskTypeEnum) {
        FSAWorkTaskMeta newTaskMeta = new FSAWorkTaskMeta(0L, taskMeta.getTransLogId(), taskMeta.getId().toString(), taskMeta.getTaskId(), taskMeta.getSyncParamId(), taskTypeEnum, taskMeta.getParamDetail(), taskMeta.isNeedRequestLock(), taskMeta.getTableNumber(), taskMeta.isAllowDimNull(), taskMeta.isIgnoreDimNull(), taskMeta.getVersion());
        return newTaskMeta;
    }
}

