/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.engine.task.common;

import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.exception.KDBizException;
import kd.data.disf.listener.IExceptionListener;
import kd.data.disf.task.IDataSequenceWorkTaskGroup;
import kd.data.disf.task.IDataWorkTask;
import kd.data.disf.task.IDataWorkTaskManager;
import kd.data.disf.task.IFinallyTask;
import kd.data.disf.task.IWorkTaskResultProcessor;
import kd.data.disf.task.status.IDataSimpleWorkTaskStatisticStatus;
import kd.data.disf.task.status.IDataWorkTaskStatusMgr;
import kd.data.fsa.engine.task.status.FSAWorkTaskStatusConsumer;

public class FSADataSequenceWorkTaskGroup
extends IDataSequenceWorkTaskGroup<Long, IDataWorkTask, IDataSimpleWorkTaskStatisticStatus> {
    protected IFinallyTask endingTask;

    public FSADataSequenceWorkTaskGroup(Serializable taskKey, Serializable version, IWorkTaskResultProcessor<IDataWorkTask> processTaskResultFunc, IExceptionListener exceptionListener) {
        super(taskKey, version, processTaskResultFunc, exceptionListener);
    }

    public FSADataSequenceWorkTaskGroup(Serializable taskKey, Serializable version, IWorkTaskResultProcessor<IDataWorkTask> processTaskResultFunc) {
        super(taskKey, version, processTaskResultFunc);
        this.exceptionListener = ex -> this.onTaskError(ex);
    }

    protected Long processTaskResult(int i, IDataWorkTask workStep, Object taskResult) {
        super.processTaskResult(i, (Callable)workStep, taskResult);
        if (taskResult instanceof Long) {
            if (this.taskResult != null) {
                FSADataSequenceWorkTaskGroup fSADataSequenceWorkTaskGroup = this;
                fSADataSequenceWorkTaskGroup.taskResult = (Long)fSADataSequenceWorkTaskGroup.taskResult + (Long)taskResult;
            } else {
                this.taskResult = 0L;
            }
        }
        return (Long)this.taskResult;
    }

    protected void doTaskFinallyCleanUp(boolean isCancelled, boolean withError) {
        if (this.endingTask != null) {
            if (!(this.endingTask instanceof IDataWorkTask)) {
                String simpleName = this.endingTask.getClass().getSimpleName() + " is not a task";
                throw new KDBizException(simpleName);
            }
            if (isCancelled || withError) {
                this.endingTask.setRollBack(true);
            }
            IDataWorkTask task = (IDataWorkTask)this.endingTask;
            Future subTaskResult = IDataWorkTaskManager.getInstance().submit(task);
            try {
                subTaskResult.get();
            }
            catch (Exception ex) {
                this.onException(ex);
            }
        }
    }

    protected boolean onTaskError(Throwable exception) {
        this.exception = exception;
        return true;
    }

    protected boolean onException(Throwable exception) {
        boolean result = super.onException(exception);
        if (this.endingTask != null) {
            this.endingTask.setRollBack(true);
        }
        return result;
    }

    protected IDataWorkTaskStatusMgr getWorkTaskStatusMgr() {
        return FSAWorkTaskStatusConsumer.getInstance();
    }

    public IFinallyTask getEndingTask() {
        return this.endingTask;
    }

    public void setEndingTask(IFinallyTask endingTask) {
        this.endingTask = endingTask;
    }
}

