/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.engine.task.status;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.data.disf.cache.IDataCacheModule;
import kd.data.disf.event.IWorkTaskStatusEvent;
import kd.data.disf.task.status.AbstractIDataWorkTaskStatusConsumer;

public class FSAWorkTaskStatusConsumer
extends AbstractIDataWorkTaskStatusConsumer {
    private static FSAWorkTaskStatusConsumer instance = new FSAWorkTaskStatusConsumer();
    private static final Map<String, FSAWorkTaskStatusConsumer> instanceMap = new ConcurrentHashMap<String, FSAWorkTaskStatusConsumer>();
    private static String centerId = null;

    protected IDataCacheModule getCacheModel() {
        return IDataCacheModule.FSA;
    }

    public static FSAWorkTaskStatusConsumer getInstance() {
        centerId = AccountUtils.getCorrectAccount((String)RequestContext.get().getAccountId(), (String)RequestContext.get().getTenantId()).getAccountId();
        FSAWorkTaskStatusConsumer consumer = instanceMap.get(centerId);
        if (consumer == null) {
            consumer = new FSAWorkTaskStatusConsumer();
            instanceMap.put(centerId, consumer);
            instance = consumer;
        }
        if (consumer.processPipe == null) {
            throw new KDBizException("FSAWorkTaskStatusConsumer PipeStream is null");
        }
        return consumer;
    }

    public void updateCachedWorkTaskStatusEvent(Object taskId, String message) {
        IWorkTaskStatusEvent statusEvent = this.getCachedWorkTaskStatusEvent(taskId);
        if (statusEvent != null) {
            statusEvent.setNeedMergeStatus(false);
            statusEvent.updateStatusMessage(message);
            try {
                instance.updateTaskStatus(statusEvent);
            }
            catch (InterruptedException e) {
                throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
            }
        }
    }
}

