/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.file;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.fsa.common.constant.FSACommonConstant;
import kd.data.fsa.common.enums.FSADimensionTypeEnum;
import kd.data.fsa.engine.task.FSAWorkTaskMeta;
import kd.data.fsa.file.FSASupFileReader;
import kd.data.fsa.model.file.FSAFieldMappingModel;
import kd.data.fsa.model.file.FSAFieldMappingWithTimePatternModel;
import kd.data.fsa.model.file.FSAFileInfoModel;

public class FSACSVFileReader
extends FSASupFileReader {
    private static final Log logger = LogFactory.getLog(FSACSVFileReader.class);
    private static final String regex = ",(?=([^\"]*\"[^\"]*\")*[^\"]*$)";
    private static volatile FSACSVFileReader csvFileReader;

    private FSACSVFileReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FSACSVFileReader getInstance() {
        if (csvFileReader != null) return csvFileReader;
        Class<FSACSVFileReader> clazz = FSACSVFileReader.class;
        synchronized (FSACSVFileReader.class) {
            if (csvFileReader != null) return csvFileReader;
            csvFileReader = new FSACSVFileReader();
            // ** MonitorExit[var0] (shouldn't be in output)
            return csvFileReader;
        }
    }

    @Override
    public List<String> getSheetNames(String fileName) {
        return Collections.singletonList(fileName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FSAFileInfoModel getFileInfoNoSheetSelect(String fileName, String fileUrl, String sheetName) {
        int rowCount = 0;
        try (InputStream inputStream = this.getInputStream(fileUrl);){
            String value;
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, Charset.forName("GBK"));
            BufferedReader reader = new BufferedReader(inputStreamReader);
            boolean parseFlag = true;
            while ((value = reader.readLine()) != null) {
                if (parseFlag) {
                    try {
                        parseFlag = false;
                        Map valueMap = (Map)JSON.parseObject((String)value, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
                        if ("error".equals(valueMap.get("status"))) {
                            FSAFileInfoModel fSAFileInfoModel = null;
                            return fSAFileInfoModel;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++rowCount;
            }
            reader.close();
            inputStreamReader.close();
            return new FSAFileInfoModel(fileName, fileUrl, this.getSheetNames(sheetName), sheetName, rowCount);
        }
        catch (Exception e) {
            logger.error("getFileInfoNoSheetSelect\uff1a", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FSAFileInfoModel getFileInfoOnSheet(FSAFileInfoModel fileInfoModel, String sheetName, int titleRow, int previewRow) {
        String fileUrl = fileInfoModel.getFileUrl();
        int rowCount = 0;
        LinkedHashSet<String> columnSet = new LinkedHashSet<String>(10);
        ArrayList<String[]> dataList = new ArrayList<String[]>(previewRow);
        ArrayList<Class> classList = new ArrayList<Class>(10);
        try (InputStream inputStream = this.getInputStream(fileUrl);){
            String value;
            if (inputStream == null) {
                FSAFileInfoModel fSAFileInfoModel = null;
                return fSAFileInfoModel;
            }
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, Charset.forName("GBK"));
            BufferedReader reader = new BufferedReader(inputStreamReader);
            boolean parseFlag = true;
            while ((value = reader.readLine()) != null) {
                String str;
                int n;
                int n2;
                String[] stringArray;
                if (parseFlag) {
                    try {
                        parseFlag = false;
                        Map valueMap = (Map)JSON.parseObject((String)value, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
                        if ("error".equals(valueMap.get("status"))) {
                            FSAFileInfoModel fSAFileInfoModel = null;
                            return fSAFileInfoModel;
                        }
                    }
                    catch (Exception valueMap) {
                        // empty catch block
                    }
                }
                if (++rowCount == titleRow) {
                    String[] values;
                    int addCount = 1;
                    stringArray = values = value.split(regex);
                    n2 = stringArray.length;
                    for (n = 0; n < n2; ++addCount, ++n) {
                        str = stringArray[n];
                        this.formatTitle(str, columnSet, addCount);
                    }
                    continue;
                }
                if (rowCount <= titleRow || dataList.size() >= previewRow) continue;
                String[] values = value.split(regex);
                int i = 0;
                stringArray = values;
                n2 = stringArray.length;
                for (n = 0; n < n2; ++i, ++n) {
                    str = stringArray[n];
                    values[i] = str = this.parseType(classList, i, str);
                }
                dataList.add(values);
            }
            reader.close();
            inputStreamReader.close();
        }
        catch (Exception e) {
            logger.error("getFileInfoOnSheet\uff1a", (Throwable)e);
            return null;
        }
        int dataCount = rowCount > titleRow ? rowCount - titleRow : 0;
        fileInfoModel.setTitleRow(titleRow);
        fileInfoModel.setPreviewRow(previewRow);
        fileInfoModel.setSheetName(sheetName);
        fileInfoModel.setColumnList(new ArrayList<String>(columnSet));
        this.handlerClassList(classList);
        fileInfoModel.setClassList(classList);
        fileInfoModel.setDataList(dataList);
        fileInfoModel.setDataCount(dataCount);
        return fileInfoModel;
    }

    @Override
    public void saveFileData(FSAWorkTaskMeta meta) {
        int rowCount = 0;
        FSAFileInfoModel fileInfoModel = meta.getFileInfoModel();
        String cacheKey = "fsa_" + meta.getTaskId();
        List<String> columnList = fileInfoModel.getColumnList();
        ArrayList<DynamicObject> dyoList = new ArrayList<DynamicObject>(1500);
        FSAFieldMappingWithTimePatternModel fieldMappingWithTimePatternModel = meta.getFieldMappingWithTimePatternModel();
        if (fieldMappingWithTimePatternModel == null) {
            return;
        }
        List<FSAFieldMappingModel> columnModelList = fieldMappingWithTimePatternModel.getFieldMappingModelList();
        SimpleDateFormat sdf = this.getSimpleDateFormatByComb(fieldMappingWithTimePatternModel.getTimePattern());
        Boolean ignoreErr = meta.getIgnoreErr();
        Boolean ignoreNull = meta.isIgnoreDimNull();
        boolean errFlag = true;
        String entity = FSACommonConstant.buildEntityName(meta.getTableNumber());
        try (InputStream inputStream = this.getInputStream(fileInfoModel.getFileUrl());){
            String value;
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, Charset.forName("GBK"));
            BufferedReader reader = new BufferedReader(inputStreamReader);
            while ((value = reader.readLine()) != null) {
                if (++rowCount <= fileInfoModel.getTitleRow()) continue;
                String[] values = value.split(regex);
                DynamicObject dyo = BusinessDataServiceHelper.newDynamicObject((String)entity);
                dyo.set("version", (Object)meta.getVersion());
                dyo.set("del", (Object)meta.getVersion());
                dyo.set("datasourcetype", (Object)"1");
                boolean dataTrueFlag = true;
                boolean nullFlag = true;
                for (FSAFieldMappingModel columnModel : columnModelList) {
                    int index = columnList.indexOf(columnModel.getV2());
                    String fieldValue = index < 0 ? columnModel.getV3() : values[index];
                    fieldValue = this.replaceHeadAndTailChar(fieldValue, "\"", "");
                    if (FSADimensionTypeEnum.MEASURE_DIM.getCodeString().equals(columnModel.getDimensionType())) {
                        if (StringUtils.isEmpty((String)fieldValue)) {
                            if (!ignoreNull.booleanValue()) continue;
                            nullFlag = false;
                            break;
                        }
                        try {
                            fieldValue = fieldValue.replaceAll(",", "").trim();
                            new BigDecimal(fieldValue);
                        }
                        catch (Exception e) {
                            dataTrueFlag = false;
                            if (ignoreErr.booleanValue()) break;
                            errFlag = false;
                            break;
                        }
                    }
                    fieldValue = this.formatDate(columnModel.getDimensionType(), fieldValue, sdf);
                    dyo.set(String.valueOf(columnModel.getV1()), (Object)fieldValue);
                }
                if (!errFlag) {
                    this.interruptDelete(fileInfoModel.getDataCount(), meta.getVersion(), cacheKey, meta.getTableNumber());
                    break;
                }
                this.handlerDataToDB(dataTrueFlag, nullFlag, dyoList, fileInfoModel.getDataCount(), dyo, fileInfoModel.getTitleRow(), rowCount, cacheKey, meta.getTableNumber(), fileInfoModel.getFileUrl(), meta.getVersion());
            }
            reader.close();
            inputStreamReader.close();
        }
        catch (Exception e) {
            logger.error("saveFileData\uff1a", (Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
    }
}

