/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.file;

import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.fsa.common.constant.FSACommonConstant;
import kd.data.fsa.common.enums.FSADimensionTypeEnum;
import kd.data.fsa.engine.task.FSAWorkTaskMeta;
import kd.data.fsa.file.FSASupFileReader;
import kd.data.fsa.model.file.FSAFieldMappingModel;
import kd.data.fsa.model.file.FSAFieldMappingWithTimePatternModel;
import kd.data.fsa.model.file.FSAFileInfoModel;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class FSAExcelFileReader
extends FSASupFileReader {
    private static final Log logger = LogFactory.getLog(FSAExcelFileReader.class);
    private static volatile FSAExcelFileReader excelFileReader;

    private FSAExcelFileReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FSAExcelFileReader getInstance() {
        if (excelFileReader != null) return excelFileReader;
        Class<FSAExcelFileReader> clazz = FSAExcelFileReader.class;
        synchronized (FSAExcelFileReader.class) {
            if (excelFileReader != null) return excelFileReader;
            excelFileReader = new FSAExcelFileReader();
            // ** MonitorExit[var0] (shouldn't be in output)
            return excelFileReader;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<String> getSheetNames(String fileUrl) {
        try (InputStream inputStream = this.getInputStream(fileUrl);){
            XSSFWorkbook workbook = new XSSFWorkbook(inputStream);
            int sheetSize = workbook.getNumberOfSheets();
            ArrayList<String> sheetNameList = new ArrayList<String>(sheetSize);
            for (int i = 0; i < sheetSize; ++i) {
                sheetNameList.add(workbook.getSheetName(i));
            }
            ArrayList<String> arrayList = sheetNameList;
            return arrayList;
        }
        catch (Exception e) {
            logger.error("getSheetNames\uff1a", (Throwable)e);
            return Collections.emptyList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FSAFileInfoModel getFileInfoNoSheetSelect(String fileName, String fileUrl, String sheetName) {
        int rowCount = 0;
        try (InputStream inputStream = this.getInputStream(fileUrl);){
            int lastRowNum;
            XSSFWorkbook workbook = new XSSFWorkbook(inputStream);
            int sheetSize = workbook.getNumberOfSheets();
            ArrayList<String> sheetNameList = new ArrayList<String>(sheetSize);
            for (int i = 0; i < sheetSize; rowCount += lastRowNum + 1, ++i) {
                sheetNameList.add(workbook.getSheetName(i));
                XSSFSheet sheet = workbook.getSheetAt(i);
                lastRowNum = sheet.getLastRowNum();
            }
            FSAFileInfoModel fSAFileInfoModel = new FSAFileInfoModel(fileName, fileUrl, sheetNameList, rowCount);
            return fSAFileInfoModel;
        }
        catch (Exception e) {
            logger.error("getFileInfoNoSheetSelect\uff1a", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FSAFileInfoModel getFileInfoOnSheet(FSAFileInfoModel fileInfoModel, String sheetName, int titleRow, int previewRow) {
        String fileUrl = fileInfoModel.getFileUrl();
        int rowCount = 0;
        LinkedHashSet<String> columnSet = new LinkedHashSet<String>(10);
        ArrayList<String[]> dataList = new ArrayList<String[]>(previewRow);
        ArrayList<Class> classList = new ArrayList<Class>(10);
        DataFormatter dataFormatter = new DataFormatter();
        try (InputStream inputStream = this.getInputStream(fileUrl);){
            XSSFWorkbook workbook = new XSSFWorkbook(inputStream);
            XSSFSheet sheet = workbook.getSheet(sheetName);
            int lastRowNum = sheet.getLastRowNum();
            rowCount += lastRowNum + 1;
            for (Row row : sheet) {
                String value;
                Cell cell;
                short i;
                int rowNum = row.getRowNum();
                short cellNum = row.getLastCellNum();
                if (rowNum == titleRow - 1) {
                    int addCount = 1;
                    for (i = 0; i <= cellNum; ++addCount, i = (short)(i + 1)) {
                        cell = row.getCell((int)i);
                        value = dataFormatter.formatCellValue(cell);
                        this.formatTitle(value, columnSet, addCount);
                    }
                    continue;
                }
                if (rowNum > titleRow - 1 && dataList.size() < previewRow) {
                    String[] dataArr = new String[cellNum + 1];
                    for (i = 0; i <= cellNum; i = (short)(i + 1)) {
                        cell = row.getCell((int)i);
                        value = dataFormatter.formatCellValue(cell);
                        dataArr[i] = value = this.parseType(classList, i, value);
                    }
                    dataList.add(dataArr);
                    continue;
                }
                if (dataList.size() < previewRow) continue;
            }
            int dataCount = rowCount > titleRow ? rowCount - titleRow : 0;
            fileInfoModel.setTitleRow(titleRow);
            fileInfoModel.setPreviewRow(previewRow);
            fileInfoModel.setSheetName(sheetName);
            fileInfoModel.setColumnList(new ArrayList<String>(columnSet));
            this.handlerClassList(classList);
            fileInfoModel.setClassList(classList);
            fileInfoModel.setDataList(dataList);
            fileInfoModel.setDataCount(dataCount);
            FSAFileInfoModel fSAFileInfoModel = fileInfoModel;
            return fSAFileInfoModel;
        }
        catch (Exception e) {
            logger.error("getFileInfoOnSheet\uff1a", (Throwable)e);
            return null;
        }
    }

    @Override
    public void saveFileData(FSAWorkTaskMeta meta) {
        FSAFileInfoModel fileInfoModel = meta.getFileInfoModel();
        try (InputStream inputStream = this.getInputStream(fileInfoModel.getFileUrl());){
            String cacheKey = "fsa_" + meta.getTaskId();
            List<String> columnList = fileInfoModel.getColumnList();
            ArrayList<DynamicObject> dyoList = new ArrayList<DynamicObject>(1500);
            FSAFieldMappingWithTimePatternModel fieldMappingWithTimePatternModel = meta.getFieldMappingWithTimePatternModel();
            if (fieldMappingWithTimePatternModel == null) {
                return;
            }
            List<FSAFieldMappingModel> columnModelList = fieldMappingWithTimePatternModel.getFieldMappingModelList();
            SimpleDateFormat sdf = this.getSimpleDateFormatByComb(fieldMappingWithTimePatternModel.getTimePattern());
            Boolean ignoreErr = meta.getIgnoreErr();
            Boolean ignoreNull = meta.isIgnoreDimNull();
            boolean errFlag = true;
            XSSFWorkbook workbook = new XSSFWorkbook(inputStream);
            XSSFSheet sheet = workbook.getSheet(fileInfoModel.getSheetName());
            Integer titleRow = fileInfoModel.getTitleRow();
            Integer dataCount = fileInfoModel.getDataCount();
            DataFormatter dataFormatter = new DataFormatter();
            String entity = FSACommonConstant.buildEntityName(meta.getTableNumber());
            for (Row row : sheet) {
                int rowNum = row.getRowNum();
                if (rowNum <= titleRow - 1) continue;
                DynamicObject dyo = BusinessDataServiceHelper.newDynamicObject((String)entity);
                dyo.set("version", (Object)meta.getVersion());
                dyo.set("del", (Object)meta.getVersion());
                dyo.set("datasourcetype", (Object)"1");
                boolean dataTrueFlag = true;
                boolean nullFlag = true;
                for (FSAFieldMappingModel columnModel : columnModelList) {
                    String fieldValue;
                    int index = columnList.indexOf(columnModel.getV2());
                    if (index < 0) {
                        fieldValue = columnModel.getV3();
                    } else {
                        Cell cell = row.getCell(index);
                        fieldValue = dataFormatter.formatCellValue(cell);
                    }
                    fieldValue = this.replaceHeadAndTailChar(fieldValue, "\"", "");
                    if (FSADimensionTypeEnum.MEASURE_DIM.getCodeString().equals(columnModel.getDimensionType())) {
                        if (StringUtils.isEmpty((String)fieldValue)) {
                            if (!ignoreNull.booleanValue()) continue;
                            nullFlag = false;
                            break;
                        }
                        try {
                            fieldValue = fieldValue.replaceAll(",", "").trim();
                            new BigDecimal(fieldValue);
                        }
                        catch (Exception e) {
                            dataTrueFlag = false;
                            if (ignoreErr.booleanValue()) break;
                            errFlag = false;
                            break;
                        }
                    }
                    fieldValue = this.formatDate(columnModel.getDimensionType(), fieldValue, sdf);
                    dyo.set(String.valueOf(columnModel.getV1()), (Object)fieldValue);
                }
                if (!errFlag) {
                    this.interruptDelete(dataCount, meta.getVersion(), cacheKey, meta.getTableNumber());
                    break;
                }
                this.handlerDataToDB(dataTrueFlag, nullFlag, dyoList, dataCount, dyo, titleRow, rowNum + 1, cacheKey, meta.getTableNumber(), fileInfoModel.getFileUrl(), meta.getVersion());
            }
        }
        catch (Exception e) {
            logger.error("saveFileData\uff1a", (Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
    }
}

