/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.file;

import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.disf.cache.DistributeCache;
import kd.data.disf.cache.IDataCacheModule;
import kd.data.disf.constants.IDataCommonConstant;
import kd.data.disf.utils.IDataValueUtil;
import kd.data.fsa.common.enums.FSADimensionTypeEnum;
import kd.data.fsa.file.FSAFileReader;

public abstract class FSASupFileReader
implements FSAFileReader {
    DistributeCache cache = DistributeCache.getCache((IDataCacheModule)IDataCacheModule.FSA);
    private static final Log logger = LogFactory.getLog(FSASupFileReader.class);
    private static final Map<String, Integer> classMap = new HashMap<String, Integer>(){
        private static final long serialVersionUID = -1485945154834247168L;
        {
            this.put(Integer.class.toString(), 0);
            this.put(Long.class.toString(), 1);
            this.put(Double.class.toString(), 2);
            this.put(BigInteger.class.toString(), 3);
            this.put(BigDecimal.class.toString(), 4);
        }
    };
    private static final Class[] numberClassArr = new Class[]{Integer.class, Long.class, Double.class, BigInteger.class, BigDecimal.class};

    public void removeFile(String fileUrl) {
        TempFileCache tfc = CacheFactory.getCommonCacheFactory().getTempFileCache();
        tfc.remove(fileUrl);
    }

    public InputStream getInputStream(String fileUrl) throws Exception {
        try {
            TempFileCacheDownloadable downLoad = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
            String[] queryParams = new URL(fileUrl).getQuery().split("&");
            HashMap<String, String> downloadFileParams = new HashMap<String, String>(queryParams.length);
            for (String queryParam : queryParams) {
                String[] p = queryParam.split("=");
                downloadFileParams.put(p[0], p[1]);
            }
            TempFileCacheDownloadable.Content content = downLoad.get((String)downloadFileParams.get("configKey"), (String)downloadFileParams.get("id"));
            return content.getInputStream();
        }
        catch (Exception e) {
            return this.getInputStreamByPath(fileUrl);
        }
    }

    public void saveToDataBase(List<DynamicObject> dyoList) {
        SaveServiceHelper.save((DynamicObject[])dyoList.toArray(new DynamicObject[0]));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String upload(MainEntityType entityType, String fileName, String fileUrl) {
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        RequestContext ctx = RequestContext.getOrCreate();
        String path = ctx.getAccountId() + '/' + entityType.getAppId() + '/' + entityType.getName() + Uuid8.generateShortUuid() + '/' + fileName;
        try (InputStream inputStream = this.getInputStream(fileUrl);){
            String string = fileService.upload(new FileItem(fileName, path, inputStream));
            return string;
        }
        catch (Exception e) {
            logger.error("upload\uff1a", (Throwable)e);
            return null;
        }
    }

    public String upload(MainEntityType entityType, String fileName, InputStream inputStream) {
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        RequestContext ctx = RequestContext.getOrCreate();
        String path = ctx.getAccountId() + '/' + entityType.getAppId() + '/' + entityType.getName() + Uuid8.generateShortUuid() + '/' + fileName;
        return fileService.upload(new FileItem(fileName, path, inputStream));
    }

    public InputStream getInputStreamByPath(String path) throws Exception {
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        return fileService.getInputStream(path);
    }

    public void deleteFileByPath(String path) {
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        fileService.delete(path);
    }

    public void formatTitle(String title, Set<String> columnSet, int addCount) {
        if (StringUtils.isNotEmpty((String)title)) {
            title = this.replaceHeadAndTailChar(title, "\"", "").trim();
        }
        if (StringUtils.isEmpty((String)title) || title.length() > 50) {
            title = "field" + addCount;
        }
        if (columnSet.contains(title)) {
            title = title + addCount;
        }
        columnSet.add(title);
    }

    public String replaceHeadAndTailChar(String text, String strToReplace, String replaceWithThis) {
        if (StringUtils.isNotEmpty((String)text) && text.startsWith(strToReplace) && text.endsWith(strToReplace)) {
            text = this.replaceLast(text, strToReplace, replaceWithThis).replaceFirst(strToReplace, replaceWithThis);
        }
        return text;
    }

    public String replaceLast(String text, String strToReplace, String replaceWithThis) {
        return text.replaceFirst("(?s)" + strToReplace + "(?!.*?" + strToReplace + ")", replaceWithThis);
    }

    public void interruptDelete(Integer dataCount, Long version, String cacheKey, String tableNumber) {
        QFilter filter = new QFilter("version", "=", (Object)version).and(new QFilter("del", "=", (Object)version));
        DeleteServiceHelper.delete((String)("fsa_" + tableNumber), (QFilter[])filter.toArray());
        this.cache.put(cacheKey, (Object)("0/" + dataCount), 1800);
    }

    public void handlerDataToDB(boolean dataTrueFlag, boolean nullFlag, List<DynamicObject> dyoList, Integer dataCount, DynamicObject dyo, Integer titleRow, Integer rowCount, String cacheKey, String tableNumber, String fileUrl, Long version) {
        if (dataTrueFlag && nullFlag) {
            dyoList.add(dyo);
            if (dyoList.size() >= 1500) {
                this.saveToDataBase(dyoList);
                dyoList.clear();
            }
        }
        if (dataCount + titleRow == rowCount && !dyoList.isEmpty()) {
            this.saveToDataBase(dyoList);
        }
        if ((rowCount - titleRow) / 100 > 0 && (rowCount - titleRow) % 100 == 0 || dataCount + titleRow == rowCount) {
            this.cache.put(cacheKey, (Object)(rowCount - titleRow + "/" + dataCount), 1800);
        }
        if (dataCount + titleRow == rowCount) {
            String stopMark = this.cache.get("fsa_stop_" + fileUrl);
            if (StringUtils.isNotEmpty((String)stopMark)) {
                QFilter filter = new QFilter("version", "=", (Object)version).and("del", "=", (Object)version);
                DeleteServiceHelper.delete((String)("fsa_" + tableNumber), (QFilter[])filter.toArray());
            } else {
                QFilter updateFilter = new QFilter("fversion", "=", (Object)version).and("fdel", "=", (Object)version);
                StringBuilder sqlBuilder = new StringBuilder("update t_fsa_").append(tableNumber).append(" set f").append("del").append(" = ?  where ").append(updateFilter);
                DB.execute((DBRoute)IDataCommonConstant.DBRoute_BDAI, (String)sqlBuilder.toString(), (Object[])new Object[]{0L});
            }
        }
    }

    public String parseType(List<Class> classList, int i, String str) {
        Class clazz;
        int classSize = classList.size();
        if (classSize > i && String.class.equals((Object)classList.get(i))) {
            return str == null ? "" : this.replaceHeadAndTailChar(str, "\"", "");
        }
        if (str == null) {
            str = "";
            clazz = null;
        } else {
            clazz = IDataValueUtil.parseObjectDataType((Object)str);
        }
        if (classSize > i) {
            Class aClass = classList.get(i);
            if (clazz == null) {
                return this.replaceHeadAndTailChar(str, "\"", "");
            }
            if (aClass == null) {
                classList.set(i, clazz);
                return this.replaceHeadAndTailChar(str, "\"", "");
            }
            if (!clazz.equals(aClass)) {
                clazz = this.handlerClassIfNumerical(aClass, clazz);
                classList.set(i, clazz);
            }
        } else {
            classList.add(clazz);
        }
        return this.replaceHeadAndTailChar(str, "\"", "");
    }

    private Class handlerClassIfNumerical(Class aClass, Class clazz) {
        Integer aClassIdx = classMap.get(aClass.toString());
        Integer clazzIdx = classMap.get(clazz.toString());
        if (aClassIdx == null || clazzIdx == null) {
            return String.class;
        }
        if (IDataValueUtil.isInRange((Integer)aClassIdx, (Integer)2, (Integer)3) && IDataValueUtil.isInRange((Integer)clazzIdx, (Integer)2, (Integer)3)) {
            return numberClassArr[4];
        }
        return numberClassArr[Math.max(aClassIdx, clazzIdx)];
    }

    public void handlerClassList(List<Class> classList) {
        for (int i = 0; i < classList.size(); ++i) {
            if (classList.get(i) != null) continue;
            classList.set(i, String.class);
        }
    }

    public SimpleDateFormat getSimpleDateFormatByComb(String combValue) {
        switch (combValue) {
            case "2": {
                return new SimpleDateFormat("dd/MM/yyyy");
            }
            case "3": {
                return new SimpleDateFormat("MM/dd/yyyy");
            }
        }
        return new SimpleDateFormat("yyyy/MM/dd");
    }

    public String formatDate(String dimensionType, String fieldValue, SimpleDateFormat sdf) {
        if (FSADimensionTypeEnum.DATE_DIM.getCodeString().equals(dimensionType)) {
            Date date = IDataValueUtil.getDate((String)fieldValue);
            fieldValue = date != null ? sdf.format(date) : "";
        }
        return fieldValue;
    }
}

