/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.model;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.disf.utils.IDataValueUtil;
import kd.data.disf.utils.Tuple;
import kd.data.fsa.model.sync.FSADataSyncTaskDimFilterModel;
import kd.data.fsa.model.sync.FSADataSyncTaskMemberModel;
import kd.data.fsa.model.sync.FSADataSyncTaskParamModel;
import kd.data.fsa.olap.OlapServerBaseMetaInfo;
import kd.data.fsa.olap.OlapServerDimMemberMetaInfo;
import kd.data.fsa.olap.OlapServerDimemsionMetaInfo;
import kd.data.fsa.utils.FSABcmDataProvider;
import kd.data.fsa.utils.FSADataCollectionHelper;

public class HierarchyTreeIterator {
    private String dimensionNumber;
    private Integer hierarchyIndex;
    private Map<Integer, Map<String, Set<String>>> hierarchyTree;
    private Map<String, Tuple<String, String>> childParentMap;
    private Set<String> shareMemberNumberSet;

    public HierarchyTreeIterator() {
    }

    public HierarchyTreeIterator(String dimensionNumber) {
        this.dimensionNumber = dimensionNumber;
        this.hierarchyTree = new HashMap<Integer, Map<String, Set<String>>>(16);
        this.childParentMap = new HashMap<String, Tuple<String, String>>(16);
    }

    public void initTree(Long syncParamId, Long logId) {
        DynamicObject syncParam = BusinessDataServiceHelper.loadSingle((Object)syncParamId, (String)"fsa_syncparam");
        if (syncParam == null) {
            return;
        }
        Map<String, OlapServerDimMemberMetaInfo> dimensionMetaInfoMap = null;
        Map<String, Object> paramMap = FSADataCollectionHelper.getSrcParamFromCol(syncParam.getLong("datacollection_id"));
        Long moduleId = paramMap == null ? null : IDataValueUtil.getLong((Object)paramMap.get("moduleId"));
        OlapServerDimemsionMetaInfo dimMeta = FSABcmDataProvider.loadModuleDimensionMeta(moduleId, this.dimensionNumber);
        if (dimMeta != null) {
            Long viewId = paramMap == null ? null : IDataValueUtil.getLong((Object)paramMap.get("OrgView"));
            dimensionMetaInfoMap = FSABcmDataProvider.loadDimensionMembers(moduleId, viewId, dimMeta.getDimEntityName(), dimMeta.getId());
        }
        if (dimensionMetaInfoMap == null || dimensionMetaInfoMap.isEmpty()) {
            return;
        }
        this.shareMemberNumberSet = dimensionMetaInfoMap.values().stream().filter(p -> p.getStorageType().equals("3")).map(OlapServerBaseMetaInfo::getNumber).collect(Collectors.toSet());
        HashSet<String> parentLongNumberSet = new HashSet<String>(16);
        DynamicObjectCollection dimEntryCol = syncParam.getDynamicObjectCollection("dimentry");
        if (dimEntryCol != null && !dimEntryCol.isEmpty()) {
            for (DynamicObject dynamicObject : dimEntryCol) {
                if (!this.dimensionNumber.equalsIgnoreCase(dynamicObject.getString("olddimnumber"))) continue;
                String filterMode = dynamicObject.getString("filtermode");
                if (logId != null && "2".equals(filterMode)) {
                    List<FSADataSyncTaskDimFilterModel> dimFilter;
                    FSADataSyncTaskParamModel syncTaskParamModel;
                    Object paramDetailJson;
                    DynamicObject log = BusinessDataServiceHelper.loadSingleFromCache((Object)logId, (String)"fsa_rptdata_synclog", (String)"paramdetail_tag");
                    if (log == null || !StringUtils.isNotEmpty((String)(paramDetailJson = log.getString("paramdetail_tag"))) || (syncTaskParamModel = (FSADataSyncTaskParamModel)JSONObject.parseObject((String)paramDetailJson, (TypeReference)new TypeReference<FSADataSyncTaskParamModel>(){}, (Feature[])new Feature[0])) == null || (dimFilter = syncTaskParamModel.getDimFilter()) == null || dimFilter.isEmpty()) break;
                    List<FSADataSyncTaskMemberModel> membersModel = null;
                    for (FSADataSyncTaskDimFilterModel dimFilterModel : dimFilter) {
                        if (!this.dimensionNumber.equalsIgnoreCase(dimFilterModel.getOlddimnumber())) continue;
                        membersModel = dimFilterModel.getMembers();
                        break;
                    }
                    if (membersModel == null || membersModel.isEmpty()) break;
                    for (FSADataSyncTaskMemberModel taskMemberModel : membersModel) {
                        this.initHierarchyTree(taskMemberModel.getLongNumber(), dimensionMetaInfoMap, parentLongNumberSet);
                    }
                } else {
                    DynamicObjectCollection dimFilterEntryCol;
                    if (!"1".equals(filterMode) || (dimFilterEntryCol = dynamicObject.getDynamicObjectCollection("dimfilterentry")) == null || dimFilterEntryCol.isEmpty()) break;
                    for (DynamicObject dimFilterObj : dimFilterEntryCol) {
                        String longNumber = dimFilterObj.getString("memberlongnumber");
                        this.initHierarchyTree(longNumber, dimensionMetaInfoMap, parentLongNumberSet);
                    }
                }
                break;
            }
        }
        if (this.hierarchyTree.isEmpty()) {
            for (Map.Entry<String, OlapServerDimMemberMetaInfo> entry : dimensionMetaInfoMap.entrySet()) {
                OlapServerDimMemberMetaInfo metaInfo = entry.getValue();
                this.initHierarchyTree(metaInfo.getLongNumber(), dimensionMetaInfoMap, parentLongNumberSet);
            }
        }
        if (!this.hierarchyTree.isEmpty() && !parentLongNumberSet.isEmpty()) {
            for (Map.Entry<Object, Object> entry : this.hierarchyTree.entrySet()) {
                Map levelMap = (Map)entry.getValue();
                if (levelMap == null || levelMap.isEmpty()) continue;
                for (Map.Entry levelEn : levelMap.entrySet()) {
                    ((Set)levelEn.getValue()).removeAll(parentLongNumberSet);
                }
            }
        }
        this.hierarchyIndex = this.getMaxLevel();
    }

    public void initHierarchyTree(String longNumber, Map<String, OlapServerDimMemberMetaInfo> dmInfoMap, Set<String> parentLongNumberSet) {
        if (StringUtils.isNotEmpty((String)longNumber)) {
            OlapServerDimMemberMetaInfo metaInfo;
            String[] longNumberArr = longNumber.split("!");
            int longNumberLength = longNumberArr.length;
            if (longNumberLength > 1 && (metaInfo = dmInfoMap.get(longNumber)) != null) {
                this.childParentMap.put(metaInfo.getId().toString(), (Tuple<String, String>)new Tuple((Object)metaInfo.getParent().toString(), (Object)longNumberArr[longNumberLength - 1]));
            }
            for (int i = 1; i < longNumberLength - 1; ++i) {
                String nodeId;
                Set<String> childMemberNumberSet;
                String nodeShortNumber = longNumberArr[i];
                String nodeLongNumber = longNumber.substring(0, longNumber.indexOf(nodeShortNumber)) + nodeShortNumber;
                parentLongNumberSet.add(nodeLongNumber);
                OlapServerDimMemberMetaInfo metaInfo2 = dmInfoMap.get(nodeLongNumber);
                if (metaInfo2 == null) continue;
                int level = i - 1;
                Map<String, Set<String>> levelMap = this.hierarchyTree.get(level);
                if (levelMap == null) {
                    levelMap = new HashMap<String, Set<String>>(4);
                    this.hierarchyTree.put(level, levelMap);
                }
                if ((childMemberNumberSet = levelMap.get(nodeId = metaInfo2.getId().toString())) == null) {
                    childMemberNumberSet = new HashSet<String>(4);
                    levelMap.put(nodeId, childMemberNumberSet);
                }
                String childShortNumber = longNumberArr[i + 1];
                String childLongNumber = longNumber.substring(0, longNumber.indexOf(childShortNumber)) + childShortNumber;
                childMemberNumberSet.add(childLongNumber);
            }
        }
    }

    public Integer getMaxLevel() {
        int maxLevel = 0;
        if (this.hierarchyTree != null && !this.hierarchyTree.isEmpty()) {
            for (Integer currentLevel : this.hierarchyTree.keySet()) {
                if (maxLevel >= currentLevel) continue;
                maxLevel = currentLevel;
            }
        }
        return maxLevel;
    }

    public Map<String, Set<String>> hierarchyNext() {
        if (this.hierarchyIndex < 0) {
            return null;
        }
        Map<String, Set<String>> hierarchyMap = this.hierarchyTree.get(this.hierarchyIndex);
        Integer n = this.hierarchyIndex;
        Integer n2 = this.hierarchyIndex = Integer.valueOf(this.hierarchyIndex - 1);
        return hierarchyMap;
    }

    public Tuple<String, String> matchParent(String childNumber) {
        return this.childParentMap.get(childNumber);
    }

    public String getDimensionNumber() {
        return this.dimensionNumber;
    }

    public Map<Integer, Map<String, Set<String>>> getHierarchyTree() {
        return this.hierarchyTree;
    }

    public Map<String, Tuple<String, String>> getChildParentMap() {
        return this.childParentMap;
    }

    public Set<String> getShareMemberNumberSet() {
        return this.shareMemberNumberSet;
    }

    public void setShareMemberNumberSet(Set<String> shareMemberNumberSet) {
        this.shareMemberNumberSet = shareMemberNumberSet;
    }
}

