/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.model;

import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import kd.data.disf.utils.Tuple;

public abstract class UnionFindSetModel<V> {
    public HashMap<V, Element<V>> elementMap;
    public HashMap<Element<V>, Element<V>> fatherMap;
    public HashMap<Element<V>, Integer> sizeMap;

    public UnionFindSetModel(List<V> list) {
        this.elementMap = new HashMap(list.size());
        this.fatherMap = new HashMap(list.size());
        this.sizeMap = new HashMap(list.size());
        for (V v : list) {
            Element<V> element = new Element<V>(v);
            this.elementMap.put((Element<V>)v, (Element<Element<V>>)element);
            this.fatherMap.put(element, element);
            this.sizeMap.put(element, 1);
        }
    }

    public Element<V> findFather(Element<V> cur) {
        Stack<Element<V>> path = new Stack<Element<V>>();
        while (cur != this.fatherMap.get(cur)) {
            path.push(cur);
            cur = this.fatherMap.get(cur);
        }
        while (!path.isEmpty()) {
            this.fatherMap.put((Element<Element<V>>)path.pop(), (Element<Element<V>>)cur);
        }
        return cur;
    }

    private boolean isSameCollection(Element<V> cur1, Element<V> cur2) {
        return this.findFather(cur1).equals(this.findFather(cur2));
    }

    public boolean union(V a, V b) {
        Element<V> elementB;
        Element<V> elementA = this.elementMap.get(a);
        if (!this.isSameCollection(elementA, elementB = this.elementMap.get(b)) && this.checkElementCanBeUnion(elementA, elementB)) {
            Tuple<Element<V>, Element<V>> elementElementTuple = this.checkFatherAndChild(a, b);
            Element bigfather = (Element)elementElementTuple.getK();
            Element smallfather = (Element)elementElementTuple.getV();
            this.fatherMap.put(smallfather, bigfather);
            int aSetSize = this.sizeMap.get(bigfather);
            int bSetSize = this.sizeMap.get(smallfather);
            this.sizeMap.put(bigfather, aSetSize + bSetSize);
            this.sizeMap.remove(smallfather);
            return true;
        }
        return false;
    }

    public int sets() {
        return this.sizeMap.size();
    }

    public Tuple<Element<V>, Element<V>> checkFatherAndChild(V a, V b) {
        int bSetSize;
        Element<V> aHead = this.findFather(this.elementMap.get(a));
        Element<V> bHead = this.findFather(this.elementMap.get(b));
        int aSetSize = this.sizeMap.get(aHead);
        Element<V> big = aSetSize >= (bSetSize = this.sizeMap.get(bHead).intValue()) ? aHead : bHead;
        Element<V> small = big == aHead ? bHead : aHead;
        return new Tuple(big, small);
    }

    public abstract boolean checkElementCanBeUnion(Element<V> var1, Element<V> var2);

    public static class Element<V> {
        public V value;

        public Element(V value) {
            this.value = value;
        }
    }
}

