/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.model.file;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.parser.Feature;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.data.disf.model.impl.IDataBaseModel;

public class FSAFileInfoModel
extends IDataBaseModel<Object, Object, Object> {
    private static final long serialVersionUID = -6723361737685905636L;
    @JSONField(serialize=false)
    @JsonIgnore
    private String fileName;
    @JSONField(serialize=false)
    @JsonIgnore
    private String fileUrl;
    @JSONField(serialize=false)
    @JsonIgnore
    private String urlMapJson;
    @JSONField(serialize=false)
    @JsonIgnore
    private Integer titleRow;
    @JSONField(serialize=false)
    @JsonIgnore
    private Integer previewRow;
    @JSONField(serialize=false)
    @JsonIgnore
    private List<String> sheetNameList;
    @JSONField(serialize=false)
    @JsonIgnore
    private String sheetName;
    @JSONField(serialize=false)
    @JsonIgnore
    private List<String> columnList;
    @JSONField(serialize=false)
    @JsonIgnore
    private List<Class> classList;
    @JSONField(serialize=false)
    @JsonIgnore
    private List<String[]> dataList;
    @JSONField(serialize=false)
    @JsonIgnore
    private Integer dataCount;

    public FSAFileInfoModel() {
    }

    public FSAFileInfoModel(String fileName, String fileUrl, List<String> sheetNameList, int dataCount) {
        this.fileName = fileName;
        this.fileUrl = fileUrl;
        this.sheetNameList = sheetNameList;
        this.dataCount = dataCount;
    }

    public FSAFileInfoModel(String fileName, String fileUrl, List<String> sheetNameList, String sheetName, int dataCount) {
        this.fileName = fileName;
        this.fileUrl = fileUrl;
        this.sheetNameList = sheetNameList;
        this.sheetName = sheetName;
        this.dataCount = dataCount;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    protected int getArraySize() {
        return super.getArraySize() + 11;
    }

    protected Object[] appendSerializedArray(Object[] targetArray) {
        super.appendSerializedArray(targetArray);
        int i = super.getArraySize();
        targetArray[i++] = this.fileName;
        targetArray[i++] = this.fileUrl;
        targetArray[i++] = this.urlMapJson;
        targetArray[i++] = this.titleRow;
        targetArray[i++] = this.previewRow;
        targetArray[i++] = this.sheetNameList;
        targetArray[i++] = this.sheetName;
        targetArray[i++] = this.columnList;
        targetArray[i++] = this.classList;
        targetArray[i++] = this.dataList;
        targetArray[i] = this.dataCount;
        return targetArray;
    }

    protected void updateValueArray(Object[] v) {
        super.updateValueArray(v);
        int i = super.getArraySize();
        this.fileName = this.getString(v, i++);
        this.fileUrl = this.getString(v, i++);
        this.urlMapJson = this.getString(v, i++);
        try {
            JSON.parseObject((String)this.urlMapJson, (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]);
        }
        catch (Exception e) {
            this.urlMapJson = null;
        }
        int n = --i;
        this.titleRow = this.getInteger(v, n);
        int n2 = ++i;
        this.previewRow = this.getInteger(v, n2);
        int n3 = ++i;
        this.sheetNameList = Arrays.asList(this.getArrayObject(v, n3, String.class));
        int n4 = ++i;
        this.sheetName = this.getString(v, n4);
        int n5 = ++i;
        ++i;
        String[] columnArr = (String[])this.getArrayObject(v, n5, String.class);
        this.columnList = columnArr == null ? null : Arrays.asList(columnArr);
        List classStrList = (List)v[i++];
        if (classStrList != null) {
            this.classList = new ArrayList<Class>(classStrList.size());
            for (Object classStr : classStrList) {
                Class<Object> clazz;
                try {
                    clazz = Class.forName(classStr.toString());
                }
                catch (ClassNotFoundException e) {
                    clazz = String.class;
                }
                this.classList.add(clazz);
            }
        }
        this.dataList = (List)v[i++];
        if (this.dataList != null) {
            ArrayList<String[]> dataListNew = new ArrayList<String[]>(this.dataList.size());
            for (String[] data : this.dataList) {
                if (!(data instanceof JSONArray)) continue;
                JSONArray dataJsonArr = (JSONArray)data;
                List list = dataJsonArr.toJavaList(String.class);
                dataListNew.add(list.toArray(new String[0]));
            }
            this.dataList = dataListNew;
        }
        this.dataCount = this.getInteger(v, i);
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public String getFileUrl() {
        return this.fileUrl;
    }

    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public String getUrlMapJson() {
        return this.urlMapJson;
    }

    public void setUrlMapJson(String urlMapJson) {
        this.urlMapJson = urlMapJson;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public Integer getTitleRow() {
        return this.titleRow;
    }

    public void setTitleRow(Integer titleRow) {
        this.titleRow = titleRow;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public Integer getPreviewRow() {
        return this.previewRow;
    }

    public void setPreviewRow(Integer previewRow) {
        this.previewRow = previewRow;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public List<String> getSheetNameList() {
        return this.sheetNameList;
    }

    public void setSheetNameList(List<String> sheetNameList) {
        this.sheetNameList = sheetNameList;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public List<String> getColumnList() {
        return this.columnList;
    }

    public void setColumnList(List<String> columnList) {
        this.columnList = columnList;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public List<Class> getClassList() {
        return this.classList;
    }

    public void setClassList(List<Class> classList) {
        this.classList = classList;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public List<String[]> getDataList() {
        return this.dataList;
    }

    public void setDataList(List<String[]> dataList) {
        this.dataList = dataList;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public Integer getDataCount() {
        return this.dataCount;
    }

    public void setDataCount(Integer dataCount) {
        this.dataCount = dataCount;
    }

    public String toString() {
        return "FSAFileInfoModel{fileName='" + this.fileName + '\'' + ", fileUrl='" + this.fileUrl + '\'' + ", urlMapJson='" + this.urlMapJson + '\'' + ", titleRow=" + this.titleRow + ", previewRow=" + this.previewRow + ", sheetNameList=" + this.sheetNameList + ", sheetName='" + this.sheetName + '\'' + ", columnList=" + this.columnList + ", classList=" + this.classList + ", dataList=" + this.dataList + ", dataCount=" + this.dataCount + '}';
    }
}

