/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.model.rpt.config;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.data.disf.fetcher.IElementKeyFetcher;
import kd.data.disf.model.impl.BasePropModel;
import kd.data.disf.model.impl.IDataBaseModel;
import kd.data.disf.model.impl.IDataBaseMutableArrayMap;
import kd.data.disf.utils.IDataJsonArraySerialization;
import kd.data.fsa.common.enums.FSAStandardReportTypeEnum;
import kd.data.fsa.model.rpt.config.FSABasePropNumberValueKeyFetcher;
import kd.data.fsa.model.rpt.config.FSABaseReportItemModel;

public class FSABaseReportModel<I extends FSABaseReportItemModel>
extends IDataBaseModel<FSAStandardReportTypeEnum, Long, BasePropModel> {
    private static final long serialVersionUID = 298368457037293634L;
    @JSONField(serialize=false)
    @JsonIgnore
    protected IDataBaseMutableArrayMap<String, I> reportItems;
    @JSONField(serialize=false)
    @JsonIgnore
    protected BasePropModel acctBookType;
    @JSONField(serialize=false)
    @JsonIgnore
    protected BasePropModel orgview;
    @JSONField(serialize=false)
    @JsonIgnore
    protected BasePropModel accountTable;
    private static final IElementKeyFetcher<String, FSABaseReportItemModel> rptItemKeyFetcher = new FSABasePropNumberValueKeyFetcher<FSABaseReportItemModel>();

    public FSABaseReportModel() {
        this.initialization();
    }

    public FSABaseReportModel(FSAStandardReportTypeEnum reportType, Long reportId, BasePropModel org, BasePropModel acctBookType) {
        super((Object)reportType, (Object)reportId, (Object)org);
        this.acctBookType = acctBookType;
        this.initialization();
    }

    public FSABaseReportModel(JSONArray jsonArray) {
        super(jsonArray);
    }

    public FSABaseReportModel(Object[] v) {
        super(v);
        this.initialization();
    }

    protected Class<I> getReportItemClassType() {
        return FSABaseReportItemModel.class;
    }

    protected I createReportItem(DynamicObject srcDyn) {
        FSABaseReportItemModel baseReportItemModel = new FSABaseReportItemModel();
        baseReportItemModel.loadFromDynamicObject(srcDyn, true);
        return (I)((Object)baseReportItemModel);
    }

    @JSONField(serialize=false)
    @JsonIgnore
    protected IElementKeyFetcher<String, I> getReportItemKeyFetcher() {
        return rptItemKeyFetcher;
    }

    private final void initialization() {
        this.reportItems = new IDataBaseMutableArrayMap(this.getReportItemClassType(), this.getReportItemKeyFetcher());
    }

    protected void fetchBaseValueFromDynamicObject(DynamicObject sourceDynamicObject) {
        DynamicObject accountTableObj;
        DynamicObject bookTypeObj;
        DynamicObject orgViewObj;
        this.v1 = FSAStandardReportTypeEnum.parseGLReportType(this.getString(sourceDynamicObject, "type"));
        this.v2 = this.getLong(sourceDynamicObject, "id");
        DynamicObject orgObj = this.getDynamicObject(sourceDynamicObject, "org");
        if (orgObj != null) {
            this.v3 = this.getBasePropObject(BasePropModel.class);
            ((BasePropModel)this.v3).loadFromDynamicObject(orgObj, true);
        }
        if ((orgViewObj = this.getDynamicObject(sourceDynamicObject, "orgview")) != null) {
            this.orgview = (BasePropModel)this.getBasePropObject(BasePropModel.class);
            this.orgview.loadFromDynamicObject(orgViewObj, true);
        }
        if ((bookTypeObj = this.getDynamicObject(sourceDynamicObject, "booktype")) != null) {
            this.acctBookType = (BasePropModel)this.getBasePropObject(BasePropModel.class);
            this.acctBookType.loadFromDynamicObject(bookTypeObj, true);
        }
        if ((accountTableObj = this.getDynamicObject(sourceDynamicObject, "accounttable")) != null) {
            this.accountTable = (BasePropModel)this.getBasePropObject(BasePropModel.class);
            this.accountTable.loadFromDynamicObject(accountTableObj, true);
        }
    }

    public void loadFromDynamicObject(DynamicObject sourceDynamicObject, boolean fetchBaseValue) {
        if (sourceDynamicObject != null) {
            this.fetchBaseValueFromDynamicObject(sourceDynamicObject);
            this.fetchValueFromDynamicObject(sourceDynamicObject);
        }
    }

    protected void fetchValueFromDynamicObject(DynamicObject sourceDynamicObject) {
        DynamicObjectCollection dyns = sourceDynamicObject.getDynamicObjectCollection("fsa_stdrptent");
        if (dyns != null && !dyns.isEmpty()) {
            for (DynamicObject dyn : dyns) {
                DynamicObject rptItemDyn = this.getDynamicObject(dyn, "rptitem");
                if (rptItemDyn == null) continue;
                I rptItem = this.createReportItem(rptItemDyn);
                this.reportItems.cache(rptItem);
                ((FSABaseReportItemModel)((Object)rptItem)).setSeq(this.getInteger(dyn, "seq"));
            }
            this.reportItems.flushCacheToArray();
        }
    }

    @JSONField(serialize=false)
    @JsonIgnore
    protected int getArraySize() {
        return 7;
    }

    protected Object[] appendSerializedArray(Object[] targetArray) {
        targetArray[0] = this.v1;
        targetArray[1] = this.v2;
        targetArray[2] = this.v3;
        int i = super.getArraySize();
        targetArray[i++] = this.acctBookType;
        targetArray[i++] = this.orgview;
        targetArray[i++] = this.accountTable;
        targetArray[i] = this.reportItems;
        return targetArray;
    }

    protected void updateValueArray(Object[] v) {
        this.v1 = FSAStandardReportTypeEnum.getEnum(this.getByte(v, 0));
        this.v2 = this.getLong(v, 1);
        this.v3 = this.getBasePropModel(v, 2);
        int i = super.getArraySize();
        this.acctBookType = this.getBasePropModel(v, i++);
        this.orgview = this.getBasePropModel(v, i++);
        this.accountTable = this.getBasePropModel(v, i++);
        this.initialization();
        this.reportItems.clear();
        this.parseFromJSONArray(this.getJSONArray(v, i), (IDataJsonArraySerialization)this.reportItems);
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public FSAStandardReportTypeEnum getReportType() {
        return (FSAStandardReportTypeEnum)((Object)this.v1);
    }

    public void setReportType(FSAStandardReportTypeEnum reportType) {
        this.v1 = reportType;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public Long getId() {
        return (Long)this.v2;
    }

    public void setId(Long id) {
        this.v2 = id;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public BasePropModel getOrg() {
        return (BasePropModel)this.v3;
    }

    public void setOrg(BasePropModel org) {
        this.v3 = org;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public IDataBaseMutableArrayMap<String, I> getReportItems() {
        return this.reportItems;
    }

    public void setReportItems(IDataBaseMutableArrayMap<String, I> reportItems) {
        this.reportItems = reportItems;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public BasePropModel getAcctBookType() {
        return this.acctBookType;
    }

    public void setAcctBookType(BasePropModel acctBookType) {
        this.acctBookType = acctBookType;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public BasePropModel getOrgview() {
        return this.orgview;
    }

    public void setOrgview(BasePropModel orgview) {
        this.orgview = orgview;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public BasePropModel getAccountTable() {
        return this.accountTable;
    }

    public void setAccountTable(BasePropModel accountTable) {
        this.accountTable = accountTable;
    }
}

