/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.model.rpt.config;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.data.disf.fetcher.IElementKeyFetcher;
import kd.data.disf.model.impl.BasePropModel;
import kd.data.disf.model.impl.IDataBaseMutableArrayMap;
import kd.data.disf.utils.IDataJsonArraySerialization;
import kd.data.disf.utils.IDataValueUtil;
import kd.data.fsa.model.rpt.config.FSABaseStdRptIndicator;
import kd.data.fsa.model.rpt.config.FSAPeriod;
import kd.data.fsa.model.rpt.config.FSAStandardReportModel;

public class FSAStdRptAnalysisScheme
extends BasePropModel {
    private static final long serialVersionUID = -2620092996122487256L;
    private static final IElementKeyFetcher<String, FSABaseStdRptIndicator> indicatorKeyFetcher = new IElementKeyFetcher<String, FSABaseStdRptIndicator>(){
        private static final long serialVersionUID = -5700294738345556211L;

        public String[] getKey(FSABaseStdRptIndicator var1) {
            return new String[]{var1.getNumber()};
        }

        public String stringToKey(String var1) {
            return var1;
        }

        public Class<String> getKeyClassType() {
            return String.class;
        }
    };
    private FSAPeriod startPeriod;
    private FSAPeriod endPeriod;
    private Long rptModelId;
    private IDataBaseMutableArrayMap<String, FSABaseStdRptIndicator> indicators;
    private FSAStandardReportModel rptModel;
    private List<Long> orgIds;

    public FSAStdRptAnalysisScheme() {
        this.initialization();
    }

    public FSAStdRptAnalysisScheme(JSONArray jsonArray) {
        super(jsonArray);
    }

    public FSAStdRptAnalysisScheme(Object id, String number, Object name) {
        super(id, number, name);
        this.initialization();
    }

    public FSAStdRptAnalysisScheme(Object[] v) {
        super(v);
        this.initialization();
    }

    private final void initialization() {
        this.indicators = new IDataBaseMutableArrayMap(FSABaseStdRptIndicator.class, indicatorKeyFetcher);
    }

    protected void fetchValueFromDynamicObject(DynamicObject sourceDynamicObject) {
        DynamicObjectCollection indicatorsCollection;
        DynamicObject endPeriodObj;
        super.fetchValueFromDynamicObject(sourceDynamicObject);
        DynamicObject startPeriodObj = this.getDynamicObject(sourceDynamicObject, "startPeriod");
        if (startPeriodObj != null) {
            this.startPeriod = (FSAPeriod)((Object)this.getBasePropObject(FSAPeriod.class));
            this.startPeriod.loadFromDynamicObject(startPeriodObj, true);
        }
        if ((endPeriodObj = this.getDynamicObject(sourceDynamicObject, "endPeriod")) != null) {
            this.endPeriod = (FSAPeriod)((Object)this.getBasePropObject(FSAPeriod.class));
            this.endPeriod.loadFromDynamicObject(endPeriodObj, true);
        }
        if ((indicatorsCollection = this.getDynamicObjectCollection(sourceDynamicObject, "rptindicators")) != null && !indicatorsCollection.isEmpty()) {
            for (DynamicObject indicatorDyn : indicatorsCollection) {
                FSABaseStdRptIndicator stdRptIndicator = new FSABaseStdRptIndicator();
                stdRptIndicator.loadFromDynamicObject(indicatorDyn.getDynamicObject("fbasedataid"), true);
                this.indicators.cache((Object)stdRptIndicator);
            }
            this.indicators.flushCacheToArray();
        }
    }

    @JSONField(serialize=false)
    @JsonIgnore
    protected int getArraySize() {
        return 8;
    }

    protected Object[] appendSerializedArray(Object[] targetArray) {
        super.appendSerializedArray(targetArray);
        int i = super.getArraySize();
        targetArray[i++] = this.startPeriod;
        targetArray[i++] = this.endPeriod;
        targetArray[i++] = this.rptModelId;
        targetArray[i++] = this.orgIds == null ? null : this.orgIds.toArray();
        targetArray[i] = this.indicators;
        return targetArray;
    }

    protected void updateValueArray(Object[] v) {
        super.updateValueArray(v);
        int i = super.getArraySize();
        this.startPeriod = (FSAPeriod)((Object)this.getBasePropObject(v, i++, FSAPeriod.class));
        this.endPeriod = (FSAPeriod)((Object)this.getBasePropObject(v, i++, FSAPeriod.class));
        this.rptModelId = this.getLong(v, i++);
        JSONArray ids = this.getJSONArray(v, i++);
        if (ids != null && !ids.isEmpty()) {
            this.orgIds = new ArrayList<Long>(ids.size());
            Iterator it = ids.iterator();
            while (it.hasNext()) {
                this.orgIds.add(IDataValueUtil.getLong(it.next()));
            }
        } else {
            this.orgIds = new ArrayList<Long>(0);
        }
        this.initialization();
        this.indicators.clear();
        this.parseFromJSONArray(this.getJSONArray(v, i), (IDataJsonArraySerialization)this.indicators);
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public FSAPeriod getStartPeriod() {
        return this.startPeriod;
    }

    public void setStartPeriod(FSAPeriod startPeriod) {
        this.startPeriod = startPeriod;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public FSAPeriod getEndPeriod() {
        return this.endPeriod;
    }

    public void setEndPeriod(FSAPeriod endPeriod) {
        this.endPeriod = endPeriod;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public Long getRptModelId() {
        return this.rptModelId;
    }

    public void setRptModelId(Long rptModelId) {
        this.rptModelId = rptModelId;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public IDataBaseMutableArrayMap<String, FSABaseStdRptIndicator> getIndicators() {
        return this.indicators;
    }

    public void setIndicators(IDataBaseMutableArrayMap<String, FSABaseStdRptIndicator> indicators) {
        this.indicators = indicators;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public FSAStandardReportModel getRptModel() {
        return this.rptModel;
    }

    public void setRptModel(FSAStandardReportModel rptModel) {
        this.rptModel = rptModel;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public List<Long> getOrgIds() {
        return this.orgIds;
    }

    public void setOrgIds(List<Long> orgIds) {
        this.orgIds = orgIds;
    }
}

