/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.model.rpt.config.gl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.data.disf.model.impl.BasePropModel;
import kd.data.disf.model.impl.IDataBaseMutableArrayMap;
import kd.data.disf.utils.IDataJsonArraySerialization;
import kd.data.fsa.common.enums.FSAStandardReportTypeEnum;
import kd.data.fsa.model.rpt.config.gl.FSABaseGLReportModel;
import kd.data.fsa.model.rpt.config.gl.FSAGLBaseReportItemModel;

public class FSAGLBalanceSheetReportModel
extends FSABaseGLReportModel {
    private static final long serialVersionUID = 3593803200630123038L;
    protected IDataBaseMutableArrayMap<String, FSAGLBaseReportItemModel> equityReportItems;

    public FSAGLBalanceSheetReportModel() {
        this.initialization();
    }

    public FSAGLBalanceSheetReportModel(FSAStandardReportTypeEnum reportType, Long reportId, BasePropModel org, BasePropModel acctBookType) {
        super(reportType, reportId, org, acctBookType);
        this.initialization();
    }

    public FSAGLBalanceSheetReportModel(JSONArray jsonArray) {
        super(jsonArray);
        this.initialization();
    }

    public FSAGLBalanceSheetReportModel(Object[] v) {
        super(v);
        this.initialization();
    }

    private final void initialization() {
        this.setReportType(FSAStandardReportTypeEnum.Balance_Sheet);
        this.equityReportItems = new IDataBaseMutableArrayMap(this.getReportItemClassType(), this.getReportItemKeyFetcher());
    }

    @Override
    protected void fetchValueFromDynamicObject(DynamicObject sourceDynamicObject) {
        DynamicObjectCollection dyns = sourceDynamicObject.getDynamicObjectCollection("entryentity");
        if (dyns != null && !dyns.isEmpty()) {
            this.reportItems.clear(0);
            this.equityReportItems.clear(0);
            DynamicProperty assetProp = dyns.getDynamicObjectType().getProperty("asset");
            DynamicProperty equityProp = dyns.getDynamicObjectType().getProperty("equity");
            for (DynamicObject dyn : dyns) {
                FSAGLBaseReportItemModel rptItemBuf;
                Integer seq = this.getInteger(dyn, "seq");
                DynamicObject rptItemDyn = (DynamicObject)assetProp.getValueFast((Object)dyn);
                if (rptItemDyn != null) {
                    rptItemBuf = new FSAGLBaseReportItemModel();
                    rptItemBuf.loadFromDynamicObject(rptItemDyn, true);
                    this.reportItems.cache((Object)rptItemBuf);
                    rptItemBuf.setSeq(seq);
                }
                if ((rptItemDyn = (DynamicObject)equityProp.getValueFast((Object)dyn)) == null) continue;
                rptItemBuf = new FSAGLBaseReportItemModel();
                rptItemBuf.loadFromDynamicObject(rptItemDyn, true);
                this.equityReportItems.cache((Object)rptItemBuf);
                rptItemBuf.setSeq(seq);
            }
            this.reportItems.flushCacheToArray();
            this.equityReportItems.flushCacheToArray();
        } else {
            this.reportItems.clear(0);
            this.equityReportItems.clear(0);
        }
        this.v1 = FSAStandardReportTypeEnum.Balance_Sheet;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    protected int getArraySize() {
        return super.getArraySize() + 1;
    }

    @Override
    protected Object[] appendSerializedArray(Object[] targetArray) {
        super.appendSerializedArray(targetArray);
        int i = super.getArraySize();
        targetArray[i] = this.equityReportItems;
        return targetArray;
    }

    @Override
    protected void updateValueArray(Object[] v) {
        super.updateValueArray(v);
        int i = super.getArraySize();
        this.equityReportItems.clear();
        this.parseFromJSONArray(this.getJSONArray(v, i), (IDataJsonArraySerialization)this.equityReportItems);
    }

    public IDataBaseMutableArrayMap<String, FSAGLBaseReportItemModel> getEquityReportItems() {
        return this.equityReportItems;
    }

    public void setEquityReportItems(IDataBaseMutableArrayMap<String, FSAGLBaseReportItemModel> equityReportItems) {
        this.equityReportItems = equityReportItems;
    }
}

