/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.olap;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.exception.KDBizException;

public abstract class BaseMServiceJsonModel
implements Serializable {
    private static final long serialVersionUID = -8165314269932568534L;

    @JSONField(serialize=false)
    @JsonIgnore
    protected abstract int getArraySize();

    public void initFromJsonString(String jsonString) {
        this.initFromJsonArray(BaseMServiceJsonModel.toJSONArray(jsonString));
    }

    public void initFromJsonArray(JSONArray jsonArray) {
        if (jsonArray != null) {
            this.updateValueArray(jsonArray.toArray());
        }
    }

    protected Object[] appendSerializedArray(Object[] targetArray) {
        return targetArray;
    }

    protected void updateValueArray(Object[] v) {
    }

    public Object[] getV() {
        return this.appendSerializedArray(new Object[this.getArraySize()]);
    }

    public void setV(Object[] v) {
        if (v == null) {
            return;
        }
        if (v.length < this.getArraySize()) {
            throw new IllegalArgumentException(String.format("Expect %s Array Size:%s, but acutal size=%s", this.getClass().getName(), this.getArraySize(), v.length));
        }
        this.updateValueArray(v);
    }

    protected <K, R> void parseMapValue(JSONObject jsonObject, Map<K, R> outputMap, Function<String, K> keyParseFun, BiFunction<K, Object, R> valueParseFun) {
        if (jsonObject != null && !jsonObject.isEmpty()) {
            for (Map.Entry en : jsonObject.entrySet()) {
                K keyValue = keyParseFun.apply((String)en.getKey());
                outputMap.put(keyValue, valueParseFun.apply(keyValue, en.getValue()));
            }
        }
    }

    protected String getString(Object[] v, int index) {
        return this.getString(v[index]);
    }

    protected Date getDate(Object[] v, int index) {
        return BaseMServiceJsonModel.getDate(v[index]);
    }

    protected static Boolean getBoolean(Object[] v, int index) {
        return BaseMServiceJsonModel.getBoolean(v[index]);
    }

    protected static Date getDate(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return new Date((Long)value);
        }
        if (value instanceof Date) {
            return (Date)ObjectConverter.convert((Object)value, Date.class, (boolean)false);
        }
        if (value instanceof String) {
            return new Date(Long.parseLong((String)value));
        }
        return null;
    }

    protected Integer getInteger(Object[] v, int index) {
        return BaseMServiceJsonModel.getInteger(v[index]);
    }

    protected Long getLong(Object[] v, int index) {
        return BaseMServiceJsonModel.getLong(v[index]);
    }

    protected String getString(Object value) {
        return value != null ? String.valueOf(value) : null;
    }

    protected static Long getLong(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        return Long.valueOf(value.toString());
    }

    protected static Boolean getBoolean(Object value) {
        if (value != null) {
            switch (value.toString().toLowerCase(Locale.ENGLISH)) {
                case "1": 
                case "y": 
                case "yes": 
                case "t": 
                case "true": 
                case "ok": {
                    return Boolean.TRUE;
                }
            }
        }
        return Boolean.FALSE;
    }

    protected static Integer getInteger(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return Integer.getInteger(value.toString());
    }

    public static JSONObject toJSONObject(Object source) {
        if (source == null) {
            return null;
        }
        if (source instanceof JSONObject) {
            return (JSONObject)source;
        }
        throw new KDBizException(String.format("Expect JSONObject, but accutal=%s", source.getClass().getName()));
    }

    protected static boolean isJSonFormat(String srcString, String ... checkContainString) {
        if (srcString == null) {
            return false;
        }
        String strBuf = srcString.trim();
        if (!strBuf.startsWith("{") || !strBuf.endsWith("}")) {
            return false;
        }
        if (checkContainString != null && checkContainString.length > 0) {
            for (String s : checkContainString) {
                if (strBuf.contains(s)) continue;
                return false;
            }
        }
        return true;
    }

    public static JSONArray toJSONArray(Object source) {
        if (source == null) {
            return null;
        }
        if (source instanceof String) {
            String jsonStr = source.toString();
            if (BaseMServiceJsonModel.isJSonFormat(jsonStr, new String[0])) {
                return BaseMServiceJsonModel.toJSONArray(JSON.parseObject((String)jsonStr));
            }
        } else {
            if (source instanceof JSONArray) {
                return (JSONArray)source;
            }
            if (source instanceof JSONObject) {
                return ((JSONObject)source).getJSONArray("v");
            }
        }
        throw new KDBizException(String.format("Expect JSONObject or JSONArray, but accutal[Class=%s]=%s", source.getClass().getName(), source));
    }
}

