/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.olap;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.exception.KDBizException;
import kd.data.disf.model.impl.IDataMapEntry;

public class FSAOlapDataStatisticsInfo
implements Serializable {
    private static final long serialVersionUID = 6853016437933117646L;
    protected static final int TotalRecCnt = 0;
    protected static final int TotalDimComboCnt = 1;
    protected static final int SkipDimComboCnt = 2;
    protected static final int PrimaryDim = 0;
    protected static final int SecondaryDim = 1;
    public static final int ProcessMemGroup = 0;
    public static final int NeedSplitMemGroup = 1;
    protected long[] totalCnt;
    protected IDataMapEntry<String, Integer>[] dimInfo;
    protected Map<Object, Map<Object, Integer>> dimMemberComboStatistics;
    protected boolean hasSecondaryDim;

    public FSAOlapDataStatisticsInfo(IDataMapEntry<String, Integer> primayDim) {
        if (primayDim == null) {
            throw new KDBizException("\u672a\u6307\u5b9a\u4efb\u4f55\u67e5\u8be2\u7ef4\u5ea6");
        }
        this.dimInfo = new IDataMapEntry[2];
        this.dimInfo[0] = primayDim;
        this.hasSecondaryDim = false;
        this.dimMemberComboStatistics = new HashMap<Object, Map<Object, Integer>>(16);
        this.totalCnt = new long[3];
        this.totalCnt[0] = 0L;
        this.totalCnt[1] = 0L;
        this.totalCnt[2] = 0L;
    }

    public FSAOlapDataStatisticsInfo(IDataMapEntry<String, Integer> primayDim, IDataMapEntry<String, Integer> secondaryDim) {
        this(primayDim);
        if (secondaryDim == null) {
            throw new KDBizException("\u672a\u6307\u5b9a\u4efb\u4f55\u8f85\u52a9\u67e5\u8be2\u7ef4\u5ea6");
        }
        this.dimInfo[1] = secondaryDim;
        this.hasSecondaryDim = true;
    }

    public void updateDimMemberCnt(Object[] rowData) {
        Map dimMemBufMap = this.dimMemberComboStatistics.computeIfAbsent(rowData[(Integer)this.dimInfo[0].getValue()], v -> new HashMap(128));
        dimMemBufMap.compute(rowData[(Integer)this.dimInfo[this.hasSecondaryDim ? 1 : 0].getValue()], (k, v) -> (v == null ? 0 : v) + 1);
    }

    public void updateTotalCnt() {
        this.totalCnt[0] = this.totalCnt[0] + 1L;
    }

    public void updateSkipCnt() {
        this.totalCnt[2] = this.totalCnt[2] + 1L;
    }

    public void refreshStatistics() {
        int dimCombCnt = 0;
        if (this.hasSecondaryDim) {
            for (Map<Object, Integer> memMap : this.dimMemberComboStatistics.values()) {
                if (memMap == null) continue;
                dimCombCnt += memMap.size();
            }
        } else {
            dimCombCnt = this.dimMemberComboStatistics.size();
        }
        this.totalCnt[1] = dimCombCnt;
    }

    public void merge(FSAOlapDataStatisticsInfo srcStatisticInfo) {
        this.totalCnt[0] = this.totalCnt[0] + srcStatisticInfo.getTotalRecCnt();
        for (Map.Entry<Object, Map<Object, Integer>> en : srcStatisticInfo.dimMemberComboStatistics.entrySet()) {
            if (en.getValue().isEmpty()) continue;
            Map bufMap = this.dimMemberComboStatistics.computeIfAbsent(en.getKey(), v -> new HashMap(((Map)en.getValue()).size()));
            for (Map.Entry<Object, Integer> memEn : en.getValue().entrySet()) {
                bufMap.compute(memEn.getKey(), (key, value) -> (value == null ? 0 : value) + (Integer)memEn.getValue());
            }
        }
        this.refreshStatistics();
    }

    public String[] getDimNumbers() {
        String[] dimNumbers = new String[this.dimInfo.length];
        for (int i = 0; i < dimNumbers.length; ++i) {
            if (this.dimInfo[i] == null) continue;
            dimNumbers[i] = (String)this.dimInfo[i].getKey();
        }
        return dimNumbers;
    }

    public Map<Object, List<Map.Entry<Object, Integer>>>[] getSortedDimMemberStatistics(int splitGroupSize) {
        List<Map.Entry<Object, Integer>> sortBufList;
        LinkedHashMap<Object, List> sortBufMap = new LinkedHashMap<Object, List>(this.dimMemberComboStatistics.size());
        Map[] resultMaps = new Map[2];
        if (this.hasSecondaryDim) {
            for (Map.Entry<Object, Map<Object, Integer>> en : this.dimMemberComboStatistics.entrySet()) {
                sortBufList = sortBufMap.computeIfAbsent(en.getKey(), v -> new ArrayList(((Map)en.getValue()).entrySet()));
                Collections.sort(sortBufList, (src, target) -> (Integer)target.getValue() - (Integer)src.getValue());
            }
        } else {
            sortBufList = new ArrayList(this.dimMemberComboStatistics.size());
            for (Map.Entry<Object, Map<Object, Integer>> en : this.dimMemberComboStatistics.entrySet()) {
                sortBufList.add(en.getValue().entrySet().iterator().next());
            }
            Collections.sort(sortBufList, (src, target) -> (Integer)target.getValue() - (Integer)src.getValue());
            sortBufList.forEach(v -> sortBufMap.put(v.getKey(), Collections.singletonList(v)));
        }
        if (splitGroupSize < 0) {
            resultMaps[0] = sortBufMap;
            resultMaps[1] = Collections.emptyMap();
        } else {
            resultMaps[0] = new LinkedHashMap(sortBufMap.size());
            resultMaps[1] = new LinkedHashMap(sortBufMap.size());
            for (Map.Entry en : sortBufMap.entrySet()) {
                sortBufList = (List)en.getValue();
                if (sortBufList == null || sortBufList.isEmpty()) continue;
                LinkedList<Map.Entry> processBufList = new LinkedList<Map.Entry>();
                LinkedList<Map.Entry> splitBufList = new LinkedList<Map.Entry>();
                for (Map.Entry memEn : (List)en.getValue()) {
                    if ((Integer)memEn.getValue() > splitGroupSize) {
                        splitBufList.add(memEn);
                        continue;
                    }
                    processBufList.add(memEn);
                }
                if (!processBufList.isEmpty()) {
                    resultMaps[0].put(en.getKey(), processBufList);
                }
                if (splitBufList.isEmpty()) continue;
                resultMaps[1].put(en.getKey(), splitBufList);
            }
        }
        return resultMaps;
    }

    public String toString() {
        return "FSAOlapDataStatisticsInfo{totalCnt=" + Arrays.toString(this.totalCnt) + ", dimInfo=" + Arrays.toString(this.dimInfo) + ", dimMemberComboStatistics=" + this.dimMemberComboStatistics + ", hasSecondaryDim=" + this.hasSecondaryDim + '}';
    }

    public long getTotalRecCnt() {
        return this.totalCnt[0];
    }

    public long getSkipRecCnt() {
        return this.totalCnt[2];
    }

    public long getTotalDimComboCnt() {
        if (this.totalCnt.length > 1) {
            return this.totalCnt[1];
        }
        return 0L;
    }

    public IDataMapEntry<String, Integer>[] getDimInfo() {
        return this.dimInfo;
    }

    public Map<Object, Map<Object, Integer>> getDimMemberComboStatistics() {
        return this.dimMemberComboStatistics;
    }

    public boolean isHasSecondaryDim() {
        return this.hasSecondaryDim;
    }
}

