/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.olap;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.dataentity.resource.ResManager;
import kd.data.disf.cache.DistributeCache;
import kd.data.disf.cache.IDataCacheModule;
import kd.data.disf.event.IDataNotifyEventConsumer;
import kd.data.disf.event.NotifyEvent;
import kd.data.disf.utils.IDataDateUtil;
import kd.data.fsa.utils.FSAJSONUtils;

public class FSAOlapGetDataConsumer
implements IDataNotifyEventConsumer {
    protected DistributeCache cache = DistributeCache.getCache((IDataCacheModule)IDataCacheModule.FSA);
    private AtomicInteger olapGetDataBuriedPoint = new AtomicInteger(0);
    private int totalTaskBuriedPoint;
    private AtomicInteger hasSaveIntoDatabaseCount = new AtomicInteger(0);
    private long beginOlapGetDataTime;
    private AtomicLong executedTimeMills = new AtomicLong(0L);
    protected long taskId;
    private NumberFormat numberFormat = NumberFormat.getInstance();

    public FSAOlapGetDataConsumer(int totalTaskCount, long beginOlapGetDataTime, long taskId) {
        this.beginOlapGetDataTime = beginOlapGetDataTime;
        this.totalTaskBuriedPoint = totalTaskCount * 100;
        this.taskId = taskId;
        this.numberFormat.setMaximumFractionDigits(2);
    }

    public String getId() {
        return "olapGetData";
    }

    public void acceptErrorEvent(NotifyEvent notifyEvent, Throwable exception) {
    }

    public void acceptNotifyEvent(NotifyEvent notifyEvent) {
        String buriedPointStr = (String)notifyEvent.getEventParam();
        this.olapGetDataBuriedPoint.addAndGet(Integer.parseInt(buriedPointStr));
        String info = String.format(ResManager.loadKDString((String)"\u5df2\u8bfb\u53d6%1$d\u6761\u8bb0\u5f55,\u65f6\u957f%2$s", (String)"AbstractOlapDataQueryTask_0", (String)"data-fsa-formplugin", (Object[])new Object[0]), this.hasSaveIntoDatabaseCount.addAndGet((Integer)notifyEvent.getSource()), IDataDateUtil.getTimeDiff((long)this.executedTimeMills.addAndGet(System.currentTimeMillis() - this.beginOlapGetDataTime)));
        HashMap<String, String> mapInfo = new HashMap<String, String>(2);
        String percentFormat = this.numberFormat.format(BigDecimal.valueOf(this.olapGetDataBuriedPoint.doubleValue() / (double)this.totalTaskBuriedPoint).setScale(2, 4).doubleValue() * 100.0);
        mapInfo.put("completepercent", percentFormat);
        mapInfo.put("info", info);
        this.cache.put("task_" + this.taskId, (Object)FSAJSONUtils.toJsonString(mapInfo), 600);
    }
}

