/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.olap;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.data.disf.algo.IColumnValueConverter;
import kd.data.disf.model.impl.IDataMapEntry;
import kd.data.fsa.olap.BaseMServiceJsonModel;

public class OlapDimensionLookupMetaInfo
extends BaseMServiceJsonModel
implements IColumnValueConverter<String, Object[][]> {
    private static final long serialVersionUID = 7173886848678268717L;
    @JSONField(serialize=false)
    protected int[] dimLookupType;
    protected Map<String, BaseDimMemLookupValueItem>[] dimMemberLookupMaps;

    public Object[][] convert(int dimIndex, String dimMemberNumber, Object ... controlParam) {
        if (dimIndex < 0 || dimIndex >= this.dimMemberLookupMaps.length) {
            return null;
        }
        if (StringUtils.isEmpty((String)dimMemberNumber)) {
            return null;
        }
        BaseDimMemLookupValueItem valueItem = this.dimMemberLookupMaps[dimIndex].get(dimMemberNumber);
        return valueItem != null ? valueItem.getValueArray(controlParam) : (Object[][])null;
    }

    @Override
    protected int getArraySize() {
        return 2;
    }

    @Override
    protected Object[] appendSerializedArray(Object[] targetArray) {
        targetArray[0] = JSON.toJSONString(this.dimMemberLookupMaps);
        return targetArray;
    }

    @Override
    protected void updateValueArray(Object[] v) {
        JSONArray jsonArray = JSONArray.parseArray((String)v[0].toString());
        JSONArray lookupValueItemEnmu = JSONArray.parseArray((String)v[1].toString());
        this.dimMemberLookupMaps = new Map[lookupValueItemEnmu.size()];
        OlapDimensionLookupMetaInfo that = this;
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = (JSONObject)jsonArray.get(i);
            LinkedHashMap<String, BaseDimMemLookupValueItem> objectObjectHashMap = new LinkedHashMap<String, BaseDimMemLookupValueItem>(16);
            int finalI = i;
            this.parseMapValue(jsonObject, objectObjectHashMap, key -> key, (key, o) -> {
                JSONArray dimMemberLookups = (JSONArray)o;
                Class<? extends BaseDimMemLookupValueItem> clazz = ModelType.getEnum((Integer)lookupValueItemEnmu.get(finalI)).getClazz();
                BaseDimMemLookupValueItem baseDimMemLookupValueItem = null;
                try {
                    Constructor<? extends BaseDimMemLookupValueItem> constructor = clazz.getDeclaredConstructor(OlapDimensionLookupMetaInfo.class);
                    baseDimMemLookupValueItem = constructor.newInstance(that);
                }
                catch (Exception e) {
                    throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
                }
                Object[][] obj = new Object[dimMemberLookups.size()][];
                for (int i1 = 0; i1 < dimMemberLookups.size(); ++i1) {
                    JSONArray dimMemberLookup = dimMemberLookups.getJSONArray(i1);
                    Object[] obj2 = new Object[dimMemberLookup.size()];
                    for (int i2 = 0; i2 < dimMemberLookup.size(); ++i2) {
                        obj2[i2] = dimMemberLookup.get(i2);
                    }
                    obj[i1] = obj2;
                }
                baseDimMemLookupValueItem.packageArray(obj);
                return baseDimMemLookupValueItem;
            });
            this.dimMemberLookupMaps[i] = objectObjectHashMap;
        }
    }

    public Map<String, BaseDimMemLookupValueItem>[] getDimMemberLookupMaps() {
        return this.dimMemberLookupMaps;
    }

    public void setDimMemberLookupMaps(Map<String, BaseDimMemLookupValueItem>[] dimMemberLookupMaps) {
        this.dimMemberLookupMaps = dimMemberLookupMaps;
    }

    public int getCategoryCnt(int dimIndex) {
        return this.dimLookupType[dimIndex];
    }

    private static enum ModelType {
        SingleNameDimMemLookupValueItem(1, SingleNameDimMemLookupValueItem.class),
        SingleHierarchyDimMemLookupValueItem(2, SingleHierarchyDimMemLookupValueItem.class),
        PeriodDimMemLookupValueItem(3, PeriodDimMemLookupValueItem.class),
        PeriodHierarchyDimMemLookupValueItem(4, PeriodHierarchyDimMemLookupValueItem.class),
        EntityHierarchyDimMemLookupValueItem(5, EntityHierarchyDimMemLookupValueItem.class);

        int value;
        Class<? extends BaseDimMemLookupValueItem> clazz;

        private ModelType(int value, Class<? extends BaseDimMemLookupValueItem> clazz) {
            this.value = value;
            this.clazz = clazz;
        }

        public static ModelType getEnum(int code) {
            switch (code) {
                case 1: {
                    return SingleNameDimMemLookupValueItem;
                }
                case 2: {
                    return SingleHierarchyDimMemLookupValueItem;
                }
                case 3: {
                    return PeriodDimMemLookupValueItem;
                }
                case 4: {
                    return PeriodHierarchyDimMemLookupValueItem;
                }
                case 5: {
                    return EntityHierarchyDimMemLookupValueItem;
                }
            }
            return SingleNameDimMemLookupValueItem;
        }

        public Class<? extends BaseDimMemLookupValueItem> getClazz() {
            return this.clazz;
        }
    }

    protected class EntityHierarchyDimMemLookupValueItem
    extends BaseDimMemLookupValueItem {
        @JSONField(serialize=false)
        protected TreeMap<Integer, IDataMapEntry<String, SingleHierarchyDimMemLookupValueItem>> entityLookupMap;

        @Override
        protected void packageArray(Object[][] objects) {
            String name = (String)objects[0][1];
            JSONObject jsonObject = (JSONObject)objects[0][0];
            Iterator iterator = jsonObject.entrySet().iterator();
            this.entityLookupMap = new TreeMap();
            this.valueArray = objects;
            while (iterator.hasNext()) {
                Map.Entry next = (Map.Entry)iterator.next();
                Integer key = Integer.parseInt((String)next.getKey());
                JSONArray value = (JSONArray)next.getValue();
                String id = (String)value.get(0);
                String pid = (String)value.get(1);
                String status = (String)value.get(2);
                this.entityLookupMap.put(key, (IDataMapEntry<String, SingleHierarchyDimMemLookupValueItem>)new IDataMapEntry((Object)status, (Object)new SingleHierarchyDimMemLookupValueItem(id, pid, name)));
            }
        }

        @Override
        public Object[][] getValueArray(Object ... params) {
            Object param = params[0];
            if (!(param instanceof Integer)) {
                throw new KDBizException("The incoming parameter type is incorrect\uff01");
            }
            int periodCode = (Integer)param;
            Map.Entry<Integer, IDataMapEntry<String, SingleHierarchyDimMemLookupValueItem>> en = this.entityLookupMap.floorEntry(periodCode);
            if (en != null) {
                IDataMapEntry<String, SingleHierarchyDimMemLookupValueItem> tuple2 = en.getValue();
                String status = (String)tuple2.getKey();
                if (status.equals("4") || status.equals("6") || status.equals("7") || status.equals("10")) {
                    return null;
                }
                SingleHierarchyDimMemLookupValueItem valueItem = (SingleHierarchyDimMemLookupValueItem)tuple2.getValue();
                if (valueItem != null) {
                    return valueItem.getValueArray(new Object[0]);
                }
            }
            return null;
        }
    }

    protected class PeriodHierarchyDimMemLookupValueItem
    extends BaseDimMemLookupValueItem {
        @Override
        protected void packageArray(Object[][] objects) {
            this.valueArray = new Object[objects.length][];
            for (int i = 0; i < this.valueArray.length; ++i) {
                Object[] object = objects[i];
                this.valueArray[i] = new Object[]{object[0], object[1], object[2], object[3]};
            }
        }
    }

    protected class SingleHierarchyDimMemLookupValueItem
    extends BaseDimMemLookupValueItem {
        public SingleHierarchyDimMemLookupValueItem(String id, String pid, String name) {
            this.initValueArray((int)1)[0] = new Object[]{id, pid, name};
        }

        public SingleHierarchyDimMemLookupValueItem() {
        }

        @Override
        protected void packageArray(Object[][] objects) {
            this.valueArray = new Object[objects.length][];
            for (int i = 0; i < this.valueArray.length; ++i) {
                Object[] object = objects[i];
                this.valueArray[i] = new Object[]{object[0], object[1], object[2]};
            }
        }
    }

    protected class PeriodDimMemLookupValueItem
    extends BaseDimMemLookupValueItem {
        @Override
        protected void packageArray(Object[][] objects) {
            Object[] object = objects[0];
            this.initValueArray((int)1)[0] = new Object[]{object[0], object[1]};
        }
    }

    protected class SingleNameDimMemLookupValueItem
    extends BaseDimMemLookupValueItem {
        @Override
        protected void packageArray(Object[][] objects) {
            this.initValueArray((int)1)[0] = new Object[]{objects[0][0]};
        }
    }

    public abstract class BaseDimMemLookupValueItem
    implements IConvertValueContent,
    Serializable {
        @JSONField(name="v")
        public Object[][] valueArray;

        protected Object[][] initValueArray(int size) {
            this.valueArray = new Object[size][];
            return this.valueArray;
        }

        protected abstract void packageArray(Object[][] var1);

        @Override
        public Object[][] getValueArray(Object ... params) {
            return this.valueArray;
        }
    }

    protected static interface IConvertValueContent {
        public Object[][] getValueArray(Object ... var1);
    }
}

