/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.olap;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.BiConsumer;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.data.disf.iterators.impl.IntArraySequenceIterator;
import kd.data.disf.task.IDataWorkTaskManager;
import kd.data.fsa.olap.OlapSQLBuilder;

public class OlapMultipleSQLBuilder
extends OlapSQLBuilder
implements Iterator<OlapSQLBuilder>,
Cloneable {
    private static final long serialVersionUID = -1708613419609586044L;
    private IntArraySequenceIterator dimGroupIterator;
    private Map<String, Set<String>> changedDimFilters;
    private int batchSize;
    protected int totalSubTaskCnt;
    private BiConsumer<String[], OlapMultipleSQLBuilder> filterChangeConsumer;

    public OlapMultipleSQLBuilder(String cubeCatalog, IntArraySequenceIterator dimGroupIterator, BiConsumer<String[], OlapMultipleSQLBuilder> consumer) {
        super(cubeCatalog);
        if (dimGroupIterator == null) {
            throw new KDBizException("\u67e5\u8be2\u7ef4\u5ea6\u8fc7\u6ee4\u6761\u4ef6\u7ec4\u5408\u7684\u8fed\u4ee3\u5668\u4e3a\u7a7a\uff01 cubeCatalog=" + cubeCatalog);
        }
        int maxThreadCnt = IDataWorkTaskManager.getInstance().getMaxThreadCnt();
        long totalStepCnt = dimGroupIterator.getTotalStepCnt();
        int orginalBatchSize = (int)(totalStepCnt % (long)maxThreadCnt != 0L ? totalStepCnt / (long)maxThreadCnt + 1L : totalStepCnt / (long)maxThreadCnt);
        this.batchSize = dimGroupIterator.calculateBatchSize(orginalBatchSize);
        this.totalSubTaskCnt = (int)(totalStepCnt % (long)this.batchSize != 0L ? totalStepCnt / (long)this.batchSize + 1L : totalStepCnt / (long)this.batchSize);
        this.changedDimFilters = new HashMap<String, Set<String>>(10);
        this.dimGroupIterator = dimGroupIterator;
        this.filterChangeConsumer = consumer;
        if (this.filterChangeConsumer == null) {
            throw new KDBizException("\u67e5\u8be2\u7ef4\u5ea6\u8fc7\u6ee4\u6761\u4ef6\u7ec4\u5408\u7684\u6d88\u8d39\u5904\u7406\u5668\u4e3a\u7a7a\uff01 cubeCatalog=" + cubeCatalog);
        }
    }

    @Override
    public boolean hasNext() {
        return this.dimGroupIterator.hasNext();
    }

    @Override
    public OlapSQLBuilder next() {
        int retrieveCnt;
        this.changedDimFilters.clear();
        for (retrieveCnt = 0; this.hasNext() && this.batchSize > retrieveCnt; ++retrieveCnt) {
            this.filterChangeConsumer.accept(this.dimGroupIterator.next().toArray(new String[0]), this);
        }
        if (retrieveCnt > 0) {
            try {
                HashMap<String, Set<String>> cloneMap = new HashMap<String, Set<String>>(this.changedDimFilters.size());
                for (Map.Entry<String, Set<String>> en : this.changedDimFilters.entrySet()) {
                    cloneMap.put(en.getKey(), new HashSet(en.getValue()));
                }
                OlapMultipleSQLBuilder sqlBuilder = (OlapMultipleSQLBuilder)this.clone();
                sqlBuilder.setChangedDimFilters(cloneMap);
                return sqlBuilder;
            }
            catch (CloneNotSupportedException e) {
                throw new KDBizException((Throwable)e, new ErrorCode("", String.format("OLAP \u67e5\u8be2\u4e2dsqlBuilder,changedDimFilters\u62f7\u8d1d\u3002\u53d1\u751f\u5f02\u5e38\uff1a%s", e.getMessage())), new Object[0]);
            }
        }
        throw new NoSuchElementException();
    }

    public OlapSQLBuilder addChangedDimFilter(String dimKey, String ... values) {
        return this.addDimFilterEx(this.changedDimFilters, dimKey, values);
    }

    @Override
    public SelectCommandInfo buildSelectCommandInfo() {
        SelectCommandInfo queryInfo = super.buildSelectCommandInfo();
        for (Map.Entry<String, Set<String>> en : this.changedDimFilters.entrySet()) {
            queryInfo.addFilter(en.getKey(), (String[])en.getValue().toArray(new String[0]).clone());
        }
        return queryInfo;
    }

    public IntArraySequenceIterator getDimGroupIterator() {
        return this.dimGroupIterator;
    }

    public void setDimGroupIterator(IntArraySequenceIterator dimGroupIterator) {
        this.dimGroupIterator = dimGroupIterator;
    }

    public Map<String, Set<String>> getChangedDimFilters() {
        return this.changedDimFilters;
    }

    public void setChangedDimFilters(Map<String, Set<String>> changedDimFilters) {
        this.changedDimFilters = changedDimFilters;
    }

    public BiConsumer<String[], OlapMultipleSQLBuilder> getFilterChangeConsumer() {
        return this.filterChangeConsumer;
    }

    public void setFilterChangeConsumer(BiConsumer<String[], OlapMultipleSQLBuilder> filterChangeConsumer) {
        this.filterChangeConsumer = filterChangeConsumer;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public int getTotalSubTaskCnt() {
        return this.totalSubTaskCnt;
    }
}

