/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.olap;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.data.disf.model.impl.IDataMapEntry;
import kd.data.disf.stream.datablock.IAsyncStreamDataBlock;
import kd.data.disf.stream.pipe.AsyncStreamPipe;
import kd.data.disf.task.IDataWorkTaskManager;
import kd.data.fsa.cacheservice.FSADataCacheMgr;
import kd.data.fsa.model.FSAConfigModel;
import kd.data.fsa.olap.FSAOlapDataStatisticsInfo;
import kd.data.fsa.olap.OlapSQLBuilder;
import kd.data.fsa.utils.KdOlapServerHelper;

public class OlapMultipleSplitSQLBuilder
extends OlapSQLBuilder
implements Iterator<OlapSQLBuilder>,
Consumer<IAsyncStreamDataBlock<SplitOlapDimGroupInfo>> {
    private static final long serialVersionUID = -8153890751443360418L;
    private static final Log logger = LogFactory.getLog(OlapMultipleSplitSQLBuilder.class);
    private FSAOlapDataStatisticsInfo srcOlapDataStatistic;
    protected AsyncStreamPipe<SplitOlapDimGroupInfo> splitTaskPipe;
    protected List<String> splitDimNumbers;
    protected boolean hasSecondaryDim;
    protected int limitCount;
    protected ConcurrentLinkedQueue<SplitOlapDimGroupInfo> subTaskInfoList;
    protected Object waitingTaskCnt;
    protected int totalSubTaskCnt = 0;
    protected AtomicInteger waitingSplitMemberCnt;
    protected int batchCoefficient = 10;
    private boolean superLongData;

    public OlapMultipleSplitSQLBuilder(String cubeCatalog, Map<String, Set<String>> fullDimFilterMap, boolean ignoreMeasureNull, FSAOlapDataStatisticsInfo srcOlapDataStatistic, int limitCount, List<String> splitDimNumbers, boolean superLongData) {
        super(cubeCatalog);
        this.dimFilters = fullDimFilterMap;
        this.ignoreMeasureNull = ignoreMeasureNull;
        this.srcOlapDataStatistic = srcOlapDataStatistic;
        this.hasSecondaryDim = srcOlapDataStatistic.isHasSecondaryDim();
        this.limitCount = limitCount;
        this.splitDimNumbers = splitDimNumbers;
        this.subTaskInfoList = new ConcurrentLinkedQueue();
        this.waitingTaskCnt = new Object();
        this.waitingSplitMemberCnt = new AtomicInteger(0);
        FSAConfigModel fsaConfigModel = FSADataCacheMgr.instance.getFSAConfigModel("max_helper_threadcnt");
        this.splitTaskPipe = new AsyncStreamPipe(fsaConfigModel == null ? IDataWorkTaskManager.getInstance().getMaxThreadCnt() : Integer.parseInt(fsaConfigModel.getValue()));
        this.splitTaskPipe.attach((Consumer)this);
        this.superLongData = superLongData;
        logger.info(String.format("IDataWorkTaskStatusConsumer Started! [%s]", this.getClass().getName()));
    }

    public void startSplitTask() {
        this.splitSubTaskAndWaitingDimEx(this.srcOlapDataStatistic, null);
    }

    @Override
    public void accept(IAsyncStreamDataBlock<SplitOlapDimGroupInfo> dataBlock) {
        if (dataBlock.getData() == null) {
            this.waitingSplitMemberCnt.decrementAndGet();
            return;
        }
        SplitOlapDimGroupInfo splitDimInfo = (SplitOlapDimGroupInfo)dataBlock.getData();
        String[] dimInfo = splitDimInfo.getDimInfo();
        Map<String, Set<String>> historySplitDimFilters = splitDimInfo.getDimFilters();
        HashMap<String, Set<String>> queryDimFilters = new HashMap<String, Set<String>>(this.dimFilters);
        queryDimFilters.putAll(historySplitDimFilters);
        String mainDimNumber = dimInfo[1] != null ? dimInfo[1] : dimInfo[0];
        String splitDimNumber = this.splitDimNumbers.get(this.splitDimNumbers.indexOf(mainDimNumber) + 1);
        FSAOlapDataStatisticsInfo newDimComboStatisticInfo = KdOlapServerHelper.queryDimMemComboStatistics(this.cubeCatalog, mainDimNumber, splitDimNumber, queryDimFilters, this.ignoreMeasureNull, this.superLongData);
        queryDimFilters = null;
        this.splitSubTaskAndWaitingDimEx(newDimComboStatisticInfo, historySplitDimFilters);
        this.waitingSplitMemberCnt.decrementAndGet();
    }

    protected boolean isSplitTaskCompleted() {
        boolean result;
        boolean bl = result = this.waitingSplitMemberCnt.get() <= 0 && this.splitTaskPipe.isEmpty();
        if (result && this.splitTaskPipe.isRunning()) {
            try {
                this.splitTaskPipe.close();
                this.splitDimNumbers = null;
                this.splitTaskPipe = null;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public void close() {
        try {
            if (this.splitTaskPipe != null) {
                this.splitTaskPipe.close(true);
                this.splitTaskPipe = null;
            }
            this.splitDimNumbers = null;
            this.subTaskInfoList.clear();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public boolean hasNext() {
        return !this.subTaskInfoList.isEmpty() || !this.isSplitTaskCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OlapSQLBuilder next() {
        while (this.hasNext()) {
            if (!this.subTaskInfoList.isEmpty()) {
                SplitOlapDimGroupInfo dimGroupInfo = (SplitOlapDimGroupInfo)this.subTaskInfoList.remove();
                HashMap<String, Set<String>> cloneDimFilter = new HashMap<String, Set<String>>(this.dimFilters);
                cloneDimFilter.putAll(dimGroupInfo.getDimFilters());
                return new OlapSQLBuilder(this.cubeCatalog, cloneDimFilter, this.ignoreMeasureNull, this.selectDimensionMap, dimGroupInfo.getDimCombCnt());
            }
            Object object = this.waitingTaskCnt;
            synchronized (object) {
                try {
                    this.waitingTaskCnt.wait(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private void splitSubTaskAndWaitingDimEx(FSAOlapDataStatisticsInfo olapDataStatisticsInfo, Map<String, Set<String>> oldDimFilters) {
        boolean hasSecondDim = olapDataStatisticsInfo.isHasSecondaryDim();
        Map<Object, List<Map.Entry<Object, Integer>>>[] sortedDimMemberStatistics = olapDataStatisticsInfo.getSortedDimMemberStatistics(this.limitCount);
        String[] dimNumberInfo = olapDataStatisticsInfo.getDimNumbers();
        FSAConfigModel splitBatchCoefficient = FSADataCacheMgr.instance.getFSAConfigModel("single_split_batch_coefficient");
        if (splitBatchCoefficient != null) {
            this.batchCoefficient = Integer.parseInt(splitBatchCoefficient.getValue());
        }
        int batchGroupSize = this.limitCount * this.batchCoefficient;
        LinkedList dimGroupInfoBufList = new LinkedList();
        Map<Object, List<Map.Entry<Object, Integer>>> bufMap = sortedDimMemberStatistics[1];
        if (!bufMap.isEmpty()) {
            this.batchProcessSplitOlapDimGroupInfo(bufMap, hasSecondDim, batchGroupSize, (filterSets, recCnt) -> {
                this.waitingSplitMemberCnt.incrementAndGet();
                dimGroupInfoBufList.add(this.createOlapDimGroupInfo(oldDimFilters, hasSecondDim, dimNumberInfo, (Set)filterSets.getKey(), (Set)filterSets.getValue(), (int)recCnt));
            });
            try {
                this.splitTaskPipe.putToQueue(dimGroupInfoBufList);
            }
            catch (InterruptedException e) {
                logger.error("\u5f85\u62c6\u5206\u5b50\u4efb\u52a1\u63d0\u4ea4\u7ba1\u9053\u6d41\u5931\u8d25\uff1a", (Object)e.getMessage(), (Object)e);
                throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
            }
        }
        if (!(bufMap = sortedDimMemberStatistics[0]).isEmpty()) {
            this.batchProcessSplitOlapDimGroupInfo(bufMap, hasSecondDim, this.limitCount, (filterSets, recCnt) -> this.addToProcessTaskQueue(this.createOlapDimGroupInfo(oldDimFilters, hasSecondDim, dimNumberInfo, (Set)filterSets.getKey(), (Set)filterSets.getValue(), (int)recCnt)));
        }
        olapDataStatisticsInfo = null;
    }

    protected void batchProcessSplitOlapDimGroupInfo(Map<Object, List<Map.Entry<Object, Integer>>> srcStatisticMap, boolean hasSecondaryDim, int batchGroupSize, BiConsumer<Map.Entry<Set<String>, Set<String>>, Integer> processBatchFunc) {
        Set<Object> mainfilterSet = null;
        int currentBatchCnt = 0;
        if (hasSecondaryDim) {
            for (Map.Entry<Object, List<Map.Entry<Object, Integer>>> en : srcStatisticMap.entrySet()) {
                currentBatchCnt = 0;
                HashSet<String> splitFilterSet = new HashSet<String>(10);
                mainfilterSet = Collections.singleton(en.getKey().toString());
                for (Map.Entry<Object, Integer> dimFilterEntry : en.getValue()) {
                    if (currentBatchCnt + dimFilterEntry.getValue() <= batchGroupSize) {
                        splitFilterSet.add(dimFilterEntry.getKey().toString());
                        currentBatchCnt += dimFilterEntry.getValue().intValue();
                        continue;
                    }
                    if (!splitFilterSet.isEmpty()) {
                        processBatchFunc.accept((Map.Entry<Set<String>, Set<String>>)new IDataMapEntry(mainfilterSet, splitFilterSet), currentBatchCnt);
                        splitFilterSet = new HashSet(10);
                    }
                    splitFilterSet.add(dimFilterEntry.getKey().toString());
                    currentBatchCnt = dimFilterEntry.getValue();
                }
                if (splitFilterSet.isEmpty()) continue;
                processBatchFunc.accept((Map.Entry<Set<String>, Set<String>>)new IDataMapEntry(mainfilterSet, splitFilterSet), currentBatchCnt);
            }
        } else {
            mainfilterSet = new HashSet(10);
            for (Map.Entry<Object, List<Map.Entry<Object, Integer>>> en : srcStatisticMap.entrySet()) {
                Map.Entry<Object, Integer> dimEntry = en.getValue().get(0);
                if (currentBatchCnt + dimEntry.getValue() <= batchGroupSize) {
                    mainfilterSet.add(dimEntry.getKey().toString());
                    currentBatchCnt += dimEntry.getValue().intValue();
                    continue;
                }
                if (!mainfilterSet.isEmpty()) {
                    processBatchFunc.accept((Map.Entry<Set<String>, Set<String>>)new IDataMapEntry(mainfilterSet, null), currentBatchCnt);
                    mainfilterSet = new HashSet(10);
                }
                mainfilterSet.add(dimEntry.getKey().toString());
                currentBatchCnt = dimEntry.getValue();
            }
            if (!mainfilterSet.isEmpty()) {
                processBatchFunc.accept((Map.Entry<Set<String>, Set<String>>)new IDataMapEntry(mainfilterSet, null), currentBatchCnt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToProcessTaskQueue(SplitOlapDimGroupInfo taskQueryInfo) {
        this.subTaskInfoList.add(taskQueryInfo);
        Object object = this.waitingTaskCnt;
        synchronized (object) {
            ++this.totalSubTaskCnt;
            this.waitingTaskCnt.notifyAll();
        }
    }

    private SplitOlapDimGroupInfo createOlapDimGroupInfo(Map<String, Set<String>> oldDimFilters, boolean hasSecondaryDim, String[] dimNumberInfo, Set<String> mainSplitMembers, Set<String> splitDimMembers, int expectRecCnt) {
        Map<String, Set<String>> changeDimFilters = this.cloneMap(oldDimFilters);
        changeDimFilters.put(dimNumberInfo[0], mainSplitMembers);
        if (hasSecondaryDim) {
            changeDimFilters.put(dimNumberInfo[1], splitDimMembers);
        }
        return new SplitOlapDimGroupInfo(dimNumberInfo, changeDimFilters, expectRecCnt);
    }

    private Map<String, Set<String>> cloneMap(Map<String, Set<String>> oldMap) {
        if (oldMap == null || oldMap.isEmpty()) {
            return new HashMap<String, Set<String>>(10);
        }
        HashMap<String, Set<String>> resultMap = new HashMap<String, Set<String>>(oldMap.size());
        for (Map.Entry<String, Set<String>> en : oldMap.entrySet()) {
            resultMap.put(en.getKey(), new HashSet(en.getValue()));
        }
        return resultMap;
    }

    @Override
    public int getTotalSubTaskCnt() {
        return this.totalSubTaskCnt;
    }

    static class SplitOlapDimGroupInfo {
        protected String[] dimInfo;
        protected Map<String, Set<String>> dimFilters;
        protected int dimCombCnt;

        public SplitOlapDimGroupInfo(String[] dimInfo, Map<String, Set<String>> dimFilters) {
            this(dimInfo, dimFilters, 0);
        }

        public SplitOlapDimGroupInfo(String[] dimInfo, Map<String, Set<String>> dimFilters, int expectRecCnt) {
            this.dimInfo = dimInfo;
            this.dimFilters = dimFilters;
            this.dimCombCnt = expectRecCnt;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(" (DimComboCnt=" + this.dimCombCnt);
            for (Map.Entry<String, Set<String>> en : this.dimFilters.entrySet()) {
                buf.append(String.format("\t[%s]: %s\n", en.getKey(), en.getValue()));
            }
            return buf.toString();
        }

        public String[] getDimInfo() {
            return this.dimInfo;
        }

        public Map<String, Set<String>> getDimFilters() {
            return this.dimFilters;
        }

        public int getDimCombCnt() {
            return this.dimCombCnt;
        }
    }
}

