/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.olap;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.DistinctSelectCommandInfo;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.bos.util.StringUtils;
import kd.data.disf.task.TaskGroupCondition;
import kd.data.fsa.common.enums.FSASelectTypeEnum;

public class OlapSQLBuilder
implements Serializable {
    private static final long serialVersionUID = -1708613419609586044L;
    private static final Log logger = LogFactory.getLog(OlapSQLBuilder.class);
    protected static final FSASelectTypeEnum[] SelectRowKeyTypes = new FSASelectTypeEnum[]{FSASelectTypeEnum.TRANS_TYPE, FSASelectTypeEnum.FIX_ROWKEY_TYPE, FSASelectTypeEnum.CHANGE_ROWKEY_TYPE};
    protected String cubeCatalog;
    protected Map<Integer, List<String>> selectDimensionMap;
    protected Map<String, Set<String>> dimFilters;
    protected int top = -1;
    protected boolean ignoreMeasureNull;
    protected boolean isCancel = false;
    protected boolean isOnlyNumber = false;
    protected int dimCombCnt;
    protected TaskGroupCondition parentTaskGroupCondition;

    public String toString() {
        return "OlapSQLBuilder [cubeCatalog=" + this.cubeCatalog + ", dimFilters=" + this.dimFilters + ", top=" + this.top + ", ignoreMeasureNull=" + this.ignoreMeasureNull + ", isCancel=" + this.isCancel + ", isOnlyNumber=" + this.isOnlyNumber + "]";
    }

    public OlapSQLBuilder(String cubeCatalog) {
        this.cubeCatalog = cubeCatalog;
        this.dimFilters = new LinkedHashMap<String, Set<String>>(10);
        this.selectDimensionMap = new LinkedHashMap<Integer, List<String>>(10);
        this.top = -1;
        this.ignoreMeasureNull = false;
        this.isCancel = false;
        this.isOnlyNumber = false;
        this.selectDimensionMap.put(FSASelectTypeEnum.MEASURE_TYPE.getIntCode(), Collections.singletonList("FMONEY"));
        this.selectDimensionMap.put(FSASelectTypeEnum.TRANS_TYPE.getIntCode(), new LinkedList());
        this.selectDimensionMap.put(FSASelectTypeEnum.FIX_ROWKEY_TYPE.getIntCode(), new LinkedList());
        this.selectDimensionMap.put(FSASelectTypeEnum.CHANGE_ROWKEY_TYPE.getIntCode(), new LinkedList());
    }

    public OlapSQLBuilder(String cubeCatalog, Map<String, Set<String>> dimFilters, boolean ignoreMeasureNull, Map<Integer, List<String>> selectDimensionMap, int dimCombCnt) {
        this(cubeCatalog);
        this.dimFilters = dimFilters;
        this.ignoreMeasureNull = ignoreMeasureNull;
        this.selectDimensionMap = selectDimensionMap;
        this.dimCombCnt = dimCombCnt;
    }

    public int getSelectFieldCnt() {
        int fieldCnt = 0;
        for (FSASelectTypeEnum type : SelectRowKeyTypes) {
            fieldCnt += this.selectDimensionMap.get(type.getIntCode()).size();
        }
        return fieldCnt += this.selectDimensionMap.get(FSASelectTypeEnum.MEASURE_TYPE.getIntCode()).size();
    }

    protected boolean addSelectFields(List<String> targetList, String ... targetItems) {
        if (targetItems == null || targetItems.length <= 0) {
            return false;
        }
        for (String f : targetItems) {
            if (targetList.contains(f)) {
                throw new KDBizException(String.format("Duplicate Field:%s. Current Selected List:%s", f, targetList));
            }
            targetList.add(f);
        }
        return true;
    }

    public String[] getFieldStrings(boolean measure) {
        if (measure) {
            return this.selectDimensionMap.get(FSASelectTypeEnum.MEASURE_TYPE.getIntCode()).toArray(new String[0]);
        }
        LinkedList resultList = new LinkedList();
        for (FSASelectTypeEnum type : SelectRowKeyTypes) {
            resultList.addAll(this.selectDimensionMap.get(type.getIntCode()));
        }
        return resultList.toArray(new String[0]);
    }

    public boolean addSelectDimFields(Integer selectType, String ... dimKeys) {
        if (this.selectDimensionMap.get(selectType) == null) {
            this.selectDimensionMap.put(selectType, new LinkedList());
        }
        return this.addSelectFields(this.selectDimensionMap.get(selectType), dimKeys);
    }

    public void batchAddSelectDimensions(Map<Integer, List<String>> selectDimensionMap) {
        if (selectDimensionMap == null || selectDimensionMap.isEmpty()) {
            return;
        }
        for (Map.Entry<Integer, List<String>> en : selectDimensionMap.entrySet()) {
            if (en.getKey() == null) continue;
            this.addSelectDimFields(en.getKey(), en.getValue() == null ? null : en.getValue().toArray(new String[0]));
        }
    }

    public boolean addMeasures(String ... measures) {
        return this.addSelectFields(this.selectDimensionMap.get(0), measures);
    }

    public OlapSQLBuilder addDimFilter(String dimKey, String ... values) {
        return this.addDimFilterEx(this.dimFilters, dimKey, values);
    }

    protected OlapSQLBuilder addDimFilterEx(Map<String, Set<String>> targetDimFilters, String dimKey, String ... values) {
        if (dimKey == null || values == null || values.length <= 0) {
            return this;
        }
        Set<String> DimFilterSet = targetDimFilters.get(dimKey);
        if (DimFilterSet == null) {
            LinkedHashSet<String> dimFilter = new LinkedHashSet<String>();
            dimFilter.addAll(Arrays.asList(values));
            targetDimFilters.putIfAbsent(dimKey, dimFilter);
        } else {
            DimFilterSet.addAll(Arrays.asList(values));
        }
        return this;
    }

    protected OlapSQLBuilder addDimFilterUpgrade(String dimKey, String ... values) {
        this.dimFilters.remove(dimKey);
        if (dimKey == null || values == null || values.length <= 0) {
            return this;
        }
        HashSet<String> dimFilter = new HashSet<String>(10);
        dimFilter.addAll(Arrays.asList(values));
        this.dimFilters.put(dimKey, dimFilter);
        return this;
    }

    public void reset() {
        this.selectDimensionMap.clear();
        this.dimFilters.clear();
    }

    public void clean() {
        this.cubeCatalog = null;
        this.selectDimensionMap = null;
        this.dimFilters.clear();
    }

    public void close() {
    }

    public boolean validate() {
        int selectFieldCnt = this.getSelectFieldCnt() - this.selectDimensionMap.get(FSASelectTypeEnum.MEASURE_TYPE.getIntCode()).size();
        return StringUtils.isNotEmpty((String)this.cubeCatalog) && !this.selectDimensionMap.get(FSASelectTypeEnum.MEASURE_TYPE.getIntCode()).isEmpty() && selectFieldCnt > 0;
    }

    public int getTop() {
        return this.top;
    }

    public SelectCommandInfo buildSelectCommandInfo() {
        SelectCommandInfo queryInfo = new SelectCommandInfo();
        queryInfo.addDims(this.getFieldStrings(false));
        queryInfo.addMeasures(this.getFieldStrings(true));
        for (Map.Entry<String, Set<String>> en : this.getDimFilters().entrySet()) {
            queryInfo.addFilter(en.getKey(), en.getValue().toArray(new String[0]));
        }
        if (logger.isInfoEnabled()) {
            logger.info(this.dumpSelectCommandInfo(queryInfo));
        }
        return queryInfo;
    }

    public DistinctSelectCommandInfo buildDitinctSelectCommandInfo(List<String> dimension, Map<String, Set<String>> distinctFilter) {
        DistinctSelectCommandInfo queryInfo = new DistinctSelectCommandInfo();
        queryInfo.addDims(dimension.toArray(new String[0]));
        for (Map.Entry<String, Set<String>> en : this.getDimFilters().entrySet()) {
            queryInfo.addFilter(en.getKey(), en.getValue().toArray(new String[0]));
        }
        for (Map.Entry<String, Set<String>> en : distinctFilter.entrySet()) {
            queryInfo.addFilter(en.getKey(), en.getValue().toArray(new String[0]));
        }
        return queryInfo;
    }

    public SelectCommandInfo buildSelectCommandInfo(List<String> dimension, Map<String, Set<String>> distinctFilter) {
        SelectCommandInfo queryInfo = new SelectCommandInfo();
        queryInfo.addMeasures(this.getFieldStrings(true));
        queryInfo.addDims(dimension.toArray(new String[0]));
        for (Map.Entry<String, Set<String>> en : this.getDimFilters().entrySet()) {
            queryInfo.addFilter(en.getKey(), en.getValue().toArray(new String[0]));
        }
        for (Map.Entry<String, Set<String>> en : distinctFilter.entrySet()) {
            queryInfo.addFilter(en.getKey(), en.getValue().toArray(new String[0]));
        }
        return queryInfo;
    }

    protected String dumpSelectCommandInfo(SelectCommandInfo selectCmd) {
        StringBuilder buf = new StringBuilder();
        if (selectCmd != null) {
            buf.append("SelectCommandInfo:[Measures=").append(selectCmd.getMeasures()).append(';');
            buf.append("DimensionFilters=[");
            if (selectCmd.getFilter() != null) {
                selectCmd.getFilter().forEach(dimFilter -> {
                    buf.append("Name=").append(dimFilter.getName());
                    buf.append("; FilterValue=").append(dimFilter.getValues()).append(';');
                });
            }
            buf.append("]]");
        }
        return buf.toString();
    }

    public void setTop(int top) {
        this.top = top;
    }

    public boolean isIgnoreMeasureNull() {
        return this.ignoreMeasureNull;
    }

    public void setIgnoreMeasureNull(boolean ignoreMeasureNull) {
        this.ignoreMeasureNull = ignoreMeasureNull;
    }

    public void setCancel(boolean cancel) {
        this.isCancel = cancel;
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public boolean isOnlyNumber() {
        return this.isOnlyNumber;
    }

    public void setOnlyNumber(boolean isOnlyNumber) {
        this.isOnlyNumber = isOnlyNumber;
    }

    public String getCubeCatalog() {
        return this.cubeCatalog;
    }

    public void setCubeCatalog(String cubeCatalog) {
        this.cubeCatalog = cubeCatalog;
    }

    public Map<String, Set<String>> getDimFilters() {
        return this.dimFilters;
    }

    public void setDimFilters(Map<String, Set<String>> dimFilters) {
        this.dimFilters = dimFilters;
    }

    public Map<Integer, List<String>> getSelectDimensionMap() {
        return this.selectDimensionMap;
    }

    public void setSelectDimensionMap(Map<Integer, List<String>> selectDimensionMap) {
        this.selectDimensionMap = selectDimensionMap;
    }

    public int getBatchSize() {
        return 1;
    }

    public int getTotalSubTaskCnt() {
        return 1;
    }

    public int getDimCombCnt() {
        return this.dimCombCnt;
    }

    public TaskGroupCondition getParentTaskGroupCondition() {
        return this.parentTaskGroupCondition;
    }

    public void setParentTaskGroupCondition(TaskGroupCondition parentTaskGroupCondition) {
        this.parentTaskGroupCondition = parentTaskGroupCondition;
    }
}

