/*
 * Decompiled with CFR 0.152.
 */
package kd.data.fsa.olap;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.data.fsa.olap.OlapServerBaseMetaInfo;
import kd.data.fsa.olap.OlapServerDimMemberMetaInfo;

public class OlapServerDimemsionMetaInfo
extends OlapServerBaseMetaInfo {
    private static final long serialVersionUID = -8587656821365432066L;
    @JSONField(serialize=false)
    @JsonIgnore
    protected String dimEntityName;
    @JSONField(serialize=false)
    @JsonIgnore
    protected String fieldMapped;
    @JSONField(serialize=false)
    @JsonIgnore
    protected Map<String, List<OlapServerDimMemberMetaInfo>> dimMembers = new LinkedHashMap<String, List<OlapServerDimMemberMetaInfo>>(10);
    @JSONField(serialize=false)
    @JsonIgnore
    private Set<String> limitedMembers;

    public OlapServerDimemsionMetaInfo() {
        this(null, null, null, null, null);
    }

    public OlapServerDimemsionMetaInfo(Long id, String number, String name, String dimEntityName, String fieldMapped, Collection<String> limitedMembers) {
        super(id, number, name);
        this.dimEntityName = dimEntityName;
        this.fieldMapped = fieldMapped;
        this.limitedMembers = new LinkedHashSet<String>(10);
        if (limitedMembers != null) {
            this.limitedMembers.addAll(limitedMembers);
        }
    }

    public OlapServerDimemsionMetaInfo(Long id, String number, String name, String dimEntityName, String fieldMapped) {
        this(id, number, name, dimEntityName, fieldMapped, null);
    }

    public String toString() {
        return "OlapServerDimemsionMetaInfo{id=" + this.id + ", number='" + this.number + '\'' + ", name='" + this.name + '\'' + ", dimEntityName='" + this.dimEntityName + '\'' + ", fieldMapped='" + this.fieldMapped + '\'' + ", dimMembers=" + this.dimMembers + ", limitedMembers=" + this.limitedMembers + '}';
    }

    public List<OlapServerDimMemberMetaInfo> getDimMemberByNumber(String memberNumber) {
        return this.dimMembers.get(memberNumber);
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    protected int getArraySize() {
        return super.getArraySize() + 4;
    }

    @Override
    protected Object[] appendSerializedArray(Object[] targetArray) {
        super.appendSerializedArray(targetArray);
        int index = super.getArraySize();
        targetArray[index++] = this.dimEntityName;
        targetArray[index++] = this.fieldMapped;
        targetArray[index++] = this.dimMembers;
        targetArray[index] = this.limitedMembers;
        return targetArray;
    }

    @Override
    protected void updateValueArray(Object[] v) {
        super.updateValueArray(v);
        int index = super.getArraySize();
        this.dimEntityName = this.getString(v, index++);
        this.fieldMapped = this.getString(v, index++);
        JSONObject jsonObject = JSON.parseObject((String)v[index++].toString());
        this.dimMembers = new HashMap<String, List<OlapServerDimMemberMetaInfo>>(10);
        this.parseMapValue(jsonObject, this.dimMembers, k -> k, (k, o) -> this.parseDimMemberMetaInfo((String)k, o));
        JSONArray jsonArray = JSON.parseArray((String)v[index].toString());
        if (jsonArray != null && !jsonArray.isEmpty()) {
            this.limitedMembers = new LinkedHashSet<String>(jsonArray.size());
            this.limitedMembers.addAll(jsonArray.toJavaList(String.class));
        }
    }

    protected List<OlapServerDimMemberMetaInfo> parseDimMemberMetaInfo(String key, Object srcObject) {
        JSONArray jsonArray = OlapServerDimemsionMetaInfo.toJSONArray(srcObject);
        List list = JSONObject.parseArray((String)jsonArray.toJSONString(), OlapServerDimMemberMetaInfo.class);
        return list;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public String getDimEntityName() {
        return this.dimEntityName;
    }

    public void setDimEntityName(String dimEntityName) {
        this.dimEntityName = dimEntityName;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public String getFieldMapped() {
        return this.fieldMapped;
    }

    public void setFieldMapped(String fieldMapped) {
        this.fieldMapped = fieldMapped;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public Map<String, List<OlapServerDimMemberMetaInfo>> getDimMembers() {
        return this.dimMembers;
    }

    public void setDimMembers(Map<String, List<OlapServerDimMemberMetaInfo>> dimMembers) {
        this.dimMembers = dimMembers;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public Set<String> getLimitedMembers() {
        return this.limitedMembers;
    }

    public void setLimitedMembers(Set<String> limitedMembers) {
        this.limitedMembers = limitedMembers;
    }
}

